# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEcsServiceResult',
    'AwaitableGetEcsServiceResult',
    'get_ecs_service',
    'get_ecs_service_output',
]

@pulumi.output_type
class GetEcsServiceResult:
    """
    A collection of values returned by getEcsService.
    """
    def __init__(__self__, capacity_provider_strategies=None, dns_prfx=None, health_check_grace_period_seconds=None, id=None, index=None, is_target_group_only=None, load_balancers=None, name=None, old_task_definition_buffer_size=None, replicas=None, target_group_arns=None, task_definition=None, tenant_id=None, wait_until_targets_ready=None):
        if capacity_provider_strategies and not isinstance(capacity_provider_strategies, list):
            raise TypeError("Expected argument 'capacity_provider_strategies' to be a list")
        pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if dns_prfx and not isinstance(dns_prfx, str):
            raise TypeError("Expected argument 'dns_prfx' to be a str")
        pulumi.set(__self__, "dns_prfx", dns_prfx)
        if health_check_grace_period_seconds and not isinstance(health_check_grace_period_seconds, int):
            raise TypeError("Expected argument 'health_check_grace_period_seconds' to be a int")
        pulumi.set(__self__, "health_check_grace_period_seconds", health_check_grace_period_seconds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index and not isinstance(index, int):
            raise TypeError("Expected argument 'index' to be a int")
        pulumi.set(__self__, "index", index)
        if is_target_group_only and not isinstance(is_target_group_only, bool):
            raise TypeError("Expected argument 'is_target_group_only' to be a bool")
        pulumi.set(__self__, "is_target_group_only", is_target_group_only)
        if load_balancers and not isinstance(load_balancers, list):
            raise TypeError("Expected argument 'load_balancers' to be a list")
        pulumi.set(__self__, "load_balancers", load_balancers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if old_task_definition_buffer_size and not isinstance(old_task_definition_buffer_size, int):
            raise TypeError("Expected argument 'old_task_definition_buffer_size' to be a int")
        pulumi.set(__self__, "old_task_definition_buffer_size", old_task_definition_buffer_size)
        if replicas and not isinstance(replicas, int):
            raise TypeError("Expected argument 'replicas' to be a int")
        pulumi.set(__self__, "replicas", replicas)
        if target_group_arns and not isinstance(target_group_arns, list):
            raise TypeError("Expected argument 'target_group_arns' to be a list")
        pulumi.set(__self__, "target_group_arns", target_group_arns)
        if task_definition and not isinstance(task_definition, str):
            raise TypeError("Expected argument 'task_definition' to be a str")
        pulumi.set(__self__, "task_definition", task_definition)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_targets_ready and not isinstance(wait_until_targets_ready, bool):
            raise TypeError("Expected argument 'wait_until_targets_ready' to be a bool")
        pulumi.set(__self__, "wait_until_targets_ready", wait_until_targets_ready)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Sequence['outputs.GetEcsServiceCapacityProviderStrategyResult']:
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter(name="dnsPrfx")
    def dns_prfx(self) -> str:
        """
        The DNS prefix to assign to this service's load balancer.
        """
        return pulumi.get(self, "dns_prfx")

    @property
    @pulumi.getter(name="healthCheckGracePeriodSeconds")
    def health_check_grace_period_seconds(self) -> int:
        return pulumi.get(self, "health_check_grace_period_seconds")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        The index of the ecs service.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="isTargetGroupOnly")
    def is_target_group_only(self) -> bool:
        return pulumi.get(self, "is_target_group_only")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence['outputs.GetEcsServiceLoadBalancerResult']:
        """
        Zero or more load balancer configurations to associate with this service.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the service to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oldTaskDefinitionBufferSize")
    def old_task_definition_buffer_size(self) -> int:
        """
        The number of older task definitions to retain in AWS.
        """
        return pulumi.get(self, "old_task_definition_buffer_size")

    @property
    @pulumi.getter
    def replicas(self) -> int:
        """
        The number of container replicas to create.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Sequence[str]:
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> str:
        """
        The ARN of the task definition to use.
        """
        return pulumi.get(self, "task_definition")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the service will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilTargetsReady")
    def wait_until_targets_ready(self) -> bool:
        """
        Whether or not to wait until all target groups are created for ecs service, after creation.
        """
        return pulumi.get(self, "wait_until_targets_ready")


class AwaitableGetEcsServiceResult(GetEcsServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsServiceResult(
            capacity_provider_strategies=self.capacity_provider_strategies,
            dns_prfx=self.dns_prfx,
            health_check_grace_period_seconds=self.health_check_grace_period_seconds,
            id=self.id,
            index=self.index,
            is_target_group_only=self.is_target_group_only,
            load_balancers=self.load_balancers,
            name=self.name,
            old_task_definition_buffer_size=self.old_task_definition_buffer_size,
            replicas=self.replicas,
            target_group_arns=self.target_group_arns,
            task_definition=self.task_definition,
            tenant_id=self.tenant_id,
            wait_until_targets_ready=self.wait_until_targets_ready)


def get_ecs_service(name: Optional[str] = None,
                    tenant_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsServiceResult:
    """
    Use this data source to access information about an existing resource.

    :param str name: The name of the service to create.
    :param str tenant_id: The GUID of the tenant that the service will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getEcsService:getEcsService', __args__, opts=opts, typ=GetEcsServiceResult).value

    return AwaitableGetEcsServiceResult(
        capacity_provider_strategies=pulumi.get(__ret__, 'capacity_provider_strategies'),
        dns_prfx=pulumi.get(__ret__, 'dns_prfx'),
        health_check_grace_period_seconds=pulumi.get(__ret__, 'health_check_grace_period_seconds'),
        id=pulumi.get(__ret__, 'id'),
        index=pulumi.get(__ret__, 'index'),
        is_target_group_only=pulumi.get(__ret__, 'is_target_group_only'),
        load_balancers=pulumi.get(__ret__, 'load_balancers'),
        name=pulumi.get(__ret__, 'name'),
        old_task_definition_buffer_size=pulumi.get(__ret__, 'old_task_definition_buffer_size'),
        replicas=pulumi.get(__ret__, 'replicas'),
        target_group_arns=pulumi.get(__ret__, 'target_group_arns'),
        task_definition=pulumi.get(__ret__, 'task_definition'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        wait_until_targets_ready=pulumi.get(__ret__, 'wait_until_targets_ready'))
def get_ecs_service_output(name: Optional[pulumi.Input[str]] = None,
                           tenant_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsServiceResult]:
    """
    Use this data source to access information about an existing resource.

    :param str name: The name of the service to create.
    :param str tenant_id: The GUID of the tenant that the service will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getEcsService:getEcsService', __args__, opts=opts, typ=GetEcsServiceResult)
    return __ret__.apply(lambda __response__: GetEcsServiceResult(
        capacity_provider_strategies=pulumi.get(__response__, 'capacity_provider_strategies'),
        dns_prfx=pulumi.get(__response__, 'dns_prfx'),
        health_check_grace_period_seconds=pulumi.get(__response__, 'health_check_grace_period_seconds'),
        id=pulumi.get(__response__, 'id'),
        index=pulumi.get(__response__, 'index'),
        is_target_group_only=pulumi.get(__response__, 'is_target_group_only'),
        load_balancers=pulumi.get(__response__, 'load_balancers'),
        name=pulumi.get(__response__, 'name'),
        old_task_definition_buffer_size=pulumi.get(__response__, 'old_task_definition_buffer_size'),
        replicas=pulumi.get(__response__, 'replicas'),
        target_group_arns=pulumi.get(__response__, 'target_group_arns'),
        task_definition=pulumi.get(__response__, 'task_definition'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        wait_until_targets_ready=pulumi.get(__response__, 'wait_until_targets_ready')))
