# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGcpFirestoresResult',
    'AwaitableGetGcpFirestoresResult',
    'get_gcp_firestores',
    'get_gcp_firestores_output',
]

@pulumi.output_type
class GetGcpFirestoresResult:
    """
    A collection of values returned by getGcpFirestores.
    """
    def __init__(__self__, firestores=None, id=None, tenant_id=None):
        if firestores and not isinstance(firestores, list):
            raise TypeError("Expected argument 'firestores' to be a list")
        pulumi.set(__self__, "firestores", firestores)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def firestores(self) -> Sequence['outputs.GetGcpFirestoresFirestoreResult']:
        return pulumi.get(self, "firestores")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the firestore will be created in.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetGcpFirestoresResult(GetGcpFirestoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpFirestoresResult(
            firestores=self.firestores,
            id=self.id,
            tenant_id=self.tenant_id)


def get_gcp_firestores(tenant_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpFirestoresResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_firestores(tenant_id="tenant_id")
    pulumi.export("out", {
        "firestores": app.firestores,
    })
    ```


    :param str tenant_id: The GUID of the tenant that the firestore will be created in.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getGcpFirestores:getGcpFirestores', __args__, opts=opts, typ=GetGcpFirestoresResult).value

    return AwaitableGetGcpFirestoresResult(
        firestores=pulumi.get(__ret__, 'firestores'),
        id=pulumi.get(__ret__, 'id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_gcp_firestores_output(tenant_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpFirestoresResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_firestores(tenant_id="tenant_id")
    pulumi.export("out", {
        "firestores": app.firestores,
    })
    ```


    :param str tenant_id: The GUID of the tenant that the firestore will be created in.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getGcpFirestores:getGcpFirestores', __args__, opts=opts, typ=GetGcpFirestoresResult)
    return __ret__.apply(lambda __response__: GetGcpFirestoresResult(
        firestores=pulumi.get(__response__, 'firestores'),
        id=pulumi.get(__response__, 'id'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
