# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGcpNodePoolResult',
    'AwaitableGetGcpNodePoolResult',
    'get_gcp_node_pool',
    'get_gcp_node_pool_output',
]

@pulumi.output_type
class GetGcpNodePoolResult:
    """
    A collection of values returned by getGcpNodePool.
    """
    def __init__(__self__, accelerators=None, auto_repair=None, auto_upgrade=None, disc_size_gb=None, disc_type=None, fullname=None, id=None, image_type=None, initial_node_count=None, is_autoscaling_enabled=None, labels=None, linux_node_configs=None, location_policy=None, machine_type=None, max_node_count=None, metadata=None, min_node_count=None, name=None, node_pool_logging_configs=None, oauth_scopes=None, resource_labels=None, spot=None, tags=None, taints=None, tenant_id=None, total_max_node_count=None, total_min_node_count=None, upgrade_settings=None, zones=None):
        if accelerators and not isinstance(accelerators, list):
            raise TypeError("Expected argument 'accelerators' to be a list")
        pulumi.set(__self__, "accelerators", accelerators)
        if auto_repair and not isinstance(auto_repair, bool):
            raise TypeError("Expected argument 'auto_repair' to be a bool")
        pulumi.set(__self__, "auto_repair", auto_repair)
        if auto_upgrade and not isinstance(auto_upgrade, bool):
            raise TypeError("Expected argument 'auto_upgrade' to be a bool")
        pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if disc_size_gb and not isinstance(disc_size_gb, int):
            raise TypeError("Expected argument 'disc_size_gb' to be a int")
        pulumi.set(__self__, "disc_size_gb", disc_size_gb)
        if disc_type and not isinstance(disc_type, str):
            raise TypeError("Expected argument 'disc_type' to be a str")
        pulumi.set(__self__, "disc_type", disc_type)
        if fullname and not isinstance(fullname, str):
            raise TypeError("Expected argument 'fullname' to be a str")
        pulumi.set(__self__, "fullname", fullname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if initial_node_count and not isinstance(initial_node_count, int):
            raise TypeError("Expected argument 'initial_node_count' to be a int")
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        if is_autoscaling_enabled and not isinstance(is_autoscaling_enabled, bool):
            raise TypeError("Expected argument 'is_autoscaling_enabled' to be a bool")
        pulumi.set(__self__, "is_autoscaling_enabled", is_autoscaling_enabled)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if linux_node_configs and not isinstance(linux_node_configs, list):
            raise TypeError("Expected argument 'linux_node_configs' to be a list")
        pulumi.set(__self__, "linux_node_configs", linux_node_configs)
        if location_policy and not isinstance(location_policy, str):
            raise TypeError("Expected argument 'location_policy' to be a str")
        pulumi.set(__self__, "location_policy", location_policy)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if max_node_count and not isinstance(max_node_count, int):
            raise TypeError("Expected argument 'max_node_count' to be a int")
        pulumi.set(__self__, "max_node_count", max_node_count)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if min_node_count and not isinstance(min_node_count, int):
            raise TypeError("Expected argument 'min_node_count' to be a int")
        pulumi.set(__self__, "min_node_count", min_node_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_pool_logging_configs and not isinstance(node_pool_logging_configs, list):
            raise TypeError("Expected argument 'node_pool_logging_configs' to be a list")
        pulumi.set(__self__, "node_pool_logging_configs", node_pool_logging_configs)
        if oauth_scopes and not isinstance(oauth_scopes, list):
            raise TypeError("Expected argument 'oauth_scopes' to be a list")
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if resource_labels and not isinstance(resource_labels, dict):
            raise TypeError("Expected argument 'resource_labels' to be a dict")
        pulumi.set(__self__, "resource_labels", resource_labels)
        if spot and not isinstance(spot, bool):
            raise TypeError("Expected argument 'spot' to be a bool")
        pulumi.set(__self__, "spot", spot)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if taints and not isinstance(taints, list):
            raise TypeError("Expected argument 'taints' to be a list")
        pulumi.set(__self__, "taints", taints)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if total_max_node_count and not isinstance(total_max_node_count, int):
            raise TypeError("Expected argument 'total_max_node_count' to be a int")
        pulumi.set(__self__, "total_max_node_count", total_max_node_count)
        if total_min_node_count and not isinstance(total_min_node_count, int):
            raise TypeError("Expected argument 'total_min_node_count' to be a int")
        pulumi.set(__self__, "total_min_node_count", total_min_node_count)
        if upgrade_settings and not isinstance(upgrade_settings, list):
            raise TypeError("Expected argument 'upgrade_settings' to be a list")
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.GetGcpNodePoolAcceleratorResult']]:
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> bool:
        """
        Whether the nodes will be automatically repaired.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> bool:
        """
        Whether the nodes will be automatically upgraded.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="discSizeGb")
    def disc_size_gb(self) -> int:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
        			If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disc_size_gb")

    @property
    @pulumi.getter(name="discType")
    def disc_type(self) -> str:
        """
        Type of the disk attached to each node
        			If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disc_type")

    @property
    @pulumi.getter
    def fullname(self) -> str:
        """
        The full name of the node pool.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        """
        The initial node count for the pool
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="isAutoscalingEnabled")
    def is_autoscaling_enabled(self) -> bool:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "is_autoscaling_enabled")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfigs")
    def linux_node_configs(self) -> Sequence['outputs.GetGcpNodePoolLinuxNodeConfigResult']:
        """
        Parameters that can be configured on Linux nodes
        """
        return pulumi.get(self, "linux_node_configs")

    @property
    @pulumi.getter(name="locationPolicy")
    def location_policy(self) -> str:
        """
        Update strategy of the node pool.
        """
        return pulumi.get(self, "location_policy")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The name of a Google Compute Engine machine type.
        			If unspecified, the default machine type is e2-medium.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs assigned to instances in the cluster.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The short name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolLoggingConfigs")
    def node_pool_logging_configs(self) -> Sequence['outputs.GetGcpNodePoolNodePoolLoggingConfigResult']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "node_pool_logging_configs")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the default service account.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Mapping[str, str]:
        """
        Resource labels associated to node pool
        """
        return pulumi.get(self, "resource_labels")

    @property
    @pulumi.getter
    def spot(self) -> bool:
        """
        Spot flag for enabling Spot VM
        """
        return pulumi.get(self, "spot")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The list of instance tags applied to all nodes.
        			Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation.
        			Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.GetGcpNodePoolTaintResult']]:
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the node pool will be associated with.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="totalMaxNodeCount")
    def total_max_node_count(self) -> int:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= minNodeCount.
        """
        return pulumi.get(self, "total_max_node_count")

    @property
    @pulumi.getter(name="totalMinNodeCount")
    def total_min_node_count(self) -> int:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= maxNodeCount.
        """
        return pulumi.get(self, "total_min_node_count")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Sequence['outputs.GetGcpNodePoolUpgradeSettingResult']:
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        """
        The list of Google Compute Engine zones in which the NodePool's nodes should be located.
        """
        return pulumi.get(self, "zones")


class AwaitableGetGcpNodePoolResult(GetGcpNodePoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpNodePoolResult(
            accelerators=self.accelerators,
            auto_repair=self.auto_repair,
            auto_upgrade=self.auto_upgrade,
            disc_size_gb=self.disc_size_gb,
            disc_type=self.disc_type,
            fullname=self.fullname,
            id=self.id,
            image_type=self.image_type,
            initial_node_count=self.initial_node_count,
            is_autoscaling_enabled=self.is_autoscaling_enabled,
            labels=self.labels,
            linux_node_configs=self.linux_node_configs,
            location_policy=self.location_policy,
            machine_type=self.machine_type,
            max_node_count=self.max_node_count,
            metadata=self.metadata,
            min_node_count=self.min_node_count,
            name=self.name,
            node_pool_logging_configs=self.node_pool_logging_configs,
            oauth_scopes=self.oauth_scopes,
            resource_labels=self.resource_labels,
            spot=self.spot,
            tags=self.tags,
            taints=self.taints,
            tenant_id=self.tenant_id,
            total_max_node_count=self.total_max_node_count,
            total_min_node_count=self.total_min_node_count,
            upgrade_settings=self.upgrade_settings,
            zones=self.zones)


def get_gcp_node_pool(accelerators: Optional[Sequence[Union['GetGcpNodePoolAcceleratorArgs', 'GetGcpNodePoolAcceleratorArgsDict']]] = None,
                      name: Optional[str] = None,
                      taints: Optional[Sequence[Union['GetGcpNodePoolTaintArgs', 'GetGcpNodePoolTaintArgsDict']]] = None,
                      tenant_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpNodePoolResult:
    """
    `GcpNodePool` retrieves a node pool in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    pool = duplocloud.get_gcp_node_pool(tenant_id="tenantid",
        name="nodepool-name")
    pulumi.export("nodepoolOutput", {
        "name": pool.name,
        "machineType": pool.machine_type,
        "zones": pool.zones,
        "discSizeGb": pool.disc_size_gb,
        "discType": pool.disc_type,
        "upgradeSettings": pool.upgrade_settings,
    })
    ```


    :param str name: The short name of the node pool.
    :param str tenant_id: The GUID of the tenant that the node pool will be associated with.
    """
    __args__ = dict()
    __args__['accelerators'] = accelerators
    __args__['name'] = name
    __args__['taints'] = taints
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getGcpNodePool:getGcpNodePool', __args__, opts=opts, typ=GetGcpNodePoolResult).value

    return AwaitableGetGcpNodePoolResult(
        accelerators=pulumi.get(__ret__, 'accelerators'),
        auto_repair=pulumi.get(__ret__, 'auto_repair'),
        auto_upgrade=pulumi.get(__ret__, 'auto_upgrade'),
        disc_size_gb=pulumi.get(__ret__, 'disc_size_gb'),
        disc_type=pulumi.get(__ret__, 'disc_type'),
        fullname=pulumi.get(__ret__, 'fullname'),
        id=pulumi.get(__ret__, 'id'),
        image_type=pulumi.get(__ret__, 'image_type'),
        initial_node_count=pulumi.get(__ret__, 'initial_node_count'),
        is_autoscaling_enabled=pulumi.get(__ret__, 'is_autoscaling_enabled'),
        labels=pulumi.get(__ret__, 'labels'),
        linux_node_configs=pulumi.get(__ret__, 'linux_node_configs'),
        location_policy=pulumi.get(__ret__, 'location_policy'),
        machine_type=pulumi.get(__ret__, 'machine_type'),
        max_node_count=pulumi.get(__ret__, 'max_node_count'),
        metadata=pulumi.get(__ret__, 'metadata'),
        min_node_count=pulumi.get(__ret__, 'min_node_count'),
        name=pulumi.get(__ret__, 'name'),
        node_pool_logging_configs=pulumi.get(__ret__, 'node_pool_logging_configs'),
        oauth_scopes=pulumi.get(__ret__, 'oauth_scopes'),
        resource_labels=pulumi.get(__ret__, 'resource_labels'),
        spot=pulumi.get(__ret__, 'spot'),
        tags=pulumi.get(__ret__, 'tags'),
        taints=pulumi.get(__ret__, 'taints'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        total_max_node_count=pulumi.get(__ret__, 'total_max_node_count'),
        total_min_node_count=pulumi.get(__ret__, 'total_min_node_count'),
        upgrade_settings=pulumi.get(__ret__, 'upgrade_settings'),
        zones=pulumi.get(__ret__, 'zones'))
def get_gcp_node_pool_output(accelerators: Optional[pulumi.Input[Optional[Sequence[Union['GetGcpNodePoolAcceleratorArgs', 'GetGcpNodePoolAcceleratorArgsDict']]]]] = None,
                             name: Optional[pulumi.Input[str]] = None,
                             taints: Optional[pulumi.Input[Optional[Sequence[Union['GetGcpNodePoolTaintArgs', 'GetGcpNodePoolTaintArgsDict']]]]] = None,
                             tenant_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpNodePoolResult]:
    """
    `GcpNodePool` retrieves a node pool in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    pool = duplocloud.get_gcp_node_pool(tenant_id="tenantid",
        name="nodepool-name")
    pulumi.export("nodepoolOutput", {
        "name": pool.name,
        "machineType": pool.machine_type,
        "zones": pool.zones,
        "discSizeGb": pool.disc_size_gb,
        "discType": pool.disc_type,
        "upgradeSettings": pool.upgrade_settings,
    })
    ```


    :param str name: The short name of the node pool.
    :param str tenant_id: The GUID of the tenant that the node pool will be associated with.
    """
    __args__ = dict()
    __args__['accelerators'] = accelerators
    __args__['name'] = name
    __args__['taints'] = taints
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getGcpNodePool:getGcpNodePool', __args__, opts=opts, typ=GetGcpNodePoolResult)
    return __ret__.apply(lambda __response__: GetGcpNodePoolResult(
        accelerators=pulumi.get(__response__, 'accelerators'),
        auto_repair=pulumi.get(__response__, 'auto_repair'),
        auto_upgrade=pulumi.get(__response__, 'auto_upgrade'),
        disc_size_gb=pulumi.get(__response__, 'disc_size_gb'),
        disc_type=pulumi.get(__response__, 'disc_type'),
        fullname=pulumi.get(__response__, 'fullname'),
        id=pulumi.get(__response__, 'id'),
        image_type=pulumi.get(__response__, 'image_type'),
        initial_node_count=pulumi.get(__response__, 'initial_node_count'),
        is_autoscaling_enabled=pulumi.get(__response__, 'is_autoscaling_enabled'),
        labels=pulumi.get(__response__, 'labels'),
        linux_node_configs=pulumi.get(__response__, 'linux_node_configs'),
        location_policy=pulumi.get(__response__, 'location_policy'),
        machine_type=pulumi.get(__response__, 'machine_type'),
        max_node_count=pulumi.get(__response__, 'max_node_count'),
        metadata=pulumi.get(__response__, 'metadata'),
        min_node_count=pulumi.get(__response__, 'min_node_count'),
        name=pulumi.get(__response__, 'name'),
        node_pool_logging_configs=pulumi.get(__response__, 'node_pool_logging_configs'),
        oauth_scopes=pulumi.get(__response__, 'oauth_scopes'),
        resource_labels=pulumi.get(__response__, 'resource_labels'),
        spot=pulumi.get(__response__, 'spot'),
        tags=pulumi.get(__response__, 'tags'),
        taints=pulumi.get(__response__, 'taints'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        total_max_node_count=pulumi.get(__response__, 'total_max_node_count'),
        total_min_node_count=pulumi.get(__response__, 'total_min_node_count'),
        upgrade_settings=pulumi.get(__response__, 'upgrade_settings'),
        zones=pulumi.get(__response__, 'zones')))
