# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGcpNodePoolsResult',
    'AwaitableGetGcpNodePoolsResult',
    'get_gcp_node_pools',
    'get_gcp_node_pools_output',
]

@pulumi.output_type
class GetGcpNodePoolsResult:
    """
    A collection of values returned by getGcpNodePools.
    """
    def __init__(__self__, id=None, node_pools=None, tenant_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        pulumi.set(__self__, "node_pools", node_pools)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence['outputs.GetGcpNodePoolsNodePoolResult']:
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the node pool will be associated with.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetGcpNodePoolsResult(GetGcpNodePoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpNodePoolsResult(
            id=self.id,
            node_pools=self.node_pools,
            tenant_id=self.tenant_id)


def get_gcp_node_pools(tenant_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpNodePoolsResult:
    """
    `get_gcp_node_pools` retrieves list of node pools in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_node_pools(tenant_id="tenantid")
    pulumi.export("nodepoolOutput", {
        "nodePools": app.node_pools,
    })
    ```


    :param str tenant_id: The GUID of the tenant that the node pool will be associated with.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getGcpNodePools:getGcpNodePools', __args__, opts=opts, typ=GetGcpNodePoolsResult).value

    return AwaitableGetGcpNodePoolsResult(
        id=pulumi.get(__ret__, 'id'),
        node_pools=pulumi.get(__ret__, 'node_pools'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_gcp_node_pools_output(tenant_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpNodePoolsResult]:
    """
    `get_gcp_node_pools` retrieves list of node pools in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_node_pools(tenant_id="tenantid")
    pulumi.export("nodepoolOutput", {
        "nodePools": app.node_pools,
    })
    ```


    :param str tenant_id: The GUID of the tenant that the node pool will be associated with.
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getGcpNodePools:getGcpNodePools', __args__, opts=opts, typ=GetGcpNodePoolsResult)
    return __ret__.apply(lambda __response__: GetGcpNodePoolsResult(
        id=pulumi.get(__response__, 'id'),
        node_pools=pulumi.get(__response__, 'node_pools'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
