# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGcpRedisInstanceResult',
    'AwaitableGetGcpRedisInstanceResult',
    'get_gcp_redis_instance',
    'get_gcp_redis_instance_output',
]

@pulumi.output_type
class GetGcpRedisInstanceResult:
    """
    A collection of values returned by getGcpRedisInstance.
    """
    def __init__(__self__, auth_enabled=None, display_name=None, fullname=None, id=None, labels=None, memory_size_gb=None, name=None, read_replicas_enabled=None, redis_configs=None, redis_version=None, replica_count=None, tenant_id=None, tier=None, transit_encryption_enabled=None):
        if auth_enabled and not isinstance(auth_enabled, bool):
            raise TypeError("Expected argument 'auth_enabled' to be a bool")
        pulumi.set(__self__, "auth_enabled", auth_enabled)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fullname and not isinstance(fullname, str):
            raise TypeError("Expected argument 'fullname' to be a str")
        pulumi.set(__self__, "fullname", fullname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if memory_size_gb and not isinstance(memory_size_gb, int):
            raise TypeError("Expected argument 'memory_size_gb' to be a int")
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if read_replicas_enabled and not isinstance(read_replicas_enabled, bool):
            raise TypeError("Expected argument 'read_replicas_enabled' to be a bool")
        pulumi.set(__self__, "read_replicas_enabled", read_replicas_enabled)
        if redis_configs and not isinstance(redis_configs, dict):
            raise TypeError("Expected argument 'redis_configs' to be a dict")
        pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version and not isinstance(redis_version, str):
            raise TypeError("Expected argument 'redis_version' to be a str")
        pulumi.set(__self__, "redis_version", redis_version)
        if replica_count and not isinstance(replica_count, int):
            raise TypeError("Expected argument 'replica_count' to be a int")
        pulumi.set(__self__, "replica_count", replica_count)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if transit_encryption_enabled and not isinstance(transit_encryption_enabled, bool):
            raise TypeError("Expected argument 'transit_encryption_enabled' to be a bool")
        pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> bool:
        """
        Indicates whether OSS Redis AUTH is enabled for the instance. If set to "true" AUTH is enabled on the instance. Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fullname(self) -> str:
        """
        The full name of the of the Redis instance.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> int:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The short name of the redis instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readReplicasEnabled")
    def read_replicas_enabled(self) -> bool:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance.
        """
        return pulumi.get(self, "read_replicas_enabled")

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Mapping[str, str]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config. Please check Memorystore documentation for the list of supported parameters: https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> str:
        """
        The version of Redis software. If not provided, latest supported version will be used. Please check the API documentation linked at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> int:
        """
        The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default is 1. The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the redis instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The service tier of the instance. Must be one of these values: BASIC: standalone instance or STANDARD*HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD*HA"]
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> bool:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        """
        return pulumi.get(self, "transit_encryption_enabled")


class AwaitableGetGcpRedisInstanceResult(GetGcpRedisInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpRedisInstanceResult(
            auth_enabled=self.auth_enabled,
            display_name=self.display_name,
            fullname=self.fullname,
            id=self.id,
            labels=self.labels,
            memory_size_gb=self.memory_size_gb,
            name=self.name,
            read_replicas_enabled=self.read_replicas_enabled,
            redis_configs=self.redis_configs,
            redis_version=self.redis_version,
            replica_count=self.replica_count,
            tenant_id=self.tenant_id,
            tier=self.tier,
            transit_encryption_enabled=self.transit_encryption_enabled)


def get_gcp_redis_instance(name: Optional[str] = None,
                           tenant_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpRedisInstanceResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_redis_instance(tenant_id="tenant_id",
        name="name")
    pulumi.export("out", {
        "name": app.name,
        "displayName": app.display_name,
        "memorySizeGb": app.memory_size_gb,
        "readReplicasEnabled": app.read_replicas_enabled,
        "redisConfigs": app.redis_configs,
        "redisVersion": app.redis_version,
        "replicaCount": app.replica_count,
        "authEnabled": app.auth_enabled,
        "transitEncryptionEnabled": app.transit_encryption_enabled,
        "tier": app.tier,
        "labels": app.labels,
    })
    ```


    :param str name: The short name of the redis instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
    :param str tenant_id: The GUID of the tenant that the redis instance will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getGcpRedisInstance:getGcpRedisInstance', __args__, opts=opts, typ=GetGcpRedisInstanceResult).value

    return AwaitableGetGcpRedisInstanceResult(
        auth_enabled=pulumi.get(__ret__, 'auth_enabled'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fullname=pulumi.get(__ret__, 'fullname'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        memory_size_gb=pulumi.get(__ret__, 'memory_size_gb'),
        name=pulumi.get(__ret__, 'name'),
        read_replicas_enabled=pulumi.get(__ret__, 'read_replicas_enabled'),
        redis_configs=pulumi.get(__ret__, 'redis_configs'),
        redis_version=pulumi.get(__ret__, 'redis_version'),
        replica_count=pulumi.get(__ret__, 'replica_count'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        tier=pulumi.get(__ret__, 'tier'),
        transit_encryption_enabled=pulumi.get(__ret__, 'transit_encryption_enabled'))
def get_gcp_redis_instance_output(name: Optional[pulumi.Input[str]] = None,
                                  tenant_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpRedisInstanceResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    app = duplocloud.get_gcp_redis_instance(tenant_id="tenant_id",
        name="name")
    pulumi.export("out", {
        "name": app.name,
        "displayName": app.display_name,
        "memorySizeGb": app.memory_size_gb,
        "readReplicasEnabled": app.read_replicas_enabled,
        "redisConfigs": app.redis_configs,
        "redisVersion": app.redis_version,
        "replicaCount": app.replica_count,
        "authEnabled": app.auth_enabled,
        "transitEncryptionEnabled": app.transit_encryption_enabled,
        "tier": app.tier,
        "labels": app.labels,
    })
    ```


    :param str name: The short name of the redis instance.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
    :param str tenant_id: The GUID of the tenant that the redis instance will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getGcpRedisInstance:getGcpRedisInstance', __args__, opts=opts, typ=GetGcpRedisInstanceResult)
    return __ret__.apply(lambda __response__: GetGcpRedisInstanceResult(
        auth_enabled=pulumi.get(__response__, 'auth_enabled'),
        display_name=pulumi.get(__response__, 'display_name'),
        fullname=pulumi.get(__response__, 'fullname'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        memory_size_gb=pulumi.get(__response__, 'memory_size_gb'),
        name=pulumi.get(__response__, 'name'),
        read_replicas_enabled=pulumi.get(__response__, 'read_replicas_enabled'),
        redis_configs=pulumi.get(__response__, 'redis_configs'),
        redis_version=pulumi.get(__response__, 'redis_version'),
        replica_count=pulumi.get(__response__, 'replica_count'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        tier=pulumi.get(__response__, 'tier'),
        transit_encryption_enabled=pulumi.get(__response__, 'transit_encryption_enabled')))
