# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGcpSqlDatabaseInstanceResult',
    'AwaitableGetGcpSqlDatabaseInstanceResult',
    'get_gcp_sql_database_instance',
    'get_gcp_sql_database_instance_output',
]

@pulumi.output_type
class GetGcpSqlDatabaseInstanceResult:
    """
    A collection of values returned by getGcpSqlDatabaseInstance.
    """
    def __init__(__self__, connection_name=None, database_version=None, disk_size=None, fullname=None, id=None, ip_addresses=None, labels=None, name=None, self_link=None, tenant_id=None, tier=None, wait_until_ready=None):
        if connection_name and not isinstance(connection_name, str):
            raise TypeError("Expected argument 'connection_name' to be a str")
        pulumi.set(__self__, "connection_name", connection_name)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if disk_size and not isinstance(disk_size, int):
            raise TypeError("Expected argument 'disk_size' to be a int")
        pulumi.set(__self__, "disk_size", disk_size)
        if fullname and not isinstance(fullname, str):
            raise TypeError("Expected argument 'fullname' to be a str")
        pulumi.set(__self__, "fullname", fullname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if wait_until_ready and not isinstance(wait_until_ready, bool):
            raise TypeError("Expected argument 'wait_until_ready' to be a bool")
        pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        """
        Connection name  of the database.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> str:
        """
        The MySQL, PostgreSQL orSQL Server version to use.Supported values include `MYSQL_5_6`,`MYSQL_5_7`, `MYSQL_8_0`, `POSTGRES_9_6`,`POSTGRES_10`,`POSTGRES_11`,`POSTGRES_12`, `POSTGRES_13`, `POSTGRES_14`, `POSTGRES_15`, `SQLSERVER_2017_STANDARD`,`SQLSERVER_2017_ENTERPRISE`,`SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`.`SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`,`SQLSERVER_2019_WEB`.[Database Version Policies](https://cloud.google.com/sql/docs/db-versions)includes an up-to-date reference of supported versions.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter
    def fullname(self) -> str:
        """
        The full name of the sql database.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        IP address of the database.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Map of string keys and values that can be used to organize and categorize this resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The short name of the sql database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The SelfLink of the sql database.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the sql database will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The machine type to use. See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as `db-custom-2-13312`.See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> bool:
        """
        Whether or not to wait until sql database instance to be ready, after creation.
        """
        return pulumi.get(self, "wait_until_ready")


class AwaitableGetGcpSqlDatabaseInstanceResult(GetGcpSqlDatabaseInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpSqlDatabaseInstanceResult(
            connection_name=self.connection_name,
            database_version=self.database_version,
            disk_size=self.disk_size,
            fullname=self.fullname,
            id=self.id,
            ip_addresses=self.ip_addresses,
            labels=self.labels,
            name=self.name,
            self_link=self.self_link,
            tenant_id=self.tenant_id,
            tier=self.tier,
            wait_until_ready=self.wait_until_ready)


def get_gcp_sql_database_instance(name: Optional[str] = None,
                                  tenant_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpSqlDatabaseInstanceResult:
    """
    `GcpSqlDatabaseInstance` retrieves a gcp sql instance in Duplo.


    :param str name: The short name of the sql database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
    :param str tenant_id: The GUID of the tenant that the sql database will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getGcpSqlDatabaseInstance:getGcpSqlDatabaseInstance', __args__, opts=opts, typ=GetGcpSqlDatabaseInstanceResult).value

    return AwaitableGetGcpSqlDatabaseInstanceResult(
        connection_name=pulumi.get(__ret__, 'connection_name'),
        database_version=pulumi.get(__ret__, 'database_version'),
        disk_size=pulumi.get(__ret__, 'disk_size'),
        fullname=pulumi.get(__ret__, 'fullname'),
        id=pulumi.get(__ret__, 'id'),
        ip_addresses=pulumi.get(__ret__, 'ip_addresses'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        self_link=pulumi.get(__ret__, 'self_link'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        tier=pulumi.get(__ret__, 'tier'),
        wait_until_ready=pulumi.get(__ret__, 'wait_until_ready'))
def get_gcp_sql_database_instance_output(name: Optional[pulumi.Input[str]] = None,
                                         tenant_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGcpSqlDatabaseInstanceResult]:
    """
    `GcpSqlDatabaseInstance` retrieves a gcp sql instance in Duplo.


    :param str name: The short name of the sql database.  Duplo will add a prefix to the name.  You can retrieve the full name from the `fullname` attribute.
    :param str tenant_id: The GUID of the tenant that the sql database will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getGcpSqlDatabaseInstance:getGcpSqlDatabaseInstance', __args__, opts=opts, typ=GetGcpSqlDatabaseInstanceResult)
    return __ret__.apply(lambda __response__: GetGcpSqlDatabaseInstanceResult(
        connection_name=pulumi.get(__response__, 'connection_name'),
        database_version=pulumi.get(__response__, 'database_version'),
        disk_size=pulumi.get(__response__, 'disk_size'),
        fullname=pulumi.get(__response__, 'fullname'),
        id=pulumi.get(__response__, 'id'),
        ip_addresses=pulumi.get(__response__, 'ip_addresses'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        self_link=pulumi.get(__response__, 'self_link'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        tier=pulumi.get(__response__, 'tier'),
        wait_until_ready=pulumi.get(__response__, 'wait_until_ready')))
