# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInfrastructureResult',
    'AwaitableGetInfrastructureResult',
    'get_infrastructure',
    'get_infrastructure_output',
]

@pulumi.output_type
class GetInfrastructureResult:
    """
    A collection of values returned by getInfrastructure.
    """
    def __init__(__self__, account_id=None, address_prefix=None, azcount=None, cloud=None, enable_k8_cluster=None, id=None, infra_name=None, private_subnets=None, public_subnets=None, region=None, security_groups=None, status=None, subnet_cidr=None, tenant_id=None, vpc_id=None, vpc_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if address_prefix and not isinstance(address_prefix, str):
            raise TypeError("Expected argument 'address_prefix' to be a str")
        pulumi.set(__self__, "address_prefix", address_prefix)
        if azcount and not isinstance(azcount, int):
            raise TypeError("Expected argument 'azcount' to be a int")
        pulumi.set(__self__, "azcount", azcount)
        if cloud and not isinstance(cloud, int):
            raise TypeError("Expected argument 'cloud' to be a int")
        pulumi.set(__self__, "cloud", cloud)
        if enable_k8_cluster and not isinstance(enable_k8_cluster, bool):
            raise TypeError("Expected argument 'enable_k8_cluster' to be a bool")
        pulumi.set(__self__, "enable_k8_cluster", enable_k8_cluster)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infra_name and not isinstance(infra_name, str):
            raise TypeError("Expected argument 'infra_name' to be a str")
        pulumi.set(__self__, "infra_name", infra_name)
        if private_subnets and not isinstance(private_subnets, list):
            raise TypeError("Expected argument 'private_subnets' to be a list")
        pulumi.set(__self__, "private_subnets", private_subnets)
        if public_subnets and not isinstance(public_subnets, list):
            raise TypeError("Expected argument 'public_subnets' to be a list")
        pulumi.set(__self__, "public_subnets", public_subnets)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_cidr and not isinstance(subnet_cidr, int):
            raise TypeError("Expected argument 'subnet_cidr' to be a int")
        pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name and not isinstance(vpc_name, str):
            raise TypeError("Expected argument 'vpc_name' to be a str")
        pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> str:
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def azcount(self) -> int:
        return pulumi.get(self, "azcount")

    @property
    @pulumi.getter
    def cloud(self) -> int:
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> bool:
        return pulumi.get(self, "enable_k8_cluster")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> str:
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter(name="privateSubnets")
    def private_subnets(self) -> Sequence['outputs.GetInfrastructurePrivateSubnetResult']:
        return pulumi.get(self, "private_subnets")

    @property
    @pulumi.getter(name="publicSubnets")
    def public_subnets(self) -> Sequence['outputs.GetInfrastructurePublicSubnetResult']:
        return pulumi.get(self, "public_subnets")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence['outputs.GetInfrastructureSecurityGroupResult']:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> int:
        return pulumi.get(self, "subnet_cidr")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        return pulumi.get(self, "vpc_name")


class AwaitableGetInfrastructureResult(GetInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInfrastructureResult(
            account_id=self.account_id,
            address_prefix=self.address_prefix,
            azcount=self.azcount,
            cloud=self.cloud,
            enable_k8_cluster=self.enable_k8_cluster,
            id=self.id,
            infra_name=self.infra_name,
            private_subnets=self.private_subnets,
            public_subnets=self.public_subnets,
            region=self.region,
            security_groups=self.security_groups,
            status=self.status,
            subnet_cidr=self.subnet_cidr,
            tenant_id=self.tenant_id,
            vpc_id=self.vpc_id,
            vpc_name=self.vpc_name)


def get_infrastructure(infra_name: Optional[str] = None,
                       tenant_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInfrastructureResult:
    """
    `Infrastructure` retrieves details of an infrastructure in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    # Example 1 - look up an infrastructure by tenant ID.
    myinfra1 = duplocloud.get_infrastructure(tenant_id=tenant_id)
    # Example 2 - look up an infrastructure by name.
    myinfra2 = duplocloud.get_infrastructure(infra_name="myinfra")
    # Example 3 - look up list of certificates by plan ID.
    cert_list = duplocloud.get_plan_certificates(plan_id="default")
    # Example 3 - look up plan certificates by plan ID and certificate name.
    single_cert = duplocloud.get_plan_certificate(plan_id="default",
        name="poc.duplocloud.net")
    ```
    """
    __args__ = dict()
    __args__['infraName'] = infra_name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getInfrastructure:getInfrastructure', __args__, opts=opts, typ=GetInfrastructureResult).value

    return AwaitableGetInfrastructureResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        address_prefix=pulumi.get(__ret__, 'address_prefix'),
        azcount=pulumi.get(__ret__, 'azcount'),
        cloud=pulumi.get(__ret__, 'cloud'),
        enable_k8_cluster=pulumi.get(__ret__, 'enable_k8_cluster'),
        id=pulumi.get(__ret__, 'id'),
        infra_name=pulumi.get(__ret__, 'infra_name'),
        private_subnets=pulumi.get(__ret__, 'private_subnets'),
        public_subnets=pulumi.get(__ret__, 'public_subnets'),
        region=pulumi.get(__ret__, 'region'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        status=pulumi.get(__ret__, 'status'),
        subnet_cidr=pulumi.get(__ret__, 'subnet_cidr'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_name=pulumi.get(__ret__, 'vpc_name'))
def get_infrastructure_output(infra_name: Optional[pulumi.Input[Optional[str]]] = None,
                              tenant_id: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInfrastructureResult]:
    """
    `Infrastructure` retrieves details of an infrastructure in Duplo.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    # Example 1 - look up an infrastructure by tenant ID.
    myinfra1 = duplocloud.get_infrastructure(tenant_id=tenant_id)
    # Example 2 - look up an infrastructure by name.
    myinfra2 = duplocloud.get_infrastructure(infra_name="myinfra")
    # Example 3 - look up list of certificates by plan ID.
    cert_list = duplocloud.get_plan_certificates(plan_id="default")
    # Example 3 - look up plan certificates by plan ID and certificate name.
    single_cert = duplocloud.get_plan_certificate(plan_id="default",
        name="poc.duplocloud.net")
    ```
    """
    __args__ = dict()
    __args__['infraName'] = infra_name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getInfrastructure:getInfrastructure', __args__, opts=opts, typ=GetInfrastructureResult)
    return __ret__.apply(lambda __response__: GetInfrastructureResult(
        account_id=pulumi.get(__response__, 'account_id'),
        address_prefix=pulumi.get(__response__, 'address_prefix'),
        azcount=pulumi.get(__response__, 'azcount'),
        cloud=pulumi.get(__response__, 'cloud'),
        enable_k8_cluster=pulumi.get(__response__, 'enable_k8_cluster'),
        id=pulumi.get(__response__, 'id'),
        infra_name=pulumi.get(__response__, 'infra_name'),
        private_subnets=pulumi.get(__response__, 'private_subnets'),
        public_subnets=pulumi.get(__response__, 'public_subnets'),
        region=pulumi.get(__response__, 'region'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        status=pulumi.get(__response__, 'status'),
        subnet_cidr=pulumi.get(__response__, 'subnet_cidr'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpc_name=pulumi.get(__response__, 'vpc_name')))
