# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetK8ConfigMapResult',
    'AwaitableGetK8ConfigMapResult',
    'get_k8_config_map',
    'get_k8_config_map_output',
]

@pulumi.output_type
class GetK8ConfigMapResult:
    """
    A collection of values returned by getK8ConfigMap.
    """
    def __init__(__self__, data=None, id=None, metadata=None, name=None, tenant_id=None):
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        A JSON encoded string representing the configmap data. You can use the `jsondecode()` function to parse this, if needed.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        A JSON encoded string representing the configmap metadata. You can use the `jsondecode()` function to parse this, if needed.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the configmap.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the configmap will be created in.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetK8ConfigMapResult(GetK8ConfigMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetK8ConfigMapResult(
            data=self.data,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            tenant_id=self.tenant_id)


def get_k8_config_map(name: Optional[str] = None,
                      tenant_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetK8ConfigMapResult:
    """
    `K8ConfigMap` reads data from a single kubernetes configmap in a Duplo tenant.


    :param str name: The name of the configmap.
    :param str tenant_id: The GUID of the tenant that the configmap will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getK8ConfigMap:getK8ConfigMap', __args__, opts=opts, typ=GetK8ConfigMapResult).value

    return AwaitableGetK8ConfigMapResult(
        data=pulumi.get(__ret__, 'data'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_k8_config_map_output(name: Optional[pulumi.Input[str]] = None,
                             tenant_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetK8ConfigMapResult]:
    """
    `K8ConfigMap` reads data from a single kubernetes configmap in a Duplo tenant.


    :param str name: The name of the configmap.
    :param str tenant_id: The GUID of the tenant that the configmap will be created in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getK8ConfigMap:getK8ConfigMap', __args__, opts=opts, typ=GetK8ConfigMapResult)
    return __ret__.apply(lambda __response__: GetK8ConfigMapResult(
        data=pulumi.get(__response__, 'data'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
