# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetK8ConfigMapsResult',
    'AwaitableGetK8ConfigMapsResult',
    'get_k8_config_maps',
    'get_k8_config_maps_output',
]

@pulumi.output_type
class GetK8ConfigMapsResult:
    """
    A collection of values returned by getK8ConfigMaps.
    """
    def __init__(__self__, config_maps=None, id=None, tenant_id=None):
        if config_maps and not isinstance(config_maps, list):
            raise TypeError("Expected argument 'config_maps' to be a list")
        pulumi.set(__self__, "config_maps", config_maps)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="configMaps")
    def config_maps(self) -> Sequence['outputs.GetK8ConfigMapsConfigMapResult']:
        return pulumi.get(self, "config_maps")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        return pulumi.get(self, "tenant_id")


class AwaitableGetK8ConfigMapsResult(GetK8ConfigMapsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetK8ConfigMapsResult(
            config_maps=self.config_maps,
            id=self.id,
            tenant_id=self.tenant_id)


def get_k8_config_maps(tenant_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetK8ConfigMapsResult:
    """
    `get_k8_config_maps` lists all kubernetes configmaps in a Duplo tenant.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    test = duplocloud.get_k8_config_maps(tenant_id=tenant_id)
    pulumi.export("configMaps", test.config_maps)
    ```
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getK8ConfigMaps:getK8ConfigMaps', __args__, opts=opts, typ=GetK8ConfigMapsResult).value

    return AwaitableGetK8ConfigMapsResult(
        config_maps=pulumi.get(__ret__, 'config_maps'),
        id=pulumi.get(__ret__, 'id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_k8_config_maps_output(tenant_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetK8ConfigMapsResult]:
    """
    `get_k8_config_maps` lists all kubernetes configmaps in a Duplo tenant.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    test = duplocloud.get_k8_config_maps(tenant_id=tenant_id)
    pulumi.export("configMaps", test.config_maps)
    ```
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getK8ConfigMaps:getK8ConfigMaps', __args__, opts=opts, typ=GetK8ConfigMapsResult)
    return __ret__.apply(lambda __response__: GetK8ConfigMapsResult(
        config_maps=pulumi.get(__response__, 'config_maps'),
        id=pulumi.get(__response__, 'id'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
