# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetK8SecretResult',
    'AwaitableGetK8SecretResult',
    'get_k8_secret',
    'get_k8_secret_output',
]

@pulumi.output_type
class GetK8SecretResult:
    """
    A collection of values returned by getK8Secret.
    """
    def __init__(__self__, id=None, secret_annotations=None, secret_data=None, secret_labels=None, secret_name=None, secret_type=None, secret_version=None, tenant_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if secret_annotations and not isinstance(secret_annotations, dict):
            raise TypeError("Expected argument 'secret_annotations' to be a dict")
        pulumi.set(__self__, "secret_annotations", secret_annotations)
        if secret_data and not isinstance(secret_data, str):
            raise TypeError("Expected argument 'secret_data' to be a str")
        pulumi.set(__self__, "secret_data", secret_data)
        if secret_labels and not isinstance(secret_labels, dict):
            raise TypeError("Expected argument 'secret_labels' to be a dict")
        pulumi.set(__self__, "secret_labels", secret_labels)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if secret_type and not isinstance(secret_type, str):
            raise TypeError("Expected argument 'secret_type' to be a str")
        pulumi.set(__self__, "secret_type", secret_type)
        if secret_version and not isinstance(secret_version, str):
            raise TypeError("Expected argument 'secret_version' to be a str")
        pulumi.set(__self__, "secret_version", secret_version)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="secretAnnotations")
    def secret_annotations(self) -> Mapping[str, str]:
        """
        Annotations for the secret
        """
        return pulumi.get(self, "secret_annotations")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> str:
        """
        A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretLabels")
    def secret_labels(self) -> Mapping[str, str]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        """
        return pulumi.get(self, "secret_labels")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> str:
        """
        The type of the secret.  Usually `"Opaque"`.
        """
        return pulumi.get(self, "secret_type")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> str:
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetK8SecretResult(GetK8SecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetK8SecretResult(
            id=self.id,
            secret_annotations=self.secret_annotations,
            secret_data=self.secret_data,
            secret_labels=self.secret_labels,
            secret_name=self.secret_name,
            secret_type=self.secret_type,
            secret_version=self.secret_version,
            tenant_id=self.tenant_id)


def get_k8_secret(secret_name: Optional[str] = None,
                  tenant_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetK8SecretResult:
    """
    Use this data source to access information about an existing resource.

    :param str secret_name: The name of the secret.
    :param str tenant_id: The GUID of the tenant that the secret will be created in.
    """
    __args__ = dict()
    __args__['secretName'] = secret_name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getK8Secret:getK8Secret', __args__, opts=opts, typ=GetK8SecretResult).value

    return AwaitableGetK8SecretResult(
        id=pulumi.get(__ret__, 'id'),
        secret_annotations=pulumi.get(__ret__, 'secret_annotations'),
        secret_data=pulumi.get(__ret__, 'secret_data'),
        secret_labels=pulumi.get(__ret__, 'secret_labels'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        secret_type=pulumi.get(__ret__, 'secret_type'),
        secret_version=pulumi.get(__ret__, 'secret_version'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_k8_secret_output(secret_name: Optional[pulumi.Input[str]] = None,
                         tenant_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetK8SecretResult]:
    """
    Use this data source to access information about an existing resource.

    :param str secret_name: The name of the secret.
    :param str tenant_id: The GUID of the tenant that the secret will be created in.
    """
    __args__ = dict()
    __args__['secretName'] = secret_name
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getK8Secret:getK8Secret', __args__, opts=opts, typ=GetK8SecretResult)
    return __ret__.apply(lambda __response__: GetK8SecretResult(
        id=pulumi.get(__response__, 'id'),
        secret_annotations=pulumi.get(__response__, 'secret_annotations'),
        secret_data=pulumi.get(__response__, 'secret_data'),
        secret_labels=pulumi.get(__response__, 'secret_labels'),
        secret_name=pulumi.get(__response__, 'secret_name'),
        secret_type=pulumi.get(__response__, 'secret_type'),
        secret_version=pulumi.get(__response__, 'secret_version'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
