# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetK8sCronJobResult',
    'AwaitableGetK8sCronJobResult',
    'get_k8s_cron_job',
    'get_k8s_cron_job_output',
]

@pulumi.output_type
class GetK8sCronJobResult:
    """
    A collection of values returned by getK8sCronJob.
    """
    def __init__(__self__, id=None, is_any_host_allowed=None, metadata=None, specs=None, tenant_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_any_host_allowed and not isinstance(is_any_host_allowed, bool):
            raise TypeError("Expected argument 'is_any_host_allowed' to be a bool")
        pulumi.set(__self__, "is_any_host_allowed", is_any_host_allowed)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> Optional[bool]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.GetK8sCronJobMetadataResult':
        """
        Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetK8sCronJobSpecResult']:
        """
        Spec of the cron job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetK8sCronJobResult(GetK8sCronJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetK8sCronJobResult(
            id=self.id,
            is_any_host_allowed=self.is_any_host_allowed,
            metadata=self.metadata,
            specs=self.specs,
            tenant_id=self.tenant_id)


def get_k8s_cron_job(is_any_host_allowed: Optional[bool] = None,
                     metadata: Optional[Union['GetK8sCronJobMetadataArgs', 'GetK8sCronJobMetadataArgsDict']] = None,
                     tenant_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetK8sCronJobResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    job = duplocloud.get_k8s_cron_job(tenant_id=tenant_id,
        metadata={
            "name": "datajob",
        })
    pulumi.export("metadata", job.metadata.namespace)
    ```


    :param bool is_any_host_allowed: Defaults to `false`.
    :param Union['GetK8sCronJobMetadataArgs', 'GetK8sCronJobMetadataArgsDict'] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
    :param str tenant_id: The GUID of the tenant that the job will be created in.
    """
    __args__ = dict()
    __args__['isAnyHostAllowed'] = is_any_host_allowed
    __args__['metadata'] = metadata
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getK8sCronJob:getK8sCronJob', __args__, opts=opts, typ=GetK8sCronJobResult).value

    return AwaitableGetK8sCronJobResult(
        id=pulumi.get(__ret__, 'id'),
        is_any_host_allowed=pulumi.get(__ret__, 'is_any_host_allowed'),
        metadata=pulumi.get(__ret__, 'metadata'),
        specs=pulumi.get(__ret__, 'specs'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_k8s_cron_job_output(is_any_host_allowed: Optional[pulumi.Input[Optional[bool]]] = None,
                            metadata: Optional[pulumi.Input[Union['GetK8sCronJobMetadataArgs', 'GetK8sCronJobMetadataArgsDict']]] = None,
                            tenant_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetK8sCronJobResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_duplocloud as duplocloud

    job = duplocloud.get_k8s_cron_job(tenant_id=tenant_id,
        metadata={
            "name": "datajob",
        })
    pulumi.export("metadata", job.metadata.namespace)
    ```


    :param bool is_any_host_allowed: Defaults to `false`.
    :param Union['GetK8sCronJobMetadataArgs', 'GetK8sCronJobMetadataArgsDict'] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
    :param str tenant_id: The GUID of the tenant that the job will be created in.
    """
    __args__ = dict()
    __args__['isAnyHostAllowed'] = is_any_host_allowed
    __args__['metadata'] = metadata
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getK8sCronJob:getK8sCronJob', __args__, opts=opts, typ=GetK8sCronJobResult)
    return __ret__.apply(lambda __response__: GetK8sCronJobResult(
        id=pulumi.get(__response__, 'id'),
        is_any_host_allowed=pulumi.get(__response__, 'is_any_host_allowed'),
        metadata=pulumi.get(__response__, 'metadata'),
        specs=pulumi.get(__response__, 'specs'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
