# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPlanCertificateResult',
    'AwaitableGetPlanCertificateResult',
    'get_plan_certificate',
    'get_plan_certificate_output',
]

@pulumi.output_type
class GetPlanCertificateResult:
    """
    A collection of values returned by getPlanCertificate.
    """
    def __init__(__self__, arn=None, id=None, name=None, plan_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the certificate
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A domain name for which the certificate should be issued
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The plan ID
        """
        return pulumi.get(self, "plan_id")


class AwaitableGetPlanCertificateResult(GetPlanCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanCertificateResult(
            arn=self.arn,
            id=self.id,
            name=self.name,
            plan_id=self.plan_id)


def get_plan_certificate(name: Optional[str] = None,
                         plan_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanCertificateResult:
    """
    `get_plan_certificate` retrieves details of a specific certificate for a given plan.


    :param str name: A domain name for which the certificate should be issued
    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanCertificate:getPlanCertificate', __args__, opts=opts, typ=GetPlanCertificateResult).value

    return AwaitableGetPlanCertificateResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        plan_id=pulumi.get(__ret__, 'plan_id'))
def get_plan_certificate_output(name: Optional[pulumi.Input[str]] = None,
                                plan_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanCertificateResult]:
    """
    `get_plan_certificate` retrieves details of a specific certificate for a given plan.


    :param str name: A domain name for which the certificate should be issued
    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanCertificate:getPlanCertificate', __args__, opts=opts, typ=GetPlanCertificateResult)
    return __ret__.apply(lambda __response__: GetPlanCertificateResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        plan_id=pulumi.get(__response__, 'plan_id')))
