# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPlanCertificatesResult',
    'AwaitableGetPlanCertificatesResult',
    'get_plan_certificates',
    'get_plan_certificates_output',
]

@pulumi.output_type
class GetPlanCertificatesResult:
    """
    A collection of values returned by getPlanCertificates.
    """
    def __init__(__self__, certificates=None, id=None, plan_id=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetPlanCertificatesCertificateResult']:
        """
        The list of certificates for this plan.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The plan ID
        """
        return pulumi.get(self, "plan_id")


class AwaitableGetPlanCertificatesResult(GetPlanCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanCertificatesResult(
            certificates=self.certificates,
            id=self.id,
            plan_id=self.plan_id)


def get_plan_certificates(plan_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanCertificatesResult:
    """
    `PlanCertificates` retrieves a list of cerificates for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanCertificates:getPlanCertificates', __args__, opts=opts, typ=GetPlanCertificatesResult).value

    return AwaitableGetPlanCertificatesResult(
        certificates=pulumi.get(__ret__, 'certificates'),
        id=pulumi.get(__ret__, 'id'),
        plan_id=pulumi.get(__ret__, 'plan_id'))
def get_plan_certificates_output(plan_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanCertificatesResult]:
    """
    `PlanCertificates` retrieves a list of cerificates for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanCertificates:getPlanCertificates', __args__, opts=opts, typ=GetPlanCertificatesResult)
    return __ret__.apply(lambda __response__: GetPlanCertificatesResult(
        certificates=pulumi.get(__response__, 'certificates'),
        id=pulumi.get(__response__, 'id'),
        plan_id=pulumi.get(__response__, 'plan_id')))
