# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPlanImageResult',
    'AwaitableGetPlanImageResult',
    'get_plan_image',
    'get_plan_image_output',
]

@pulumi.output_type
class GetPlanImageResult:
    """
    A collection of values returned by getPlanImage.
    """
    def __init__(__self__, id=None, image_id=None, name=None, os=None, plan_id=None, tags=None, username=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def os(self) -> str:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The plan ID
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetPlanImageTagResult']:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


class AwaitableGetPlanImageResult(GetPlanImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanImageResult(
            id=self.id,
            image_id=self.image_id,
            name=self.name,
            os=self.os,
            plan_id=self.plan_id,
            tags=self.tags,
            username=self.username)


def get_plan_image(name: Optional[str] = None,
                   plan_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanImageResult:
    """
    `get_plan_image` retrieves details of a specific image for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanImage:getPlanImage', __args__, opts=opts, typ=GetPlanImageResult).value

    return AwaitableGetPlanImageResult(
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        name=pulumi.get(__ret__, 'name'),
        os=pulumi.get(__ret__, 'os'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        tags=pulumi.get(__ret__, 'tags'),
        username=pulumi.get(__ret__, 'username'))
def get_plan_image_output(name: Optional[pulumi.Input[str]] = None,
                          plan_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanImageResult]:
    """
    `get_plan_image` retrieves details of a specific image for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanImage:getPlanImage', __args__, opts=opts, typ=GetPlanImageResult)
    return __ret__.apply(lambda __response__: GetPlanImageResult(
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        name=pulumi.get(__response__, 'name'),
        os=pulumi.get(__response__, 'os'),
        plan_id=pulumi.get(__response__, 'plan_id'),
        tags=pulumi.get(__response__, 'tags'),
        username=pulumi.get(__response__, 'username')))
