# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPlanImagesResult',
    'AwaitableGetPlanImagesResult',
    'get_plan_images',
    'get_plan_images_output',
]

@pulumi.output_type
class GetPlanImagesResult:
    """
    A collection of values returned by getPlanImages.
    """
    def __init__(__self__, id=None, images=None, plan_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetPlanImagesImageResult']:
        """
        The list of images for this plan.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The plan ID
        """
        return pulumi.get(self, "plan_id")


class AwaitableGetPlanImagesResult(GetPlanImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanImagesResult(
            id=self.id,
            images=self.images,
            plan_id=self.plan_id)


def get_plan_images(plan_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanImagesResult:
    """
    `PlanImages` retrieves a list of images for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanImages:getPlanImages', __args__, opts=opts, typ=GetPlanImagesResult).value

    return AwaitableGetPlanImagesResult(
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        plan_id=pulumi.get(__ret__, 'plan_id'))
def get_plan_images_output(plan_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanImagesResult]:
    """
    `PlanImages` retrieves a list of images for a given plan.


    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanImages:getPlanImages', __args__, opts=opts, typ=GetPlanImagesResult)
    return __ret__.apply(lambda __response__: GetPlanImagesResult(
        id=pulumi.get(__response__, 'id'),
        images=pulumi.get(__response__, 'images'),
        plan_id=pulumi.get(__response__, 'plan_id')))
