# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPlanSettingsResult',
    'AwaitableGetPlanSettingsResult',
    'get_plan_settings',
    'get_plan_settings_output',
]

@pulumi.output_type
class GetPlanSettingsResult:
    """
    A collection of values returned by getPlanSettings.
    """
    def __init__(__self__, dns_settings=None, id=None, include_global_dns=None, metadatas=None, plan_id=None, unrestricted_ext_lb=None):
        if dns_settings and not isinstance(dns_settings, list):
            raise TypeError("Expected argument 'dns_settings' to be a list")
        pulumi.set(__self__, "dns_settings", dns_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_global_dns and not isinstance(include_global_dns, bool):
            raise TypeError("Expected argument 'include_global_dns' to be a bool")
        pulumi.set(__self__, "include_global_dns", include_global_dns)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if unrestricted_ext_lb and not isinstance(unrestricted_ext_lb, bool):
            raise TypeError("Expected argument 'unrestricted_ext_lb' to be a bool")
        pulumi.set(__self__, "unrestricted_ext_lb", unrestricted_ext_lb)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Sequence['outputs.GetPlanSettingsDnsSettingResult']:
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeGlobalDns")
    def include_global_dns(self) -> Optional[bool]:
        """
        Defaults to `true`.
        """
        return pulumi.get(self, "include_global_dns")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetPlanSettingsMetadataResult']:
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="unrestrictedExtLb")
    def unrestricted_ext_lb(self) -> bool:
        return pulumi.get(self, "unrestricted_ext_lb")


class AwaitableGetPlanSettingsResult(GetPlanSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanSettingsResult(
            dns_settings=self.dns_settings,
            id=self.id,
            include_global_dns=self.include_global_dns,
            metadatas=self.metadatas,
            plan_id=self.plan_id,
            unrestricted_ext_lb=self.unrestricted_ext_lb)


def get_plan_settings(include_global_dns: Optional[bool] = None,
                      plan_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanSettingsResult:
    """
    `PlanSettings` manages an plan settings in Duplo.


    :param bool include_global_dns: Defaults to `true`.
    """
    __args__ = dict()
    __args__['includeGlobalDns'] = include_global_dns
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanSettings:getPlanSettings', __args__, opts=opts, typ=GetPlanSettingsResult).value

    return AwaitableGetPlanSettingsResult(
        dns_settings=pulumi.get(__ret__, 'dns_settings'),
        id=pulumi.get(__ret__, 'id'),
        include_global_dns=pulumi.get(__ret__, 'include_global_dns'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        unrestricted_ext_lb=pulumi.get(__ret__, 'unrestricted_ext_lb'))
def get_plan_settings_output(include_global_dns: Optional[pulumi.Input[Optional[bool]]] = None,
                             plan_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanSettingsResult]:
    """
    `PlanSettings` manages an plan settings in Duplo.


    :param bool include_global_dns: Defaults to `true`.
    """
    __args__ = dict()
    __args__['includeGlobalDns'] = include_global_dns
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanSettings:getPlanSettings', __args__, opts=opts, typ=GetPlanSettingsResult)
    return __ret__.apply(lambda __response__: GetPlanSettingsResult(
        dns_settings=pulumi.get(__response__, 'dns_settings'),
        id=pulumi.get(__response__, 'id'),
        include_global_dns=pulumi.get(__response__, 'include_global_dns'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        plan_id=pulumi.get(__response__, 'plan_id'),
        unrestricted_ext_lb=pulumi.get(__response__, 'unrestricted_ext_lb')))
