# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPlanWafV2Result',
    'AwaitableGetPlanWafV2Result',
    'get_plan_waf_v2',
    'get_plan_waf_v2_output',
]

@pulumi.output_type
class GetPlanWafV2Result:
    """
    A collection of values returned by getPlanWafV2.
    """
    def __init__(__self__, arn=None, dashboard_url=None, id=None, name=None, plan_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dashboard_url and not isinstance(dashboard_url, str):
            raise TypeError("Expected argument 'dashboard_url' to be a str")
        pulumi.set(__self__, "dashboard_url", dashboard_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the waf
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> str:
        """
        The dashboard url associated to waf
        """
        return pulumi.get(self, "dashboard_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the waf  issued
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The plan ID
        """
        return pulumi.get(self, "plan_id")


class AwaitableGetPlanWafV2Result(GetPlanWafV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanWafV2Result(
            arn=self.arn,
            dashboard_url=self.dashboard_url,
            id=self.id,
            name=self.name,
            plan_id=self.plan_id)


def get_plan_waf_v2(name: Optional[str] = None,
                    plan_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanWafV2Result:
    """
    `PlanWaf` retrieves details of a specific waf for a given plan.


    :param str name: Name of the waf  issued
    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('duplocloud:index/getPlanWafV2:getPlanWafV2', __args__, opts=opts, typ=GetPlanWafV2Result).value

    return AwaitableGetPlanWafV2Result(
        arn=pulumi.get(__ret__, 'arn'),
        dashboard_url=pulumi.get(__ret__, 'dashboard_url'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        plan_id=pulumi.get(__ret__, 'plan_id'))
def get_plan_waf_v2_output(name: Optional[pulumi.Input[str]] = None,
                           plan_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanWafV2Result]:
    """
    `PlanWaf` retrieves details of a specific waf for a given plan.


    :param str name: Name of the waf  issued
    :param str plan_id: The plan ID
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['planId'] = plan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('duplocloud:index/getPlanWafV2:getPlanWafV2', __args__, opts=opts, typ=GetPlanWafV2Result)
    return __ret__.apply(lambda __response__: GetPlanWafV2Result(
        arn=pulumi.get(__response__, 'arn'),
        dashboard_url=pulumi.get(__response__, 'dashboard_url'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        plan_id=pulumi.get(__response__, 'plan_id')))
