# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureArgs', 'Infrastructure']

@pulumi.input_type
class InfrastructureArgs:
    def __init__(__self__, *,
                 address_prefix: pulumi.Input[str],
                 enable_k8_cluster: pulumi.Input[bool],
                 infra_name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cluster_ip_cidr: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 enable_container_insights: Optional[pulumi.Input[bool]] = None,
                 enable_ecs_cluster: Optional[pulumi.Input[bool]] = None,
                 is_serverless_kubernetes: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]] = None,
                 subnet_address_prefix: Optional[pulumi.Input[str]] = None,
                 subnet_cidr: Optional[pulumi.Input[int]] = None,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 wait_until_deleted: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Infrastructure resource.
        :param pulumi.Input[str] address_prefix: The CIDR to use for the VPC or VNet.
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] region: The cloud provider region. The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[str] account_id: The cloud account ID.
        :param pulumi.Input[int] azcount: The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[int] cloud: The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
               Google
        :param pulumi.Input[str] cluster_ip_cidr: cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
               recommended to change the default value of `false`.
        :param pulumi.Input[bool] enable_container_insights: Whether or not to enable container insights for an ECS cluster.
        :param pulumi.Input[bool] enable_ecs_cluster: Whether or not to provision an ECS cluster.
        :param pulumi.Input[bool] is_serverless_kubernetes: Whether or not to make GKE with autopilot.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[str] subnet_address_prefix: The address prefixe to use for the subnet. This is applicable only for Azure
        :param pulumi.Input[int] subnet_cidr: The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        :param pulumi.Input[str] subnet_name: The name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[bool] wait_until_deleted: Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        pulumi.set(__self__, "address_prefix", address_prefix)
        pulumi.set(__self__, "enable_k8_cluster", enable_k8_cluster)
        pulumi.set(__self__, "infra_name", infra_name)
        pulumi.set(__self__, "region", region)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if azcount is not None:
            pulumi.set(__self__, "azcount", azcount)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cluster_ip_cidr is not None:
            pulumi.set(__self__, "cluster_ip_cidr", cluster_ip_cidr)
        if custom_datas is not None:
            warnings.warn("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""", DeprecationWarning)
            pulumi.log.warn("""custom_datas is deprecated: The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if enable_container_insights is not None:
            pulumi.set(__self__, "enable_container_insights", enable_container_insights)
        if enable_ecs_cluster is not None:
            pulumi.set(__self__, "enable_ecs_cluster", enable_ecs_cluster)
        if is_serverless_kubernetes is not None:
            pulumi.set(__self__, "is_serverless_kubernetes", is_serverless_kubernetes)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if subnet_address_prefix is not None:
            pulumi.set(__self__, "subnet_address_prefix", subnet_address_prefix)
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if wait_until_deleted is not None:
            pulumi.set(__self__, "wait_until_deleted", wait_until_deleted)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Input[str]:
        """
        The CIDR to use for the VPC or VNet.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> pulumi.Input[bool]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @enable_k8_cluster.setter
    def enable_k8_cluster(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_k8_cluster", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The cloud provider region. The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def azcount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @azcount.setter
    def azcount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "azcount", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
        Google
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="clusterIpCidr")
    def cluster_ip_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        """
        return pulumi.get(self, "cluster_ip_cidr")

    @cluster_ip_cidr.setter
    def cluster_ip_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ip_cidr", value)

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
        recommended to change the default value of `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter(name="enableContainerInsights")
    def enable_container_insights(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable container insights for an ECS cluster.
        """
        return pulumi.get(self, "enable_container_insights")

    @enable_container_insights.setter
    def enable_container_insights(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_container_insights", value)

    @property
    @pulumi.getter(name="enableEcsCluster")
    def enable_ecs_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to provision an ECS cluster.
        """
        return pulumi.get(self, "enable_ecs_cluster")

    @enable_ecs_cluster.setter
    def enable_ecs_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ecs_cluster", value)

    @property
    @pulumi.getter(name="isServerlessKubernetes")
    def is_serverless_kubernetes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to make GKE with autopilot.
        """
        return pulumi.get(self, "is_serverless_kubernetes")

    @is_serverless_kubernetes.setter
    def is_serverless_kubernetes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_serverless_kubernetes", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="subnetAddressPrefix")
    def subnet_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The address prefixe to use for the subnet. This is applicable only for Azure
        """
        return pulumi.get(self, "subnet_address_prefix")

    @subnet_address_prefix.setter
    def subnet_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_address_prefix", value)

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[pulumi.Input[int]]:
        """
        The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        """
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_cidr", value)

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet. This is applicable only for Azure.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_name", value)

    @property
    @pulumi.getter(name="waitUntilDeleted")
    def wait_until_deleted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        return pulumi.get(self, "wait_until_deleted")

    @wait_until_deleted.setter
    def wait_until_deleted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_deleted", value)


@pulumi.input_type
class _InfrastructureState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 all_settings: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureAllSettingArgs']]]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cluster_ip_cidr: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 enable_container_insights: Optional[pulumi.Input[bool]] = None,
                 enable_ecs_cluster: Optional[pulumi.Input[bool]] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 is_serverless_kubernetes: Optional[pulumi.Input[bool]] = None,
                 private_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePrivateSubnetArgs']]]] = None,
                 public_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePublicSubnetArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSecurityGroupArgs']]]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]] = None,
                 specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_address_prefix: Optional[pulumi.Input[str]] = None,
                 subnet_cidr: Optional[pulumi.Input[int]] = None,
                 subnet_fullname: Optional[pulumi.Input[str]] = None,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None,
                 wait_until_deleted: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Infrastructure resources.
        :param pulumi.Input[str] account_id: The cloud account ID.
        :param pulumi.Input[str] address_prefix: The CIDR to use for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureAllSettingArgs']]] all_settings: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource.
        :param pulumi.Input[int] azcount: The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[int] cloud: The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
               Google
        :param pulumi.Input[str] cluster_ip_cidr: cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
               recommended to change the default value of `false`.
        :param pulumi.Input[bool] enable_container_insights: Whether or not to enable container insights for an ECS cluster.
        :param pulumi.Input[bool] enable_ecs_cluster: Whether or not to provision an ECS cluster.
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[bool] is_serverless_kubernetes: Whether or not to make GKE with autopilot.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructurePrivateSubnetArgs']]] private_subnets: The private subnets for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructurePublicSubnetArgs']]] public_subnets: The public subnets for the VPC or VNet.
        :param pulumi.Input[str] region: The cloud provider region. The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSecurityGroupArgs']]] security_groups: The security groups for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        :param pulumi.Input[str] status: The status of the infrastructure.
        :param pulumi.Input[str] subnet_address_prefix: The address prefixe to use for the subnet. This is applicable only for Azure
        :param pulumi.Input[int] subnet_cidr: The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        :param pulumi.Input[str] subnet_fullname: The full name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[str] subnet_name: The name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[str] vpc_id: The VPC or VNet ID.
        :param pulumi.Input[str] vpc_name: The VPC or VNet name.
        :param pulumi.Input[bool] wait_until_deleted: Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if all_settings is not None:
            pulumi.set(__self__, "all_settings", all_settings)
        if azcount is not None:
            pulumi.set(__self__, "azcount", azcount)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cluster_ip_cidr is not None:
            pulumi.set(__self__, "cluster_ip_cidr", cluster_ip_cidr)
        if custom_datas is not None:
            warnings.warn("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""", DeprecationWarning)
            pulumi.log.warn("""custom_datas is deprecated: The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if enable_container_insights is not None:
            pulumi.set(__self__, "enable_container_insights", enable_container_insights)
        if enable_ecs_cluster is not None:
            pulumi.set(__self__, "enable_ecs_cluster", enable_ecs_cluster)
        if enable_k8_cluster is not None:
            pulumi.set(__self__, "enable_k8_cluster", enable_k8_cluster)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if is_serverless_kubernetes is not None:
            pulumi.set(__self__, "is_serverless_kubernetes", is_serverless_kubernetes)
        if private_subnets is not None:
            pulumi.set(__self__, "private_subnets", private_subnets)
        if public_subnets is not None:
            pulumi.set(__self__, "public_subnets", public_subnets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if specified_settings is not None:
            pulumi.set(__self__, "specified_settings", specified_settings)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_address_prefix is not None:
            pulumi.set(__self__, "subnet_address_prefix", subnet_address_prefix)
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if subnet_fullname is not None:
            pulumi.set(__self__, "subnet_fullname", subnet_fullname)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if wait_until_deleted is not None:
            pulumi.set(__self__, "wait_until_deleted", wait_until_deleted)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR to use for the VPC or VNet.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureAllSettingArgs']]]]:
        """
        A complete list of configuration settings for this infrastructure, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_settings")

    @all_settings.setter
    def all_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureAllSettingArgs']]]]):
        pulumi.set(self, "all_settings", value)

    @property
    @pulumi.getter
    def azcount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @azcount.setter
    def azcount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "azcount", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
        Google
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="clusterIpCidr")
    def cluster_ip_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        """
        return pulumi.get(self, "cluster_ip_cidr")

    @cluster_ip_cidr.setter
    def cluster_ip_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ip_cidr", value)

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
        recommended to change the default value of `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter(name="enableContainerInsights")
    def enable_container_insights(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable container insights for an ECS cluster.
        """
        return pulumi.get(self, "enable_container_insights")

    @enable_container_insights.setter
    def enable_container_insights(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_container_insights", value)

    @property
    @pulumi.getter(name="enableEcsCluster")
    def enable_ecs_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to provision an ECS cluster.
        """
        return pulumi.get(self, "enable_ecs_cluster")

    @enable_ecs_cluster.setter
    def enable_ecs_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ecs_cluster", value)

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @enable_k8_cluster.setter
    def enable_k8_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_k8_cluster", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="isServerlessKubernetes")
    def is_serverless_kubernetes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to make GKE with autopilot.
        """
        return pulumi.get(self, "is_serverless_kubernetes")

    @is_serverless_kubernetes.setter
    def is_serverless_kubernetes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_serverless_kubernetes", value)

    @property
    @pulumi.getter(name="privateSubnets")
    def private_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePrivateSubnetArgs']]]]:
        """
        The private subnets for the VPC or VNet.
        """
        return pulumi.get(self, "private_subnets")

    @private_subnets.setter
    def private_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePrivateSubnetArgs']]]]):
        pulumi.set(self, "private_subnets", value)

    @property
    @pulumi.getter(name="publicSubnets")
    def public_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePublicSubnetArgs']]]]:
        """
        The public subnets for the VPC or VNet.
        """
        return pulumi.get(self, "public_subnets")

    @public_subnets.setter
    def public_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructurePublicSubnetArgs']]]]):
        pulumi.set(self, "public_subnets", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud provider region. The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSecurityGroupArgs']]]]:
        """
        The security groups for the VPC or VNet.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSecurityGroupArgs']]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

    @specified_settings.setter
    def specified_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_settings", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetAddressPrefix")
    def subnet_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The address prefixe to use for the subnet. This is applicable only for Azure
        """
        return pulumi.get(self, "subnet_address_prefix")

    @subnet_address_prefix.setter
    def subnet_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_address_prefix", value)

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[pulumi.Input[int]]:
        """
        The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        """
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_cidr", value)

    @property
    @pulumi.getter(name="subnetFullname")
    def subnet_fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the subnet. This is applicable only for Azure.
        """
        return pulumi.get(self, "subnet_fullname")

    @subnet_fullname.setter
    def subnet_fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_fullname", value)

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet. This is applicable only for Azure.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC or VNet ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC or VNet name.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_name", value)

    @property
    @pulumi.getter(name="waitUntilDeleted")
    def wait_until_deleted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        return pulumi.get(self, "wait_until_deleted")

    @wait_until_deleted.setter
    def wait_until_deleted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_deleted", value)


class Infrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cluster_ip_cidr: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureCustomDataArgs', 'InfrastructureCustomDataArgsDict']]]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 enable_container_insights: Optional[pulumi.Input[bool]] = None,
                 enable_ecs_cluster: Optional[pulumi.Input[bool]] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 is_serverless_kubernetes: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingArgs', 'InfrastructureSettingArgsDict']]]]] = None,
                 subnet_address_prefix: Optional[pulumi.Input[str]] = None,
                 subnet_cidr: Optional[pulumi.Input[int]] = None,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 wait_until_deleted: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Create a DuploCloud infrastructure named nonprod

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=True,
            address_prefix="10.11.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named nonprod with cidr 10.34.0.0/16 in us-west-2 region

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=True,
            address_prefix="10.34.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named nonprod with cidr 10.30.0.0/16 in us-east-1 region with EKS cluster

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-east-1",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.30.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.30.0.0/16, a subnet mask of 24, and EKS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.30.0.0/16",
            subnet_cidr=24)
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.30.0.0/16, a subnet mask of 24, and an EKS cluster disabled with an ingress controller

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        prod_infra = duplocloud.Infrastructure("prod_infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=False,
            address_prefix="10.30.0.0/16",
            subnet_cidr=24)
        settings = duplocloud.InfrastructureSetting("settings",
            infra_name=prod_infra.infra_name,
            settings=[{
                "key": "EnableAwsAlbIngress",
                "value": "true",
            }])
        ```

        ### Create a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster enabled with an autoscaler

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=24)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            infra_name=nonprod_infra.infra_name,
            settings=[{
                "key": "EnableClusterAutoscaler",
                "value": "true",
            }])
        ```

        ### Create a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster enabled with an autoscaler, ingress controller, and Secrets Store CSI Driver

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=24)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            infra_name=nonprod_infra.infra_name,
            settings=[
                {
                    "key": "EnableClusterAutoscaler",
                    "value": "true",
                },
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
            ])
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.50.0.0/16, a subnet mask of 22, and ECS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_ecs_cluster=True,
            address_prefix="10.50.0.0/16",
            subnet_cidr=22)
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.49.0.0/16, a subnet mask of 24, and EKS, ECS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=True,
            enable_ecs_cluster=True,
            address_prefix="10.49.0.0/16",
            subnet_cidr=24)
        ```

        ### Set up a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster configured with an autoscaler, ingress controller, and Secrets Store CSI Driver using variables and dynamic blocks.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        config = pulumi.Config()
        infra_settings = config.get_object("infraSettings")
        if infra_settings is None:
            infra_settings = [
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
                {
                    "key": "EnableClusterAutoscaler",
                    "value": "true",
                },
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
            ]
        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=22)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            settings=[{
                "key": entry["value"]["key"],
                "value": entry["value"]["value"],
            } for entry in [{"key": k, "value": v} for k, v in infra_settings]],
            infra_name=nonprod_infra.infra_name)
        ```

        ## Import

        Example: Importing an existing infrastructure

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructure:Infrastructure myinfra v2/admin/InfrastructureV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The cloud account ID.
        :param pulumi.Input[str] address_prefix: The CIDR to use for the VPC or VNet.
        :param pulumi.Input[int] azcount: The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[int] cloud: The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
               Google
        :param pulumi.Input[str] cluster_ip_cidr: cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureCustomDataArgs', 'InfrastructureCustomDataArgsDict']]]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
               recommended to change the default value of `false`.
        :param pulumi.Input[bool] enable_container_insights: Whether or not to enable container insights for an ECS cluster.
        :param pulumi.Input[bool] enable_ecs_cluster: Whether or not to provision an ECS cluster.
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[bool] is_serverless_kubernetes: Whether or not to make GKE with autopilot.
        :param pulumi.Input[str] region: The cloud provider region. The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingArgs', 'InfrastructureSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[str] subnet_address_prefix: The address prefixe to use for the subnet. This is applicable only for Azure
        :param pulumi.Input[int] subnet_cidr: The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        :param pulumi.Input[str] subnet_name: The name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[bool] wait_until_deleted: Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Create a DuploCloud infrastructure named nonprod

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=True,
            address_prefix="10.11.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named nonprod with cidr 10.34.0.0/16 in us-west-2 region

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=True,
            address_prefix="10.34.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named nonprod with cidr 10.30.0.0/16 in us-east-1 region with EKS cluster

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="nonprod",
            cloud=0,
            region="us-east-1",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.30.0.0/16")
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.30.0.0/16, a subnet mask of 24, and EKS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.30.0.0/16",
            subnet_cidr=24)
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.30.0.0/16, a subnet mask of 24, and an EKS cluster disabled with an ingress controller

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        prod_infra = duplocloud.Infrastructure("prod_infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=False,
            address_prefix="10.30.0.0/16",
            subnet_cidr=24)
        settings = duplocloud.InfrastructureSetting("settings",
            infra_name=prod_infra.infra_name,
            settings=[{
                "key": "EnableAwsAlbIngress",
                "value": "true",
            }])
        ```

        ### Create a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster enabled with an autoscaler

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=24)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            infra_name=nonprod_infra.infra_name,
            settings=[{
                "key": "EnableClusterAutoscaler",
                "value": "true",
            }])
        ```

        ### Create a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster enabled with an autoscaler, ingress controller, and Secrets Store CSI Driver

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=24)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            infra_name=nonprod_infra.infra_name,
            settings=[
                {
                    "key": "EnableClusterAutoscaler",
                    "value": "true",
                },
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
            ])
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.50.0.0/16, a subnet mask of 22, and ECS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_ecs_cluster=True,
            address_prefix="10.50.0.0/16",
            subnet_cidr=22)
        ```

        ### Create a DuploCloud infrastructure named 'prod' in the us-east-2 region, with a VPC CIDR of 10.49.0.0/16, a subnet mask of 24, and EKS, ECS cluster enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-east-2",
            azcount=2,
            enable_k8_cluster=True,
            enable_ecs_cluster=True,
            address_prefix="10.49.0.0/16",
            subnet_cidr=24)
        ```

        ### Set up a DuploCloud infrastructure named 'nonprod' in the us-west-2 region, with a VPC CIDR of 10.60.0.0/16, a subnet mask of 24, and an EKS cluster configured with an autoscaler, ingress controller, and Secrets Store CSI Driver using variables and dynamic blocks.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        config = pulumi.Config()
        infra_settings = config.get_object("infraSettings")
        if infra_settings is None:
            infra_settings = [
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
                {
                    "key": "EnableClusterAutoscaler",
                    "value": "true",
                },
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
            ]
        nonprod_infra = duplocloud.Infrastructure("nonprod_infra",
            infra_name="nonprod",
            cloud=0,
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.60.0.0/16",
            subnet_cidr=22)
        nonprod_settings = duplocloud.InfrastructureSetting("nonprod_settings",
            settings=[{
                "key": entry["value"]["key"],
                "value": entry["value"]["value"],
            } for entry in [{"key": k, "value": v} for k, v in infra_settings]],
            infra_name=nonprod_infra.infra_name)
        ```

        ## Import

        Example: Importing an existing infrastructure

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructure:Infrastructure myinfra v2/admin/InfrastructureV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cloud: Optional[pulumi.Input[int]] = None,
                 cluster_ip_cidr: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureCustomDataArgs', 'InfrastructureCustomDataArgsDict']]]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 enable_container_insights: Optional[pulumi.Input[bool]] = None,
                 enable_ecs_cluster: Optional[pulumi.Input[bool]] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 is_serverless_kubernetes: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingArgs', 'InfrastructureSettingArgsDict']]]]] = None,
                 subnet_address_prefix: Optional[pulumi.Input[str]] = None,
                 subnet_cidr: Optional[pulumi.Input[int]] = None,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 wait_until_deleted: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureArgs.__new__(InfrastructureArgs)

            __props__.__dict__["account_id"] = account_id
            if address_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'address_prefix'")
            __props__.__dict__["address_prefix"] = address_prefix
            __props__.__dict__["azcount"] = azcount
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["cluster_ip_cidr"] = cluster_ip_cidr
            __props__.__dict__["custom_datas"] = custom_datas
            __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
            __props__.__dict__["enable_container_insights"] = enable_container_insights
            __props__.__dict__["enable_ecs_cluster"] = enable_ecs_cluster
            if enable_k8_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'enable_k8_cluster'")
            __props__.__dict__["enable_k8_cluster"] = enable_k8_cluster
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["is_serverless_kubernetes"] = is_serverless_kubernetes
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["subnet_address_prefix"] = subnet_address_prefix
            __props__.__dict__["subnet_cidr"] = subnet_cidr
            __props__.__dict__["subnet_name"] = subnet_name
            __props__.__dict__["wait_until_deleted"] = wait_until_deleted
            __props__.__dict__["all_settings"] = None
            __props__.__dict__["private_subnets"] = None
            __props__.__dict__["public_subnets"] = None
            __props__.__dict__["security_groups"] = None
            __props__.__dict__["specified_settings"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_fullname"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["vpc_name"] = None
        super(Infrastructure, __self__).__init__(
            'duplocloud:index/infrastructure:Infrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            address_prefix: Optional[pulumi.Input[str]] = None,
            all_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureAllSettingArgs', 'InfrastructureAllSettingArgsDict']]]]] = None,
            azcount: Optional[pulumi.Input[int]] = None,
            cloud: Optional[pulumi.Input[int]] = None,
            cluster_ip_cidr: Optional[pulumi.Input[str]] = None,
            custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureCustomDataArgs', 'InfrastructureCustomDataArgsDict']]]]] = None,
            delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
            enable_container_insights: Optional[pulumi.Input[bool]] = None,
            enable_ecs_cluster: Optional[pulumi.Input[bool]] = None,
            enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            is_serverless_kubernetes: Optional[pulumi.Input[bool]] = None,
            private_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructurePrivateSubnetArgs', 'InfrastructurePrivateSubnetArgsDict']]]]] = None,
            public_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructurePublicSubnetArgs', 'InfrastructurePublicSubnetArgsDict']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSecurityGroupArgs', 'InfrastructureSecurityGroupArgsDict']]]]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingArgs', 'InfrastructureSettingArgsDict']]]]] = None,
            specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_address_prefix: Optional[pulumi.Input[str]] = None,
            subnet_cidr: Optional[pulumi.Input[int]] = None,
            subnet_fullname: Optional[pulumi.Input[str]] = None,
            subnet_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_name: Optional[pulumi.Input[str]] = None,
            wait_until_deleted: Optional[pulumi.Input[bool]] = None) -> 'Infrastructure':
        """
        Get an existing Infrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The cloud account ID.
        :param pulumi.Input[str] address_prefix: The CIDR to use for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureAllSettingArgs', 'InfrastructureAllSettingArgsDict']]]] all_settings: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource.
        :param pulumi.Input[int] azcount: The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[int] cloud: The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
               Google
        :param pulumi.Input[str] cluster_ip_cidr: cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureCustomDataArgs', 'InfrastructureCustomDataArgsDict']]]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
               recommended to change the default value of `false`.
        :param pulumi.Input[bool] enable_container_insights: Whether or not to enable container insights for an ECS cluster.
        :param pulumi.Input[bool] enable_ecs_cluster: Whether or not to provision an ECS cluster.
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[bool] is_serverless_kubernetes: Whether or not to make GKE with autopilot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructurePrivateSubnetArgs', 'InfrastructurePrivateSubnetArgsDict']]]] private_subnets: The private subnets for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructurePublicSubnetArgs', 'InfrastructurePublicSubnetArgsDict']]]] public_subnets: The public subnets for the VPC or VNet.
        :param pulumi.Input[str] region: The cloud provider region. The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSecurityGroupArgs', 'InfrastructureSecurityGroupArgsDict']]]] security_groups: The security groups for the VPC or VNet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingArgs', 'InfrastructureSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        :param pulumi.Input[str] status: The status of the infrastructure.
        :param pulumi.Input[str] subnet_address_prefix: The address prefixe to use for the subnet. This is applicable only for Azure
        :param pulumi.Input[int] subnet_cidr: The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        :param pulumi.Input[str] subnet_fullname: The full name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[str] subnet_name: The name of the subnet. This is applicable only for Azure.
        :param pulumi.Input[str] vpc_id: The VPC or VNet ID.
        :param pulumi.Input[str] vpc_name: The VPC or VNet name.
        :param pulumi.Input[bool] wait_until_deleted: Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureState.__new__(_InfrastructureState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["address_prefix"] = address_prefix
        __props__.__dict__["all_settings"] = all_settings
        __props__.__dict__["azcount"] = azcount
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["cluster_ip_cidr"] = cluster_ip_cidr
        __props__.__dict__["custom_datas"] = custom_datas
        __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
        __props__.__dict__["enable_container_insights"] = enable_container_insights
        __props__.__dict__["enable_ecs_cluster"] = enable_ecs_cluster
        __props__.__dict__["enable_k8_cluster"] = enable_k8_cluster
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["is_serverless_kubernetes"] = is_serverless_kubernetes
        __props__.__dict__["private_subnets"] = private_subnets
        __props__.__dict__["public_subnets"] = public_subnets
        __props__.__dict__["region"] = region
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["settings"] = settings
        __props__.__dict__["specified_settings"] = specified_settings
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_address_prefix"] = subnet_address_prefix
        __props__.__dict__["subnet_cidr"] = subnet_cidr
        __props__.__dict__["subnet_fullname"] = subnet_fullname
        __props__.__dict__["subnet_name"] = subnet_name
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_name"] = vpc_name
        __props__.__dict__["wait_until_deleted"] = wait_until_deleted
        return Infrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The cloud account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Output[str]:
        """
        The CIDR to use for the VPC or VNet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> pulumi.Output[Sequence['outputs.InfrastructureAllSetting']]:
        """
        A complete list of configuration settings for this infrastructure, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_settings")

    @property
    @pulumi.getter
    def azcount(self) -> pulumi.Output[Optional[int]]:
        """
        The number of availability zones. Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[int]]:
        """
        The numerical index of cloud provider to use for the infrastructure. Should be one of: - `0` : AWS - `2` : Azure - `3` :
        Google
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="clusterIpCidr")
    def cluster_ip_cidr(self) -> pulumi.Output[str]:
        """
        cluster IP CIDR defines a private IP address range used for internal Kubernetes services.
        """
        return pulumi.get(self, "cluster_ip_cidr")

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureCustomData']]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:** It is not
        recommended to change the default value of `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @property
    @pulumi.getter(name="enableContainerInsights")
    def enable_container_insights(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable container insights for an ECS cluster.
        """
        return pulumi.get(self, "enable_container_insights")

    @property
    @pulumi.getter(name="enableEcsCluster")
    def enable_ecs_cluster(self) -> pulumi.Output[bool]:
        """
        Whether or not to provision an ECS cluster.
        """
        return pulumi.get(self, "enable_ecs_cluster")

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> pulumi.Output[bool]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure. Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter(name="isServerlessKubernetes")
    def is_serverless_kubernetes(self) -> pulumi.Output[bool]:
        """
        Whether or not to make GKE with autopilot.
        """
        return pulumi.get(self, "is_serverless_kubernetes")

    @property
    @pulumi.getter(name="privateSubnets")
    def private_subnets(self) -> pulumi.Output[Sequence['outputs.InfrastructurePrivateSubnet']]:
        """
        The private subnets for the VPC or VNet.
        """
        return pulumi.get(self, "private_subnets")

    @property
    @pulumi.getter(name="publicSubnets")
    def public_subnets(self) -> pulumi.Output[Sequence['outputs.InfrastructurePublicSubnet']]:
        """
        The public subnets for the VPC or VNet.
        """
        return pulumi.get(self, "public_subnets")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The cloud provider region. The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence['outputs.InfrastructureSecurityGroup']]:
        """
        The security groups for the VPC or VNet.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureSetting']]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetAddressPrefix")
    def subnet_address_prefix(self) -> pulumi.Output[str]:
        """
        The address prefixe to use for the subnet. This is applicable only for Azure
        """
        return pulumi.get(self, "subnet_address_prefix")

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> pulumi.Output[Optional[int]]:
        """
        The CIDR subnet size (in bits) for the automatically created subnets. This is applicable only for AWS.
        """
        return pulumi.get(self, "subnet_cidr")

    @property
    @pulumi.getter(name="subnetFullname")
    def subnet_fullname(self) -> pulumi.Output[str]:
        """
        The full name of the subnet. This is applicable only for Azure.
        """
        return pulumi.get(self, "subnet_fullname")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> pulumi.Output[str]:
        """
        The name of the subnet. This is applicable only for Azure.
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC or VNet ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[str]:
        """
        The VPC or VNet name.
        """
        return pulumi.get(self, "vpc_name")

    @property
    @pulumi.getter(name="waitUntilDeleted")
    def wait_until_deleted(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until Duplo has destroyed the infrastructure.
        """
        return pulumi.get(self, "wait_until_deleted")

