# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureOnpremArgs', 'InfrastructureOnprem']

@pulumi.input_type
class InfrastructureOnpremArgs:
    def __init__(__self__, *,
                 api_token: pulumi.Input[str],
                 cluster_certificate_authority_data: pulumi.Input[str],
                 cluster_endpoint: pulumi.Input[str],
                 cluster_name: pulumi.Input[str],
                 data_center: pulumi.Input[str],
                 enable_k8_cluster: pulumi.Input[bool],
                 infra_name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 vendor: pulumi.Input[int],
                 account_id: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]] = None,
                 eks_config: Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']] = None):
        """
        The set of arguments for constructing a InfrastructureOnprem resource.
        :param pulumi.Input[str] api_token: Token to access cluster API's
        :param pulumi.Input[str] cluster_certificate_authority_data: Required to validate API server certificates and kubelet client certificates
        :param pulumi.Input[str] cluster_endpoint: Endpoint URL of K8 cluster
        :param pulumi.Input[str] cluster_name: Name of the on premise k8 cluster
        :param pulumi.Input[str] data_center: Datacenter name of the onpremise cluster
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] region: The cloud provider region.  The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[int] vendor: Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        :param pulumi.Input[str] account_id: The cloud account ID. Used with GCP cloud
        :param pulumi.Input[int] azcount: The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input['InfrastructureOnpremEksConfigArgs'] eks_config: EKS configuration for on premise infra if vendor is selected as 2
        """
        pulumi.set(__self__, "api_token", api_token)
        pulumi.set(__self__, "cluster_certificate_authority_data", cluster_certificate_authority_data)
        pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "data_center", data_center)
        pulumi.set(__self__, "enable_k8_cluster", enable_k8_cluster)
        pulumi.set(__self__, "infra_name", infra_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vendor", vendor)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if azcount is not None:
            pulumi.set(__self__, "azcount", azcount)
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if eks_config is not None:
            pulumi.set(__self__, "eks_config", eks_config)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Input[str]:
        """
        Token to access cluster API's
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter(name="clusterCertificateAuthorityData")
    def cluster_certificate_authority_data(self) -> pulumi.Input[str]:
        """
        Required to validate API server certificates and kubelet client certificates
        """
        return pulumi.get(self, "cluster_certificate_authority_data")

    @cluster_certificate_authority_data.setter
    def cluster_certificate_authority_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_certificate_authority_data", value)

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Input[str]:
        """
        Endpoint URL of K8 cluster
        """
        return pulumi.get(self, "cluster_endpoint")

    @cluster_endpoint.setter
    def cluster_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_endpoint", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the on premise k8 cluster
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> pulumi.Input[str]:
        """
        Datacenter name of the onpremise cluster
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_center", value)

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> pulumi.Input[bool]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @enable_k8_cluster.setter
    def enable_k8_cluster(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_k8_cluster", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The cloud provider region.  The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Input[int]:
        """
        Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: pulumi.Input[int]):
        pulumi.set(self, "vendor", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud account ID. Used with GCP cloud
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def azcount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @azcount.setter
    def azcount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "azcount", value)

    @property
    @pulumi.getter(name="customDatas")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="eksConfig")
    def eks_config(self) -> Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']]:
        """
        EKS configuration for on premise infra if vendor is selected as 2
        """
        return pulumi.get(self, "eks_config")

    @eks_config.setter
    def eks_config(self, value: Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']]):
        pulumi.set(self, "eks_config", value)


@pulumi.input_type
class _InfrastructureOnpremState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cluster_certificate_authority_data: Optional[pulumi.Input[str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]] = None,
                 data_center: Optional[pulumi.Input[str]] = None,
                 eks_config: Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering InfrastructureOnprem resources.
        :param pulumi.Input[str] account_id: The cloud account ID. Used with GCP cloud
        :param pulumi.Input[str] api_token: Token to access cluster API's
        :param pulumi.Input[int] azcount: The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[str] cluster_certificate_authority_data: Required to validate API server certificates and kubelet client certificates
        :param pulumi.Input[str] cluster_endpoint: Endpoint URL of K8 cluster
        :param pulumi.Input[str] cluster_name: Name of the on premise k8 cluster
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[str] data_center: Datacenter name of the onpremise cluster
        :param pulumi.Input['InfrastructureOnpremEksConfigArgs'] eks_config: EKS configuration for on premise infra if vendor is selected as 2
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] region: The cloud provider region.  The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[str] status: The status of the infrastructure.
        :param pulumi.Input[int] vendor: Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if azcount is not None:
            pulumi.set(__self__, "azcount", azcount)
        if cluster_certificate_authority_data is not None:
            pulumi.set(__self__, "cluster_certificate_authority_data", cluster_certificate_authority_data)
        if cluster_endpoint is not None:
            pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if eks_config is not None:
            pulumi.set(__self__, "eks_config", eks_config)
        if enable_k8_cluster is not None:
            pulumi.set(__self__, "enable_k8_cluster", enable_k8_cluster)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud account ID. Used with GCP cloud
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[str]]:
        """
        Token to access cluster API's
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter
    def azcount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @azcount.setter
    def azcount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "azcount", value)

    @property
    @pulumi.getter(name="clusterCertificateAuthorityData")
    def cluster_certificate_authority_data(self) -> Optional[pulumi.Input[str]]:
        """
        Required to validate API server certificates and kubelet client certificates
        """
        return pulumi.get(self, "cluster_certificate_authority_data")

    @cluster_certificate_authority_data.setter
    def cluster_certificate_authority_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_certificate_authority_data", value)

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint URL of K8 cluster
        """
        return pulumi.get(self, "cluster_endpoint")

    @cluster_endpoint.setter
    def cluster_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_endpoint", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the on premise k8 cluster
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="customDatas")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureOnpremCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[pulumi.Input[str]]:
        """
        Datacenter name of the onpremise cluster
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_center", value)

    @property
    @pulumi.getter(name="eksConfig")
    def eks_config(self) -> Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']]:
        """
        EKS configuration for on premise infra if vendor is selected as 2
        """
        return pulumi.get(self, "eks_config")

    @eks_config.setter
    def eks_config(self, value: Optional[pulumi.Input['InfrastructureOnpremEksConfigArgs']]):
        pulumi.set(self, "eks_config", value)

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @enable_k8_cluster.setter
    def enable_k8_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_k8_cluster", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud provider region.  The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[int]]:
        """
        Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vendor", value)


class InfrastructureOnprem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cluster_certificate_authority_data: Optional[pulumi.Input[str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureOnpremCustomDataArgs', 'InfrastructureOnpremCustomDataArgsDict']]]]] = None,
                 data_center: Optional[pulumi.Input[str]] = None,
                 eks_config: Optional[pulumi.Input[Union['InfrastructureOnpremEksConfigArgs', 'InfrastructureOnpremEksConfigArgsDict']]] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `InfrastructureOnprem` adds support to integrate on premise infra into duplocloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        ### Create a DuploCloud onpremise infrastructure named onprem with eks vendor
        ### Solution:
        infra = duplocloud.InfrastructureOnprem("infra",
            infra_name="onprem",
            cluster_name="onprem",
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            vendor=2,
            cluster_endpoint="https://BB3C2589BAE34AD680060B5FDBA12BA1.gr7.us-west-2.eks.amazonaws.com",
            api_token="<api-token>",
            cluster_certificate_authority_data="<certificate-authority-data>",
            data_center="us",
            eks_config={
                "private_subnets": [
                    "subnet-06c1b3a338ace60ce",
                    "subnet-09252308e1a093bda",
                ],
                "public_subnets": [
                    "subnet-0d5b3c3a3ae9d129f",
                    "subnet-065ab3e894092dd1c",
                ],
                "ingress_security_group_ids": ["sg-0331e348b886ed796"],
                "vpc_id": "vpc-0961fc6b0903ad63f",
            },
            custom_datas=[{
                "key": "K8sVersion",
                "value": "1.31",
            }])
        ```

        ## Import

        Example: Importing an existing infrastructure

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructureOnprem:InfrastructureOnprem myinfra v2/admin/Infrastructure/OnPremises/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The cloud account ID. Used with GCP cloud
        :param pulumi.Input[str] api_token: Token to access cluster API's
        :param pulumi.Input[int] azcount: The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[str] cluster_certificate_authority_data: Required to validate API server certificates and kubelet client certificates
        :param pulumi.Input[str] cluster_endpoint: Endpoint URL of K8 cluster
        :param pulumi.Input[str] cluster_name: Name of the on premise k8 cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureOnpremCustomDataArgs', 'InfrastructureOnpremCustomDataArgsDict']]]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[str] data_center: Datacenter name of the onpremise cluster
        :param pulumi.Input[Union['InfrastructureOnpremEksConfigArgs', 'InfrastructureOnpremEksConfigArgsDict']] eks_config: EKS configuration for on premise infra if vendor is selected as 2
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] region: The cloud provider region.  The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[int] vendor: Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureOnpremArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `InfrastructureOnprem` adds support to integrate on premise infra into duplocloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        ### Create a DuploCloud onpremise infrastructure named onprem with eks vendor
        ### Solution:
        infra = duplocloud.InfrastructureOnprem("infra",
            infra_name="onprem",
            cluster_name="onprem",
            region="us-west-2",
            azcount=2,
            enable_k8_cluster=True,
            vendor=2,
            cluster_endpoint="https://BB3C2589BAE34AD680060B5FDBA12BA1.gr7.us-west-2.eks.amazonaws.com",
            api_token="<api-token>",
            cluster_certificate_authority_data="<certificate-authority-data>",
            data_center="us",
            eks_config={
                "private_subnets": [
                    "subnet-06c1b3a338ace60ce",
                    "subnet-09252308e1a093bda",
                ],
                "public_subnets": [
                    "subnet-0d5b3c3a3ae9d129f",
                    "subnet-065ab3e894092dd1c",
                ],
                "ingress_security_group_ids": ["sg-0331e348b886ed796"],
                "vpc_id": "vpc-0961fc6b0903ad63f",
            },
            custom_datas=[{
                "key": "K8sVersion",
                "value": "1.31",
            }])
        ```

        ## Import

        Example: Importing an existing infrastructure

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructureOnprem:InfrastructureOnprem myinfra v2/admin/Infrastructure/OnPremises/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureOnpremArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureOnpremArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 azcount: Optional[pulumi.Input[int]] = None,
                 cluster_certificate_authority_data: Optional[pulumi.Input[str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureOnpremCustomDataArgs', 'InfrastructureOnpremCustomDataArgsDict']]]]] = None,
                 data_center: Optional[pulumi.Input[str]] = None,
                 eks_config: Optional[pulumi.Input[Union['InfrastructureOnpremEksConfigArgs', 'InfrastructureOnpremEksConfigArgsDict']]] = None,
                 enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureOnpremArgs.__new__(InfrastructureOnpremArgs)

            __props__.__dict__["account_id"] = account_id
            if api_token is None and not opts.urn:
                raise TypeError("Missing required property 'api_token'")
            __props__.__dict__["api_token"] = api_token
            __props__.__dict__["azcount"] = azcount
            if cluster_certificate_authority_data is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_certificate_authority_data'")
            __props__.__dict__["cluster_certificate_authority_data"] = cluster_certificate_authority_data
            if cluster_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_endpoint'")
            __props__.__dict__["cluster_endpoint"] = cluster_endpoint
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["custom_datas"] = custom_datas
            if data_center is None and not opts.urn:
                raise TypeError("Missing required property 'data_center'")
            __props__.__dict__["data_center"] = data_center
            __props__.__dict__["eks_config"] = eks_config
            if enable_k8_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'enable_k8_cluster'")
            __props__.__dict__["enable_k8_cluster"] = enable_k8_cluster
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if vendor is None and not opts.urn:
                raise TypeError("Missing required property 'vendor'")
            __props__.__dict__["vendor"] = vendor
            __props__.__dict__["status"] = None
        super(InfrastructureOnprem, __self__).__init__(
            'duplocloud:index/infrastructureOnprem:InfrastructureOnprem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            api_token: Optional[pulumi.Input[str]] = None,
            azcount: Optional[pulumi.Input[int]] = None,
            cluster_certificate_authority_data: Optional[pulumi.Input[str]] = None,
            cluster_endpoint: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureOnpremCustomDataArgs', 'InfrastructureOnpremCustomDataArgsDict']]]]] = None,
            data_center: Optional[pulumi.Input[str]] = None,
            eks_config: Optional[pulumi.Input[Union['InfrastructureOnpremEksConfigArgs', 'InfrastructureOnpremEksConfigArgsDict']]] = None,
            enable_k8_cluster: Optional[pulumi.Input[bool]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vendor: Optional[pulumi.Input[int]] = None) -> 'InfrastructureOnprem':
        """
        Get an existing InfrastructureOnprem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The cloud account ID. Used with GCP cloud
        :param pulumi.Input[str] api_token: Token to access cluster API's
        :param pulumi.Input[int] azcount: The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        :param pulumi.Input[str] cluster_certificate_authority_data: Required to validate API server certificates and kubelet client certificates
        :param pulumi.Input[str] cluster_endpoint: Endpoint URL of K8 cluster
        :param pulumi.Input[str] cluster_name: Name of the on premise k8 cluster
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureOnpremCustomDataArgs', 'InfrastructureOnpremCustomDataArgsDict']]]] custom_datas: A list of configuration settings to apply on creation, expressed as key / value pairs.
        :param pulumi.Input[str] data_center: Datacenter name of the onpremise cluster
        :param pulumi.Input[Union['InfrastructureOnpremEksConfigArgs', 'InfrastructureOnpremEksConfigArgsDict']] eks_config: EKS configuration for on premise infra if vendor is selected as 2
        :param pulumi.Input[bool] enable_k8_cluster: Whether or not to provision a kubernetes cluster.
        :param pulumi.Input[str] infra_name: The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        :param pulumi.Input[str] region: The cloud provider region.  The Duplo portal must have already been configured to support this region.
        :param pulumi.Input[str] status: The status of the infrastructure.
        :param pulumi.Input[int] vendor: Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureOnpremState.__new__(_InfrastructureOnpremState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["api_token"] = api_token
        __props__.__dict__["azcount"] = azcount
        __props__.__dict__["cluster_certificate_authority_data"] = cluster_certificate_authority_data
        __props__.__dict__["cluster_endpoint"] = cluster_endpoint
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["custom_datas"] = custom_datas
        __props__.__dict__["data_center"] = data_center
        __props__.__dict__["eks_config"] = eks_config
        __props__.__dict__["enable_k8_cluster"] = enable_k8_cluster
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["vendor"] = vendor
        return InfrastructureOnprem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The cloud account ID. Used with GCP cloud
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[str]:
        """
        Token to access cluster API's
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter
    def azcount(self) -> pulumi.Output[Optional[int]]:
        """
        The number of availability zones.  Must be one of: `2`, `3`, or `4`. This is applicable only for AWS.
        """
        return pulumi.get(self, "azcount")

    @property
    @pulumi.getter(name="clusterCertificateAuthorityData")
    def cluster_certificate_authority_data(self) -> pulumi.Output[str]:
        """
        Required to validate API server certificates and kubelet client certificates
        """
        return pulumi.get(self, "cluster_certificate_authority_data")

    @property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Output[str]:
        """
        Endpoint URL of K8 cluster
        """
        return pulumi.get(self, "cluster_endpoint")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the on premise k8 cluster
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="customDatas")
    def custom_datas(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureOnpremCustomData']]]:
        """
        A list of configuration settings to apply on creation, expressed as key / value pairs.
        """
        return pulumi.get(self, "custom_datas")

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> pulumi.Output[str]:
        """
        Datacenter name of the onpremise cluster
        """
        return pulumi.get(self, "data_center")

    @property
    @pulumi.getter(name="eksConfig")
    def eks_config(self) -> pulumi.Output[Optional['outputs.InfrastructureOnpremEksConfig']]:
        """
        EKS configuration for on premise infra if vendor is selected as 2
        """
        return pulumi.get(self, "eks_config")

    @property
    @pulumi.getter(name="enableK8Cluster")
    def enable_k8_cluster(self) -> pulumi.Output[bool]:
        """
        Whether or not to provision a kubernetes cluster.
        """
        return pulumi.get(self, "enable_k8_cluster")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure.  Infrastructure names are globally unique and less than 13 characters.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The cloud provider region.  The Duplo portal must have already been configured to support this region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the infrastructure.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[int]:
        """
        Type of on premise vendor \\n\\n0 - Rancher\\n\\n1 - Generic\\n\\n2 - EKS\\n\\n
        """
        return pulumi.get(self, "vendor")

