# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfrastructureSettingInitArgs', 'InfrastructureSetting']

@pulumi.input_type
class InfrastructureSettingInitArgs:
    def __init__(__self__, *,
                 infra_name: pulumi.Input[str],
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]] = None):
        """
        The set of arguments for constructing a InfrastructureSetting resource.
        :param pulumi.Input[str] infra_name: The name of the infrastructure to configure.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]] custom_datas: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        """
        pulumi.set(__self__, "infra_name", infra_name)
        if custom_datas is not None:
            warnings.warn("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""", DeprecationWarning)
            pulumi.log.warn("""custom_datas is deprecated: The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Input[str]:
        """
        The name of the infrastructure to configure.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]]:
        """
        A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _InfrastructureSettingState:
    def __init__(__self__, *,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]] = None,
                 specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering InfrastructureSetting resources.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]] custom_datas: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] infra_name: The name of the infrastructure to configure.
        :param pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        """
        if custom_datas is not None:
            warnings.warn("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""", DeprecationWarning)
            pulumi.log.warn("""custom_datas is deprecated: The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
        if custom_datas is not None:
            pulumi.set(__self__, "custom_datas", custom_datas)
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if infra_name is not None:
            pulumi.set(__self__, "infra_name", infra_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if specified_settings is not None:
            pulumi.set(__self__, "specified_settings", specified_settings)

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]]:
        """
        A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        """
        return pulumi.get(self, "custom_datas")

    @custom_datas.setter
    def custom_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingCustomDataArgs']]]]):
        pulumi.set(self, "custom_datas", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the infrastructure to configure.
        """
        return pulumi.get(self, "infra_name")

    @infra_name.setter
    def infra_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infra_name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InfrastructureSettingSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

    @specified_settings.setter
    def specified_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_settings", value)


class InfrastructureSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingCustomDataArgs', 'InfrastructureSettingCustomDataArgsDict']]]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingSettingArgs', 'InfrastructureSettingSettingArgsDict']]]]] = None,
                 __props__=None):
        """
        `InfrastructureSetting` manages a infrastructure's configuration in Duplo.

        Infrastructure settings are initially populated by Duplo when an infrastructure is created.  This resource allows you take control of individual configuration settings for a specific infrastructure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myinfra = duplocloud.Infrastructure("myinfra",
            infra_name="myinfra",
            cloud=0,
            region="us-east-1",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.34.0.0/16",
            subnet_cidr=24)
        settings = duplocloud.InfrastructureSetting("settings",
            infra_name=myinfra.name,
            settings=[
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
                {
                    "key": "EnableAWSEfsVolumes",
                    "value": "true",
                },
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
            ])
        ```

        ## Import

        Example: Importing an existing infrastructure setting

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructureSetting:InfrastructureSetting settings *NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingCustomDataArgs', 'InfrastructureSettingCustomDataArgsDict']]]] custom_datas: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] infra_name: The name of the infrastructure to configure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingSettingArgs', 'InfrastructureSettingSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfrastructureSettingInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `InfrastructureSetting` manages a infrastructure's configuration in Duplo.

        Infrastructure settings are initially populated by Duplo when an infrastructure is created.  This resource allows you take control of individual configuration settings for a specific infrastructure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myinfra = duplocloud.Infrastructure("myinfra",
            infra_name="myinfra",
            cloud=0,
            region="us-east-1",
            azcount=2,
            enable_k8_cluster=True,
            address_prefix="10.34.0.0/16",
            subnet_cidr=24)
        settings = duplocloud.InfrastructureSetting("settings",
            infra_name=myinfra.name,
            settings=[
                {
                    "key": "EnableSecretCsiDriver",
                    "value": "true",
                },
                {
                    "key": "EnableAWSEfsVolumes",
                    "value": "true",
                },
                {
                    "key": "EnableAwsAlbIngress",
                    "value": "true",
                },
            ])
        ```

        ## Import

        Example: Importing an existing infrastructure setting

         - *NAME* is the infrastructure name

        # 

        ```sh
        $ pulumi import duplocloud:index/infrastructureSetting:InfrastructureSetting settings *NAME*
        ```

        :param str resource_name: The name of the resource.
        :param InfrastructureSettingInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfrastructureSettingInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingCustomDataArgs', 'InfrastructureSettingCustomDataArgsDict']]]]] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 infra_name: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingSettingArgs', 'InfrastructureSettingSettingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfrastructureSettingInitArgs.__new__(InfrastructureSettingInitArgs)

            __props__.__dict__["custom_datas"] = custom_datas
            __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
            if infra_name is None and not opts.urn:
                raise TypeError("Missing required property 'infra_name'")
            __props__.__dict__["infra_name"] = infra_name
            __props__.__dict__["settings"] = settings
            __props__.__dict__["specified_settings"] = None
        super(InfrastructureSetting, __self__).__init__(
            'duplocloud:index/infrastructureSetting:InfrastructureSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingCustomDataArgs', 'InfrastructureSettingCustomDataArgsDict']]]]] = None,
            delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
            infra_name: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingSettingArgs', 'InfrastructureSettingSettingArgsDict']]]]] = None,
            specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'InfrastructureSetting':
        """
        Get an existing InfrastructureSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingCustomDataArgs', 'InfrastructureSettingCustomDataArgsDict']]]] custom_datas: A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] infra_name: The name of the infrastructure to configure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InfrastructureSettingSettingArgs', 'InfrastructureSettingSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfrastructureSettingState.__new__(_InfrastructureSettingState)

        __props__.__dict__["custom_datas"] = custom_datas
        __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
        __props__.__dict__["infra_name"] = infra_name
        __props__.__dict__["settings"] = settings
        __props__.__dict__["specified_settings"] = specified_settings
        return InfrastructureSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customDatas")
    @_utilities.deprecated("""The custom_data argument is only applied on creation, and is deprecated in favor of the settings argument.""")
    def custom_datas(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureSettingCustomData']]]:
        """
        A complete list of configuration settings for this infrastructure, even ones not being managed by this resource. The custom*data argument is only applied on creation, and is deprecated in favor of the settings argument.
        """
        return pulumi.get(self, "custom_datas")

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @property
    @pulumi.getter(name="infraName")
    def infra_name(self) -> pulumi.Output[str]:
        """
        The name of the infrastructure to configure.
        """
        return pulumi.get(self, "infra_name")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Sequence['outputs.InfrastructureSettingSetting']]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

