# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['K8ConfigMapArgs', 'K8ConfigMap']

@pulumi.input_type
class K8ConfigMapArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8ConfigMap resource.
        :param pulumi.Input[str] data: A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the configmap will be created in.
        :param pulumi.Input[str] name: The name of the configmap.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the configmap will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the configmap.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _K8ConfigMapState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8ConfigMap resources.
        :param pulumi.Input[str] data: A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        :param pulumi.Input[str] metadata: A JSON encoded string representing the configmap metadata. You can use the `jsondecode()` function to parse this, if needed.
        :param pulumi.Input[str] name: The name of the configmap.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the configmap will be created in.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded string representing the configmap metadata. You can use the `jsondecode()` function to parse this, if needed.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the configmap.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the configmap will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class K8ConfigMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `K8ConfigMap` manages a kubernetes configmap in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8_config_map = duplocloud.K8ConfigMap("myapp",
            tenant_id=myapp.tenant_id,
            name="myconfigmap",
            data=json.dumps({
                "foo": "bar2",
            }))
        ```

        ## Import

        Example: Importing an existing kubernetes config map

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the config map name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8ConfigMap:K8ConfigMap myapp v2/subscriptions/*TENANT_ID*/K8ConfigMapApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        :param pulumi.Input[str] name: The name of the configmap.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the configmap will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8ConfigMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8ConfigMap` manages a kubernetes configmap in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8_config_map = duplocloud.K8ConfigMap("myapp",
            tenant_id=myapp.tenant_id,
            name="myconfigmap",
            data=json.dumps({
                "foo": "bar2",
            }))
        ```

        ## Import

        Example: Importing an existing kubernetes config map

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the config map name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8ConfigMap:K8ConfigMap myapp v2/subscriptions/*TENANT_ID*/K8ConfigMapApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8ConfigMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8ConfigMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8ConfigMapArgs.__new__(K8ConfigMapArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["metadata"] = None
        super(K8ConfigMap, __self__).__init__(
            'duplocloud:index/k8ConfigMap:K8ConfigMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'K8ConfigMap':
        """
        Get an existing K8ConfigMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        :param pulumi.Input[str] metadata: A JSON encoded string representing the configmap metadata. You can use the `jsondecode()` function to parse this, if needed.
        :param pulumi.Input[str] name: The name of the configmap.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the configmap will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8ConfigMapState.__new__(_K8ConfigMapState)

        __props__.__dict__["data"] = data
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        return K8ConfigMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[str]:
        """
        A JSON encoded string representing the configmap data. You can use the `jsonencode()` function to build this from JSON.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        A JSON encoded string representing the configmap metadata. You can use the `jsondecode()` function to parse this, if needed.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the configmap.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the configmap will be created in.
        """
        return pulumi.get(self, "tenant_id")

