# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8HelmReleaseArgs', 'K8HelmRelease']

@pulumi.input_type
class K8HelmReleaseArgs:
    def __init__(__self__, *,
                 release_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 charts: Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8HelmRelease resource.
        :param pulumi.Input[str] release_name: Provide release name to identify specific deployment of helm chart.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]] charts: Helm chart
        :param pulumi.Input[str] interval: Interval related to helm release Defaults to `5m0s`.
        :param pulumi.Input[str] name: The name of the helm chart
        :param pulumi.Input[str] values: Customise an helm chart.
        """
        pulumi.set(__self__, "release_name", release_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if charts is not None:
            pulumi.set(__self__, "charts", charts)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> pulumi.Input[str]:
        """
        Provide release name to identify specific deployment of helm chart.
        """
        return pulumi.get(self, "release_name")

    @release_name.setter
    def release_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def charts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]]:
        """
        Helm chart
        """
        return pulumi.get(self, "charts")

    @charts.setter
    def charts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]]):
        pulumi.set(self, "charts", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval related to helm release Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the helm chart
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[str]]:
        """
        Customise an helm chart.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _K8HelmReleaseState:
    def __init__(__self__, *,
                 charts: Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8HelmRelease resources.
        :param pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]] charts: Helm chart
        :param pulumi.Input[str] interval: Interval related to helm release Defaults to `5m0s`.
        :param pulumi.Input[str] name: The name of the helm chart
        :param pulumi.Input[str] release_name: Provide release name to identify specific deployment of helm chart.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] values: Customise an helm chart.
        """
        if charts is not None:
            pulumi.set(__self__, "charts", charts)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_name is not None:
            pulumi.set(__self__, "release_name", release_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def charts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]]:
        """
        Helm chart
        """
        return pulumi.get(self, "charts")

    @charts.setter
    def charts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8HelmReleaseChartArgs']]]]):
        pulumi.set(self, "charts", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval related to helm release Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the helm chart
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> Optional[pulumi.Input[str]]:
        """
        Provide release name to identify specific deployment of helm chart.
        """
        return pulumi.get(self, "release_name")

    @release_name.setter
    def release_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[str]]:
        """
        Customise an helm chart.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values", value)


class K8HelmRelease(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8HelmReleaseChartArgs', 'K8HelmReleaseChartArgsDict']]]]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `duplocloud_helm_release` manages helm release at duplocloud

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        release = duplocloud.K8HelmRelease("release",
            tenant_id=myapp.tenant_id,
            name="helm-release-name",
            interval="05m00s",
            release_name="helm-release-1",
            charts=[{
                "name": "chart-name",
                "version": "v1",
                "reconcile_strategy": "ChartVersion",
                "source_type": "HelmRepository",
                "source_name": repo["name"],
            }],
            values=json.dumps({
                "replicaCount": 2,
                "serviceAccount": {
                    "create": False,
                },
            }))
        ```

        ## Import

        Example: Importing an existing helm release

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the helm release name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8HelmRelease:K8HelmRelease release *TENANT_ID*/helm-release/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8HelmReleaseChartArgs', 'K8HelmReleaseChartArgsDict']]]] charts: Helm chart
        :param pulumi.Input[str] interval: Interval related to helm release Defaults to `5m0s`.
        :param pulumi.Input[str] name: The name of the helm chart
        :param pulumi.Input[str] release_name: Provide release name to identify specific deployment of helm chart.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] values: Customise an helm chart.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8HelmReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `duplocloud_helm_release` manages helm release at duplocloud

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        release = duplocloud.K8HelmRelease("release",
            tenant_id=myapp.tenant_id,
            name="helm-release-name",
            interval="05m00s",
            release_name="helm-release-1",
            charts=[{
                "name": "chart-name",
                "version": "v1",
                "reconcile_strategy": "ChartVersion",
                "source_type": "HelmRepository",
                "source_name": repo["name"],
            }],
            values=json.dumps({
                "replicaCount": 2,
                "serviceAccount": {
                    "create": False,
                },
            }))
        ```

        ## Import

        Example: Importing an existing helm release

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the helm release name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8HelmRelease:K8HelmRelease release *TENANT_ID*/helm-release/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8HelmReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8HelmReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8HelmReleaseChartArgs', 'K8HelmReleaseChartArgsDict']]]]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8HelmReleaseArgs.__new__(K8HelmReleaseArgs)

            __props__.__dict__["charts"] = charts
            __props__.__dict__["interval"] = interval
            __props__.__dict__["name"] = name
            if release_name is None and not opts.urn:
                raise TypeError("Missing required property 'release_name'")
            __props__.__dict__["release_name"] = release_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["values"] = values
        super(K8HelmRelease, __self__).__init__(
            'duplocloud:index/k8HelmRelease:K8HelmRelease',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            charts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8HelmReleaseChartArgs', 'K8HelmReleaseChartArgsDict']]]]] = None,
            interval: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            release_name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            values: Optional[pulumi.Input[str]] = None) -> 'K8HelmRelease':
        """
        Get an existing K8HelmRelease resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8HelmReleaseChartArgs', 'K8HelmReleaseChartArgsDict']]]] charts: Helm chart
        :param pulumi.Input[str] interval: Interval related to helm release Defaults to `5m0s`.
        :param pulumi.Input[str] name: The name of the helm chart
        :param pulumi.Input[str] release_name: Provide release name to identify specific deployment of helm chart.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] values: Customise an helm chart.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8HelmReleaseState.__new__(_K8HelmReleaseState)

        __props__.__dict__["charts"] = charts
        __props__.__dict__["interval"] = interval
        __props__.__dict__["name"] = name
        __props__.__dict__["release_name"] = release_name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["values"] = values
        return K8HelmRelease(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def charts(self) -> pulumi.Output[Sequence['outputs.K8HelmReleaseChart']]:
        """
        Helm chart
        """
        return pulumi.get(self, "charts")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[str]]:
        """
        Interval related to helm release Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the helm chart
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseName")
    def release_name(self) -> pulumi.Output[str]:
        """
        Provide release name to identify specific deployment of helm chart.
        """
        return pulumi.get(self, "release_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[str]]:
        """
        Customise an helm chart.
        """
        return pulumi.get(self, "values")

