# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['K8HelmRepositoryArgs', 'K8HelmRepository']

@pulumi.input_type
class K8HelmRepositoryArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 url: pulumi.Input[str],
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8HelmRepository resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] url: The url of helm repository to be attached
        :param pulumi.Input[str] interval: The interval associated to helm repository Defaults to `5m0s`.
        :param pulumi.Input[str] name: The identifier name for the helm repository in duplocloud
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "url", url)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The url of helm repository to be attached
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval associated to helm repository Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier name for the helm repository in duplocloud
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _K8HelmRepositoryState:
    def __init__(__self__, *,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8HelmRepository resources.
        :param pulumi.Input[str] interval: The interval associated to helm repository Defaults to `5m0s`.
        :param pulumi.Input[str] name: The identifier name for the helm repository in duplocloud
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] url: The url of helm repository to be attached
        """
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval associated to helm repository Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier name for the helm repository in duplocloud
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The url of helm repository to be attached
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class K8HelmRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `duplocloud_helm_repository` manages helm repository in duplocloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        repo = duplocloud.index.HelmRepository("repo",
            tenant_id=myapp.tenant_id,
            name=repo-name,
            interval=06m00s,
            url=https://helm.github.com)
        ```

        ## Import

        Example: Importing an existing helm repository

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the helm repository name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8HelmRepository:K8HelmRepository repo *TENANT_ID*/helm-repository/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] interval: The interval associated to helm repository Defaults to `5m0s`.
        :param pulumi.Input[str] name: The identifier name for the helm repository in duplocloud
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] url: The url of helm repository to be attached
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8HelmRepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `duplocloud_helm_repository` manages helm repository in duplocloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        repo = duplocloud.index.HelmRepository("repo",
            tenant_id=myapp.tenant_id,
            name=repo-name,
            interval=06m00s,
            url=https://helm.github.com)
        ```

        ## Import

        Example: Importing an existing helm repository

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the helm repository name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8HelmRepository:K8HelmRepository repo *TENANT_ID*/helm-repository/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8HelmRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8HelmRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8HelmRepositoryArgs.__new__(K8HelmRepositoryArgs)

            __props__.__dict__["interval"] = interval
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
        super(K8HelmRepository, __self__).__init__(
            'duplocloud:index/k8HelmRepository:K8HelmRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interval: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'K8HelmRepository':
        """
        Get an existing K8HelmRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] interval: The interval associated to helm repository Defaults to `5m0s`.
        :param pulumi.Input[str] name: The identifier name for the helm repository in duplocloud
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage bucket will be created in.
        :param pulumi.Input[str] url: The url of helm repository to be attached
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8HelmRepositoryState.__new__(_K8HelmRepositoryState)

        __props__.__dict__["interval"] = interval
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["url"] = url
        return K8HelmRepository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[str]]:
        """
        The interval associated to helm repository Defaults to `5m0s`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier name for the helm repository in duplocloud
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the storage bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The url of helm repository to be attached
        """
        return pulumi.get(self, "url")

