# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8IngressArgs', 'K8Ingress']

@pulumi.input_type
class K8IngressArgs:
    def __init__(__self__, *,
                 ingress_class_name: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lbconfig: Optional[pulumi.Input['K8IngressLbconfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]] = None):
        """
        The set of arguments for constructing a K8Ingress resource.
        :param pulumi.Input[str] ingress_class_name: The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Ingress will be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        :param pulumi.Input['K8IngressLbconfigArgs'] lbconfig: The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        :param pulumi.Input[str] name: The name of the Ingress.
        :param pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]] rules: A list of host rules used to configure the Ingress.
        :param pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]] tls: Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lbconfig is not None:
            pulumi.set(__self__, "lbconfig", lbconfig)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> pulumi.Input[str]:
        """
        The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        """
        return pulumi.get(self, "ingress_class_name")

    @ingress_class_name.setter
    def ingress_class_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "ingress_class_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Ingress will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lbconfig(self) -> Optional[pulumi.Input['K8IngressLbconfigArgs']]:
        """
        The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        """
        return pulumi.get(self, "lbconfig")

    @lbconfig.setter
    def lbconfig(self, value: Optional[pulumi.Input['K8IngressLbconfigArgs']]):
        pulumi.set(self, "lbconfig", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ingress.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]]:
        """
        A list of host rules used to configure the Ingress.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]]:
        """
        Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]]):
        pulumi.set(self, "tls", value)


@pulumi.input_type
class _K8IngressState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_class_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lbconfig: Optional[pulumi.Input['K8IngressLbconfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]] = None):
        """
        Input properties used for looking up and filtering K8Ingress resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        :param pulumi.Input[str] ingress_class_name: The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        :param pulumi.Input['K8IngressLbconfigArgs'] lbconfig: The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        :param pulumi.Input[str] name: The name of the Ingress.
        :param pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]] rules: A list of host rules used to configure the Ingress.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Ingress will be created in.
        :param pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]] tls: Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lbconfig is not None:
            pulumi.set(__self__, "lbconfig", lbconfig)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        """
        return pulumi.get(self, "ingress_class_name")

    @ingress_class_name.setter
    def ingress_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_class_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lbconfig(self) -> Optional[pulumi.Input['K8IngressLbconfigArgs']]:
        """
        The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        """
        return pulumi.get(self, "lbconfig")

    @lbconfig.setter
    def lbconfig(self, value: Optional[pulumi.Input['K8IngressLbconfigArgs']]):
        pulumi.set(self, "lbconfig", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ingress.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]]:
        """
        A list of host rules used to configure the Ingress.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Ingress will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]]:
        """
        Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8IngressTlArgs']]]]):
        pulumi.set(self, "tls", value)


class K8Ingress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_class_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lbconfig: Optional[pulumi.Input[Union['K8IngressLbconfigArgs', 'K8IngressLbconfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressRuleArgs', 'K8IngressRuleArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressTlArgs', 'K8IngressTlArgsDict']]]]] = None,
                 __props__=None):
        """
        `K8Ingress` manages a kubernetes Ingress in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes ingress

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the ingress name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8Ingress:K8Ingress ingress v3/subscriptions/*TENANT_ID*/k8s/ingress/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        :param pulumi.Input[str] ingress_class_name: The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        :param pulumi.Input[Union['K8IngressLbconfigArgs', 'K8IngressLbconfigArgsDict']] lbconfig: The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        :param pulumi.Input[str] name: The name of the Ingress.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8IngressRuleArgs', 'K8IngressRuleArgsDict']]]] rules: A list of host rules used to configure the Ingress.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Ingress will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8IngressTlArgs', 'K8IngressTlArgsDict']]]] tls: Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8IngressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8Ingress` manages a kubernetes Ingress in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes ingress

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the ingress name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8Ingress:K8Ingress ingress v3/subscriptions/*TENANT_ID*/k8s/ingress/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8IngressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8IngressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ingress_class_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lbconfig: Optional[pulumi.Input[Union['K8IngressLbconfigArgs', 'K8IngressLbconfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressRuleArgs', 'K8IngressRuleArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressTlArgs', 'K8IngressTlArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8IngressArgs.__new__(K8IngressArgs)

            __props__.__dict__["annotations"] = annotations
            if ingress_class_name is None and not opts.urn:
                raise TypeError("Missing required property 'ingress_class_name'")
            __props__.__dict__["ingress_class_name"] = ingress_class_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lbconfig"] = lbconfig
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["tls"] = tls
        super(K8Ingress, __self__).__init__(
            'duplocloud:index/k8Ingress:K8Ingress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ingress_class_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lbconfig: Optional[pulumi.Input[Union['K8IngressLbconfigArgs', 'K8IngressLbconfigArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressRuleArgs', 'K8IngressRuleArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            tls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8IngressTlArgs', 'K8IngressTlArgsDict']]]]] = None) -> 'K8Ingress':
        """
        Get an existing K8Ingress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        :param pulumi.Input[str] ingress_class_name: The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        :param pulumi.Input[Union['K8IngressLbconfigArgs', 'K8IngressLbconfigArgsDict']] lbconfig: The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        :param pulumi.Input[str] name: The name of the Ingress.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8IngressRuleArgs', 'K8IngressRuleArgsDict']]]] rules: A list of host rules used to configure the Ingress.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Ingress will be created in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8IngressTlArgs', 'K8IngressTlArgsDict']]]] tls: Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8IngressState.__new__(_K8IngressState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["ingress_class_name"] = ingress_class_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lbconfig"] = lbconfig
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["tls"] = tls
        return K8Ingress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        An unstructured key value map stored with the ingress that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> pulumi.Output[str]:
        """
        The ingress class name references an IngressClass resource that contains additional configuration including the name of the controller that should implement the class.
        """
        return pulumi.get(self, "ingress_class_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service. May match selectors of replication controllers and services.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lbconfig(self) -> pulumi.Output['outputs.K8IngressLbconfig']:
        """
        The load balancer configuration. This is required when `ingress_class_name` is set to `alb`.
        """
        return pulumi.get(self, "lbconfig")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Ingress.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.K8IngressRule']]:
        """
        A list of host rules used to configure the Ingress.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Ingress will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def tls(self) -> pulumi.Output[Optional[Sequence['outputs.K8IngressTl']]]:
        """
        Block represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI
        """
        return pulumi.get(self, "tls")

