# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8PersistentVolumeClaimArgs', 'K8PersistentVolumeClaim']

@pulumi.input_type
class K8PersistentVolumeClaimArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['K8PersistentVolumeClaimSpecArgs'],
                 tenant_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8PersistentVolumeClaim resource.
        :param pulumi.Input['K8PersistentVolumeClaimSpecArgs'] spec: Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the persistent volume claim will be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the persistent volume claim.
        """
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['K8PersistentVolumeClaimSpecArgs']:
        """
        Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['K8PersistentVolumeClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the persistent volume claim will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the persistent volume claim.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _K8PersistentVolumeClaimState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input['K8PersistentVolumeClaimSpecArgs']] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8PersistentVolumeClaim resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the persistent volume claim.
        :param pulumi.Input['K8PersistentVolumeClaimSpecArgs'] spec: Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the persistent volume claim will be created in.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the persistent volume claim.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['K8PersistentVolumeClaimSpecArgs']]:
        """
        Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['K8PersistentVolumeClaimSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the persistent volume claim will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class K8PersistentVolumeClaim(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[Union['K8PersistentVolumeClaimSpecArgs', 'K8PersistentVolumeClaimSpecArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `K8PersistentVolumeClaim` manages a kubernetes persistent volume claim in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "3a0b2ea5-7403-4765-ad6e-8771ca8fa0fd"
        pvc = duplocloud.K8PersistentVolumeClaim("pvc",
            tenant_id=tenant_id,
            name="pvc",
            spec={
                "access_modes": ["ReadWriteMany"],
                "volume_mode": "Filesystem",
                "storage_class_name": "duploservices-dev02-sc",
                "resources": {
                    "limits": {
                        "storage": "20Gi",
                    },
                    "requests": {
                        "storage": "10Gi",
                    },
                },
            },
            annotations={
                "a1": "v1",
                "a2": "v2",
            },
            labels={
                "l1": "v1",
                "l2": "v2",
            })
        ```

        ## Import

        Example: Importing an existing kubernetes Persistent Volume Claim

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of Persistent Volume Claim

        # 

        ```sh
        $ pulumi import duplocloud:index/k8PersistentVolumeClaim:K8PersistentVolumeClaim pvc v3/subscriptions/*TENANT_ID*/k8s/pvc/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the persistent volume claim.
        :param pulumi.Input[Union['K8PersistentVolumeClaimSpecArgs', 'K8PersistentVolumeClaimSpecArgsDict']] spec: Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the persistent volume claim will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8PersistentVolumeClaimArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8PersistentVolumeClaim` manages a kubernetes persistent volume claim in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "3a0b2ea5-7403-4765-ad6e-8771ca8fa0fd"
        pvc = duplocloud.K8PersistentVolumeClaim("pvc",
            tenant_id=tenant_id,
            name="pvc",
            spec={
                "access_modes": ["ReadWriteMany"],
                "volume_mode": "Filesystem",
                "storage_class_name": "duploservices-dev02-sc",
                "resources": {
                    "limits": {
                        "storage": "20Gi",
                    },
                    "requests": {
                        "storage": "10Gi",
                    },
                },
            },
            annotations={
                "a1": "v1",
                "a2": "v2",
            },
            labels={
                "l1": "v1",
                "l2": "v2",
            })
        ```

        ## Import

        Example: Importing an existing kubernetes Persistent Volume Claim

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the name of Persistent Volume Claim

        # 

        ```sh
        $ pulumi import duplocloud:index/k8PersistentVolumeClaim:K8PersistentVolumeClaim pvc v3/subscriptions/*TENANT_ID*/k8s/pvc/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8PersistentVolumeClaimArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8PersistentVolumeClaimArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[Union['K8PersistentVolumeClaimSpecArgs', 'K8PersistentVolumeClaimSpecArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8PersistentVolumeClaimArgs.__new__(K8PersistentVolumeClaimArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(K8PersistentVolumeClaim, __self__).__init__(
            'duplocloud:index/k8PersistentVolumeClaim:K8PersistentVolumeClaim',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[Union['K8PersistentVolumeClaimSpecArgs', 'K8PersistentVolumeClaimSpecArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'K8PersistentVolumeClaim':
        """
        Get an existing K8PersistentVolumeClaim resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the persistent volume claim.
        :param pulumi.Input[Union['K8PersistentVolumeClaimSpecArgs', 'K8PersistentVolumeClaimSpecArgsDict']] spec: Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the persistent volume claim will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8PersistentVolumeClaimState.__new__(_K8PersistentVolumeClaimState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["spec"] = spec
        __props__.__dict__["tenant_id"] = tenant_id
        return K8PersistentVolumeClaim(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        An unstructured key value map stored with the persistent volume claim that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the persistent volume claim.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output['outputs.K8PersistentVolumeClaimSpec']:
        """
        Spec defines the desired characteristics of a volume requested by a pod author. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the persistent volume claim will be created in.
        """
        return pulumi.get(self, "tenant_id")

