# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['K8SecretArgs', 'K8Secret']

@pulumi.input_type
class K8SecretArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[str],
                 secret_type: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 secret_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a K8Secret resource.
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret.  Usually `"Opaque"`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_annotations: Annotations for the secret
        :param pulumi.Input[str] secret_data: A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_labels: Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "secret_type", secret_type)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if secret_annotations is not None:
            pulumi.set(__self__, "secret_annotations", secret_annotations)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_labels is not None:
            pulumi.set(__self__, "secret_labels", secret_labels)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Input[str]:
        """
        The type of the secret.  Usually `"Opaque"`.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="secretAnnotations")
    def secret_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations for the secret
        """
        return pulumi.get(self, "secret_annotations")

    @secret_annotations.setter
    def secret_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_annotations", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretLabels")
    def secret_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        """
        return pulumi.get(self, "secret_labels")

    @secret_labels.setter
    def secret_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_labels", value)


@pulumi.input_type
class _K8SecretState:
    def __init__(__self__, *,
                 client_secret_version: Optional[pulumi.Input[str]] = None,
                 secret_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 secret_version: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8Secret resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_annotations: Annotations for the secret
        :param pulumi.Input[str] secret_data: A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_labels: Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret.  Usually `"Opaque"`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        """
        if client_secret_version is not None:
            pulumi.set(__self__, "client_secret_version", client_secret_version)
        if secret_annotations is not None:
            pulumi.set(__self__, "secret_annotations", secret_annotations)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_labels is not None:
            pulumi.set(__self__, "secret_labels", secret_labels)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientSecretVersion")
    def client_secret_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_secret_version")

    @client_secret_version.setter
    def client_secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_version", value)

    @property
    @pulumi.getter(name="secretAnnotations")
    def secret_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations for the secret
        """
        return pulumi.get(self, "secret_annotations")

    @secret_annotations.setter
    def secret_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_annotations", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretLabels")
    def secret_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        """
        return pulumi.get(self, "secret_labels")

    @secret_labels.setter
    def secret_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_labels", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the secret.  Usually `"Opaque"`.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_version", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class K8Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 secret_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `K8Secret` manages a kubernetes secret in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes secret

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the config map name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8Secret:K8Secret myapp v2/subscriptions/*TENANT_ID*/K8SecretApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_annotations: Annotations for the secret
        :param pulumi.Input[str] secret_data: A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_labels: Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret.  Usually `"Opaque"`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8Secret` manages a kubernetes secret in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes secret

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the config map name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8Secret:K8Secret myapp v2/subscriptions/*TENANT_ID*/K8SecretApiV2/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 secret_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8SecretArgs.__new__(K8SecretArgs)

            __props__.__dict__["secret_annotations"] = secret_annotations
            __props__.__dict__["secret_data"] = None if secret_data is None else pulumi.Output.secret(secret_data)
            __props__.__dict__["secret_labels"] = secret_labels
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
            if secret_type is None and not opts.urn:
                raise TypeError("Missing required property 'secret_type'")
            __props__.__dict__["secret_type"] = secret_type
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["client_secret_version"] = None
            __props__.__dict__["secret_version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(K8Secret, __self__).__init__(
            'duplocloud:index/k8Secret:K8Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_secret_version: Optional[pulumi.Input[str]] = None,
            secret_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            secret_data: Optional[pulumi.Input[str]] = None,
            secret_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            secret_name: Optional[pulumi.Input[str]] = None,
            secret_type: Optional[pulumi.Input[str]] = None,
            secret_version: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'K8Secret':
        """
        Get an existing K8Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_annotations: Annotations for the secret
        :param pulumi.Input[str] secret_data: A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_labels: Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        :param pulumi.Input[str] secret_name: The name of the secret.
        :param pulumi.Input[str] secret_type: The type of the secret.  Usually `"Opaque"`.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8SecretState.__new__(_K8SecretState)

        __props__.__dict__["client_secret_version"] = client_secret_version
        __props__.__dict__["secret_annotations"] = secret_annotations
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["secret_labels"] = secret_labels
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["secret_type"] = secret_type
        __props__.__dict__["secret_version"] = secret_version
        __props__.__dict__["tenant_id"] = tenant_id
        return K8Secret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientSecretVersion")
    def client_secret_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "client_secret_version")

    @property
    @pulumi.getter(name="secretAnnotations")
    def secret_annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Annotations for the secret
        """
        return pulumi.get(self, "secret_annotations")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON encoded string representing the secret metadata. You can use the `jsonencode()` function to convert map or object data, if needed. You can use the `jsondecode()` function to read data.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretLabels")
    def secret_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the secret
        """
        return pulumi.get(self, "secret_labels")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[str]:
        """
        The name of the secret.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Output[str]:
        """
        The type of the secret.  Usually `"Opaque"`.
        """
        return pulumi.get(self, "secret_type")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

