# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8SecretProviderClassArgs', 'K8SecretProviderClass']

@pulumi.input_type
class K8SecretProviderClassArgs:
    def __init__(__self__, *,
                 secret_provider: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 secret_objects: Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]] = None):
        """
        The set of arguments for constructing a K8SecretProviderClass resource.
        :param pulumi.Input[str] secret_provider: Provider to be used.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Secret Provider Class will be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the Secret Provider Class.
        :param pulumi.Input[str] parameters: The parameters section contains the details of the mount request.
        :param pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]] secret_objects: You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        """
        pulumi.set(__self__, "secret_provider", secret_provider)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_objects is not None:
            pulumi.set(__self__, "secret_objects", secret_objects)

    @property
    @pulumi.getter(name="secretProvider")
    def secret_provider(self) -> pulumi.Input[str]:
        """
        Provider to be used.
        """
        return pulumi.get(self, "secret_provider")

    @secret_provider.setter
    def secret_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_provider", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Secret Provider Class will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secret Provider Class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        The parameters section contains the details of the mount request.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretObjects")
    def secret_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]]:
        """
        You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        """
        return pulumi.get(self, "secret_objects")

    @secret_objects.setter
    def secret_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]]):
        pulumi.set(self, "secret_objects", value)


@pulumi.input_type
class _K8SecretProviderClassState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 secret_objects: Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]] = None,
                 secret_provider: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8SecretProviderClass resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the Secret Provider Class.
        :param pulumi.Input[str] parameters: The parameters section contains the details of the mount request.
        :param pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]] secret_objects: You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        :param pulumi.Input[str] secret_provider: Provider to be used.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Secret Provider Class will be created in.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secret_objects is not None:
            pulumi.set(__self__, "secret_objects", secret_objects)
        if secret_provider is not None:
            pulumi.set(__self__, "secret_provider", secret_provider)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secret Provider Class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        The parameters section contains the details of the mount request.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="secretObjects")
    def secret_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]]:
        """
        You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        """
        return pulumi.get(self, "secret_objects")

    @secret_objects.setter
    def secret_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8SecretProviderClassSecretObjectArgs']]]]):
        pulumi.set(self, "secret_objects", value)

    @property
    @pulumi.getter(name="secretProvider")
    def secret_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Provider to be used.
        """
        return pulumi.get(self, "secret_provider")

    @secret_provider.setter
    def secret_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_provider", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Secret Provider Class will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class K8SecretProviderClass(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 secret_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8SecretProviderClassSecretObjectArgs', 'K8SecretProviderClassSecretObjectArgsDict']]]]] = None,
                 secret_provider: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `K8SecretProviderClass` manages a kubernetes Secret Provider Class in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes secret provider class

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the secret provider class name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8SecretProviderClass:K8SecretProviderClass spc v3/subscriptions/*TENANT_ID*/k8s/secretproviderclass/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the Secret Provider Class.
        :param pulumi.Input[str] parameters: The parameters section contains the details of the mount request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8SecretProviderClassSecretObjectArgs', 'K8SecretProviderClassSecretObjectArgsDict']]]] secret_objects: You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        :param pulumi.Input[str] secret_provider: Provider to be used.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Secret Provider Class will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8SecretProviderClassArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8SecretProviderClass` manages a kubernetes Secret Provider Class in a Duplo tenant.

        ## Import

        Example: Importing an existing kubernetes secret provider class

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the secret provider class name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8SecretProviderClass:K8SecretProviderClass spc v3/subscriptions/*TENANT_ID*/k8s/secretproviderclass/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8SecretProviderClassArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8SecretProviderClassArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 secret_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8SecretProviderClassSecretObjectArgs', 'K8SecretProviderClassSecretObjectArgsDict']]]]] = None,
                 secret_provider: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8SecretProviderClassArgs.__new__(K8SecretProviderClassArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["secret_objects"] = secret_objects
            if secret_provider is None and not opts.urn:
                raise TypeError("Missing required property 'secret_provider'")
            __props__.__dict__["secret_provider"] = secret_provider
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(K8SecretProviderClass, __self__).__init__(
            'duplocloud:index/k8SecretProviderClass:K8SecretProviderClass',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[str]] = None,
            secret_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8SecretProviderClassSecretObjectArgs', 'K8SecretProviderClassSecretObjectArgsDict']]]]] = None,
            secret_provider: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'K8SecretProviderClass':
        """
        Get an existing K8SecretProviderClass resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the Secret Provider Class.
        :param pulumi.Input[str] parameters: The parameters section contains the details of the mount request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8SecretProviderClassSecretObjectArgs', 'K8SecretProviderClassSecretObjectArgsDict']]]] secret_objects: You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        :param pulumi.Input[str] secret_provider: Provider to be used.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Secret Provider Class will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8SecretProviderClassState.__new__(_K8SecretProviderClassState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["secret_objects"] = secret_objects
        __props__.__dict__["secret_provider"] = secret_provider
        __props__.__dict__["tenant_id"] = tenant_id
        return K8SecretProviderClass(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        An unstructured key value map stored with the secret provider class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Secret Provider Class.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[str]:
        """
        The parameters section contains the details of the mount request.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="secretObjects")
    def secret_objects(self) -> pulumi.Output[Sequence['outputs.K8SecretProviderClassSecretObject']]:
        """
        You may want to create a Kubernetes Secret to mirror the mounted content. Use the optional secretObjects field to define the desired state of the synced Kubernetes secret objects
        """
        return pulumi.get(self, "secret_objects")

    @property
    @pulumi.getter(name="secretProvider")
    def secret_provider(self) -> pulumi.Output[str]:
        """
        Provider to be used.
        """
        return pulumi.get(self, "secret_provider")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Secret Provider Class will be created in.
        """
        return pulumi.get(self, "tenant_id")

