# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8StorageClassArgs', 'K8StorageClass']

@pulumi.input_type
class K8StorageClassArgs:
    def __init__(__self__, *,
                 storage_provisioner: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 allowed_topologies: Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8StorageClass resource.
        :param pulumi.Input[str] storage_provisioner: Indicates the type of the provisioner
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage class will be created in.
        :param pulumi.Input[bool] allow_volume_expansion: Indicates whether the storage class allow volume expand Defaults to `false`.
        :param pulumi.Input['K8StorageClassAllowedTopologiesArgs'] allowed_topologies: Restrict the node topologies where volumes can be dynamically provisioned.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The parameters for the provisioner that should create volumes of this storage class
        :param pulumi.Input[str] reclaim_policy: Indicates the type of the reclaim policy Defaults to `Delete`.
        :param pulumi.Input[str] volume_binding_mode: Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        pulumi.set(__self__, "storage_provisioner", storage_provisioner)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if allow_volume_expansion is not None:
            pulumi.set(__self__, "allow_volume_expansion", allow_volume_expansion)
        if allowed_topologies is not None:
            pulumi.set(__self__, "allowed_topologies", allowed_topologies)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if volume_binding_mode is not None:
            pulumi.set(__self__, "volume_binding_mode", volume_binding_mode)

    @property
    @pulumi.getter(name="storageProvisioner")
    def storage_provisioner(self) -> pulumi.Input[str]:
        """
        Indicates the type of the provisioner
        """
        return pulumi.get(self, "storage_provisioner")

    @storage_provisioner.setter
    def storage_provisioner(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_provisioner", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the storage class will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the storage class allow volume expand Defaults to `false`.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @allow_volume_expansion.setter
    def allow_volume_expansion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_volume_expansion", value)

    @property
    @pulumi.getter(name="allowedTopologies")
    def allowed_topologies(self) -> Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']]:
        """
        Restrict the node topologies where volumes can be dynamically provisioned.
        """
        return pulumi.get(self, "allowed_topologies")

    @allowed_topologies.setter
    def allowed_topologies(self, value: Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']]):
        pulumi.set(self, "allowed_topologies", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the storage class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The parameters for the provisioner that should create volumes of this storage class
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the type of the reclaim policy Defaults to `Delete`.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        return pulumi.get(self, "volume_binding_mode")

    @volume_binding_mode.setter
    def volume_binding_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_binding_mode", value)


@pulumi.input_type
class _K8StorageClassState:
    def __init__(__self__, *,
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 allowed_topologies: Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 storage_provisioner: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8StorageClass resources.
        :param pulumi.Input[bool] allow_volume_expansion: Indicates whether the storage class allow volume expand Defaults to `false`.
        :param pulumi.Input['K8StorageClassAllowedTopologiesArgs'] allowed_topologies: Restrict the node topologies where volumes can be dynamically provisioned.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        :param pulumi.Input[str] fullname: The full name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The parameters for the provisioner that should create volumes of this storage class
        :param pulumi.Input[str] reclaim_policy: Indicates the type of the reclaim policy Defaults to `Delete`.
        :param pulumi.Input[str] storage_provisioner: Indicates the type of the provisioner
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage class will be created in.
        :param pulumi.Input[str] volume_binding_mode: Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        if allow_volume_expansion is not None:
            pulumi.set(__self__, "allow_volume_expansion", allow_volume_expansion)
        if allowed_topologies is not None:
            pulumi.set(__self__, "allowed_topologies", allowed_topologies)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if storage_provisioner is not None:
            pulumi.set(__self__, "storage_provisioner", storage_provisioner)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if volume_binding_mode is not None:
            pulumi.set(__self__, "volume_binding_mode", volume_binding_mode)

    @property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the storage class allow volume expand Defaults to `false`.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @allow_volume_expansion.setter
    def allow_volume_expansion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_volume_expansion", value)

    @property
    @pulumi.getter(name="allowedTopologies")
    def allowed_topologies(self) -> Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']]:
        """
        Restrict the node topologies where volumes can be dynamically provisioned.
        """
        return pulumi.get(self, "allowed_topologies")

    @allowed_topologies.setter
    def allowed_topologies(self, value: Optional[pulumi.Input['K8StorageClassAllowedTopologiesArgs']]):
        pulumi.set(self, "allowed_topologies", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the storage class.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the storage class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The parameters for the provisioner that should create volumes of this storage class
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the type of the reclaim policy Defaults to `Delete`.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="storageProvisioner")
    def storage_provisioner(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the type of the provisioner
        """
        return pulumi.get(self, "storage_provisioner")

    @storage_provisioner.setter
    def storage_provisioner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_provisioner", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the storage class will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        return pulumi.get(self, "volume_binding_mode")

    @volume_binding_mode.setter
    def volume_binding_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_binding_mode", value)


class K8StorageClass(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 allowed_topologies: Optional[pulumi.Input[Union['K8StorageClassAllowedTopologiesArgs', 'K8StorageClassAllowedTopologiesArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 storage_provisioner: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `K8StorageClass` manages a kubernetes storage class in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "3a0b2ea5-7403-4765-ad6e-8771ca8fa0fd"
        sc = duplocloud.K8StorageClass("sc",
            tenant_id=tenant_id,
            name="sc",
            storage_provisioner="efs.csi.aws.com",
            reclaim_policy="Delete",
            volume_binding_mode="Immediate",
            allow_volume_expansion=False,
            parameters={
                "fileSystemId": "fs-0d2f79aca4712c6e8",
                "basePath": "/dynamic_provisioning",
                "directoryPerms": "700",
                "gidRangeStart": "1000",
                "gidRangeEnd": "2000",
                "provisioningMode": "efs-ap",
            },
            annotations={
                "a1": "v1",
                "a2": "v2",
            },
            labels={
                "l1": "v1",
                "l2": "v2",
            })
        ```

        ## Import

        Example: Importing an existing kubernetes storage class

         - *TENANT_ID* is the tenant GUID

         - *FULL_NAME* is the Duplo provided storage class name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8StorageClass:K8StorageClass sc v3/subscriptions/*TENANT_ID*/k8s/storageclass/*FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_volume_expansion: Indicates whether the storage class allow volume expand Defaults to `false`.
        :param pulumi.Input[Union['K8StorageClassAllowedTopologiesArgs', 'K8StorageClassAllowedTopologiesArgsDict']] allowed_topologies: Restrict the node topologies where volumes can be dynamically provisioned.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The parameters for the provisioner that should create volumes of this storage class
        :param pulumi.Input[str] reclaim_policy: Indicates the type of the reclaim policy Defaults to `Delete`.
        :param pulumi.Input[str] storage_provisioner: Indicates the type of the provisioner
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage class will be created in.
        :param pulumi.Input[str] volume_binding_mode: Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8StorageClassArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `K8StorageClass` manages a kubernetes storage class in a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant_id = "3a0b2ea5-7403-4765-ad6e-8771ca8fa0fd"
        sc = duplocloud.K8StorageClass("sc",
            tenant_id=tenant_id,
            name="sc",
            storage_provisioner="efs.csi.aws.com",
            reclaim_policy="Delete",
            volume_binding_mode="Immediate",
            allow_volume_expansion=False,
            parameters={
                "fileSystemId": "fs-0d2f79aca4712c6e8",
                "basePath": "/dynamic_provisioning",
                "directoryPerms": "700",
                "gidRangeStart": "1000",
                "gidRangeEnd": "2000",
                "provisioningMode": "efs-ap",
            },
            annotations={
                "a1": "v1",
                "a2": "v2",
            },
            labels={
                "l1": "v1",
                "l2": "v2",
            })
        ```

        ## Import

        Example: Importing an existing kubernetes storage class

         - *TENANT_ID* is the tenant GUID

         - *FULL_NAME* is the Duplo provided storage class name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8StorageClass:K8StorageClass sc v3/subscriptions/*TENANT_ID*/k8s/storageclass/*FULL_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8StorageClassArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8StorageClassArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 allowed_topologies: Optional[pulumi.Input[Union['K8StorageClassAllowedTopologiesArgs', 'K8StorageClassAllowedTopologiesArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 storage_provisioner: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8StorageClassArgs.__new__(K8StorageClassArgs)

            __props__.__dict__["allow_volume_expansion"] = allow_volume_expansion
            __props__.__dict__["allowed_topologies"] = allowed_topologies
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["reclaim_policy"] = reclaim_policy
            if storage_provisioner is None and not opts.urn:
                raise TypeError("Missing required property 'storage_provisioner'")
            __props__.__dict__["storage_provisioner"] = storage_provisioner
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["volume_binding_mode"] = volume_binding_mode
            __props__.__dict__["fullname"] = None
        super(K8StorageClass, __self__).__init__(
            'duplocloud:index/k8StorageClass:K8StorageClass',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
            allowed_topologies: Optional[pulumi.Input[Union['K8StorageClassAllowedTopologiesArgs', 'K8StorageClassAllowedTopologiesArgsDict']]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            reclaim_policy: Optional[pulumi.Input[str]] = None,
            storage_provisioner: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            volume_binding_mode: Optional[pulumi.Input[str]] = None) -> 'K8StorageClass':
        """
        Get an existing K8StorageClass resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_volume_expansion: Indicates whether the storage class allow volume expand Defaults to `false`.
        :param pulumi.Input[Union['K8StorageClassAllowedTopologiesArgs', 'K8StorageClassAllowedTopologiesArgsDict']] allowed_topologies: Restrict the node topologies where volumes can be dynamically provisioned.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        :param pulumi.Input[str] fullname: The full name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        :param pulumi.Input[str] name: The name of the storage class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The parameters for the provisioner that should create volumes of this storage class
        :param pulumi.Input[str] reclaim_policy: Indicates the type of the reclaim policy Defaults to `Delete`.
        :param pulumi.Input[str] storage_provisioner: Indicates the type of the provisioner
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the storage class will be created in.
        :param pulumi.Input[str] volume_binding_mode: Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8StorageClassState.__new__(_K8StorageClassState)

        __props__.__dict__["allow_volume_expansion"] = allow_volume_expansion
        __props__.__dict__["allowed_topologies"] = allowed_topologies
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["reclaim_policy"] = reclaim_policy
        __props__.__dict__["storage_provisioner"] = storage_provisioner
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["volume_binding_mode"] = volume_binding_mode
        return K8StorageClass(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the storage class allow volume expand Defaults to `false`.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @property
    @pulumi.getter(name="allowedTopologies")
    def allowed_topologies(self) -> pulumi.Output[Optional['outputs.K8StorageClassAllowedTopologies']]:
        """
        Restrict the node topologies where volumes can be dynamically provisioned.
        """
        return pulumi.get(self, "allowed_topologies")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        An unstructured key value map stored with the storage class that may be used to store arbitrary metadata.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the storage class.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) the service.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the storage class.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The parameters for the provisioner that should create volumes of this storage class
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the type of the reclaim policy Defaults to `Delete`.
        """
        return pulumi.get(self, "reclaim_policy")

    @property
    @pulumi.getter(name="storageProvisioner")
    def storage_provisioner(self) -> pulumi.Output[str]:
        """
        Indicates the type of the provisioner
        """
        return pulumi.get(self, "storage_provisioner")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the storage class will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates when volume binding and dynamic provisioning should occur Defaults to `Immediate`.
        """
        return pulumi.get(self, "volume_binding_mode")

