# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sCronJobArgs', 'K8sCronJob']

@pulumi.input_type
class K8sCronJobArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input['K8sCronJobMetadataArgs'],
                 tenant_id: pulumi.Input[str],
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]] = None):
        """
        The set of arguments for constructing a K8sCronJob resource.
        :param pulumi.Input['K8sCronJobMetadataArgs'] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]] specs: Spec of the cron job owned by the cluster
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if is_any_host_allowed is not None:
            pulumi.set(__self__, "is_any_host_allowed", is_any_host_allowed)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['K8sCronJobMetadataArgs']:
        """
        Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['K8sCronJobMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @is_any_host_allowed.setter
    def is_any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_any_host_allowed", value)

    @property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]]:
        """
        Spec of the cron job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]]):
        pulumi.set(self, "specs", value)


@pulumi.input_type
class _K8sCronJobState:
    def __init__(__self__, *,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input['K8sCronJobMetadataArgs']] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8sCronJob resources.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input['K8sCronJobMetadataArgs'] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]] specs: Spec of the cron job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        if is_any_host_allowed is not None:
            pulumi.set(__self__, "is_any_host_allowed", is_any_host_allowed)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @is_any_host_allowed.setter
    def is_any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_any_host_allowed", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['K8sCronJobMetadataArgs']]:
        """
        Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['K8sCronJobMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]]:
        """
        Spec of the cron job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sCronJobSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class K8sCronJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Union['K8sCronJobMetadataArgs', 'K8sCronJobMetadataArgsDict']]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCronJobSpecArgs', 'K8sCronJobSpecArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8s_cron_job = duplocloud.K8sCronJob("myapp",
            tenant_id=myapp.tenant_id,
            metadata={
                "name": "jobname",
            },
            specs=[{
                "job_template": {
                    "spec": {
                        "template": {
                            "spec": {
                                "containers": [{
                                    "name": "containername",
                                    "image": "nginx:latest",
                                }],
                            },
                        },
                    },
                },
                "schedule": "*/1 * * * *",
            }])
        ```

        ## Import

        Example: Importing an existing kubernetes job

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the k8s job name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8sCronJob:K8sCronJob myapp v3/subscriptions/*TENANT_ID*/k8s/cronjob/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Union['K8sCronJobMetadataArgs', 'K8sCronJobMetadataArgsDict']] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sCronJobSpecArgs', 'K8sCronJobSpecArgsDict']]]] specs: Spec of the cron job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sCronJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8s_cron_job = duplocloud.K8sCronJob("myapp",
            tenant_id=myapp.tenant_id,
            metadata={
                "name": "jobname",
            },
            specs=[{
                "job_template": {
                    "spec": {
                        "template": {
                            "spec": {
                                "containers": [{
                                    "name": "containername",
                                    "image": "nginx:latest",
                                }],
                            },
                        },
                    },
                },
                "schedule": "*/1 * * * *",
            }])
        ```

        ## Import

        Example: Importing an existing kubernetes job

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the k8s job name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8sCronJob:K8sCronJob myapp v3/subscriptions/*TENANT_ID*/k8s/cronjob/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8sCronJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sCronJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Union['K8sCronJobMetadataArgs', 'K8sCronJobMetadataArgsDict']]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCronJobSpecArgs', 'K8sCronJobSpecArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sCronJobArgs.__new__(K8sCronJobArgs)

            __props__.__dict__["is_any_host_allowed"] = is_any_host_allowed
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["specs"] = specs
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(K8sCronJob, __self__).__init__(
            'duplocloud:index/k8sCronJob:K8sCronJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
            metadata: Optional[pulumi.Input[Union['K8sCronJobMetadataArgs', 'K8sCronJobMetadataArgsDict']]] = None,
            specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sCronJobSpecArgs', 'K8sCronJobSpecArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'K8sCronJob':
        """
        Get an existing K8sCronJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Union['K8sCronJobMetadataArgs', 'K8sCronJobMetadataArgsDict']] metadata: Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sCronJobSpecArgs', 'K8sCronJobSpecArgsDict']]]] specs: Spec of the cron job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sCronJobState.__new__(_K8sCronJobState)

        __props__.__dict__["is_any_host_allowed"] = is_any_host_allowed
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["specs"] = specs
        __props__.__dict__["tenant_id"] = tenant_id
        return K8sCronJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.K8sCronJobMetadata']:
        """
        Standard cronjob's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def specs(self) -> pulumi.Output[Optional[Sequence['outputs.K8sCronJobSpec']]]:
        """
        Spec of the cron job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

