# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sJobArgs', 'K8sJob']

@pulumi.input_type
class K8sJobArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input['K8sJobMetadataArgs'],
                 tenant_id: pulumi.Input[str],
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]] = None,
                 wait_for_completion: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a K8sJob resource.
        :param pulumi.Input['K8sJobMetadataArgs'] metadata: Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]] specs: Spec of the job owned by the cluster
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if is_any_host_allowed is not None:
            pulumi.set(__self__, "is_any_host_allowed", is_any_host_allowed)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if wait_for_completion is not None:
            pulumi.set(__self__, "wait_for_completion", wait_for_completion)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['K8sJobMetadataArgs']:
        """
        Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['K8sJobMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @is_any_host_allowed.setter
    def is_any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_any_host_allowed", value)

    @property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]]:
        """
        Spec of the job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @property
    @pulumi.getter(name="waitForCompletion")
    def wait_for_completion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_completion")

    @wait_for_completion.setter
    def wait_for_completion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_completion", value)


@pulumi.input_type
class _K8sJobState:
    def __init__(__self__, *,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input['K8sJobMetadataArgs']] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_completion: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering K8sJob resources.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input['K8sJobMetadataArgs'] metadata: Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]] specs: Spec of the job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        if is_any_host_allowed is not None:
            pulumi.set(__self__, "is_any_host_allowed", is_any_host_allowed)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_for_completion is not None:
            pulumi.set(__self__, "wait_for_completion", wait_for_completion)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @is_any_host_allowed.setter
    def is_any_host_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_any_host_allowed", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['K8sJobMetadataArgs']]:
        """
        Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['K8sJobMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]]:
        """
        Spec of the job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sJobSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitForCompletion")
    def wait_for_completion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_completion")

    @wait_for_completion.setter
    def wait_for_completion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_completion", value)


class K8sJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Union['K8sJobMetadataArgs', 'K8sJobMetadataArgsDict']]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sJobSpecArgs', 'K8sJobSpecArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_completion: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8s_job = duplocloud.K8sJob("myapp",
            tenant_id=myapp.tenant_id,
            metadata={
                "name": "jobname",
            },
            specs=[{
                "template": {
                    "spec": {
                        "containers": [{
                            "name": "containername",
                            "image": "nginx:latest",
                        }],
                    },
                },
            }])
        ```

        ## Import

        Example: Importing an existing kubernetes job

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the k8s job name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8sJob:K8sJob myapp v3/subscriptions/*TENANT_ID*/k8s/job/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Union['K8sJobMetadataArgs', 'K8sJobMetadataArgsDict']] metadata: Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sJobSpecArgs', 'K8sJobSpecArgsDict']]]] specs: Spec of the job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_k8s_job = duplocloud.K8sJob("myapp",
            tenant_id=myapp.tenant_id,
            metadata={
                "name": "jobname",
            },
            specs=[{
                "template": {
                    "spec": {
                        "containers": [{
                            "name": "containername",
                            "image": "nginx:latest",
                        }],
                    },
                },
            }])
        ```

        ## Import

        Example: Importing an existing kubernetes job

         - *TENANT_ID* is the tenant GUID

         - *NAME* is the k8s job name

        # 

        ```sh
        $ pulumi import duplocloud:index/k8sJob:K8sJob myapp v3/subscriptions/*TENANT_ID*/k8s/job/*NAME*
        ```

        :param str resource_name: The name of the resource.
        :param K8sJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Union['K8sJobMetadataArgs', 'K8sJobMetadataArgsDict']]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sJobSpecArgs', 'K8sJobSpecArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_for_completion: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sJobArgs.__new__(K8sJobArgs)

            __props__.__dict__["is_any_host_allowed"] = is_any_host_allowed
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["specs"] = specs
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_for_completion"] = wait_for_completion
        super(K8sJob, __self__).__init__(
            'duplocloud:index/k8sJob:K8sJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_any_host_allowed: Optional[pulumi.Input[bool]] = None,
            metadata: Optional[pulumi.Input[Union['K8sJobMetadataArgs', 'K8sJobMetadataArgsDict']]] = None,
            specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sJobSpecArgs', 'K8sJobSpecArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_for_completion: Optional[pulumi.Input[bool]] = None) -> 'K8sJob':
        """
        Get an existing K8sJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_any_host_allowed: Defaults to `false`.
        :param pulumi.Input[Union['K8sJobMetadataArgs', 'K8sJobMetadataArgsDict']] metadata: Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sJobSpecArgs', 'K8sJobSpecArgsDict']]]] specs: Spec of the job owned by the cluster
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the job will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sJobState.__new__(_K8sJobState)

        __props__.__dict__["is_any_host_allowed"] = is_any_host_allowed
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["specs"] = specs
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_for_completion"] = wait_for_completion
        return K8sJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isAnyHostAllowed")
    def is_any_host_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_any_host_allowed")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.K8sJobMetadata']:
        """
        Standard job's metadata. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def specs(self) -> pulumi.Output[Optional[Sequence['outputs.K8sJobSpec']]]:
        """
        Spec of the job owned by the cluster
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the job will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitForCompletion")
    def wait_for_completion(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "wait_for_completion")

