# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OciContainerengineNodePoolArgs', 'OciContainerengineNodePool']

@pulumi.input_type
class OciContainerengineNodePoolArgs:
    def __init__(__self__, *,
                 node_shape: pulumi.Input[str],
                 node_shape_config: pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs'],
                 tenant_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_source_details: Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a OciContainerengineNodePool resource.
        :param pulumi.Input[str] node_shape: The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        pulumi.set(__self__, "node_shape", node_shape)
        pulumi.set(__self__, "node_shape_config", node_shape_config)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_node_labels is not None:
            pulumi.set(__self__, "initial_node_labels", initial_node_labels)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config_details is not None:
            pulumi.set(__self__, "node_config_details", node_config_details)
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_image_name is not None:
            pulumi.set(__self__, "node_image_name", node_image_name)
        if node_metadata is not None:
            pulumi.set(__self__, "node_metadata", node_metadata)
        if node_source_details is not None:
            pulumi.set(__self__, "node_source_details", node_source_details)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if quantity_per_subnet is not None:
            pulumi.set(__self__, "quantity_per_subnet", quantity_per_subnet)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> pulumi.Input[str]:
        """
        The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @node_shape.setter
    def node_shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_shape", value)

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs']:
        return pulumi.get(self, "node_shape_config")

    @node_shape_config.setter
    def node_shape_config(self, value: pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs']):
        pulumi.set(self, "node_shape_config", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]]:
        return pulumi.get(self, "initial_node_labels")

    @initial_node_labels.setter
    def initial_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]]):
        pulumi.set(self, "initial_node_labels", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']]:
        return pulumi.get(self, "node_config_details")

    @node_config_details.setter
    def node_config_details(self, value: Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']]):
        pulumi.set(self, "node_config_details", value)

    @property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "node_image_id")

    @node_image_id.setter
    def node_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_id", value)

    @property
    @pulumi.getter(name="nodeImageName")
    def node_image_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "node_image_name")

    @node_image_name.setter
    def node_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_name", value)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "node_metadata")

    @node_metadata.setter
    def node_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_metadata", value)

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']]:
        return pulumi.get(self, "node_source_details")

    @node_source_details.setter
    def node_source_details(self, value: Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']]):
        pulumi.set(self, "node_source_details", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]]:
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "quantity_per_subnet")

    @quantity_per_subnet.setter
    def quantity_per_subnet(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity_per_subnet", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


@pulumi.input_type
class _OciContainerengineNodePoolState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_pool_id: Optional[pulumi.Input[str]] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs']] = None,
                 node_source_details: Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering OciContainerengineNodePool resources.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[str] node_pool_id: The OCID of the node pool.
        :param pulumi.Input[str] node_shape: The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_node_labels is not None:
            pulumi.set(__self__, "initial_node_labels", initial_node_labels)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config_details is not None:
            pulumi.set(__self__, "node_config_details", node_config_details)
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_image_name is not None:
            pulumi.set(__self__, "node_image_name", node_image_name)
        if node_metadata is not None:
            pulumi.set(__self__, "node_metadata", node_metadata)
        if node_pool_id is not None:
            pulumi.set(__self__, "node_pool_id", node_pool_id)
        if node_shape is not None:
            pulumi.set(__self__, "node_shape", node_shape)
        if node_shape_config is not None:
            pulumi.set(__self__, "node_shape_config", node_shape_config)
        if node_source_details is not None:
            pulumi.set(__self__, "node_source_details", node_source_details)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if quantity_per_subnet is not None:
            pulumi.set(__self__, "quantity_per_subnet", quantity_per_subnet)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if wait_until_ready is not None:
            pulumi.set(__self__, "wait_until_ready", wait_until_ready)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster to which this node pool is attached.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment in which the node pool exists.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]]:
        return pulumi.get(self, "initial_node_labels")

    @initial_node_labels.setter
    def initial_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolInitialNodeLabelArgs']]]]):
        pulumi.set(self, "initial_node_labels", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']]:
        return pulumi.get(self, "node_config_details")

    @node_config_details.setter
    def node_config_details(self, value: Optional[pulumi.Input['OciContainerengineNodePoolNodeConfigDetailsArgs']]):
        pulumi.set(self, "node_config_details", value)

    @property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "node_image_id")

    @node_image_id.setter
    def node_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_id", value)

    @property
    @pulumi.getter(name="nodeImageName")
    def node_image_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "node_image_name")

    @node_image_name.setter
    def node_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_name", value)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "node_metadata")

    @node_metadata.setter
    def node_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_metadata", value)

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "node_pool_id")

    @node_pool_id.setter
    def node_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_pool_id", value)

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @node_shape.setter
    def node_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_shape", value)

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> Optional[pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs']]:
        return pulumi.get(self, "node_shape_config")

    @node_shape_config.setter
    def node_shape_config(self, value: Optional[pulumi.Input['OciContainerengineNodePoolNodeShapeConfigArgs']]):
        pulumi.set(self, "node_shape_config", value)

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']]:
        return pulumi.get(self, "node_source_details")

    @node_source_details.setter
    def node_source_details(self, value: Optional[pulumi.Input['OciContainerengineNodePoolNodeSourceDetailsArgs']]):
        pulumi.set(self, "node_source_details", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]]:
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OciContainerengineNodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "quantity_per_subnet")

    @quantity_per_subnet.setter
    def quantity_per_subnet(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity_per_subnet", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

    @wait_until_ready.setter
    def wait_until_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_ready", value)


class OciContainerengineNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolInitialNodeLabelArgs', 'OciContainerengineNodePoolInitialNodeLabelArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeConfigDetailsArgs', 'OciContainerengineNodePoolNodeConfigDetailsArgsDict']]] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeShapeConfigArgs', 'OciContainerengineNodePoolNodeShapeConfigArgsDict']]] = None,
                 node_source_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeSourceDetailsArgs', 'OciContainerengineNodePoolNodeSourceDetailsArgsDict']]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolNodeArgs', 'OciContainerengineNodePoolNodeArgsDict']]]]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `OciContainerengineNodePool` manages an OCI container node pool in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        my_oci_node_pool = duplocloud.OciContainerengineNodePool("myOciNodePool",
            tenant_id=myapp.tenant_id,
            name="tf-test",
            node_shape="VM.Standard2.1",
            node_image_id="ocid1.image.oc1.ap-mumbai-1.aaaaaaaagosxifkwha6a6pi2fxx4idf3te3icdsf7z6jar2sxls6xycnehna",
            initial_node_labels=[{
                "key": "allocationtags",
                "value": "test",
            }],
            node_config_details={
                "size": 1,
                "placement_configs": [{
                    "availability_domain": "uwFr:AP-MUMBAI-1-AD-1",
                    "subnet_id": "ocid1.subnet.oc1.ap-mumbai-1.aaaaaaaasz36nwww2zygjn7arpuq4fbz3z22kn6adlalldvld3b5nu6afuxa",
                }],
                "freeform_tags": {
                    "CreatedBy": "duplo",
                },
            })
        ```

        ## Import

        Example: Importing an existing OCI Container Engine Node Pool

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/ociContainerengineNodePool:OciContainerengineNodePool myOciNodePool *TENANT_ID*/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[str] node_shape: The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OciContainerengineNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `OciContainerengineNodePool` manages an OCI container node pool in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        my_oci_node_pool = duplocloud.OciContainerengineNodePool("myOciNodePool",
            tenant_id=myapp.tenant_id,
            name="tf-test",
            node_shape="VM.Standard2.1",
            node_image_id="ocid1.image.oc1.ap-mumbai-1.aaaaaaaagosxifkwha6a6pi2fxx4idf3te3icdsf7z6jar2sxls6xycnehna",
            initial_node_labels=[{
                "key": "allocationtags",
                "value": "test",
            }],
            node_config_details={
                "size": 1,
                "placement_configs": [{
                    "availability_domain": "uwFr:AP-MUMBAI-1-AD-1",
                    "subnet_id": "ocid1.subnet.oc1.ap-mumbai-1.aaaaaaaasz36nwww2zygjn7arpuq4fbz3z22kn6adlalldvld3b5nu6afuxa",
                }],
                "freeform_tags": {
                    "CreatedBy": "duplo",
                },
            })
        ```

        ## Import

        Example: Importing an existing OCI Container Engine Node Pool

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the cluster

        # 

        ```sh
        $ pulumi import duplocloud:index/ociContainerengineNodePool:OciContainerengineNodePool myOciNodePool *TENANT_ID*/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param OciContainerengineNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OciContainerengineNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolInitialNodeLabelArgs', 'OciContainerengineNodePoolInitialNodeLabelArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeConfigDetailsArgs', 'OciContainerengineNodePoolNodeConfigDetailsArgsDict']]] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeShapeConfigArgs', 'OciContainerengineNodePoolNodeShapeConfigArgsDict']]] = None,
                 node_source_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeSourceDetailsArgs', 'OciContainerengineNodePoolNodeSourceDetailsArgsDict']]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolNodeArgs', 'OciContainerengineNodePoolNodeArgsDict']]]]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 wait_until_ready: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OciContainerengineNodePoolArgs.__new__(OciContainerengineNodePoolArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["initial_node_labels"] = initial_node_labels
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config_details"] = node_config_details
            __props__.__dict__["node_image_id"] = node_image_id
            __props__.__dict__["node_image_name"] = node_image_name
            __props__.__dict__["node_metadata"] = node_metadata
            if node_shape is None and not opts.urn:
                raise TypeError("Missing required property 'node_shape'")
            __props__.__dict__["node_shape"] = node_shape
            if node_shape_config is None and not opts.urn:
                raise TypeError("Missing required property 'node_shape_config'")
            __props__.__dict__["node_shape_config"] = node_shape_config
            __props__.__dict__["node_source_details"] = node_source_details
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["quantity_per_subnet"] = quantity_per_subnet
            __props__.__dict__["ssh_public_key"] = ssh_public_key
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["system_tags"] = system_tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["wait_until_ready"] = wait_until_ready
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["node_pool_id"] = None
        super(OciContainerengineNodePool, __self__).__init__(
            'duplocloud:index/ociContainerengineNodePool:OciContainerengineNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolInitialNodeLabelArgs', 'OciContainerengineNodePoolInitialNodeLabelArgsDict']]]]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_config_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeConfigDetailsArgs', 'OciContainerengineNodePoolNodeConfigDetailsArgsDict']]] = None,
            node_image_id: Optional[pulumi.Input[str]] = None,
            node_image_name: Optional[pulumi.Input[str]] = None,
            node_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            node_pool_id: Optional[pulumi.Input[str]] = None,
            node_shape: Optional[pulumi.Input[str]] = None,
            node_shape_config: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeShapeConfigArgs', 'OciContainerengineNodePoolNodeShapeConfigArgsDict']]] = None,
            node_source_details: Optional[pulumi.Input[Union['OciContainerengineNodePoolNodeSourceDetailsArgs', 'OciContainerengineNodePoolNodeSourceDetailsArgsDict']]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OciContainerengineNodePoolNodeArgs', 'OciContainerengineNodePoolNodeArgsDict']]]]] = None,
            quantity_per_subnet: Optional[pulumi.Input[int]] = None,
            ssh_public_key: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            wait_until_ready: Optional[pulumi.Input[bool]] = None) -> 'OciContainerengineNodePool':
        """
        Get an existing OciContainerengineNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: The name of the node pool.
        :param pulumi.Input[str] node_pool_id: The OCID of the node pool.
        :param pulumi.Input[str] node_shape: The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        :param pulumi.Input[bool] wait_until_ready: Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OciContainerengineNodePoolState.__new__(_OciContainerengineNodePoolState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["initial_node_labels"] = initial_node_labels
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config_details"] = node_config_details
        __props__.__dict__["node_image_id"] = node_image_id
        __props__.__dict__["node_image_name"] = node_image_name
        __props__.__dict__["node_metadata"] = node_metadata
        __props__.__dict__["node_pool_id"] = node_pool_id
        __props__.__dict__["node_shape"] = node_shape
        __props__.__dict__["node_shape_config"] = node_shape_config
        __props__.__dict__["node_source_details"] = node_source_details
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["quantity_per_subnet"] = quantity_per_subnet
        __props__.__dict__["ssh_public_key"] = ssh_public_key
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["wait_until_ready"] = wait_until_ready
        return OciContainerengineNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster to which this node pool is attached.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment in which the node pool exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> pulumi.Output[Optional[Sequence['outputs.OciContainerengineNodePoolInitialNodeLabel']]]:
        return pulumi.get(self, "initial_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> pulumi.Output['outputs.OciContainerengineNodePoolNodeConfigDetails']:
        return pulumi.get(self, "node_config_details")

    @property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "node_image_id")

    @property
    @pulumi.getter(name="nodeImageName")
    def node_image_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "node_image_name")

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "node_metadata")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> pulumi.Output[str]:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> pulumi.Output[str]:
        """
        The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> pulumi.Output['outputs.OciContainerengineNodePoolNodeShapeConfig']:
        return pulumi.get(self, "node_shape_config")

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> pulumi.Output['outputs.OciContainerengineNodePoolNodeSourceDetails']:
        return pulumi.get(self, "node_source_details")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.OciContainerengineNodePoolNode']]:
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> pulumi.Output[int]:
        return pulumi.get(self, "quantity_per_subnet")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the Node Pool resource in Oracle Cloud Infrastructure Container Engine service be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="waitUntilReady")
    def wait_until_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to wait until oci node pool to be ready, after creation. Defaults to `true`.
        """
        return pulumi.get(self, "wait_until_ready")

