# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlanCertificatesArgs', 'PlanCertificates']

@pulumi.input_type
class PlanCertificatesArgs:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 certificate: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]] = None,
                 delete_unspecified_certificates: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PlanCertificates resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]] certificate: A list of certificates to manage.
        :param pulumi.Input[bool] delete_unspecified_certificates: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if delete_unspecified_certificates is not None:
            pulumi.set(__self__, "delete_unspecified_certificates", delete_unspecified_certificates)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]:
        """
        A list of certificates to manage.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedCertificates")
    def delete_unspecified_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_certificates")

    @delete_unspecified_certificates.setter
    def delete_unspecified_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_certificates", value)


@pulumi.input_type
class _PlanCertificatesState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]] = None,
                 delete_unspecified_certificates: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering PlanCertificates resources.
        :param pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]] certificate: A list of certificates to manage.
        :param pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]] certificates: A complete list of certificates for this plan, even ones not being managed by this resource.
        :param pulumi.Input[bool] delete_unspecified_certificates: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_certificates: A list of certificate names being managed by this resource.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if delete_unspecified_certificates is not None:
            pulumi.set(__self__, "delete_unspecified_certificates", delete_unspecified_certificates)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if specified_certificates is not None:
            pulumi.set(__self__, "specified_certificates", specified_certificates)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]:
        """
        A list of certificates to manage.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]:
        """
        A complete list of certificates for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanCertificatesCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedCertificates")
    def delete_unspecified_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_certificates")

    @delete_unspecified_certificates.setter
    def delete_unspecified_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_certificates", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="specifiedCertificates")
    def specified_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of certificate names being managed by this resource.
        """
        return pulumi.get(self, "specified_certificates")

    @specified_certificates.setter
    def specified_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_certificates", value)


class PlanCertificates(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]]] = None,
                 delete_unspecified_certificates: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `PlanCertificates` manages the list of certificates avaialble to a plan in Duplo.

        This resource allows you take control of individual plan certificates for a specific plan.

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planCertificates:PlanCertificates myplan PLAN_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]] certificate: A list of certificates to manage.
        :param pulumi.Input[bool] delete_unspecified_certificates: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanCertificatesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanCertificates` manages the list of certificates avaialble to a plan in Duplo.

        This resource allows you take control of individual plan certificates for a specific plan.

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planCertificates:PlanCertificates myplan PLAN_ID
        ```

        :param str resource_name: The name of the resource.
        :param PlanCertificatesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanCertificatesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]]] = None,
                 delete_unspecified_certificates: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanCertificatesArgs.__new__(PlanCertificatesArgs)

            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["delete_unspecified_certificates"] = delete_unspecified_certificates
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["certificates"] = None
            __props__.__dict__["specified_certificates"] = None
        super(PlanCertificates, __self__).__init__(
            'duplocloud:index/planCertificates:PlanCertificates',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]]] = None,
            delete_unspecified_certificates: Optional[pulumi.Input[bool]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            specified_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'PlanCertificates':
        """
        Get an existing PlanCertificates resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]] certificate: A list of certificates to manage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanCertificatesCertificateArgs', 'PlanCertificatesCertificateArgsDict']]]] certificates: A complete list of certificates for this plan, even ones not being managed by this resource.
        :param pulumi.Input[bool] delete_unspecified_certificates: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_certificates: A list of certificate names being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanCertificatesState.__new__(_PlanCertificatesState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["delete_unspecified_certificates"] = delete_unspecified_certificates
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["specified_certificates"] = specified_certificates
        return PlanCertificates(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[Sequence['outputs.PlanCertificatesCertificate']]]:
        """
        A list of certificates to manage.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.PlanCertificatesCertificate']]:
        """
        A complete list of certificates for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="deleteUnspecifiedCertificates")
    def delete_unspecified_certificates(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_certificates")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="specifiedCertificates")
    def specified_certificates(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of certificate names being managed by this resource.
        """
        return pulumi.get(self, "specified_certificates")

