# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlanImagesArgs', 'PlanImages']

@pulumi.input_type
class PlanImagesArgs:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 delete_unspecified_images: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]] = None):
        """
        The set of arguments for constructing a PlanImages resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[bool] delete_unspecified_images: Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]] image: A list of images to manage.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        if delete_unspecified_images is not None:
            pulumi.set(__self__, "delete_unspecified_images", delete_unspecified_images)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedImages")
    def delete_unspecified_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_images")

    @delete_unspecified_images.setter
    def delete_unspecified_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_images", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]:
        """
        A list of images to manage.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class _PlanImagesState:
    def __init__(__self__, *,
                 delete_unspecified_images: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering PlanImages resources.
        :param pulumi.Input[bool] delete_unspecified_images: Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]] image: A list of images to manage.
        :param pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]] images: A complete list of images for this plan, even ones not being managed by this resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_images: A list of image names being managed by this resource.
        """
        if delete_unspecified_images is not None:
            pulumi.set(__self__, "delete_unspecified_images", delete_unspecified_images)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if specified_images is not None:
            pulumi.set(__self__, "specified_images", specified_images)

    @property
    @pulumi.getter(name="deleteUnspecifiedImages")
    def delete_unspecified_images(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_images")

    @delete_unspecified_images.setter
    def delete_unspecified_images(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_images", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]:
        """
        A list of images to manage.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]:
        """
        A complete list of images for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanImagesImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="specifiedImages")
    def specified_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of image names being managed by this resource.
        """
        return pulumi.get(self, "specified_images")

    @specified_images.setter
    def specified_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_images", value)


class PlanImages(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_images: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `PlanImages` manages the list of images avaialble to a plan in Duplo.

        This resource allows you take control of individual images for a specific plan.

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planImages:PlanImages myplan PLAN_ID/WAF_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_images: Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]] image: A list of images to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanImagesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanImages` manages the list of images avaialble to a plan in Duplo.

        This resource allows you take control of individual images for a specific plan.

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planImages:PlanImages myplan PLAN_ID/WAF_NAME
        ```

        :param str resource_name: The name of the resource.
        :param PlanImagesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanImagesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_images: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanImagesArgs.__new__(PlanImagesArgs)

            __props__.__dict__["delete_unspecified_images"] = delete_unspecified_images
            __props__.__dict__["image"] = image
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["images"] = None
            __props__.__dict__["specified_images"] = None
        super(PlanImages, __self__).__init__(
            'duplocloud:index/planImages:PlanImages',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_unspecified_images: Optional[pulumi.Input[bool]] = None,
            image: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]]] = None,
            images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            specified_images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'PlanImages':
        """
        Get an existing PlanImages resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_images: Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]] image: A list of images to manage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanImagesImageArgs', 'PlanImagesImageArgsDict']]]] images: A complete list of images for this plan, even ones not being managed by this resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_images: A list of image names being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanImagesState.__new__(_PlanImagesState)

        __props__.__dict__["delete_unspecified_images"] = delete_unspecified_images
        __props__.__dict__["image"] = image
        __props__.__dict__["images"] = images
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["specified_images"] = specified_images
        return PlanImages(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteUnspecifiedImages")
    def delete_unspecified_images(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any images not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_images")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[Sequence['outputs.PlanImagesImage']]]:
        """
        A list of images to manage.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def images(self) -> pulumi.Output[Sequence['outputs.PlanImagesImage']]:
        """
        A complete list of images for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="specifiedImages")
    def specified_images(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of image names being managed by this resource.
        """
        return pulumi.get(self, "specified_images")

