# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlanKmsV2Args', 'PlanKmsV2']

@pulumi.input_type
class PlanKmsV2Args:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 delete_unspecified_kms_keys: Optional[pulumi.Input[bool]] = None,
                 kms: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]] = None):
        """
        The set of arguments for constructing a PlanKmsV2 resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[bool] delete_unspecified_kms_keys: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]] kms: A list of KMS key to manage.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        if delete_unspecified_kms_keys is not None:
            pulumi.set(__self__, "delete_unspecified_kms_keys", delete_unspecified_kms_keys)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedKmsKeys")
    def delete_unspecified_kms_keys(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_kms_keys")

    @delete_unspecified_kms_keys.setter
    def delete_unspecified_kms_keys(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_kms_keys", value)

    @property
    @pulumi.getter
    def kms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]]:
        """
        A list of KMS key to manage.
        """
        return pulumi.get(self, "kms")

    @kms.setter
    def kms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]]):
        pulumi.set(self, "kms", value)


@pulumi.input_type
class _PlanKmsV2State:
    def __init__(__self__, *,
                 delete_unspecified_kms_keys: Optional[pulumi.Input[bool]] = None,
                 kms: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]] = None,
                 kms_keys: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmsKeyArgs']]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_kms_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering PlanKmsV2 resources.
        :param pulumi.Input[bool] delete_unspecified_kms_keys: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]] kms: A list of KMS key to manage.
        :param pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmsKeyArgs']]] kms_keys: A list of KMS key to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_kms_keys: A list of certificate names being managed by this resource.
        """
        if delete_unspecified_kms_keys is not None:
            pulumi.set(__self__, "delete_unspecified_kms_keys", delete_unspecified_kms_keys)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if kms_keys is not None:
            pulumi.set(__self__, "kms_keys", kms_keys)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if specified_kms_keys is not None:
            pulumi.set(__self__, "specified_kms_keys", specified_kms_keys)

    @property
    @pulumi.getter(name="deleteUnspecifiedKmsKeys")
    def delete_unspecified_kms_keys(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_kms_keys")

    @delete_unspecified_kms_keys.setter
    def delete_unspecified_kms_keys(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_kms_keys", value)

    @property
    @pulumi.getter
    def kms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]]:
        """
        A list of KMS key to manage.
        """
        return pulumi.get(self, "kms")

    @kms.setter
    def kms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmArgs']]]]):
        pulumi.set(self, "kms", value)

    @property
    @pulumi.getter(name="kmsKeys")
    def kms_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmsKeyArgs']]]]:
        """
        A list of KMS key to manage.
        """
        return pulumi.get(self, "kms_keys")

    @kms_keys.setter
    def kms_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanKmsV2KmsKeyArgs']]]]):
        pulumi.set(self, "kms_keys", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="specifiedKmsKeys")
    def specified_kms_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of certificate names being managed by this resource.
        """
        return pulumi.get(self, "specified_kms_keys")

    @specified_kms_keys.setter
    def specified_kms_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_kms_keys", value)


class PlanKmsV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_kms_keys: Optional[pulumi.Input[bool]] = None,
                 kms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmArgs', 'PlanKmsV2KmArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `PlanKmsV2` manages the list of kms avaialble to a plan in Duplo.

        This resource allows you take control of individual plan kms for a specific plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan = duplocloud.PlanKmsV2("myplan",
            plan_id="plan-name",
            kms=[{
                "id": "kms-id",
                "arn": "kms-arn",
                "name": "kms-name",
            }])
        ```

        ## Import

        Example: Importing an existing WAF instance

         - *PLAN_ID* is the plan name

        ```sh
        $ pulumi import duplocloud:index/planKmsV2:PlanKmsV2 myplan *PLAN_ID*/kms*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_kms_keys: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmArgs', 'PlanKmsV2KmArgsDict']]]] kms: A list of KMS key to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanKmsV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanKmsV2` manages the list of kms avaialble to a plan in Duplo.

        This resource allows you take control of individual plan kms for a specific plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan = duplocloud.PlanKmsV2("myplan",
            plan_id="plan-name",
            kms=[{
                "id": "kms-id",
                "arn": "kms-arn",
                "name": "kms-name",
            }])
        ```

        ## Import

        Example: Importing an existing WAF instance

         - *PLAN_ID* is the plan name

        ```sh
        $ pulumi import duplocloud:index/planKmsV2:PlanKmsV2 myplan *PLAN_ID*/kms*
        ```

        :param str resource_name: The name of the resource.
        :param PlanKmsV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanKmsV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_kms_keys: Optional[pulumi.Input[bool]] = None,
                 kms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmArgs', 'PlanKmsV2KmArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanKmsV2Args.__new__(PlanKmsV2Args)

            __props__.__dict__["delete_unspecified_kms_keys"] = delete_unspecified_kms_keys
            __props__.__dict__["kms"] = kms
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["kms_keys"] = None
            __props__.__dict__["specified_kms_keys"] = None
        super(PlanKmsV2, __self__).__init__(
            'duplocloud:index/planKmsV2:PlanKmsV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_unspecified_kms_keys: Optional[pulumi.Input[bool]] = None,
            kms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmArgs', 'PlanKmsV2KmArgsDict']]]]] = None,
            kms_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmsKeyArgs', 'PlanKmsV2KmsKeyArgsDict']]]]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            specified_kms_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'PlanKmsV2':
        """
        Get an existing PlanKmsV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_kms_keys: Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmArgs', 'PlanKmsV2KmArgsDict']]]] kms: A list of KMS key to manage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanKmsV2KmsKeyArgs', 'PlanKmsV2KmsKeyArgsDict']]]] kms_keys: A list of KMS key to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_kms_keys: A list of certificate names being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanKmsV2State.__new__(_PlanKmsV2State)

        __props__.__dict__["delete_unspecified_kms_keys"] = delete_unspecified_kms_keys
        __props__.__dict__["kms"] = kms
        __props__.__dict__["kms_keys"] = kms_keys
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["specified_kms_keys"] = specified_kms_keys
        return PlanKmsV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteUnspecifiedKmsKeys")
    def delete_unspecified_kms_keys(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any certificates not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_kms_keys")

    @property
    @pulumi.getter
    def kms(self) -> pulumi.Output[Optional[Sequence['outputs.PlanKmsV2Km']]]:
        """
        A list of KMS key to manage.
        """
        return pulumi.get(self, "kms")

    @property
    @pulumi.getter(name="kmsKeys")
    def kms_keys(self) -> pulumi.Output[Sequence['outputs.PlanKmsV2KmsKey']]:
        """
        A list of KMS key to manage.
        """
        return pulumi.get(self, "kms_keys")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="specifiedKmsKeys")
    def specified_kms_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of certificate names being managed by this resource.
        """
        return pulumi.get(self, "specified_kms_keys")

