# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlanSettingsArgs', 'PlanSettings']

@pulumi.input_type
class PlanSettingsArgs:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 dns_setting: Optional[pulumi.Input['PlanSettingsDnsSettingArgs']] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]] = None,
                 specified_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unrestricted_ext_lb: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PlanSettings resource.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]] metadatas: A list of metadata for the plan to manage.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_metadatas: A list of metadata being managed by this resource.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        if dns_setting is not None:
            pulumi.set(__self__, "dns_setting", dns_setting)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if specified_metadatas is not None:
            pulumi.set(__self__, "specified_metadatas", specified_metadatas)
        if unrestricted_ext_lb is not None:
            pulumi.set(__self__, "unrestricted_ext_lb", unrestricted_ext_lb)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="dnsSetting")
    def dns_setting(self) -> Optional[pulumi.Input['PlanSettingsDnsSettingArgs']]:
        return pulumi.get(self, "dns_setting")

    @dns_setting.setter
    def dns_setting(self, value: Optional[pulumi.Input['PlanSettingsDnsSettingArgs']]):
        pulumi.set(self, "dns_setting", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]]:
        """
        A list of metadata for the plan to manage.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="specifiedMetadatas")
    def specified_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of metadata being managed by this resource.
        """
        return pulumi.get(self, "specified_metadatas")

    @specified_metadatas.setter
    def specified_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_metadatas", value)

    @property
    @pulumi.getter(name="unrestrictedExtLb")
    def unrestricted_ext_lb(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "unrestricted_ext_lb")

    @unrestricted_ext_lb.setter
    def unrestricted_ext_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unrestricted_ext_lb", value)


@pulumi.input_type
class _PlanSettingsState:
    def __init__(__self__, *,
                 all_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsAllMetadataArgs']]]] = None,
                 dns_setting: Optional[pulumi.Input['PlanSettingsDnsSettingArgs']] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unrestricted_ext_lb: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering PlanSettings resources.
        :param pulumi.Input[Sequence[pulumi.Input['PlanSettingsAllMetadataArgs']]] all_metadatas: A complete list of metadata for this plan, even ones not being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]] metadatas: A list of metadata for the plan to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_metadatas: A list of metadata being managed by this resource.
        """
        if all_metadatas is not None:
            pulumi.set(__self__, "all_metadatas", all_metadatas)
        if dns_setting is not None:
            pulumi.set(__self__, "dns_setting", dns_setting)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if specified_metadatas is not None:
            pulumi.set(__self__, "specified_metadatas", specified_metadatas)
        if unrestricted_ext_lb is not None:
            pulumi.set(__self__, "unrestricted_ext_lb", unrestricted_ext_lb)

    @property
    @pulumi.getter(name="allMetadatas")
    def all_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsAllMetadataArgs']]]]:
        """
        A complete list of metadata for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_metadatas")

    @all_metadatas.setter
    def all_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsAllMetadataArgs']]]]):
        pulumi.set(self, "all_metadatas", value)

    @property
    @pulumi.getter(name="dnsSetting")
    def dns_setting(self) -> Optional[pulumi.Input['PlanSettingsDnsSettingArgs']]:
        return pulumi.get(self, "dns_setting")

    @dns_setting.setter
    def dns_setting(self, value: Optional[pulumi.Input['PlanSettingsDnsSettingArgs']]):
        pulumi.set(self, "dns_setting", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]]:
        """
        A list of metadata for the plan to manage.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanSettingsMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="specifiedMetadatas")
    def specified_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of metadata being managed by this resource.
        """
        return pulumi.get(self, "specified_metadatas")

    @specified_metadatas.setter
    def specified_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_metadatas", value)

    @property
    @pulumi.getter(name="unrestrictedExtLb")
    def unrestricted_ext_lb(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "unrestricted_ext_lb")

    @unrestricted_ext_lb.setter
    def unrestricted_ext_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unrestricted_ext_lb", value)


class PlanSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_setting: Optional[pulumi.Input[Union['PlanSettingsDnsSettingArgs', 'PlanSettingsDnsSettingArgsDict']]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsMetadataArgs', 'PlanSettingsMetadataArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unrestricted_ext_lb: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        `PlanSettings` manages an plan settings in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan_settings = duplocloud.PlanSettings("myplanSettings",
            plan_id="myplan",
            unrestricted_ext_lb=True,
            dns_setting={
                "domain_id": "Z02791752705G9GHH8CYF",
                "internal_dns_suffix": ".test.duplocloud.net",
                "external_dns_suffix": ".test.duplocloud.net",
            })
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planSettings:PlanSettings myplanSettings PLAN_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsMetadataArgs', 'PlanSettingsMetadataArgsDict']]]] metadatas: A list of metadata for the plan to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_metadatas: A list of metadata being managed by this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanSettings` manages an plan settings in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan_settings = duplocloud.PlanSettings("myplanSettings",
            plan_id="myplan",
            unrestricted_ext_lb=True,
            dns_setting={
                "domain_id": "Z02791752705G9GHH8CYF",
                "internal_dns_suffix": ".test.duplocloud.net",
                "external_dns_suffix": ".test.duplocloud.net",
            })
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/planSettings:PlanSettings myplanSettings PLAN_ID
        ```

        :param str resource_name: The name of the resource.
        :param PlanSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_setting: Optional[pulumi.Input[Union['PlanSettingsDnsSettingArgs', 'PlanSettingsDnsSettingArgsDict']]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsMetadataArgs', 'PlanSettingsMetadataArgsDict']]]]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 unrestricted_ext_lb: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanSettingsArgs.__new__(PlanSettingsArgs)

            __props__.__dict__["dns_setting"] = dns_setting
            __props__.__dict__["metadatas"] = metadatas
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            __props__.__dict__["specified_metadatas"] = specified_metadatas
            __props__.__dict__["unrestricted_ext_lb"] = unrestricted_ext_lb
            __props__.__dict__["all_metadatas"] = None
        super(PlanSettings, __self__).__init__(
            'duplocloud:index/planSettings:PlanSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsAllMetadataArgs', 'PlanSettingsAllMetadataArgsDict']]]]] = None,
            dns_setting: Optional[pulumi.Input[Union['PlanSettingsDnsSettingArgs', 'PlanSettingsDnsSettingArgsDict']]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsMetadataArgs', 'PlanSettingsMetadataArgsDict']]]]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            specified_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            unrestricted_ext_lb: Optional[pulumi.Input[bool]] = None) -> 'PlanSettings':
        """
        Get an existing PlanSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsAllMetadataArgs', 'PlanSettingsAllMetadataArgsDict']]]] all_metadatas: A complete list of metadata for this plan, even ones not being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanSettingsMetadataArgs', 'PlanSettingsMetadataArgsDict']]]] metadatas: A list of metadata for the plan to manage.
        :param pulumi.Input[str] plan_id: The ID of the plan to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_metadatas: A list of metadata being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanSettingsState.__new__(_PlanSettingsState)

        __props__.__dict__["all_metadatas"] = all_metadatas
        __props__.__dict__["dns_setting"] = dns_setting
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["specified_metadatas"] = specified_metadatas
        __props__.__dict__["unrestricted_ext_lb"] = unrestricted_ext_lb
        return PlanSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allMetadatas")
    def all_metadatas(self) -> pulumi.Output[Sequence['outputs.PlanSettingsAllMetadata']]:
        """
        A complete list of metadata for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "all_metadatas")

    @property
    @pulumi.getter(name="dnsSetting")
    def dns_setting(self) -> pulumi.Output['outputs.PlanSettingsDnsSetting']:
        return pulumi.get(self, "dns_setting")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.PlanSettingsMetadata']]]:
        """
        A list of metadata for the plan to manage.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan to configure.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="specifiedMetadatas")
    def specified_metadatas(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of metadata being managed by this resource.
        """
        return pulumi.get(self, "specified_metadatas")

    @property
    @pulumi.getter(name="unrestrictedExtLb")
    def unrestricted_ext_lb(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "unrestricted_ext_lb")

