# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PlanWafArgs', 'PlanWaf']

@pulumi.input_type
class PlanWafArgs:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 waf_arn: pulumi.Input[str],
                 waf_name: pulumi.Input[str],
                 dashboard_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PlanWaf resource.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "waf_arn", waf_arn)
        pulumi.set(__self__, "waf_name", waf_name)
        if dashboard_url is not None:
            pulumi.set(__self__, "dashboard_url", dashboard_url)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="wafArn")
    def waf_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "waf_arn")

    @waf_arn.setter
    def waf_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "waf_arn", value)

    @property
    @pulumi.getter(name="wafName")
    def waf_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "waf_name")

    @waf_name.setter
    def waf_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "waf_name", value)

    @property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dashboard_url")

    @dashboard_url.setter
    def dashboard_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard_url", value)


@pulumi.input_type
class _PlanWafState:
    def __init__(__self__, *,
                 dashboard_url: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 waf_arn: Optional[pulumi.Input[str]] = None,
                 waf_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PlanWaf resources.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        """
        if dashboard_url is not None:
            pulumi.set(__self__, "dashboard_url", dashboard_url)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if waf_arn is not None:
            pulumi.set(__self__, "waf_arn", waf_arn)
        if waf_name is not None:
            pulumi.set(__self__, "waf_name", waf_name)

    @property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dashboard_url")

    @dashboard_url.setter
    def dashboard_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard_url", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="wafArn")
    def waf_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "waf_arn")

    @waf_arn.setter
    def waf_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf_arn", value)

    @property
    @pulumi.getter(name="wafName")
    def waf_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "waf_name")

    @waf_name.setter
    def waf_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf_name", value)


class PlanWaf(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_url: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 waf_arn: Optional[pulumi.Input[str]] = None,
                 waf_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `PlanWaf` manages the list of waf's avaialble to a plan in Duplo.

        This resource allows you take control of individual waf's for a specific plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan = duplocloud.PlanWaf("myplan",
            plan_id="plan-name",
            waf_name="WebAcl name",
            waf_arn="WebAcl ARN",
            dashboard_url="dashboard url")
        ```

        ## Import

        Example: Importing an existing WAF instance

         - *PLAN_ID* is the plan name

         - *WAF_NAME* is the name of the WAF

        # 

        ```sh
        $ pulumi import duplocloud:index/planWaf:PlanWaf myplan *PLAN_ID*/*WAF_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanWafArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanWaf` manages the list of waf's avaialble to a plan in Duplo.

        This resource allows you take control of individual waf's for a specific plan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myplan = duplocloud.PlanWaf("myplan",
            plan_id="plan-name",
            waf_name="WebAcl name",
            waf_arn="WebAcl ARN",
            dashboard_url="dashboard url")
        ```

        ## Import

        Example: Importing an existing WAF instance

         - *PLAN_ID* is the plan name

         - *WAF_NAME* is the name of the WAF

        # 

        ```sh
        $ pulumi import duplocloud:index/planWaf:PlanWaf myplan *PLAN_ID*/*WAF_NAME*
        ```

        :param str resource_name: The name of the resource.
        :param PlanWafArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanWafArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dashboard_url: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 waf_arn: Optional[pulumi.Input[str]] = None,
                 waf_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanWafArgs.__new__(PlanWafArgs)

            __props__.__dict__["dashboard_url"] = dashboard_url
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            if waf_arn is None and not opts.urn:
                raise TypeError("Missing required property 'waf_arn'")
            __props__.__dict__["waf_arn"] = waf_arn
            if waf_name is None and not opts.urn:
                raise TypeError("Missing required property 'waf_name'")
            __props__.__dict__["waf_name"] = waf_name
        super(PlanWaf, __self__).__init__(
            'duplocloud:index/planWaf:PlanWaf',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dashboard_url: Optional[pulumi.Input[str]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            waf_arn: Optional[pulumi.Input[str]] = None,
            waf_name: Optional[pulumi.Input[str]] = None) -> 'PlanWaf':
        """
        Get an existing PlanWaf resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanWafState.__new__(_PlanWafState)

        __props__.__dict__["dashboard_url"] = dashboard_url
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["waf_arn"] = waf_arn
        __props__.__dict__["waf_name"] = waf_name
        return PlanWaf(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dashboard_url")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="wafArn")
    def waf_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "waf_arn")

    @property
    @pulumi.getter(name="wafName")
    def waf_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "waf_name")

