# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PlanWafV2Args', 'PlanWafV2']

@pulumi.input_type
class PlanWafV2Args:
    def __init__(__self__, *,
                 plan_id: pulumi.Input[str],
                 waf: pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]],
                 delete_unspecified_wafs: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a PlanWafV2 resource.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        :param pulumi.Input[bool] delete_unspecified_wafs: Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "waf", waf)
        if delete_unspecified_wafs is not None:
            pulumi.set(__self__, "delete_unspecified_wafs", delete_unspecified_wafs)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Input[str]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter
    def waf(self) -> pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]:
        return pulumi.get(self, "waf")

    @waf.setter
    def waf(self, value: pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]):
        pulumi.set(self, "waf", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedWafs")
    def delete_unspecified_wafs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_wafs")

    @delete_unspecified_wafs.setter
    def delete_unspecified_wafs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_wafs", value)


@pulumi.input_type
class _PlanWafV2State:
    def __init__(__self__, *,
                 delete_unspecified_wafs: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 specified_wafs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 waf: Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]] = None,
                 wafs: Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]] = None):
        """
        Input properties used for looking up and filtering PlanWafV2 resources.
        :param pulumi.Input[bool] delete_unspecified_wafs: Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_wafs: A list of wafs names being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]] wafs: A complete list of wafs for this plan, even ones not being managed by this resource.
        """
        if delete_unspecified_wafs is not None:
            pulumi.set(__self__, "delete_unspecified_wafs", delete_unspecified_wafs)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if specified_wafs is not None:
            pulumi.set(__self__, "specified_wafs", specified_wafs)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if wafs is not None:
            pulumi.set(__self__, "wafs", wafs)

    @property
    @pulumi.getter(name="deleteUnspecifiedWafs")
    def delete_unspecified_wafs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_wafs")

    @delete_unspecified_wafs.setter
    def delete_unspecified_wafs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_wafs", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="specifiedWafs")
    def specified_wafs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of wafs names being managed by this resource.
        """
        return pulumi.get(self, "specified_wafs")

    @specified_wafs.setter
    def specified_wafs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_wafs", value)

    @property
    @pulumi.getter
    def waf(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]]:
        return pulumi.get(self, "waf")

    @waf.setter
    def waf(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]]):
        pulumi.set(self, "waf", value)

    @property
    @pulumi.getter
    def wafs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]]:
        """
        A complete list of wafs for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "wafs")

    @wafs.setter
    def wafs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlanWafV2WafArgs']]]]):
        pulumi.set(self, "wafs", value)


class PlanWafV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_wafs: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 waf: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanWafV2WafArgs', 'PlanWafV2WafArgsDict']]]]] = None,
                 __props__=None):
        """
        `PlanWafV2` manages the list of waf's avaialble to a plan in Duplo.

        This resource allows you take control of individual waf's for a specific plan.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_wafs: Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PlanWafV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `PlanWafV2` manages the list of waf's avaialble to a plan in Duplo.

        This resource allows you take control of individual waf's for a specific plan.

        :param str resource_name: The name of the resource.
        :param PlanWafV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PlanWafV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_wafs: Optional[pulumi.Input[bool]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 waf: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanWafV2WafArgs', 'PlanWafV2WafArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PlanWafV2Args.__new__(PlanWafV2Args)

            __props__.__dict__["delete_unspecified_wafs"] = delete_unspecified_wafs
            if plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'plan_id'")
            __props__.__dict__["plan_id"] = plan_id
            if waf is None and not opts.urn:
                raise TypeError("Missing required property 'waf'")
            __props__.__dict__["waf"] = waf
            __props__.__dict__["specified_wafs"] = None
            __props__.__dict__["wafs"] = None
        super(PlanWafV2, __self__).__init__(
            'duplocloud:index/planWafV2:PlanWafV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_unspecified_wafs: Optional[pulumi.Input[bool]] = None,
            plan_id: Optional[pulumi.Input[str]] = None,
            specified_wafs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            waf: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanWafV2WafArgs', 'PlanWafV2WafArgsDict']]]]] = None,
            wafs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PlanWafV2WafArgs', 'PlanWafV2WafArgsDict']]]]] = None) -> 'PlanWafV2':
        """
        Get an existing PlanWafV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_wafs: Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[str] plan_id: The ID of the plan for waf.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_wafs: A list of wafs names being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PlanWafV2WafArgs', 'PlanWafV2WafArgsDict']]]] wafs: A complete list of wafs for this plan, even ones not being managed by this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PlanWafV2State.__new__(_PlanWafV2State)

        __props__.__dict__["delete_unspecified_wafs"] = delete_unspecified_wafs
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["specified_wafs"] = specified_wafs
        __props__.__dict__["waf"] = waf
        __props__.__dict__["wafs"] = wafs
        return PlanWafV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteUnspecifiedWafs")
    def delete_unspecified_wafs(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any wafs not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_wafs")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[str]:
        """
        The ID of the plan for waf.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="specifiedWafs")
    def specified_wafs(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of wafs names being managed by this resource.
        """
        return pulumi.get(self, "specified_wafs")

    @property
    @pulumi.getter
    def waf(self) -> pulumi.Output[Sequence['outputs.PlanWafV2Waf']]:
        return pulumi.get(self, "waf")

    @property
    @pulumi.getter
    def wafs(self) -> pulumi.Output[Sequence['outputs.PlanWafV2Waf']]:
        """
        A complete list of wafs for this plan, even ones not being managed by this resource.
        """
        return pulumi.get(self, "wafs")

