# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RdsInstanceArgs', 'RdsInstance']

@pulumi.input_type
class RdsInstanceArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[int],
                 size: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_iam_auth: Optional[pulumi.Input[bool]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 encrypt_storage: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 store_details_in_secret_manager: Optional[pulumi.Input[bool]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']] = None):
        """
        The set of arguments for constructing a RdsInstance resource.
        :param pulumi.Input[int] engine: The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
               PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
               MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        :param pulumi.Input[str] size: The instance type of the RDS instance. See AWS documentation for the [available instance
               types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
               serverless
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS instance will be created in.
        :param pulumi.Input[int] allocated_storage: (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        :param pulumi.Input[str] availability_zone: Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
               instance. e.g. us-west-2a
        :param pulumi.Input[int] backup_retention_period: Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. This is not applicable for update.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
               `true`. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] enable_iam_auth: Whether or not to enable the RDS IAM authentication.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[str] engine_version: The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
               RDS instance, you can use the [AWS
               CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[int] iops: The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] master_password: The master password of the RDS instance.
        :param pulumi.Input[str] master_username: The master username of the RDS instance.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
               `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input['RdsInstancePerformanceInsightsArgs'] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
               the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
               to true.
        :param pulumi.Input[bool] skip_final_snapshot: If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
               deleted.
        :param pulumi.Input[str] snapshot_id: A database snapshot to initialize the RDS instance from, at launch.
        :param pulumi.Input[str] storage_type: Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
               |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
               | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
               provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
               customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
               You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
               Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
               guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
               unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
               least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
               Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
               databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
               multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
               guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
               consistently high performance for critical workloads. |
        :param pulumi.Input[bool] store_details_in_secret_manager: Whether or not to store RDS details in the AWS secrets manager.
        :param pulumi.Input['RdsInstanceV2ScalingConfigurationArgs'] v2_scaling_configuration: Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
               instances
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_iam_auth is not None:
            pulumi.set(__self__, "enable_iam_auth", enable_iam_auth)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if encrypt_storage is not None:
            pulumi.set(__self__, "encrypt_storage", encrypt_storage)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if performance_insights is not None:
            pulumi.set(__self__, "performance_insights", performance_insights)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if store_details_in_secret_manager is not None:
            pulumi.set(__self__, "store_details_in_secret_manager", store_details_in_secret_manager)
        if v2_scaling_configuration is not None:
            pulumi.set(__self__, "v2_scaling_configuration", v2_scaling_configuration)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[int]:
        """
        The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
        PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
        MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[int]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The instance type of the RDS instance. See AWS documentation for the [available instance
        types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
        serverless
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the RDS instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
        instance. e.g. us-west-2a
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter group associated with this instance's DB Cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to create when the DB instance is created. This is not applicable for update.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
        `true`. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableIamAuth")
    def enable_iam_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the RDS IAM authentication.
        """
        return pulumi.get(self, "enable_iam_auth")

    @enable_iam_auth.setter
    def enable_iam_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_iam_auth", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="encryptStorage")
    def encrypt_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to encrypt the RDS instance storage.
        """
        return pulumi.get(self, "encrypt_storage")

    @encrypt_storage.setter
    def encrypt_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_storage", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
        RDS instance, you can use the [AWS
        CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[int]]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[str]]:
        """
        The master password of the RDS instance.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        The master username of the RDS instance.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
        `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']]:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
        the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
        to true.
        """
        return pulumi.get(self, "performance_insights")

    @performance_insights.setter
    def performance_insights(self, value: Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']]):
        pulumi.set(self, "performance_insights", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
        deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        A database snapshot to initialize the RDS instance from, at launch.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
        |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
        provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
        customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
        You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
        Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
        guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
        unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
        least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
        Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
        databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
        multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
        guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
        consistently high performance for critical workloads. |
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="storeDetailsInSecretManager")
    def store_details_in_secret_manager(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to store RDS details in the AWS secrets manager.
        """
        return pulumi.get(self, "store_details_in_secret_manager")

    @store_details_in_secret_manager.setter
    def store_details_in_secret_manager(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "store_details_in_secret_manager", value)

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']]:
        """
        Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
        instances
        """
        return pulumi.get(self, "v2_scaling_configuration")

    @v2_scaling_configuration.setter
    def v2_scaling_configuration(self, value: Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']]):
        pulumi.set(self, "v2_scaling_configuration", value)


@pulumi.input_type
class _RdsInstanceState:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_iam_auth: Optional[pulumi.Input[bool]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 encrypt_storage: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[int]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 instance_status: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 store_details_in_secret_manager: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering RdsInstance resources.
        :param pulumi.Input[int] allocated_storage: (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        :param pulumi.Input[str] arn: The ARN of the RDS instance.
        :param pulumi.Input[str] availability_zone: Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
               instance. e.g. us-west-2a
        :param pulumi.Input[int] backup_retention_period: Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        :param pulumi.Input[str] cluster_identifier: The RDS Cluster Identifier
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. This is not applicable for update.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
               `true`. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] enable_iam_auth: Whether or not to enable the RDS IAM authentication.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[str] endpoint: The endpoint of the RDS instance.
        :param pulumi.Input[int] engine: The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
               PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
               MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        :param pulumi.Input[str] engine_version: The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
               RDS instance, you can use the [AWS
               CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[str] host: The DNS hostname of the RDS instance.
        :param pulumi.Input[str] identifier: The full name of the RDS instance.
        :param pulumi.Input[str] instance_status: The current status of the RDS instance.
        :param pulumi.Input[int] iops: The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] master_password: The master password of the RDS instance.
        :param pulumi.Input[str] master_username: The master username of the RDS instance.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
               `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input['RdsInstancePerformanceInsightsArgs'] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
               the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
               to true.
        :param pulumi.Input[int] port: The listening port of the RDS instance.
        :param pulumi.Input[str] size: The instance type of the RDS instance. See AWS documentation for the [available instance
               types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
               serverless
        :param pulumi.Input[bool] skip_final_snapshot: If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
               deleted.
        :param pulumi.Input[str] snapshot_id: A database snapshot to initialize the RDS instance from, at launch.
        :param pulumi.Input[str] storage_type: Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
               |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
               | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
               provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
               customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
               You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
               Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
               guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
               unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
               least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
               Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
               databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
               multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
               guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
               consistently high performance for critical workloads. |
        :param pulumi.Input[bool] store_details_in_secret_manager: Whether or not to store RDS details in the AWS secrets manager.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS instance will be created in.
        :param pulumi.Input['RdsInstanceV2ScalingConfigurationArgs'] v2_scaling_configuration: Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
               instances
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_iam_auth is not None:
            pulumi.set(__self__, "enable_iam_auth", enable_iam_auth)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if encrypt_storage is not None:
            pulumi.set(__self__, "encrypt_storage", encrypt_storage)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if instance_status is not None:
            pulumi.set(__self__, "instance_status", instance_status)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if performance_insights is not None:
            pulumi.set(__self__, "performance_insights", performance_insights)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if store_details_in_secret_manager is not None:
            pulumi.set(__self__, "store_details_in_secret_manager", store_details_in_secret_manager)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if v2_scaling_configuration is not None:
            pulumi.set(__self__, "v2_scaling_configuration", v2_scaling_configuration)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the RDS instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
        instance. e.g. us-west-2a
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The RDS Cluster Identifier
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter group associated with this instance's DB Cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to create when the DB instance is created. This is not applicable for update.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
        `true`. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="enableIamAuth")
    def enable_iam_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the RDS IAM authentication.
        """
        return pulumi.get(self, "enable_iam_auth")

    @enable_iam_auth.setter
    def enable_iam_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_iam_auth", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="encryptStorage")
    def encrypt_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to encrypt the RDS instance storage.
        """
        return pulumi.get(self, "encrypt_storage")

    @encrypt_storage.setter
    def encrypt_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_storage", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the RDS instance.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
        PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
        MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
        RDS instance, you can use the [AWS
        CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[int]]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS hostname of the RDS instance.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the RDS instance.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the RDS instance.
        """
        return pulumi.get(self, "instance_status")

    @instance_status.setter
    def instance_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_status", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[str]]:
        """
        The master password of the RDS instance.
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        The master username of the RDS instance.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
        `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']]:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
        the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
        to true.
        """
        return pulumi.get(self, "performance_insights")

    @performance_insights.setter
    def performance_insights(self, value: Optional[pulumi.Input['RdsInstancePerformanceInsightsArgs']]):
        pulumi.set(self, "performance_insights", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The listening port of the RDS instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the RDS instance. See AWS documentation for the [available instance
        types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
        serverless
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
        deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        A database snapshot to initialize the RDS instance from, at launch.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
        |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
        provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
        customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
        You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
        Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
        guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
        unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
        least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
        Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
        databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
        multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
        guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
        consistently high performance for critical workloads. |
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="storeDetailsInSecretManager")
    def store_details_in_secret_manager(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to store RDS details in the AWS secrets manager.
        """
        return pulumi.get(self, "store_details_in_secret_manager")

    @store_details_in_secret_manager.setter
    def store_details_in_secret_manager(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "store_details_in_secret_manager", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the RDS instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']]:
        """
        Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
        instances
        """
        return pulumi.get(self, "v2_scaling_configuration")

    @v2_scaling_configuration.setter
    def v2_scaling_configuration(self, value: Optional[pulumi.Input['RdsInstanceV2ScalingConfigurationArgs']]):
        pulumi.set(self, "v2_scaling_configuration", value)


class RdsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_iam_auth: Optional[pulumi.Input[bool]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 encrypt_storage: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[int]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input[Union['RdsInstancePerformanceInsightsArgs', 'RdsInstancePerformanceInsightsArgsDict']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 store_details_in_secret_manager: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input[Union['RdsInstanceV2ScalingConfigurationArgs', 'RdsInstanceV2ScalingConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Provision an RDS instance using the PostgreSQL engine named dev-db in DuploCloud platform.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Before creating an RDS instance, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Generate a random password for the RDS instance.
        password = random.index.Password("password",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.tenant_id,
            name="dev-db",
            engine=1,
            engine_version="15.2",
            size="db.t3.medium",
            master_username="postgres",
            master_password=password["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Provision an RDS instance using the PostgreSQL engine named dev-db with deletion protection enabled and multi-az enabled.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=1,
            engine_version="15.2",
            size="db.t3.medium",
            deletion_protection=True,
            multi_az=True,
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Create an RDS instance using the Aurora-PostgreSQL engine named aurora-postgres-db with instance class db.m5.large.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        aurora_postgres_db = duplocloud.RdsInstance("aurora-postgres-db",
            tenant_id=tenant.id,
            name="aurora-postgres-db",
            engine=9,
            engine_version="15.2",
            size="db.m5.large",
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Create an Aurora serverless RDS instance using the PostgreSQL engine named aurora-postgres with engine version 15.5, minimum capacity of 0.5, maximum capacity of 2, with deletion protection enabled and store the DB credentials in AWS secrets manager. Also create a read replica for this database.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        aurora_serverless = duplocloud.RdsInstance("aurora-serverless",
            tenant_id=tenant.id,
            name="aurora-postgres",
            engine=9,
            engine_version="15.5",
            size="db.serverless",
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            v2_scaling_configuration={
                "min_capacity": 0.5,
                "max_capacity": 2,
            },
            store_details_in_secret_manager=True,
            deletion_protection=True)
        read_replica = duplocloud.RdsReadReplica("read-replica",
            tenant_id=tenant.id,
            name="aurora-postgres-read-replica",
            size="db.serverless",
            cluster_identifier=aurora_serverless.cluster_identifier,
            opts = pulumi.ResourceOptions(depends_on=[aurora_serverless]))
        ```

        ### Provision an RDS instance using the MySQL engine named dev-db, with username mysql_user1 in DuploCloud platform.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=0,
            engine_version="8.0.32",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Provision an RDS instance using the MySQL engine named dev-db with engine version 5.7, allocated storage 50 GB and enable IAM auth and logging for this DB.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=0,
            engine_version="5.7.44",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            allocated_storage=50,
            enable_iam_auth=True,
            enable_logging=True)
        ```

        ### Create an RDS instance using the Aurora MySQL engine named mysql-db with engine version 5.7, allocated storage 100 GB and storage type io1 with number of iops 6000. It should skip the final snapshot and store the credentials in secrets manager.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        mysql_db = duplocloud.RdsInstance("mysql-db",
            tenant_id=tenant.id,
            name="mysql-db",
            engine=8,
            engine_version="5.7.mysql_aurora.2.11.6",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            allocated_storage=100,
            storage_type="io1",
            iops=6000,
            skip_final_snapshot=True,
            store_details_in_secret_manager=True)
        ```

        # Example for enabling performance insights in a RDS instance

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="mydb1psql",
            engine=1,
            engine_version="14.11",
            size="db.t3.micro",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            storage_type="gp2",
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        # Example for enabling performance insights in a RDS cluster

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="clust",
            engine=8,
            engine_version="8.0.mysql_aurora.3.07.1",
            size="db.r5.large",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        # Example for enabling performance insights in a Document DB
        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="doc",
            engine=13,
            engine_version="3.6.0",
            size="db.t3.medium",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Example for creating db using snapshot
        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="mydbpsql",
            engine=0,
            engine_version="5.7.44",
            size="db.t3.medium",
            snapshot_id="rds:duplotest-snapdb-2024-12-17-07-00")
        ```

        ## Import

        Example: Importing an existing RDS instance

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the database (without the duplo prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/rdsInstance:RdsInstance mydb v2/subscriptions/*TENANT_ID*/RDSDBInstance/*SHORTNAME*
        ```

        Example to showcase use of parameter group in writer and read replica for aurora cluster instance

        resource "random_password" "mypassword" {

          length  = 16

          special = false

        }

        resource "duplocloud_rds_instance" "app" {

          tenant_id      = data.duplocloud_tenant.tenant.id

          name           = "writer1-sqlnew"

          engine         = 8

          engine_version = "5.7.mysql_aurora.2.11.5"

          size           = "db.r5.large"

          master_username              = "myuser"

          master_password              = random_password.mypassword.result

          encrypt_storage         = true

          backup_retention_period = 10

          db_name         =  "auroradb"

          skip_final_snapshot = true

          store_details_in_secret_manager = false

          enhanced_monitoring = 0

          availability_zone = "us-west-2b"

          storage_type                    = "aurora"

          cluster_parameter_group_name = "c-aurora-mysql"

          parameter_group_name = "aurora-mysql-dbparam"

        }

        resource "duplocloud_rds_read_replica" "replica1" {

          tenant_id          = duplocloud_rds_instance.app.tenant_id

          name               = "aurora-replica-new"

          size               = "db.r5.large"

          cluster_identifier = duplocloud_rds_instance.app.cluster_identifier

          availability_zone = "us-west-2a"

          parameter_group_name = "aurora-mysql-dbparam"

          engine_type=duplocloud_rds_instance.app.engine

        }

        Example to showcase use of parameter group in writer and read replica for standalone instance

        resource "duplocloud_rds_instance" "mydb" {

          tenant_id      = data.duplocloud_tenant.tenant.id

          name           = "tf-postgresql1"

          engine         = 1// PostgreSQL

          engine_version = "13.11"

          size           = "db.t3.medium"

          master_username = "myuser"

          master_password = "Qaazwedd#1"

          parameter_group_name = "psql13dbparam"

          encrypt_storage                 = false

          store_details_in_secret_manager = false

          enhanced_monitoring             = 0

          storage_type                    = "gp2"

        }

        resource "duplocloud_rds_read_replica" "replica" {

          tenant_id          = duplocloud_rds_instance.mydb.tenant_id

          name               = "postgresql-rep1"

          size               = "db.t3.medium"

          cluster_identifier = duplocloud_rds_instance.mydb.cluster_identifier

          #availability_zone = "us-east-1b"

          performance_insights {

            enabled          = true
            
            retention_period = 31

          }

          engine_type=duplocloud_rds_instance.mydb.engine

          parameter_group_name=duplocloud_rds_instance.mydb.parameter_group_name

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        :param pulumi.Input[str] availability_zone: Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
               instance. e.g. us-west-2a
        :param pulumi.Input[int] backup_retention_period: Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. This is not applicable for update.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
               `true`. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] enable_iam_auth: Whether or not to enable the RDS IAM authentication.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[int] engine: The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
               PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
               MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        :param pulumi.Input[str] engine_version: The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
               RDS instance, you can use the [AWS
               CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[int] iops: The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] master_password: The master password of the RDS instance.
        :param pulumi.Input[str] master_username: The master username of the RDS instance.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
               `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input[Union['RdsInstancePerformanceInsightsArgs', 'RdsInstancePerformanceInsightsArgsDict']] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
               the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
               to true.
        :param pulumi.Input[str] size: The instance type of the RDS instance. See AWS documentation for the [available instance
               types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
               serverless
        :param pulumi.Input[bool] skip_final_snapshot: If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
               deleted.
        :param pulumi.Input[str] snapshot_id: A database snapshot to initialize the RDS instance from, at launch.
        :param pulumi.Input[str] storage_type: Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
               |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
               | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
               provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
               customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
               You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
               Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
               guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
               unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
               least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
               Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
               databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
               multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
               guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
               consistently high performance for critical workloads. |
        :param pulumi.Input[bool] store_details_in_secret_manager: Whether or not to store RDS details in the AWS secrets manager.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS instance will be created in.
        :param pulumi.Input[Union['RdsInstanceV2ScalingConfigurationArgs', 'RdsInstanceV2ScalingConfigurationArgsDict']] v2_scaling_configuration: Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
               instances
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RdsInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Provision an RDS instance using the PostgreSQL engine named dev-db in DuploCloud platform.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Before creating an RDS instance, you must first set up the infrastructure and tenant. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="dev",
            cloud=0,
            region="us-east-1",
            enable_k8_cluster=False,
            address_prefix="10.13.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="dev",
            plan_id=infra.infra_name)
        # Generate a random password for the RDS instance.
        password = random.index.Password("password",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.tenant_id,
            name="dev-db",
            engine=1,
            engine_version="15.2",
            size="db.t3.medium",
            master_username="postgres",
            master_password=password["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Provision an RDS instance using the PostgreSQL engine named dev-db with deletion protection enabled and multi-az enabled.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=1,
            engine_version="15.2",
            size="db.t3.medium",
            deletion_protection=True,
            multi_az=True,
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Create an RDS instance using the Aurora-PostgreSQL engine named aurora-postgres-db with instance class db.m5.large.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        aurora_postgres_db = duplocloud.RdsInstance("aurora-postgres-db",
            tenant_id=tenant.id,
            name="aurora-postgres-db",
            engine=9,
            engine_version="15.2",
            size="db.m5.large",
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Create an Aurora serverless RDS instance using the PostgreSQL engine named aurora-postgres with engine version 15.5, minimum capacity of 0.5, maximum capacity of 2, with deletion protection enabled and store the DB credentials in AWS secrets manager. Also create a read replica for this database.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        aurora_serverless = duplocloud.RdsInstance("aurora-serverless",
            tenant_id=tenant.id,
            name="aurora-postgres",
            engine=9,
            engine_version="15.5",
            size="db.serverless",
            master_username="postgres",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            v2_scaling_configuration={
                "min_capacity": 0.5,
                "max_capacity": 2,
            },
            store_details_in_secret_manager=True,
            deletion_protection=True)
        read_replica = duplocloud.RdsReadReplica("read-replica",
            tenant_id=tenant.id,
            name="aurora-postgres-read-replica",
            size="db.serverless",
            cluster_identifier=aurora_serverless.cluster_identifier,
            opts = pulumi.ResourceOptions(depends_on=[aurora_serverless]))
        ```

        ### Provision an RDS instance using the MySQL engine named dev-db, with username mysql_user1 in DuploCloud platform.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=0,
            engine_version="8.0.32",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7)
        ```

        ### Provision an RDS instance using the MySQL engine named dev-db with engine version 5.7, allocated storage 50 GB and enable IAM auth and logging for this DB.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        dev_db = duplocloud.RdsInstance("dev-db",
            tenant_id=tenant.id,
            name="dev-db",
            engine=0,
            engine_version="5.7.44",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            allocated_storage=50,
            enable_iam_auth=True,
            enable_logging=True)
        ```

        ### Create an RDS instance using the Aurora MySQL engine named mysql-db with engine version 5.7, allocated storage 100 GB and storage type io1 with number of iops 6000. It should skip the final snapshot and store the credentials in secrets manager.

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud
        import pulumi_random as random

        # Ensure the 'dev' tenant is already created before creating the RDS instance.
        tenant = duplocloud.get_tenant(name="dev")
        # Generate a random password for the RDS instance.
        mypassword = random.index.Password("mypassword",
            length=16,
            special=False)
        # Create an RDS instance.
        mysql_db = duplocloud.RdsInstance("mysql-db",
            tenant_id=tenant.id,
            name="mysql-db",
            engine=8,
            engine_version="5.7.mysql_aurora.2.11.6",
            size="db.t3.medium",
            master_username="mysql_user1",
            master_password=mypassword["result"],
            encrypt_storage=True,
            backup_retention_period=7,
            allocated_storage=100,
            storage_type="io1",
            iops=6000,
            skip_final_snapshot=True,
            store_details_in_secret_manager=True)
        ```

        # Example for enabling performance insights in a RDS instance

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="mydb1psql",
            engine=1,
            engine_version="14.11",
            size="db.t3.micro",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            storage_type="gp2",
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        # Example for enabling performance insights in a RDS cluster

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="clust",
            engine=8,
            engine_version="8.0.mysql_aurora.3.07.1",
            size="db.r5.large",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        # Example for enabling performance insights in a Document DB
        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="doc",
            engine=13,
            engine_version="3.6.0",
            size="db.t3.medium",
            master_username="myuser",
            master_password="Qaazwedd#1",
            encrypt_storage=True,
            store_details_in_secret_manager=True,
            enhanced_monitoring=0,
            performance_insights={
                "enabled": True,
                "retention_period": 7,
            })
        ```

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Example for creating db using snapshot
        mydb = duplocloud.RdsInstance("mydb",
            tenant_id=tenant["id"],
            name="mydbpsql",
            engine=0,
            engine_version="5.7.44",
            size="db.t3.medium",
            snapshot_id="rds:duplotest-snapdb-2024-12-17-07-00")
        ```

        ## Import

        Example: Importing an existing RDS instance

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the database (without the duplo prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/rdsInstance:RdsInstance mydb v2/subscriptions/*TENANT_ID*/RDSDBInstance/*SHORTNAME*
        ```

        Example to showcase use of parameter group in writer and read replica for aurora cluster instance

        resource "random_password" "mypassword" {

          length  = 16

          special = false

        }

        resource "duplocloud_rds_instance" "app" {

          tenant_id      = data.duplocloud_tenant.tenant.id

          name           = "writer1-sqlnew"

          engine         = 8

          engine_version = "5.7.mysql_aurora.2.11.5"

          size           = "db.r5.large"

          master_username              = "myuser"

          master_password              = random_password.mypassword.result

          encrypt_storage         = true

          backup_retention_period = 10

          db_name         =  "auroradb"

          skip_final_snapshot = true

          store_details_in_secret_manager = false

          enhanced_monitoring = 0

          availability_zone = "us-west-2b"

          storage_type                    = "aurora"

          cluster_parameter_group_name = "c-aurora-mysql"

          parameter_group_name = "aurora-mysql-dbparam"

        }

        resource "duplocloud_rds_read_replica" "replica1" {

          tenant_id          = duplocloud_rds_instance.app.tenant_id

          name               = "aurora-replica-new"

          size               = "db.r5.large"

          cluster_identifier = duplocloud_rds_instance.app.cluster_identifier

          availability_zone = "us-west-2a"

          parameter_group_name = "aurora-mysql-dbparam"

          engine_type=duplocloud_rds_instance.app.engine

        }

        Example to showcase use of parameter group in writer and read replica for standalone instance

        resource "duplocloud_rds_instance" "mydb" {

          tenant_id      = data.duplocloud_tenant.tenant.id

          name           = "tf-postgresql1"

          engine         = 1// PostgreSQL

          engine_version = "13.11"

          size           = "db.t3.medium"

          master_username = "myuser"

          master_password = "Qaazwedd#1"

          parameter_group_name = "psql13dbparam"

          encrypt_storage                 = false

          store_details_in_secret_manager = false

          enhanced_monitoring             = 0

          storage_type                    = "gp2"

        }

        resource "duplocloud_rds_read_replica" "replica" {

          tenant_id          = duplocloud_rds_instance.mydb.tenant_id

          name               = "postgresql-rep1"

          size               = "db.t3.medium"

          cluster_identifier = duplocloud_rds_instance.mydb.cluster_identifier

          #availability_zone = "us-east-1b"

          performance_insights {

            enabled          = true
            
            retention_period = 31

          }

          engine_type=duplocloud_rds_instance.mydb.engine

          parameter_group_name=duplocloud_rds_instance.mydb.parameter_group_name

        }

        :param str resource_name: The name of the resource.
        :param RdsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 enable_iam_auth: Optional[pulumi.Input[bool]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 encrypt_storage: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[int]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input[Union['RdsInstancePerformanceInsightsArgs', 'RdsInstancePerformanceInsightsArgsDict']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 store_details_in_secret_manager: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input[Union['RdsInstanceV2ScalingConfigurationArgs', 'RdsInstanceV2ScalingConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsInstanceArgs.__new__(RdsInstanceArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_iam_auth"] = enable_iam_auth
            __props__.__dict__["enable_logging"] = enable_logging
            __props__.__dict__["encrypt_storage"] = encrypt_storage
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["master_password"] = None if master_password is None else pulumi.Output.secret(master_password)
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["name"] = name
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["performance_insights"] = performance_insights
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["store_details_in_secret_manager"] = store_details_in_secret_manager
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["v2_scaling_configuration"] = v2_scaling_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_identifier"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["instance_status"] = None
            __props__.__dict__["port"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["masterPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RdsInstance, __self__).__init__(
            'duplocloud:index/rdsInstance:RdsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated_storage: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_retention_period: Optional[pulumi.Input[int]] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            db_subnet_group_name: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            enable_iam_auth: Optional[pulumi.Input[bool]] = None,
            enable_logging: Optional[pulumi.Input[bool]] = None,
            encrypt_storage: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[int]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enhanced_monitoring: Optional[pulumi.Input[int]] = None,
            host: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            instance_status: Optional[pulumi.Input[str]] = None,
            iops: Optional[pulumi.Input[int]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            master_password: Optional[pulumi.Input[str]] = None,
            master_username: Optional[pulumi.Input[str]] = None,
            multi_az: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameter_group_name: Optional[pulumi.Input[str]] = None,
            performance_insights: Optional[pulumi.Input[Union['RdsInstancePerformanceInsightsArgs', 'RdsInstancePerformanceInsightsArgsDict']]] = None,
            port: Optional[pulumi.Input[int]] = None,
            size: Optional[pulumi.Input[str]] = None,
            skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            store_details_in_secret_manager: Optional[pulumi.Input[bool]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            v2_scaling_configuration: Optional[pulumi.Input[Union['RdsInstanceV2ScalingConfigurationArgs', 'RdsInstanceV2ScalingConfigurationArgsDict']]] = None) -> 'RdsInstance':
        """
        Get an existing RdsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        :param pulumi.Input[str] arn: The ARN of the RDS instance.
        :param pulumi.Input[str] availability_zone: Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
               instance. e.g. us-west-2a
        :param pulumi.Input[int] backup_retention_period: Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        :param pulumi.Input[str] cluster_identifier: The RDS Cluster Identifier
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[str] db_name: The name of the database to create when the DB instance is created. This is not applicable for update.
        :param pulumi.Input[str] db_subnet_group_name: Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        :param pulumi.Input[bool] deletion_protection: If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
               `true`. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] enable_iam_auth: Whether or not to enable the RDS IAM authentication.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[str] endpoint: The endpoint of the RDS instance.
        :param pulumi.Input[int] engine: The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
               PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
               MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        :param pulumi.Input[str] engine_version: The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
               RDS instance, you can use the [AWS
               CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[str] host: The DNS hostname of the RDS instance.
        :param pulumi.Input[str] identifier: The full name of the RDS instance.
        :param pulumi.Input[str] instance_status: The current status of the RDS instance.
        :param pulumi.Input[int] iops: The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[str] master_password: The master password of the RDS instance.
        :param pulumi.Input[str] master_username: The master username of the RDS instance.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
               `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input[Union['RdsInstancePerformanceInsightsArgs', 'RdsInstancePerformanceInsightsArgsDict']] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
               the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
               to true.
        :param pulumi.Input[int] port: The listening port of the RDS instance.
        :param pulumi.Input[str] size: The instance type of the RDS instance. See AWS documentation for the [available instance
               types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
               serverless
        :param pulumi.Input[bool] skip_final_snapshot: If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
               deleted.
        :param pulumi.Input[str] snapshot_id: A database snapshot to initialize the RDS instance from, at launch.
        :param pulumi.Input[str] storage_type: Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
               |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
               | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
               provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
               customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
               You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
               Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
               guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
               unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
               least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
               Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
               databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
               multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
               guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
               consistently high performance for critical workloads. |
        :param pulumi.Input[bool] store_details_in_secret_manager: Whether or not to store RDS details in the AWS secrets manager.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS instance will be created in.
        :param pulumi.Input[Union['RdsInstanceV2ScalingConfigurationArgs', 'RdsInstanceV2ScalingConfigurationArgsDict']] v2_scaling_configuration: Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
               instances
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsInstanceState.__new__(_RdsInstanceState)

        __props__.__dict__["allocated_storage"] = allocated_storage
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_retention_period"] = backup_retention_period
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_iam_auth"] = enable_iam_auth
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["encrypt_storage"] = encrypt_storage
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
        __props__.__dict__["host"] = host
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["instance_status"] = instance_status
        __props__.__dict__["iops"] = iops
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["master_password"] = master_password
        __props__.__dict__["master_username"] = master_username
        __props__.__dict__["multi_az"] = multi_az
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["performance_insights"] = performance_insights
        __props__.__dict__["port"] = port
        __props__.__dict__["size"] = size
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["store_details_in_secret_manager"] = store_details_in_secret_manager
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["v2_scaling_configuration"] = v2_scaling_configuration
        return RdsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[int]:
        """
        (Required unless a `snapshot_id` is provided) The allocated storage in gigabytes.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the RDS instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specify a valid Availability Zone for the RDS primary instance (when Multi-AZ is disabled) or for the Aurora writer
        instance. e.g. us-west-2a
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies backup retention period between 1 and 35 day(s). Default backup retention period is 1 day.
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[str]:
        """
        The RDS Cluster Identifier
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> pulumi.Output[str]:
        """
        Parameter group associated with this instance's DB Cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The name of the database to create when the DB instance is created. This is not applicable for update.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[str]:
        """
        Name of DB subnet group. DB instance will be created in the VPC associated with the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        If the DB instance should have deletion protection enabled.The database can't be deleted when this value is set to
        `true`. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="enableIamAuth")
    def enable_iam_auth(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable the RDS IAM authentication.
        """
        return pulumi.get(self, "enable_iam_auth")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="encryptStorage")
    def encrypt_storage(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to encrypt the RDS instance storage.
        """
        return pulumi.get(self, "encrypt_storage")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint of the RDS instance.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[int]:
        """
        The numerical index of database engine to use the for the RDS instance. Should be one of: - `0` : MySQL - `1` :
        PostgreSQL - `2` : MsftSQL-Express - `3` : MsftSQL-Standard - `8` : Aurora-MySQL - `9` : Aurora-PostgreSQL - `10` :
        MsftSQL-Web - `13` : DocumentDB - `14` : MariaDB - `16` : Aurora
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The database engine version to use the for the RDS instance. If you don't know the available engine versions for your
        RDS instance, you can use the [AWS
        CLI](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html) to retrieve a list.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> pulumi.Output[Optional[int]]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The DNS hostname of the RDS instance.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The full name of the RDS instance.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> pulumi.Output[str]:
        """
        The current status of the RDS instance.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[int]:
        """
        The IOPS (Input/Output Operations Per Second) value. Should be specified only if `storage_type` is either io1 or gp3.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> pulumi.Output[Optional[str]]:
        """
        The master password of the RDS instance.
        """
        return pulumi.get(self, "master_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[str]:
        """
        The master username of the RDS instance.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[bool]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the RDS instance. Duplo will add a prefix to the name. You can retrieve the full name from the
        `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[str]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> pulumi.Output[Optional['outputs.RdsInstancePerformanceInsights']]:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess
        the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set
        to true.
        """
        return pulumi.get(self, "performance_insights")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The listening port of the RDS instance.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The instance type of the RDS instance. See AWS documentation for the [available instance
        types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if rds instamce is created as
        serverless
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        If the final snapshot should be taken. When set to true, the final snapshot will not be taken when the resource is
        deleted.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[str]]:
        """
        A database snapshot to initialize the RDS instance from, at launch.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Storage type to be used for RDS instance storage. |Storage Type | Performance | Throughput | Descritpion |
        |------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        | | gp2 | 3 IOPS/GB, up to 16K IOPS | Up to 250 MB/s | General-purpose databases, small to medium workloads. 'gp2'
        provides SSD-based storage with burstable IOPS | | gp3 | 3K to 16K IOPS | Up to 1,000 MB/s | Cost-effective,
        customizable performance for a wide range of workloads. gp3 offers a more advanced and cost-effective version of gp2.
        You can provision IOPS and throughput independently of storage size. | | io1 | Up to 256K IOPS | Up to 1,000 MB/s |
        Mission-critical applications with high IOPS requirements. io1 provides provisioned IOPS, meaning you can define and
        guarantee IOPS performance levels independently of storage capacity. | | standard | Variable, low IOPS | Low and
        unpredictable | Low-cost, infrequent access, small databases, or test environments. Magnetic storage is the oldest and
        least performant storage option. It is mainly used for low-cost applications with low performance demands. | | aurora |
        Automatic scaling, up to 200K IOPS | Varies | High-performance, fault-tolerant, distributed storage for Amazon Aurora
        databases. Aurora uses a unique distributed, fault-tolerant storage system that automatically replicates data across
        multiple Availability Zones. | | aurora-iopt1 | Provisioned IOPS, similar to io1 | Varies | Aurora databases needing
        guaranteed, high-performance IOPS. Aurora I/O-Optimized storage offers provisioned IOPS for Aurora clusters that require
        consistently high performance for critical workloads. |
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="storeDetailsInSecretManager")
    def store_details_in_secret_manager(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to store RDS details in the AWS secrets manager.
        """
        return pulumi.get(self, "store_details_in_secret_manager")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the RDS instance will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> pulumi.Output[Optional['outputs.RdsInstanceV2ScalingConfiguration']]:
        """
        Serverless v2_scaling_configuration min and max scaling capacity. This configuration is only applicable for serverless
        instances
        """
        return pulumi.get(self, "v2_scaling_configuration")

