# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RdsReadReplicaArgs', 'RdsReadReplica']

@pulumi.input_type
class RdsReadReplicaArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str],
                 size: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[int]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']] = None,
                 v2_scaling_configuration: Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']] = None):
        """
        The set of arguments for constructing a RdsReadReplica resource.
        :param pulumi.Input[str] cluster_identifier: The full name of the RDS Cluster.
        :param pulumi.Input[str] size: The type of the RDS read replica.
               See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS read replica will be created in.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[int] engine_type: Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input['RdsReadReplicaPerformanceInsightsArgs'] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        :param pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs'] v2_scaling_configuration: Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if performance_insights is not None:
            pulumi.set(__self__, "performance_insights", performance_insights)
        if v2_scaling_configuration is not None:
            pulumi.set(__self__, "v2_scaling_configuration", v2_scaling_configuration)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        The full name of the RDS Cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The type of the RDS read replica.
        See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the RDS read replica will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[int]]:
        """
        Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[int]]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']]:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        """
        return pulumi.get(self, "performance_insights")

    @performance_insights.setter
    def performance_insights(self, value: Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']]):
        pulumi.set(self, "performance_insights", value)

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']]:
        """
        Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        return pulumi.get(self, "v2_scaling_configuration")

    @v2_scaling_configuration.setter
    def v2_scaling_configuration(self, value: Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']]):
        pulumi.set(self, "v2_scaling_configuration", value)


@pulumi.input_type
class _RdsReadReplicaState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 encrypt_storage: Optional[pulumi.Input[bool]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[int]] = None,
                 engine_type: Optional[pulumi.Input[int]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 replica_status: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering RdsReadReplica resources.
        :param pulumi.Input[str] arn: The ARN of the RDS read replica.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[str] cluster_identifier: The full name of the RDS Cluster.
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[str] endpoint: The endpoint of the RDS read replica.
        :param pulumi.Input[int] engine: The numerical index of database engine to be used the for the RDS read replica.
        :param pulumi.Input[int] engine_type: Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        :param pulumi.Input[str] engine_version: The database engine version to be used the for the RDS read replica.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[str] host: The DNS hostname of the RDS read replica.
        :param pulumi.Input[str] identifier: The full name of the RDS read replica.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input['RdsReadReplicaPerformanceInsightsArgs'] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        :param pulumi.Input[int] port: The listening port of the RDS read replica.
        :param pulumi.Input[str] replica_status: The current status of the RDS read replica.
        :param pulumi.Input[str] size: The type of the RDS read replica.
               See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS read replica will be created in.
        :param pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs'] v2_scaling_configuration: Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if encrypt_storage is not None:
            pulumi.set(__self__, "encrypt_storage", encrypt_storage)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enhanced_monitoring is not None:
            pulumi.set(__self__, "enhanced_monitoring", enhanced_monitoring)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if performance_insights is not None:
            pulumi.set(__self__, "performance_insights", performance_insights)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if replica_status is not None:
            pulumi.set(__self__, "replica_status", replica_status)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if v2_scaling_configuration is not None:
            pulumi.set(__self__, "v2_scaling_configuration", v2_scaling_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the RDS read replica.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the RDS Cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter group associated with this instance's DB Cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="encryptStorage")
    def encrypt_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to encrypt the RDS instance storage.
        """
        return pulumi.get(self, "encrypt_storage")

    @encrypt_storage.setter
    def encrypt_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_storage", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the RDS read replica.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[int]]:
        """
        The numerical index of database engine to be used the for the RDS read replica.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[int]]:
        """
        Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine version to be used the for the RDS read replica.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> Optional[pulumi.Input[int]]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @enhanced_monitoring.setter
    def enhanced_monitoring(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enhanced_monitoring", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS hostname of the RDS read replica.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the RDS read replica.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @parameter_group_name.setter
    def parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_group_name", value)

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']]:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        """
        return pulumi.get(self, "performance_insights")

    @performance_insights.setter
    def performance_insights(self, value: Optional[pulumi.Input['RdsReadReplicaPerformanceInsightsArgs']]):
        pulumi.set(self, "performance_insights", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The listening port of the RDS read replica.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="replicaStatus")
    def replica_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the RDS read replica.
        """
        return pulumi.get(self, "replica_status")

    @replica_status.setter
    def replica_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_status", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the RDS read replica.
        See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the RDS read replica will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']]:
        """
        Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        return pulumi.get(self, "v2_scaling_configuration")

    @v2_scaling_configuration.setter
    def v2_scaling_configuration(self, value: Optional[pulumi.Input['RdsReadReplicaV2ScalingConfigurationArgs']]):
        pulumi.set(self, "v2_scaling_configuration", value)


class RdsReadReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[int]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input[Union['RdsReadReplicaPerformanceInsightsArgs', 'RdsReadReplicaPerformanceInsightsArgsDict']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input[Union['RdsReadReplicaV2ScalingConfigurationArgs', 'RdsReadReplicaV2ScalingConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        `RdsReadReplica` manages an AWS RDS read replica in Duplo.

        ## Import

        Example: Importing an existing RDS read replica

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the database read replica (without the duplo prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/rdsReadReplica:RdsReadReplica read_replica v2/subscriptions/*TENANT_ID*/RDSDBInstance/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[str] cluster_identifier: The full name of the RDS Cluster.
        :param pulumi.Input[int] engine_type: Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input[Union['RdsReadReplicaPerformanceInsightsArgs', 'RdsReadReplicaPerformanceInsightsArgsDict']] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        :param pulumi.Input[str] size: The type of the RDS read replica.
               See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS read replica will be created in.
        :param pulumi.Input[Union['RdsReadReplicaV2ScalingConfigurationArgs', 'RdsReadReplicaV2ScalingConfigurationArgsDict']] v2_scaling_configuration: Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RdsReadReplicaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `RdsReadReplica` manages an AWS RDS read replica in Duplo.

        ## Import

        Example: Importing an existing RDS read replica

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the database read replica (without the duplo prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/rdsReadReplica:RdsReadReplica read_replica v2/subscriptions/*TENANT_ID*/RDSDBInstance/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param RdsReadReplicaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsReadReplicaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[int]] = None,
                 enhanced_monitoring: Optional[pulumi.Input[int]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_group_name: Optional[pulumi.Input[str]] = None,
                 performance_insights: Optional[pulumi.Input[Union['RdsReadReplicaPerformanceInsightsArgs', 'RdsReadReplicaPerformanceInsightsArgsDict']]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 v2_scaling_configuration: Optional[pulumi.Input[Union['RdsReadReplicaV2ScalingConfigurationArgs', 'RdsReadReplicaV2ScalingConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsReadReplicaArgs.__new__(RdsReadReplicaArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["engine_type"] = engine_type
            __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["name"] = name
            __props__.__dict__["parameter_group_name"] = parameter_group_name
            __props__.__dict__["performance_insights"] = performance_insights
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["v2_scaling_configuration"] = v2_scaling_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["cluster_parameter_group_name"] = None
            __props__.__dict__["enable_logging"] = None
            __props__.__dict__["encrypt_storage"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["replica_status"] = None
        super(RdsReadReplica, __self__).__init__(
            'duplocloud:index/rdsReadReplica:RdsReadReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
            enable_logging: Optional[pulumi.Input[bool]] = None,
            encrypt_storage: Optional[pulumi.Input[bool]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[int]] = None,
            engine_type: Optional[pulumi.Input[int]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enhanced_monitoring: Optional[pulumi.Input[int]] = None,
            host: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            multi_az: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameter_group_name: Optional[pulumi.Input[str]] = None,
            performance_insights: Optional[pulumi.Input[Union['RdsReadReplicaPerformanceInsightsArgs', 'RdsReadReplicaPerformanceInsightsArgsDict']]] = None,
            port: Optional[pulumi.Input[int]] = None,
            replica_status: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            v2_scaling_configuration: Optional[pulumi.Input[Union['RdsReadReplicaV2ScalingConfigurationArgs', 'RdsReadReplicaV2ScalingConfigurationArgsDict']]] = None) -> 'RdsReadReplica':
        """
        Get an existing RdsReadReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the RDS read replica.
        :param pulumi.Input[str] availability_zone: The AZ for the RDS instance.
        :param pulumi.Input[str] cluster_identifier: The full name of the RDS Cluster.
        :param pulumi.Input[str] cluster_parameter_group_name: Parameter group associated with this instance's DB Cluster.
        :param pulumi.Input[bool] enable_logging: Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        :param pulumi.Input[bool] encrypt_storage: Whether or not to encrypt the RDS instance storage.
        :param pulumi.Input[str] endpoint: The endpoint of the RDS read replica.
        :param pulumi.Input[int] engine: The numerical index of database engine to be used the for the RDS read replica.
        :param pulumi.Input[int] engine_type: Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        :param pulumi.Input[str] engine_version: The database engine version to be used the for the RDS read replica.
        :param pulumi.Input[int] enhanced_monitoring: Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        :param pulumi.Input[str] host: The DNS hostname of the RDS read replica.
        :param pulumi.Input[str] identifier: The full name of the RDS read replica.
        :param pulumi.Input[str] kms_key_id: The globally unique identifier for the key.
        :param pulumi.Input[bool] multi_az: Specifies if the RDS instance is multi-AZ.
        :param pulumi.Input[str] name: The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        :param pulumi.Input[str] parameter_group_name: A RDS parameter group name to apply to the RDS instance.
        :param pulumi.Input[Union['RdsReadReplicaPerformanceInsightsArgs', 'RdsReadReplicaPerformanceInsightsArgsDict']] performance_insights: Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        :param pulumi.Input[int] port: The listening port of the RDS read replica.
        :param pulumi.Input[str] replica_status: The current status of the RDS read replica.
        :param pulumi.Input[str] size: The type of the RDS read replica.
               See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the RDS read replica will be created in.
        :param pulumi.Input[Union['RdsReadReplicaV2ScalingConfigurationArgs', 'RdsReadReplicaV2ScalingConfigurationArgsDict']] v2_scaling_configuration: Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsReadReplicaState.__new__(_RdsReadReplicaState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["encrypt_storage"] = encrypt_storage
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enhanced_monitoring"] = enhanced_monitoring
        __props__.__dict__["host"] = host
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["multi_az"] = multi_az
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter_group_name"] = parameter_group_name
        __props__.__dict__["performance_insights"] = performance_insights
        __props__.__dict__["port"] = port
        __props__.__dict__["replica_status"] = replica_status
        __props__.__dict__["size"] = size
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["v2_scaling_configuration"] = v2_scaling_configuration
        return RdsReadReplica(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the RDS read replica.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The AZ for the RDS instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[str]:
        """
        The full name of the RDS Cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> pulumi.Output[str]:
        """
        Parameter group associated with this instance's DB Cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable the RDS instance logging. This setting is not applicable for document db cluster instance.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="encryptStorage")
    def encrypt_storage(self) -> pulumi.Output[bool]:
        """
        Whether or not to encrypt the RDS instance storage.
        """
        return pulumi.get(self, "encrypt_storage")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint of the RDS read replica.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[int]:
        """
        The numerical index of database engine to be used the for the RDS read replica.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[int]:
        """
        Engine type required to validate applicable parameter group setting for different instance. Should be referred from writer
        """
        return pulumi.get(self, "engine_type")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The database engine version to be used the for the RDS read replica.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enhancedMonitoring")
    def enhanced_monitoring(self) -> pulumi.Output[int]:
        """
        Interval to capture metrics in real time for the operating system (OS) that your Amazon RDS DB instance runs on.
        """
        return pulumi.get(self, "enhanced_monitoring")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The DNS hostname of the RDS read replica.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The full name of the RDS read replica.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the RDS instance is multi-AZ.
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the RDS read replica.  Duplo will add a prefix to the name.  You can retrieve the full name from the `identifier` attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        A RDS parameter group name to apply to the RDS instance.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter(name="performanceInsights")
    def performance_insights(self) -> pulumi.Output['outputs.RdsReadReplicaPerformanceInsights']:
        """
        Amazon RDS Performance Insights is a database performance tuning and monitoring feature that helps you quickly assess the load on your database, and determine when and where to take action. Perfomance Insights get apply when enable is set to true.
        """
        return pulumi.get(self, "performance_insights")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The listening port of the RDS read replica.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="replicaStatus")
    def replica_status(self) -> pulumi.Output[str]:
        """
        The current status of the RDS read replica.
        """
        return pulumi.get(self, "replica_status")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The type of the RDS read replica.
        See AWS documentation for the [available instance types](https://aws.amazon.com/rds/instance-types/).Size should be set as db.serverless if read replica instamce is created as serverless
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the RDS read replica will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="v2ScalingConfiguration")
    def v2_scaling_configuration(self) -> pulumi.Output[Optional['outputs.RdsReadReplicaV2ScalingConfiguration']]:
        """
        Serverless v2*scaling*configuration min and max scalling capacity. Required during creating a servless read replica.
        """
        return pulumi.get(self, "v2_scaling_configuration")

