# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['S3BucketArgs', 'S3Bucket']

@pulumi.input_type
class S3BucketArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 allow_public_access: Optional[pulumi.Input[bool]] = None,
                 default_encryption: Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 enable_versioning: Optional[pulumi.Input[bool]] = None,
                 managed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a S3Bucket resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket will be created in.
        :param pulumi.Input[bool] allow_public_access: Whether or not to remove the public access block from the bucket.
        :param pulumi.Input['S3BucketDefaultEncryptionArgs'] default_encryption: Default encryption settings for objects uploaded to the bucket.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        :param pulumi.Input[bool] enable_versioning: Whether or not to enable versioning.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policies: Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
               when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        :param pulumi.Input[str] name: The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] region: The region of the S3 bucket.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if allow_public_access is not None:
            pulumi.set(__self__, "allow_public_access", allow_public_access)
        if default_encryption is not None:
            pulumi.set(__self__, "default_encryption", default_encryption)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if enable_versioning is not None:
            pulumi.set(__self__, "enable_versioning", enable_versioning)
        if managed_policies is not None:
            pulumi.set(__self__, "managed_policies", managed_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the S3 bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="allowPublicAccess")
    def allow_public_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to remove the public access block from the bucket.
        """
        return pulumi.get(self, "allow_public_access")

    @allow_public_access.setter
    def allow_public_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_public_access", value)

    @property
    @pulumi.getter(name="defaultEncryption")
    def default_encryption(self) -> Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']]:
        """
        Default encryption settings for objects uploaded to the bucket.
        """
        return pulumi.get(self, "default_encryption")

    @default_encryption.setter
    def default_encryption(self, value: Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']]):
        pulumi.set(self, "default_encryption", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter(name="enableVersioning")
    def enable_versioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable versioning.
        """
        return pulumi.get(self, "enable_versioning")

    @enable_versioning.setter
    def enable_versioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_versioning", value)

    @property
    @pulumi.getter(name="managedPolicies")
    def managed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
        when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        """
        return pulumi.get(self, "managed_policies")

    @managed_policies.setter
    def managed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "managed_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the S3 bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _S3BucketState:
    def __init__(__self__, *,
                 allow_public_access: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 default_encryption: Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 enable_versioning: Optional[pulumi.Input[bool]] = None,
                 fullname: Optional[pulumi.Input[str]] = None,
                 managed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering S3Bucket resources.
        :param pulumi.Input[bool] allow_public_access: Whether or not to remove the public access block from the bucket.
        :param pulumi.Input[str] arn: The ARN of the S3 bucket.
        :param pulumi.Input['S3BucketDefaultEncryptionArgs'] default_encryption: Default encryption settings for objects uploaded to the bucket.
        :param pulumi.Input[str] domain_name: The domain name of the S3 bucket.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        :param pulumi.Input[bool] enable_versioning: Whether or not to enable versioning.
        :param pulumi.Input[str] fullname: The full name of the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policies: Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
               when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        :param pulumi.Input[str] name: The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] region: The region of the S3 bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket will be created in.
        """
        if allow_public_access is not None:
            pulumi.set(__self__, "allow_public_access", allow_public_access)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if default_encryption is not None:
            pulumi.set(__self__, "default_encryption", default_encryption)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if enable_access_logs is not None:
            pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if enable_versioning is not None:
            pulumi.set(__self__, "enable_versioning", enable_versioning)
        if fullname is not None:
            pulumi.set(__self__, "fullname", fullname)
        if managed_policies is not None:
            pulumi.set(__self__, "managed_policies", managed_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="allowPublicAccess")
    def allow_public_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to remove the public access block from the bucket.
        """
        return pulumi.get(self, "allow_public_access")

    @allow_public_access.setter
    def allow_public_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_public_access", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the S3 bucket.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="defaultEncryption")
    def default_encryption(self) -> Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']]:
        """
        Default encryption settings for objects uploaded to the bucket.
        """
        return pulumi.get(self, "default_encryption")

    @default_encryption.setter
    def default_encryption(self, value: Optional[pulumi.Input['S3BucketDefaultEncryptionArgs']]):
        pulumi.set(self, "default_encryption", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the S3 bucket.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        """
        return pulumi.get(self, "enable_access_logs")

    @enable_access_logs.setter
    def enable_access_logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logs", value)

    @property
    @pulumi.getter(name="enableVersioning")
    def enable_versioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable versioning.
        """
        return pulumi.get(self, "enable_versioning")

    @enable_versioning.setter
    def enable_versioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_versioning", value)

    @property
    @pulumi.getter
    def fullname(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the S3 bucket.
        """
        return pulumi.get(self, "fullname")

    @fullname.setter
    def fullname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fullname", value)

    @property
    @pulumi.getter(name="managedPolicies")
    def managed_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
        when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        """
        return pulumi.get(self, "managed_policies")

    @managed_policies.setter
    def managed_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "managed_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the S3 bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the S3 bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class S3Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_public_access: Optional[pulumi.Input[bool]] = None,
                 default_encryption: Optional[pulumi.Input[Union['S3BucketDefaultEncryptionArgs', 'S3BucketDefaultEncryptionArgsDict']]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 enable_versioning: Optional[pulumi.Input[bool]] = None,
                 managed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Create a S3 bucket named static_assets

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a tenant, you must first set up the infrastructure. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=False,
            address_prefix="10.11.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="prod",
            plan_id=infra.infra_name)
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the S3 bucket.
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.tenant_id,
            name="static_assets",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Provision an S3 bucket within the dev tenant

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the s3 bucket.
        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket in the dev tenant, with public access enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the s3 bucket.
        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=True,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket in the dev tenant within DuploCloud, with versioning disabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Setup an S3 bucket in the qa tenant, with access logs disabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="qa")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=False,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Configure an S3 bucket in the QA tenant, enabling public access while disabling versioning and access logs

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="qa")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=True,
            enable_access_logs=False,
            enable_versioning=False,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket named data in the preprod tenant, with tenant kms enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="preprod")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="data",
            allow_public_access=False,
            enable_access_logs=False,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "TenantKms",
            })
        ```

        ### Deploy an S3 bucket with hardened security settings

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="test")
        mydata = duplocloud.S3Bucket("mydata",
            tenant_id=tenant.id,
            name="mydata",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Deploy a hardened S3 bucket suitable for public website hosting in test tenant

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="test")
        www = duplocloud.S3Bucket("www",
            tenant_id=tenant.id,
            name="website",
            allow_public_access=True,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Deploy an S3 bucket to us-east-1 region

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'test' tenant is already created before creating the s3 bucket.
        tenant = duplocloud.get_tenant(name="test")
        static_assets = duplocloud.S3Bucket("static_assets",
            tenant_id=tenant.id,
            name="static_assets",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            },
            region="us-east-1")
        ```

        ## Import

        Example: Importing an existing S3 bucket

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the S3 bucket (without the duploservices prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/s3Bucket:S3Bucket mybucket *TENANT_ID*/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_public_access: Whether or not to remove the public access block from the bucket.
        :param pulumi.Input[Union['S3BucketDefaultEncryptionArgs', 'S3BucketDefaultEncryptionArgsDict']] default_encryption: Default encryption settings for objects uploaded to the bucket.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        :param pulumi.Input[bool] enable_versioning: Whether or not to enable versioning.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policies: Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
               when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        :param pulumi.Input[str] name: The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] region: The region of the S3 bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: S3BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Create a S3 bucket named static_assets

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Before creating a tenant, you must first set up the infrastructure. Below is the resource for creating the infrastructure.
        infra = duplocloud.Infrastructure("infra",
            infra_name="prod",
            cloud=0,
            region="us-west-2",
            enable_k8_cluster=False,
            address_prefix="10.11.0.0/16")
        # Use the infrastructure name as the 'plan_id' from the 'duplocloud_infrastructure' resource while creating tenant.
        tenant = duplocloud.Tenant("tenant",
            account_name="prod",
            plan_id=infra.infra_name)
        # Use the tenant_id from the duplocloud_tenant, which will be populated after the tenant resource is created, when setting up the S3 bucket.
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.tenant_id,
            name="static_assets",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Provision an S3 bucket within the dev tenant

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the s3 bucket.
        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket in the dev tenant, with public access enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'dev' tenant is already created before setting up the s3 bucket.
        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=True,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket in the dev tenant within DuploCloud, with versioning disabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="dev")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Setup an S3 bucket in the qa tenant, with access logs disabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="qa")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=False,
            enable_access_logs=False,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Configure an S3 bucket in the QA tenant, enabling public access while disabling versioning and access logs

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="qa")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="bucket",
            allow_public_access=True,
            enable_access_logs=False,
            enable_versioning=False,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Create an S3 bucket named data in the preprod tenant, with tenant kms enabled

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="preprod")
        bucket = duplocloud.S3Bucket("bucket",
            tenant_id=tenant.id,
            name="data",
            allow_public_access=False,
            enable_access_logs=False,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "TenantKms",
            })
        ```

        ### Deploy an S3 bucket with hardened security settings

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="test")
        mydata = duplocloud.S3Bucket("mydata",
            tenant_id=tenant.id,
            name="mydata",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Deploy a hardened S3 bucket suitable for public website hosting in test tenant

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        tenant = duplocloud.get_tenant(name="test")
        www = duplocloud.S3Bucket("www",
            tenant_id=tenant.id,
            name="website",
            allow_public_access=True,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            })
        ```

        ### Deploy an S3 bucket to us-east-1 region

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        # Ensure the 'test' tenant is already created before creating the s3 bucket.
        tenant = duplocloud.get_tenant(name="test")
        static_assets = duplocloud.S3Bucket("static_assets",
            tenant_id=tenant.id,
            name="static_assets",
            allow_public_access=False,
            enable_access_logs=True,
            enable_versioning=True,
            managed_policies=["ssl"],
            default_encryption={
                "method": "Sse",
            },
            region="us-east-1")
        ```

        ## Import

        Example: Importing an existing S3 bucket

         - *TENANT_ID* is the tenant GUID

         - *SHORTNAME* is the short name of the S3 bucket (without the duploservices prefix)

        # 

        ```sh
        $ pulumi import duplocloud:index/s3Bucket:S3Bucket mybucket *TENANT_ID*/*SHORTNAME*
        ```

        :param str resource_name: The name of the resource.
        :param S3BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(S3BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_public_access: Optional[pulumi.Input[bool]] = None,
                 default_encryption: Optional[pulumi.Input[Union['S3BucketDefaultEncryptionArgs', 'S3BucketDefaultEncryptionArgsDict']]] = None,
                 enable_access_logs: Optional[pulumi.Input[bool]] = None,
                 enable_versioning: Optional[pulumi.Input[bool]] = None,
                 managed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = S3BucketArgs.__new__(S3BucketArgs)

            __props__.__dict__["allow_public_access"] = allow_public_access
            __props__.__dict__["default_encryption"] = default_encryption
            __props__.__dict__["enable_access_logs"] = enable_access_logs
            __props__.__dict__["enable_versioning"] = enable_versioning
            __props__.__dict__["managed_policies"] = managed_policies
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["fullname"] = None
            __props__.__dict__["tags"] = None
        super(S3Bucket, __self__).__init__(
            'duplocloud:index/s3Bucket:S3Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_public_access: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            default_encryption: Optional[pulumi.Input[Union['S3BucketDefaultEncryptionArgs', 'S3BucketDefaultEncryptionArgsDict']]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            enable_access_logs: Optional[pulumi.Input[bool]] = None,
            enable_versioning: Optional[pulumi.Input[bool]] = None,
            fullname: Optional[pulumi.Input[str]] = None,
            managed_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['S3BucketTagArgs', 'S3BucketTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'S3Bucket':
        """
        Get an existing S3Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_public_access: Whether or not to remove the public access block from the bucket.
        :param pulumi.Input[str] arn: The ARN of the S3 bucket.
        :param pulumi.Input[Union['S3BucketDefaultEncryptionArgs', 'S3BucketDefaultEncryptionArgsDict']] default_encryption: Default encryption settings for objects uploaded to the bucket.
        :param pulumi.Input[str] domain_name: The domain name of the S3 bucket.
        :param pulumi.Input[bool] enable_access_logs: Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        :param pulumi.Input[bool] enable_versioning: Whether or not to enable versioning.
        :param pulumi.Input[str] fullname: The full name of the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_policies: Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
               when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        :param pulumi.Input[str] name: The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
               attribute.
        :param pulumi.Input[str] region: The region of the S3 bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _S3BucketState.__new__(_S3BucketState)

        __props__.__dict__["allow_public_access"] = allow_public_access
        __props__.__dict__["arn"] = arn
        __props__.__dict__["default_encryption"] = default_encryption
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["enable_access_logs"] = enable_access_logs
        __props__.__dict__["enable_versioning"] = enable_versioning
        __props__.__dict__["fullname"] = fullname
        __props__.__dict__["managed_policies"] = managed_policies
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return S3Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowPublicAccess")
    def allow_public_access(self) -> pulumi.Output[bool]:
        """
        Whether or not to remove the public access block from the bucket.
        """
        return pulumi.get(self, "allow_public_access")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the S3 bucket.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultEncryption")
    def default_encryption(self) -> pulumi.Output['outputs.S3BucketDefaultEncryption']:
        """
        Default encryption settings for objects uploaded to the bucket.
        """
        return pulumi.get(self, "default_encryption")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The domain name of the S3 bucket.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable access logs. When enabled, Duplo will send access logs to a centralized S3 bucket per plan.
        """
        return pulumi.get(self, "enable_access_logs")

    @property
    @pulumi.getter(name="enableVersioning")
    def enable_versioning(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable versioning.
        """
        return pulumi.get(self, "enable_versioning")

    @property
    @pulumi.getter
    def fullname(self) -> pulumi.Output[str]:
        """
        The full name of the S3 bucket.
        """
        return pulumi.get(self, "fullname")

    @property
    @pulumi.getter(name="managedPolicies")
    def managed_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        Duplo can manage your S3 bucket policy for you, based on simple list of policy keywords: - `"ssl"`: Require SSL / HTTPS
        when accessing the bucket. - `"ignore"`: If this value is present, Duplo will not manage your bucket policy.
        """
        return pulumi.get(self, "managed_policies")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The short name of the S3 bucket. Duplo will add a prefix to the name. You can retrieve the full name from the `fullname`
        attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region of the S3 bucket.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.S3BucketTag']]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the S3 bucket will be created in.
        """
        return pulumi.get(self, "tenant_id")

