# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['S3BucketReplicationArgs', 'S3BucketReplication']

@pulumi.input_type
class S3BucketReplicationArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]],
                 source_bucket: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a S3BucketReplication resource.
        :param pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]] rules: replication rules for source bucket
        :param pulumi.Input[str] source_bucket: fullname of the source bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "source_bucket", source_bucket)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]]:
        """
        replication rules for source bucket
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceBucket")
    def source_bucket(self) -> pulumi.Input[str]:
        """
        fullname of the source bucket.
        """
        return pulumi.get(self, "source_bucket")

    @source_bucket.setter
    def source_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_bucket", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _S3BucketReplicationState:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]]] = None,
                 source_bucket: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering S3BucketReplication resources.
        :param pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]] rules: replication rules for source bucket
        :param pulumi.Input[str] source_bucket: fullname of the source bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_bucket is not None:
            pulumi.set(__self__, "source_bucket", source_bucket)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]]]:
        """
        replication rules for source bucket
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3BucketReplicationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceBucket")
    def source_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        fullname of the source bucket.
        """
        return pulumi.get(self, "source_bucket")

    @source_bucket.setter
    def source_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_bucket", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class S3BucketReplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['S3BucketReplicationRuleArgs', 'S3BucketReplicationRuleArgsDict']]]]] = None,
                 source_bucket: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource S3BucketReplication is dependent on duplocloud_s3_bucket. This resource sets replication rules for source bucket

        ## Import

        Example: Importing an existing S3 bucket replication

         - *TENANT_ID* is the tenant GUID

         - *SOURCEBUCKETNAME* is the full name of the S3 bucket

        # 

        ```sh
        $ pulumi import duplocloud:index/s3BucketReplication:S3BucketReplication mybucket *TENANT_ID*/*SOURCEBUCKETNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['S3BucketReplicationRuleArgs', 'S3BucketReplicationRuleArgsDict']]]] rules: replication rules for source bucket
        :param pulumi.Input[str] source_bucket: fullname of the source bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: S3BucketReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource S3BucketReplication is dependent on duplocloud_s3_bucket. This resource sets replication rules for source bucket

        ## Import

        Example: Importing an existing S3 bucket replication

         - *TENANT_ID* is the tenant GUID

         - *SOURCEBUCKETNAME* is the full name of the S3 bucket

        # 

        ```sh
        $ pulumi import duplocloud:index/s3BucketReplication:S3BucketReplication mybucket *TENANT_ID*/*SOURCEBUCKETNAME*
        ```

        :param str resource_name: The name of the resource.
        :param S3BucketReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(S3BucketReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['S3BucketReplicationRuleArgs', 'S3BucketReplicationRuleArgsDict']]]]] = None,
                 source_bucket: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = S3BucketReplicationArgs.__new__(S3BucketReplicationArgs)

            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if source_bucket is None and not opts.urn:
                raise TypeError("Missing required property 'source_bucket'")
            __props__.__dict__["source_bucket"] = source_bucket
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(S3BucketReplication, __self__).__init__(
            'duplocloud:index/s3BucketReplication:S3BucketReplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['S3BucketReplicationRuleArgs', 'S3BucketReplicationRuleArgsDict']]]]] = None,
            source_bucket: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'S3BucketReplication':
        """
        Get an existing S3BucketReplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['S3BucketReplicationRuleArgs', 'S3BucketReplicationRuleArgsDict']]]] rules: replication rules for source bucket
        :param pulumi.Input[str] source_bucket: fullname of the source bucket.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _S3BucketReplicationState.__new__(_S3BucketReplicationState)

        __props__.__dict__["rules"] = rules
        __props__.__dict__["source_bucket"] = source_bucket
        __props__.__dict__["tenant_id"] = tenant_id
        return S3BucketReplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.S3BucketReplicationRule']]:
        """
        replication rules for source bucket
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sourceBucket")
    def source_bucket(self) -> pulumi.Output[str]:
        """
        fullname of the source bucket.
        """
        return pulumi.get(self, "source_bucket")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the S3 bucket replication rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

