# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TenantCleanupTimersArgs', 'TenantCleanupTimers']

@pulumi.input_type
class TenantCleanupTimersArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 pause_time: Optional[pulumi.Input[str]] = None,
                 remove_expiry_time: Optional[pulumi.Input[bool]] = None,
                 remove_pause_time: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a TenantCleanupTimers resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the expiry will be created in.
        :param pulumi.Input[str] expiry_time: The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[str] pause_time: The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[bool] remove_expiry_time: Whether to remove the expiry time.
        :param pulumi.Input[bool] remove_pause_time: Whether to remove the pause time.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if pause_time is not None:
            pulumi.set(__self__, "pause_time", pause_time)
        if remove_expiry_time is not None:
            pulumi.set(__self__, "remove_expiry_time", remove_expiry_time)
        if remove_pause_time is not None:
            pulumi.set(__self__, "remove_pause_time", remove_pause_time)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the expiry will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="pauseTime")
    def pause_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "pause_time")

    @pause_time.setter
    def pause_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pause_time", value)

    @property
    @pulumi.getter(name="removeExpiryTime")
    def remove_expiry_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to remove the expiry time.
        """
        return pulumi.get(self, "remove_expiry_time")

    @remove_expiry_time.setter
    def remove_expiry_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_expiry_time", value)

    @property
    @pulumi.getter(name="removePauseTime")
    def remove_pause_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to remove the pause time.
        """
        return pulumi.get(self, "remove_pause_time")

    @remove_pause_time.setter
    def remove_pause_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_pause_time", value)


@pulumi.input_type
class _TenantCleanupTimersState:
    def __init__(__self__, *,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 pause_time: Optional[pulumi.Input[str]] = None,
                 remove_expiry_time: Optional[pulumi.Input[bool]] = None,
                 remove_pause_time: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TenantCleanupTimers resources.
        :param pulumi.Input[str] expiry_time: The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[str] pause_time: The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[bool] remove_expiry_time: Whether to remove the expiry time.
        :param pulumi.Input[bool] remove_pause_time: Whether to remove the pause time.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the expiry will be created in.
        """
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if pause_time is not None:
            pulumi.set(__self__, "pause_time", pause_time)
        if remove_expiry_time is not None:
            pulumi.set(__self__, "remove_expiry_time", remove_expiry_time)
        if remove_pause_time is not None:
            pulumi.set(__self__, "remove_pause_time", remove_pause_time)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="pauseTime")
    def pause_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "pause_time")

    @pause_time.setter
    def pause_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pause_time", value)

    @property
    @pulumi.getter(name="removeExpiryTime")
    def remove_expiry_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to remove the expiry time.
        """
        return pulumi.get(self, "remove_expiry_time")

    @remove_expiry_time.setter
    def remove_expiry_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_expiry_time", value)

    @property
    @pulumi.getter(name="removePauseTime")
    def remove_pause_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to remove the pause time.
        """
        return pulumi.get(self, "remove_pause_time")

    @remove_pause_time.setter
    def remove_pause_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_pause_time", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the expiry will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class TenantCleanupTimers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 pause_time: Optional[pulumi.Input[str]] = None,
                 remove_expiry_time: Optional[pulumi.Input[bool]] = None,
                 remove_pause_time: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage tenant expiry in DuploCloud

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantCleanupTimers:TenantCleanupTimers mytimers *TENANT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expiry_time: The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[str] pause_time: The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[bool] remove_expiry_time: Whether to remove the expiry time.
        :param pulumi.Input[bool] remove_pause_time: Whether to remove the pause time.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the expiry will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantCleanupTimersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage tenant expiry in DuploCloud

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantCleanupTimers:TenantCleanupTimers mytimers *TENANT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param TenantCleanupTimersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantCleanupTimersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 pause_time: Optional[pulumi.Input[str]] = None,
                 remove_expiry_time: Optional[pulumi.Input[bool]] = None,
                 remove_pause_time: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantCleanupTimersArgs.__new__(TenantCleanupTimersArgs)

            __props__.__dict__["expiry_time"] = expiry_time
            __props__.__dict__["pause_time"] = pause_time
            __props__.__dict__["remove_expiry_time"] = remove_expiry_time
            __props__.__dict__["remove_pause_time"] = remove_pause_time
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(TenantCleanupTimers, __self__).__init__(
            'duplocloud:index/tenantCleanupTimers:TenantCleanupTimers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiry_time: Optional[pulumi.Input[str]] = None,
            pause_time: Optional[pulumi.Input[str]] = None,
            remove_expiry_time: Optional[pulumi.Input[bool]] = None,
            remove_pause_time: Optional[pulumi.Input[bool]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'TenantCleanupTimers':
        """
        Get an existing TenantCleanupTimers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expiry_time: The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[str] pause_time: The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        :param pulumi.Input[bool] remove_expiry_time: Whether to remove the expiry time.
        :param pulumi.Input[bool] remove_pause_time: Whether to remove the pause time.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the expiry will be created in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantCleanupTimersState.__new__(_TenantCleanupTimersState)

        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["pause_time"] = pause_time
        __props__.__dict__["remove_expiry_time"] = remove_expiry_time
        __props__.__dict__["remove_pause_time"] = remove_pause_time
        __props__.__dict__["tenant_id"] = tenant_id
        return TenantCleanupTimers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[Optional[str]]:
        """
        The expiry time of the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter(name="pauseTime")
    def pause_time(self) -> pulumi.Output[Optional[str]]:
        """
        The time to pause the tenant, in UTC with the format YYYY-MM-DDTHH:MM:SSZ (e.g. `2021-06-01T00:00:00Z`)
        """
        return pulumi.get(self, "pause_time")

    @property
    @pulumi.getter(name="removeExpiryTime")
    def remove_expiry_time(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to remove the expiry time.
        """
        return pulumi.get(self, "remove_expiry_time")

    @property
    @pulumi.getter(name="removePauseTime")
    def remove_pause_time(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to remove the pause time.
        """
        return pulumi.get(self, "remove_pause_time")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the expiry will be created in.
        """
        return pulumi.get(self, "tenant_id")

