# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TenantConfigArgs', 'TenantConfig']

@pulumi.input_type
class TenantConfigArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]] = None):
        """
        The set of arguments for constructing a TenantConfig resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant to configure.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant to configure.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _TenantConfigState:
    def __init__(__self__, *,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigMetadataArgs']]]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]] = None,
                 specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TenantConfig resources.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TenantConfigMetadataArgs']]] metadatas: A complete list of configuration settings for this tenant, even ones not being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant to configure.
        """
        if delete_unspecified_settings is not None:
            pulumi.set(__self__, "delete_unspecified_settings", delete_unspecified_settings)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if specified_settings is not None:
            pulumi.set(__self__, "specified_settings", specified_settings)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @delete_unspecified_settings.setter
    def delete_unspecified_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_unspecified_settings", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigMetadataArgs']]]]:
        """
        A complete list of configuration settings for this tenant, even ones not being managed by this resource.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TenantConfigSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

    @specified_settings.setter
    def specified_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "specified_settings", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant to configure.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class TenantConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigSettingArgs', 'TenantConfigSettingArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `TenantConfig` manages a tenant's configuration in Duplo.

        Tenant configuration is initially populated by Duplo when a tenant is created.  This resource allows you take control of individual configuration settings for a specific tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_tenant_config = duplocloud.TenantConfig("myapp",
            tenant_id=myapp.tenant_id,
            settings=[
                {
                    "key": "block_public_access_to_s3",
                    "value": "true",
                },
                {
                    "key": "enforce_ssl_for_s3",
                    "value": "true",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantConfig:TenantConfig myapp TENANT_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigSettingArgs', 'TenantConfigSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant to configure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `TenantConfig` manages a tenant's configuration in Duplo.

        Tenant configuration is initially populated by Duplo when a tenant is created.  This resource allows you take control of individual configuration settings for a specific tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        myapp_tenant_config = duplocloud.TenantConfig("myapp",
            tenant_id=myapp.tenant_id,
            settings=[
                {
                    "key": "block_public_access_to_s3",
                    "value": "true",
                },
                {
                    "key": "enforce_ssl_for_s3",
                    "value": "true",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantConfig:TenantConfig myapp TENANT_ID
        ```

        :param str resource_name: The name of the resource.
        :param TenantConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigSettingArgs', 'TenantConfigSettingArgsDict']]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantConfigArgs.__new__(TenantConfigArgs)

            __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
            __props__.__dict__["settings"] = settings
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["specified_settings"] = None
        super(TenantConfig, __self__).__init__(
            'duplocloud:index/tenantConfig:TenantConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_unspecified_settings: Optional[pulumi.Input[bool]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigMetadataArgs', 'TenantConfigMetadataArgsDict']]]]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigSettingArgs', 'TenantConfigSettingArgsDict']]]]] = None,
            specified_settings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'TenantConfig':
        """
        Get an existing TenantConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_unspecified_settings: Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigMetadataArgs', 'TenantConfigMetadataArgsDict']]]] metadatas: A complete list of configuration settings for this tenant, even ones not being managed by this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TenantConfigSettingArgs', 'TenantConfigSettingArgsDict']]]] settings: A list of configuration settings to manage, expressed as key / value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] specified_settings: A list of configuration setting key being managed by this resource.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant to configure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantConfigState.__new__(_TenantConfigState)

        __props__.__dict__["delete_unspecified_settings"] = delete_unspecified_settings
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["settings"] = settings
        __props__.__dict__["specified_settings"] = specified_settings
        __props__.__dict__["tenant_id"] = tenant_id
        return TenantConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteUnspecifiedSettings")
    def delete_unspecified_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this resource should delete any settings not specified by this resource. **WARNING:**  It is not recommended to change the default value of `false`. Defaults to `false`.
        """
        return pulumi.get(self, "delete_unspecified_settings")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.TenantConfigMetadata']]:
        """
        A complete list of configuration settings for this tenant, even ones not being managed by this resource.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Sequence['outputs.TenantConfigSetting']]]:
        """
        A list of configuration settings to manage, expressed as key / value pairs.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="specifiedSettings")
    def specified_settings(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of configuration setting key being managed by this resource.
        """
        return pulumi.get(self, "specified_settings")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant to configure.
        """
        return pulumi.get(self, "tenant_id")

