# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TenantNetworkSecurityRuleArgs', 'TenantNetworkSecurityRule']

@pulumi.input_type
class TenantNetworkSecurityRuleArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 from_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_tenant: Optional[pulumi.Input[str]] = None,
                 to_port: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a TenantNetworkSecurityRule resource.
        :param pulumi.Input[str] description: A description for this rule.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the network security rule will be created in.
        :param pulumi.Input[int] from_port: The start of a port range to allow traffic to. Defaults to `0`.
        :param pulumi.Input[str] protocol: The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        :param pulumi.Input[str] source_address: The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] source_tenant: The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[int] to_port: The end of a port range to allow traffic to. Defaults to `65535`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if source_tenant is not None:
            pulumi.set(__self__, "source_tenant", source_tenant)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A description for this rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the network security rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[int]]:
        """
        The start of a port range to allow traffic to. Defaults to `0`.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[pulumi.Input[str]]:
        """
        The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_address")

    @source_address.setter
    def source_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address", value)

    @property
    @pulumi.getter(name="sourceTenant")
    def source_tenant(self) -> Optional[pulumi.Input[str]]:
        """
        The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_tenant")

    @source_tenant.setter
    def source_tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_tenant", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[int]]:
        """
        The end of a port range to allow traffic to. Defaults to `65535`.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class _TenantNetworkSecurityRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 from_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_tenant: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 to_port: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering TenantNetworkSecurityRule resources.
        :param pulumi.Input[str] description: A description for this rule.
        :param pulumi.Input[int] from_port: The start of a port range to allow traffic to. Defaults to `0`.
        :param pulumi.Input[str] protocol: The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        :param pulumi.Input[str] source_address: The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] source_tenant: The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the network security rule will be created in.
        :param pulumi.Input[int] to_port: The end of a port range to allow traffic to. Defaults to `65535`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address is not None:
            pulumi.set(__self__, "source_address", source_address)
        if source_tenant is not None:
            pulumi.set(__self__, "source_tenant", source_tenant)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for this rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[int]]:
        """
        The start of a port range to allow traffic to. Defaults to `0`.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> Optional[pulumi.Input[str]]:
        """
        The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_address")

    @source_address.setter
    def source_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address", value)

    @property
    @pulumi.getter(name="sourceTenant")
    def source_tenant(self) -> Optional[pulumi.Input[str]]:
        """
        The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_tenant")

    @source_tenant.setter
    def source_tenant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_tenant", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the network security rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[int]]:
        """
        The end of a port range to allow traffic to. Defaults to `65535`.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "to_port", value)


class TenantNetworkSecurityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 from_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_tenant: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 to_port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        `TenantNetworkSecurityRule` manages a single network single rule for a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Allow the "default" tenant to send HTTPS requests to "myapp"
        myrule = duplocloud.TenantNetworkSecurityRule("myrule",
            tenant_id=myapp.tenant_id,
            source_tenant="default",
            protocol="tcp",
            from_port=443,
            to_port=443,
            description="Allow the default tenant to send HTTPS traffic")
        ```

        ## Import

        Example 1: Importing a "source_tenant" rule:

         - TENANT_ID is the target tenant GUID

         - 0 is the rule type

         - SOURCE_TENANT is the source tenant NAME

        ```sh
        $ pulumi import duplocloud:index/tenantNetworkSecurityRule:TenantNetworkSecurityRule myrule TENANT_ID/0/SOURCE_TENANT/PROTOCOL/FROM_PORT/TO_PORT
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for this rule.
        :param pulumi.Input[int] from_port: The start of a port range to allow traffic to. Defaults to `0`.
        :param pulumi.Input[str] protocol: The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        :param pulumi.Input[str] source_address: The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] source_tenant: The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the network security rule will be created in.
        :param pulumi.Input[int] to_port: The end of a port range to allow traffic to. Defaults to `65535`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantNetworkSecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `TenantNetworkSecurityRule` manages a single network single rule for a Duplo tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Allow the "default" tenant to send HTTPS requests to "myapp"
        myrule = duplocloud.TenantNetworkSecurityRule("myrule",
            tenant_id=myapp.tenant_id,
            source_tenant="default",
            protocol="tcp",
            from_port=443,
            to_port=443,
            description="Allow the default tenant to send HTTPS traffic")
        ```

        ## Import

        Example 1: Importing a "source_tenant" rule:

         - TENANT_ID is the target tenant GUID

         - 0 is the rule type

         - SOURCE_TENANT is the source tenant NAME

        ```sh
        $ pulumi import duplocloud:index/tenantNetworkSecurityRule:TenantNetworkSecurityRule myrule TENANT_ID/0/SOURCE_TENANT/PROTOCOL/FROM_PORT/TO_PORT
        ```

        :param str resource_name: The name of the resource.
        :param TenantNetworkSecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantNetworkSecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 from_port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address: Optional[pulumi.Input[str]] = None,
                 source_tenant: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 to_port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantNetworkSecurityRuleArgs.__new__(TenantNetworkSecurityRuleArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["from_port"] = from_port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["source_address"] = source_address
            __props__.__dict__["source_tenant"] = source_tenant
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["to_port"] = to_port
        super(TenantNetworkSecurityRule, __self__).__init__(
            'duplocloud:index/tenantNetworkSecurityRule:TenantNetworkSecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            from_port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            source_address: Optional[pulumi.Input[str]] = None,
            source_tenant: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            to_port: Optional[pulumi.Input[int]] = None) -> 'TenantNetworkSecurityRule':
        """
        Get an existing TenantNetworkSecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for this rule.
        :param pulumi.Input[int] from_port: The start of a port range to allow traffic to. Defaults to `0`.
        :param pulumi.Input[str] protocol: The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        :param pulumi.Input[str] source_address: The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] source_tenant: The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the network security rule will be created in.
        :param pulumi.Input[int] to_port: The end of a port range to allow traffic to. Defaults to `65535`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantNetworkSecurityRuleState.__new__(_TenantNetworkSecurityRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["from_port"] = from_port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source_address"] = source_address
        __props__.__dict__["source_tenant"] = source_tenant
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["to_port"] = to_port
        return TenantNetworkSecurityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description for this rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Output[Optional[int]]:
        """
        The start of a port range to allow traffic to. Defaults to `0`.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The network protocol.  Must be one of:  `tcp`, `udp`, `icmp` Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAddress")
    def source_address(self) -> pulumi.Output[Optional[str]]:
        """
        The source CIDR block to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_address")

    @property
    @pulumi.getter(name="sourceTenant")
    def source_tenant(self) -> pulumi.Output[Optional[str]]:
        """
        The source tenant name (*not* GUID) to allow traffic from. Only one of `source_tenant` or `source_address` may be specified.
        """
        return pulumi.get(self, "source_tenant")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the network security rule will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Output[Optional[int]]:
        """
        The end of a port range to allow traffic to. Defaults to `65535`.
        """
        return pulumi.get(self, "to_port")

