# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TenantSecretArgs', 'TenantSecret']

@pulumi.input_type
class TenantSecretArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[str],
                 name_suffix: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a TenantSecret resource.
        :param pulumi.Input[str] data: The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        :param pulumi.Input[str] name_suffix: The short name of the secret. You can get the fullname from the `name` attribute after creation.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "name_suffix", name_suffix)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Input[str]:
        """
        The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[str]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="nameSuffix")
    def name_suffix(self) -> pulumi.Input[str]:
        """
        The short name of the secret. You can get the fullname from the `name` attribute after creation.
        """
        return pulumi.get(self, "name_suffix")

    @name_suffix.setter
    def name_suffix(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_suffix", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _TenantSecretState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_suffix: Optional[pulumi.Input[str]] = None,
                 rotation_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['TenantSecretTagArgs']]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TenantSecret resources.
        :param pulumi.Input[str] arn: The ARN of the created secret.
        :param pulumi.Input[str] data: The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        :param pulumi.Input[str] name: The full name of the secret.
        :param pulumi.Input[str] name_suffix: The short name of the secret. You can get the fullname from the `name` attribute after creation.
        :param pulumi.Input[bool] rotation_enabled: Whether or not rotation is enabled for this secret.
        :param pulumi.Input[Sequence[pulumi.Input['TenantSecretTagArgs']]] tags: A list of tags for this secret.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        :param pulumi.Input[str] version_id: The version ID of the secret.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_suffix is not None:
            pulumi.set(__self__, "name_suffix", name_suffix)
        if rotation_enabled is not None:
            pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the created secret.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameSuffix")
    def name_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The short name of the secret. You can get the fullname from the `name` attribute after creation.
        """
        return pulumi.get(self, "name_suffix")

    @name_suffix.setter
    def name_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_suffix", value)

    @property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not rotation is enabled for this secret.
        """
        return pulumi.get(self, "rotation_enabled")

    @rotation_enabled.setter
    def rotation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rotation_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TenantSecretTagArgs']]]]:
        """
        A list of tags for this secret.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TenantSecretTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The version ID of the secret.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class TenantSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 name_suffix: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `TenantSecret` manages a tenant secret in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Example with plaintext data.
        mysecret1 = duplocloud.TenantSecret("mysecret1",
            tenant_id=myapp.tenant_id,
            name_suffix="mytext",
            data="hi")
        # Example with JSON data.
        mysecret2 = duplocloud.TenantSecret("mysecret2",
            tenant_id=myapp.tenant_id,
            name_suffix="myjson",
            data=json.dumps({
                "foo": "bar",
            }))
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantSecret:TenantSecret myapp TENANT_ID/SECRET_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        :param pulumi.Input[str] name_suffix: The short name of the secret. You can get the fullname from the `name` attribute after creation.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `TenantSecret` manages a tenant secret in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Example with plaintext data.
        mysecret1 = duplocloud.TenantSecret("mysecret1",
            tenant_id=myapp.tenant_id,
            name_suffix="mytext",
            data="hi")
        # Example with JSON data.
        mysecret2 = duplocloud.TenantSecret("mysecret2",
            tenant_id=myapp.tenant_id,
            name_suffix="myjson",
            data=json.dumps({
                "foo": "bar",
            }))
        ```

        ## Import

        ```sh
        $ pulumi import duplocloud:index/tenantSecret:TenantSecret myapp TENANT_ID/SECRET_NAME
        ```

        :param str resource_name: The name of the resource.
        :param TenantSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 name_suffix: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantSecretArgs.__new__(TenantSecretArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = None if data is None else pulumi.Output.secret(data)
            if name_suffix is None and not opts.urn:
                raise TypeError("Missing required property 'name_suffix'")
            __props__.__dict__["name_suffix"] = name_suffix
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["rotation_enabled"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["version_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["data"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TenantSecret, __self__).__init__(
            'duplocloud:index/tenantSecret:TenantSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_suffix: Optional[pulumi.Input[str]] = None,
            rotation_enabled: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TenantSecretTagArgs', 'TenantSecretTagArgsDict']]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            version_id: Optional[pulumi.Input[str]] = None) -> 'TenantSecret':
        """
        Get an existing TenantSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the created secret.
        :param pulumi.Input[str] data: The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        :param pulumi.Input[str] name: The full name of the secret.
        :param pulumi.Input[str] name_suffix: The short name of the secret. You can get the fullname from the `name` attribute after creation.
        :param pulumi.Input[bool] rotation_enabled: Whether or not rotation is enabled for this secret.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TenantSecretTagArgs', 'TenantSecretTagArgsDict']]]] tags: A list of tags for this secret.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the secret will be created in.
        :param pulumi.Input[str] version_id: The version ID of the secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantSecretState.__new__(_TenantSecretState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data"] = data
        __props__.__dict__["name"] = name
        __props__.__dict__["name_suffix"] = name_suffix
        __props__.__dict__["rotation_enabled"] = rotation_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["version_id"] = version_id
        return TenantSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the created secret.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[str]:
        """
        The plaintext secret data. You can use the `jsonencode()` function to store JSON data in this field.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The full name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameSuffix")
    def name_suffix(self) -> pulumi.Output[str]:
        """
        The short name of the secret. You can get the fullname from the `name` attribute after creation.
        """
        return pulumi.get(self, "name_suffix")

    @property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> pulumi.Output[bool]:
        """
        Whether or not rotation is enabled for this secret.
        """
        return pulumi.get(self, "rotation_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.TenantSecretTag']]:
        """
        A list of tags for this secret.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the secret will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The version ID of the secret.
        """
        return pulumi.get(self, "version_id")

