# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TenantTagInitArgs', 'TenantTag']

@pulumi.input_type
class TenantTagInitArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a TenantTag resource.
        :param pulumi.Input[str] key: Specify key for tag.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the tags will be created in.
        :param pulumi.Input[str] value: Specify value for tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Specify key for tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The GUID of the tenant that the tags will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specify value for tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _TenantTagState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TenantTag resources.
        :param pulumi.Input[str] key: Specify key for tag.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the tags will be created in.
        :param pulumi.Input[str] value: Specify value for tag.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Specify key for tag.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GUID of the tenant that the tags will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Specify value for tag.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class TenantTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `TenantTag` manages a tenant tag in Duplo.

        ## Import

        Example: Importing an existing S3 bucket

         - *TENANT_ID* is the tenant GUID

         - *TAG_KEY* is the tenant tag key

        # 

        ```sh
        $ pulumi import duplocloud:index/tenantTag:TenantTag tag TENANT_ID/TAG_KEY
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Specify key for tag.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the tags will be created in.
        :param pulumi.Input[str] value: Specify value for tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantTagInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `TenantTag` manages a tenant tag in Duplo.

        ## Import

        Example: Importing an existing S3 bucket

         - *TENANT_ID* is the tenant GUID

         - *TAG_KEY* is the tenant tag key

        # 

        ```sh
        $ pulumi import duplocloud:index/tenantTag:TenantTag tag TENANT_ID/TAG_KEY
        ```

        :param str resource_name: The name of the resource.
        :param TenantTagInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantTagInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantTagInitArgs.__new__(TenantTagInitArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(TenantTag, __self__).__init__(
            'duplocloud:index/tenantTag:TenantTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'TenantTag':
        """
        Get an existing TenantTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Specify key for tag.
        :param pulumi.Input[str] tenant_id: The GUID of the tenant that the tags will be created in.
        :param pulumi.Input[str] value: Specify value for tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantTagState.__new__(_TenantTagState)

        __props__.__dict__["key"] = key
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value"] = value
        return TenantTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Specify key for tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The GUID of the tenant that the tags will be created in.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Specify value for tag.
        """
        return pulumi.get(self, "value")

