# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 username: pulumi.Input[str],
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 reallocate_vpn_address: Optional[pulumi.Input[bool]] = None,
                 regenerate_vpn_password: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        :param pulumi.Input[str] username: The unique user name or the email.
        :param pulumi.Input[bool] is_readonly: Defaults to `false`.
        :param pulumi.Input[bool] reallocate_vpn_address: Defaults to `false`.
        :param pulumi.Input[bool] regenerate_vpn_password: Defaults to `false`.
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "username", username)
        if is_readonly is not None:
            pulumi.set(__self__, "is_readonly", is_readonly)
        if reallocate_vpn_address is not None:
            pulumi.set(__self__, "reallocate_vpn_address", reallocate_vpn_address)
        if regenerate_vpn_password is not None:
            pulumi.set(__self__, "regenerate_vpn_password", regenerate_vpn_password)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @is_readonly.setter
    def is_readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_readonly", value)

    @property
    @pulumi.getter(name="reallocateVpnAddress")
    def reallocate_vpn_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "reallocate_vpn_address")

    @reallocate_vpn_address.setter
    def reallocate_vpn_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reallocate_vpn_address", value)

    @property
    @pulumi.getter(name="regenerateVpnPassword")
    def regenerate_vpn_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "regenerate_vpn_password")

    @regenerate_vpn_password.setter
    def regenerate_vpn_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "regenerate_vpn_password", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 current_session_token: Optional[pulumi.Input[str]] = None,
                 is_confirmation_email_sent: Optional[pulumi.Input[bool]] = None,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 is_vpn_config_created: Optional[pulumi.Input[bool]] = None,
                 reallocate_vpn_address: Optional[pulumi.Input[bool]] = None,
                 regenerate_vpn_password: Optional[pulumi.Input[bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpn_static_ip: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[bool] is_readonly: Defaults to `false`.
        :param pulumi.Input[bool] reallocate_vpn_address: Defaults to `false`.
        :param pulumi.Input[bool] regenerate_vpn_password: Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        if current_session_token is not None:
            pulumi.set(__self__, "current_session_token", current_session_token)
        if is_confirmation_email_sent is not None:
            pulumi.set(__self__, "is_confirmation_email_sent", is_confirmation_email_sent)
        if is_readonly is not None:
            pulumi.set(__self__, "is_readonly", is_readonly)
        if is_vpn_config_created is not None:
            pulumi.set(__self__, "is_vpn_config_created", is_vpn_config_created)
        if reallocate_vpn_address is not None:
            pulumi.set(__self__, "reallocate_vpn_address", reallocate_vpn_address)
        if regenerate_vpn_password is not None:
            pulumi.set(__self__, "regenerate_vpn_password", regenerate_vpn_password)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpn_static_ip is not None:
            pulumi.set(__self__, "vpn_static_ip", vpn_static_ip)

    @property
    @pulumi.getter(name="currentSessionToken")
    def current_session_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "current_session_token")

    @current_session_token.setter
    def current_session_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_session_token", value)

    @property
    @pulumi.getter(name="isConfirmationEmailSent")
    def is_confirmation_email_sent(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_confirmation_email_sent")

    @is_confirmation_email_sent.setter
    def is_confirmation_email_sent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_confirmation_email_sent", value)

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @is_readonly.setter
    def is_readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_readonly", value)

    @property
    @pulumi.getter(name="isVpnConfigCreated")
    def is_vpn_config_created(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_vpn_config_created")

    @is_vpn_config_created.setter
    def is_vpn_config_created(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_vpn_config_created", value)

    @property
    @pulumi.getter(name="reallocateVpnAddress")
    def reallocate_vpn_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "reallocate_vpn_address")

    @reallocate_vpn_address.setter
    def reallocate_vpn_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reallocate_vpn_address", value)

    @property
    @pulumi.getter(name="regenerateVpnPassword")
    def regenerate_vpn_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "regenerate_vpn_password")

    @regenerate_vpn_password.setter
    def regenerate_vpn_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "regenerate_vpn_password", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpnStaticIp")
    def vpn_static_ip(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpn_static_ip")

    @vpn_static_ip.setter
    def vpn_static_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_static_ip", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 reallocate_vpn_address: Optional[pulumi.Input[bool]] = None,
                 regenerate_vpn_password: Optional[pulumi.Input[bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `User` manages a user in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myuser = duplocloud.User("myuser",
            username="me@abc.com",
            roles=[
                "User",
                "Administrator",
                "SignupUser",
                "SecurityAdmin",
            ],
            is_readonly=False,
            reallocate_vpn_address=False,
            regenerate_vpn_password=False)
        ```

        ## Import

        Example: Importing an existing duplo user

         - *USERNAME* is the duplo username

        # 

        ```sh
        $ pulumi import duplocloud:index/user:User myuser *USERNAME*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_readonly: Defaults to `false`.
        :param pulumi.Input[bool] reallocate_vpn_address: Defaults to `false`.
        :param pulumi.Input[bool] regenerate_vpn_password: Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `User` manages a user in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myuser = duplocloud.User("myuser",
            username="me@abc.com",
            roles=[
                "User",
                "Administrator",
                "SignupUser",
                "SecurityAdmin",
            ],
            is_readonly=False,
            reallocate_vpn_address=False,
            regenerate_vpn_password=False)
        ```

        ## Import

        Example: Importing an existing duplo user

         - *USERNAME* is the duplo username

        # 

        ```sh
        $ pulumi import duplocloud:index/user:User myuser *USERNAME*
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 reallocate_vpn_address: Optional[pulumi.Input[bool]] = None,
                 regenerate_vpn_password: Optional[pulumi.Input[bool]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["is_readonly"] = is_readonly
            __props__.__dict__["reallocate_vpn_address"] = reallocate_vpn_address
            __props__.__dict__["regenerate_vpn_password"] = regenerate_vpn_password
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["current_session_token"] = None
            __props__.__dict__["is_confirmation_email_sent"] = None
            __props__.__dict__["is_vpn_config_created"] = None
            __props__.__dict__["vpn_static_ip"] = None
        super(User, __self__).__init__(
            'duplocloud:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            current_session_token: Optional[pulumi.Input[str]] = None,
            is_confirmation_email_sent: Optional[pulumi.Input[bool]] = None,
            is_readonly: Optional[pulumi.Input[bool]] = None,
            is_vpn_config_created: Optional[pulumi.Input[bool]] = None,
            reallocate_vpn_address: Optional[pulumi.Input[bool]] = None,
            regenerate_vpn_password: Optional[pulumi.Input[bool]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None,
            vpn_static_ip: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_readonly: Defaults to `false`.
        :param pulumi.Input[bool] reallocate_vpn_address: Defaults to `false`.
        :param pulumi.Input[bool] regenerate_vpn_password: Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["current_session_token"] = current_session_token
        __props__.__dict__["is_confirmation_email_sent"] = is_confirmation_email_sent
        __props__.__dict__["is_readonly"] = is_readonly
        __props__.__dict__["is_vpn_config_created"] = is_vpn_config_created
        __props__.__dict__["reallocate_vpn_address"] = reallocate_vpn_address
        __props__.__dict__["regenerate_vpn_password"] = regenerate_vpn_password
        __props__.__dict__["roles"] = roles
        __props__.__dict__["username"] = username
        __props__.__dict__["vpn_static_ip"] = vpn_static_ip
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="currentSessionToken")
    def current_session_token(self) -> pulumi.Output[str]:
        return pulumi.get(self, "current_session_token")

    @property
    @pulumi.getter(name="isConfirmationEmailSent")
    def is_confirmation_email_sent(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_confirmation_email_sent")

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @property
    @pulumi.getter(name="isVpnConfigCreated")
    def is_vpn_config_created(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_vpn_config_created")

    @property
    @pulumi.getter(name="reallocateVpnAddress")
    def reallocate_vpn_address(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "reallocate_vpn_address")

    @property
    @pulumi.getter(name="regenerateVpnPassword")
    def regenerate_vpn_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Defaults to `false`.
        """
        return pulumi.get(self, "regenerate_vpn_password")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of roles to be assigned to thh created user. Valid values are - `User`, `Administrator`, `SignupUser`, `SecurityAdmin`.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vpnStaticIp")
    def vpn_static_ip(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpn_static_ip")

