# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserTenantAccessArgs', 'UserTenantAccess']

@pulumi.input_type
class UserTenantAccessArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 username: pulumi.Input[str],
                 is_readonly: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a UserTenantAccess resource.
        :param pulumi.Input[str] tenant_id: Tenant Id to which user need to get access
        :param pulumi.Input[str] username: The unique user name or the email.
        :param pulumi.Input[bool] is_readonly: Specifiy readonly policy related to tenant Defaults to `false`.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "username", username)
        if is_readonly is not None:
            pulumi.set(__self__, "is_readonly", is_readonly)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        Tenant Id to which user need to get access
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifiy readonly policy related to tenant Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @is_readonly.setter
    def is_readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_readonly", value)


@pulumi.input_type
class _UserTenantAccessState:
    def __init__(__self__, *,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserTenantAccess resources.
        :param pulumi.Input[bool] is_readonly: Specifiy readonly policy related to tenant Defaults to `false`.
        :param pulumi.Input[str] tenant_id: Tenant Id to which user need to get access
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        if is_readonly is not None:
            pulumi.set(__self__, "is_readonly", is_readonly)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifiy readonly policy related to tenant Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @is_readonly.setter
    def is_readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_readonly", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id to which user need to get access
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_name", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class UserTenantAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `UserTenantAccess` manages a user tenant access in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Simple Example 1:  Grant access of tenant to user
        access = duplocloud.UserTenantAccess("access",
            username="user@domain",
            tenant_id=myapp.tenant_id,
            is_readonly=False)
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *USERNAME* is the unique user name or email id of the user to which TENANT_ID access has been given

        # 

        ```sh
        $ pulumi import duplocloud:index/userTenantAccess:UserTenantAccess access *USERNAME*/*TENANT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_readonly: Specifiy readonly policy related to tenant Defaults to `false`.
        :param pulumi.Input[str] tenant_id: Tenant Id to which user need to get access
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserTenantAccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `UserTenantAccess` manages a user tenant access in Duplo.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_duplocloud as duplocloud

        myapp = duplocloud.Tenant("myapp",
            account_name="myapp",
            plan_id="default")
        # Simple Example 1:  Grant access of tenant to user
        access = duplocloud.UserTenantAccess("access",
            username="user@domain",
            tenant_id=myapp.tenant_id,
            is_readonly=False)
        ```

        ## Import

        Example: Importing an existing service

         - *TENANT_ID* is the tenant GUID

         - *USERNAME* is the unique user name or email id of the user to which TENANT_ID access has been given

        # 

        ```sh
        $ pulumi import duplocloud:index/userTenantAccess:UserTenantAccess access *USERNAME*/*TENANT_ID*
        ```

        :param str resource_name: The name of the resource.
        :param UserTenantAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserTenantAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_readonly: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserTenantAccessArgs.__new__(UserTenantAccessArgs)

            __props__.__dict__["is_readonly"] = is_readonly
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["tenant_name"] = None
        super(UserTenantAccess, __self__).__init__(
            'duplocloud:index/userTenantAccess:UserTenantAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_readonly: Optional[pulumi.Input[bool]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            tenant_name: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'UserTenantAccess':
        """
        Get an existing UserTenantAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_readonly: Specifiy readonly policy related to tenant Defaults to `false`.
        :param pulumi.Input[str] tenant_id: Tenant Id to which user need to get access
        :param pulumi.Input[str] username: The unique user name or the email.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserTenantAccessState.__new__(_UserTenantAccessState)

        __props__.__dict__["is_readonly"] = is_readonly
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["tenant_name"] = tenant_name
        __props__.__dict__["username"] = username
        return UserTenantAccess(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isReadonly")
    def is_readonly(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifiy readonly policy related to tenant Defaults to `false`.
        """
        return pulumi.get(self, "is_readonly")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Tenant Id to which user need to get access
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The unique user name or the email.
        """
        return pulumi.get(self, "username")

