# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElasticsearchProjectArgs', 'ElasticsearchProject']

@pulumi.input_type
class ElasticsearchProjectArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optimized_for: Optional[pulumi.Input[str]] = None,
                 search_lake: Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']] = None):
        """
        The set of arguments for constructing a ElasticsearchProject resource.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] optimized_for: The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        :param pulumi.Input['ElasticsearchProjectSearchLakeArgs'] search_lake: Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        """
        pulumi.set(__self__, "region_id", region_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized_for is not None:
            pulumi.set(__self__, "optimized_for", optimized_for)
        if search_lake is not None:
            pulumi.set(__self__, "search_lake", search_lake)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optimizedFor")
    def optimized_for(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        """
        return pulumi.get(self, "optimized_for")

    @optimized_for.setter
    def optimized_for(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "optimized_for", value)

    @property
    @pulumi.getter(name="searchLake")
    def search_lake(self) -> Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']]:
        """
        Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        """
        return pulumi.get(self, "search_lake")

    @search_lake.setter
    def search_lake(self, value: Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']]):
        pulumi.set(self, "search_lake", value)


@pulumi.input_type
class _ElasticsearchProjectState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['ElasticsearchProjectCredentialsArgs']] = None,
                 endpoints: Optional[pulumi.Input['ElasticsearchProjectEndpointsArgs']] = None,
                 metadata: Optional[pulumi.Input['ElasticsearchProjectMetadataArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optimized_for: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 search_lake: Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ElasticsearchProject resources.
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input['ElasticsearchProjectCredentialsArgs'] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input['ElasticsearchProjectEndpointsArgs'] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input['ElasticsearchProjectMetadataArgs'] metadata: Additional details about the project.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] optimized_for: The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input['ElasticsearchProjectSearchLakeArgs'] search_lake: Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        :param pulumi.Input[str] type: the type of the project
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized_for is not None:
            pulumi.set(__self__, "optimized_for", optimized_for)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if search_lake is not None:
            pulumi.set(__self__, "search_lake", search_lake)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ElasticsearchProjectCredentialsArgs']]:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ElasticsearchProjectCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['ElasticsearchProjectEndpointsArgs']]:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['ElasticsearchProjectEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ElasticsearchProjectMetadataArgs']]:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ElasticsearchProjectMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optimizedFor")
    def optimized_for(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        """
        return pulumi.get(self, "optimized_for")

    @optimized_for.setter
    def optimized_for(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "optimized_for", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="searchLake")
    def search_lake(self) -> Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']]:
        """
        Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        """
        return pulumi.get(self, "search_lake")

    @search_lake.setter
    def search_lake(self, value: Optional[pulumi.Input['ElasticsearchProjectSearchLakeArgs']]):
        pulumi.set(self, "search_lake", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ElasticsearchProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optimized_for: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 search_lake: Optional[pulumi.Input[Union['ElasticsearchProjectSearchLakeArgs', 'ElasticsearchProjectSearchLakeArgsDict']]] = None,
                 __props__=None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.ElasticsearchProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/elasticsearchProject:ElasticsearchProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] optimized_for: The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[Union['ElasticsearchProjectSearchLakeArgs', 'ElasticsearchProjectSearchLakeArgsDict']] search_lake: Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElasticsearchProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.ElasticsearchProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/elasticsearchProject:ElasticsearchProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param ElasticsearchProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElasticsearchProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optimized_for: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 search_lake: Optional[pulumi.Input[Union['ElasticsearchProjectSearchLakeArgs', 'ElasticsearchProjectSearchLakeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElasticsearchProjectArgs.__new__(ElasticsearchProjectArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["name"] = name
            __props__.__dict__["optimized_for"] = optimized_for
            if region_id is None and not opts.urn:
                raise TypeError("Missing required property 'region_id'")
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["search_lake"] = search_lake
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["credentials"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["type"] = None
        super(ElasticsearchProject, __self__).__init__(
            'ec:index/elasticsearchProject:ElasticsearchProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            cloud_id: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[Union['ElasticsearchProjectCredentialsArgs', 'ElasticsearchProjectCredentialsArgsDict']]] = None,
            endpoints: Optional[pulumi.Input[Union['ElasticsearchProjectEndpointsArgs', 'ElasticsearchProjectEndpointsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Union['ElasticsearchProjectMetadataArgs', 'ElasticsearchProjectMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            optimized_for: Optional[pulumi.Input[str]] = None,
            region_id: Optional[pulumi.Input[str]] = None,
            search_lake: Optional[pulumi.Input[Union['ElasticsearchProjectSearchLakeArgs', 'ElasticsearchProjectSearchLakeArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ElasticsearchProject':
        """
        Get an existing ElasticsearchProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input[Union['ElasticsearchProjectCredentialsArgs', 'ElasticsearchProjectCredentialsArgsDict']] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input[Union['ElasticsearchProjectEndpointsArgs', 'ElasticsearchProjectEndpointsArgsDict']] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input[Union['ElasticsearchProjectMetadataArgs', 'ElasticsearchProjectMetadataArgsDict']] metadata: Additional details about the project.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] optimized_for: The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[Union['ElasticsearchProjectSearchLakeArgs', 'ElasticsearchProjectSearchLakeArgsDict']] search_lake: Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        :param pulumi.Input[str] type: the type of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElasticsearchProjectState.__new__(_ElasticsearchProjectState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["optimized_for"] = optimized_for
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["search_lake"] = search_lake
        __props__.__dict__["type"] = type
        return ElasticsearchProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[str]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.ElasticsearchProjectCredentials']:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output['outputs.ElasticsearchProjectEndpoints']:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.ElasticsearchProjectMetadata']:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optimizedFor")
    def optimized_for(self) -> pulumi.Output[str]:
        """
        The purpose for which the hardware of this elasticsearch project is optimized for. Also known as the Elasticsearch project subtype.
        """
        return pulumi.get(self, "optimized_for")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="searchLake")
    def search_lake(self) -> pulumi.Output['outputs.ElasticsearchProjectSearchLake']:
        """
        Configuration for entire set of capabilities that make the data searchable in Elasticsearch.
        """
        return pulumi.get(self, "search_lake")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

