# coding: utf-8
#
# THIS FILE IS AUTOMATICALLY GENERATED!
#
# To update this file, run ./contrib/internal/build-confusables.py

from typing import Dict, Optional, Tuple

from typing_extensions import TypeAlias


ConfusablesMapValue: TypeAlias = Tuple[str, Optional[int]]
ConfusablesMap: TypeAlias = Dict[str, ConfusablesMapValue]


COMMON_CONFUSABLES_MAP: ConfusablesMap = {
    '\xa0': (' ', None),  # A0; COMMON
    '´': ("'", None),  # B4; COMMON
    '¸': (',', None),  # B8; COMMON
    '×': ('x', None),  # D7; COMMON
    'ı': ('i', None),  # 131; LATIN
    'ſ': ('f', None),  # 17F; LATIN
    'Ƅ': ('b', None),  # 184; LATIN
    'ƍ': ('g', None),  # 18D; LATIN
    'Ɩ': ('l', None),  # 196; LATIN
    'Ʀ': ('R', None),  # 1A6; LATIN
    'Ƨ': ('2', None),  # 1A7; LATIN
    'Ʒ': ('3', None),  # 1B7; LATIN
    'Ƽ': ('5', None),  # 1BC; LATIN
    'ƽ': ('s', None),  # 1BD; LATIN
    'ǀ': ('l', None),  # 1C0; LATIN
    'ǃ': ('!', None),  # 1C3; LATIN
    'Ȝ': ('3', None),  # 21C; LATIN
    'Ȣ': ('8', None),  # 222; LATIN
    'ȣ': ('8', None),  # 223; LATIN
    'Ɂ': ('?', None),  # 241; LATIN
    'ɑ': ('a', None),  # 251; LATIN
    'ɡ': ('g', None),  # 261; LATIN
    'ɣ': ('y', None),  # 263; LATIN
    'ɩ': ('i', None),  # 269; LATIN
    'ɪ': ('i', None),  # 26A; LATIN
    'ɯ': ('w', None),  # 26F; LATIN
    'ʋ': ('u', None),  # 28B; LATIN
    'ʏ': ('y', None),  # 28F; LATIN
    'ʔ': ('?', None),  # 294; LATIN
    'ʹ': ("'", None),  # 2B9; COMMON
    'ʻ': ("'", None),  # 2BB; COMMON
    'ʼ': ("'", None),  # 2BC; COMMON
    'ʽ': ("'", None),  # 2BD; COMMON
    'ʾ': ("'", None),  # 2BE; COMMON
    '˂': ('<', None),  # 2C2; COMMON
    '˃': ('>', None),  # 2C3; COMMON
    '˄': ('^', None),  # 2C4; COMMON
    'ˆ': ('^', None),  # 2C6; COMMON
    'ˈ': ("'", None),  # 2C8; COMMON
    'ˊ': ("'", None),  # 2CA; COMMON
    'ˋ': ("'", None),  # 2CB; COMMON
    'ː': (':', None),  # 2D0; COMMON
    '˗': ('-', None),  # 2D7; COMMON
    '˛': ('i', None),  # 2DB; COMMON
    '˜': ('~', None),  # 2DC; COMMON
    '˴': ("'", None),  # 2F4; COMMON
    '˸': (':', None),  # 2F8; COMMON
    'ʹ': ("'", None),  # 374; COMMON
    'ͺ': ('i', 0),  # 37A; GREEK
    ';': (';', None),  # 37E; COMMON
    'Ϳ': ('J', 0),  # 37F; GREEK
    '΄': ("'", 0),  # 384; GREEK
    'Α': ('A', 0),  # 391; GREEK
    'Β': ('B', 0),  # 392; GREEK
    'Ε': ('E', 0),  # 395; GREEK
    'Ζ': ('Z', 0),  # 396; GREEK
    'Η': ('H', 0),  # 397; GREEK
    'Ι': ('l', 0),  # 399; GREEK
    'Κ': ('K', 0),  # 39A; GREEK
    'Μ': ('M', 0),  # 39C; GREEK
    'Ν': ('N', 0),  # 39D; GREEK
    'Ο': ('O', 0),  # 39F; GREEK
    'Ρ': ('P', 0),  # 3A1; GREEK
    'Τ': ('T', 0),  # 3A4; GREEK
    'Υ': ('Y', 0),  # 3A5; GREEK
    'Χ': ('X', 0),  # 3A7; GREEK
    'α': ('a', 0),  # 3B1; GREEK
    'γ': ('y', 0),  # 3B3; GREEK
    'ι': ('i', 0),  # 3B9; GREEK
    'ν': ('v', 0),  # 3BD; GREEK
    'ο': ('o', 0),  # 3BF; GREEK
    'ρ': ('p', 0),  # 3C1; GREEK
    'σ': ('o', 0),  # 3C3; GREEK
    'υ': ('u', 0),  # 3C5; GREEK
    'ϒ': ('Y', 0),  # 3D2; GREEK
    'Ϝ': ('F', 0),  # 3DC; GREEK
    'Ϩ': ('2', None),  # 3E8; COPTIC
    'ϱ': ('p', 0),  # 3F1; GREEK
    'ϲ': ('c', 0),  # 3F2; GREEK
    'ϳ': ('j', 0),  # 3F3; GREEK
    'Ϲ': ('C', 0),  # 3F9; GREEK
    'Ϻ': ('M', 0),  # 3FA; GREEK
    'Ѕ': ('S', 1),  # 405; CYRILLIC
    'І': ('l', 1),  # 406; CYRILLIC
    'Ј': ('J', 1),  # 408; CYRILLIC
    'А': ('A', 1),  # 410; CYRILLIC
    'В': ('B', 1),  # 412; CYRILLIC
    'Е': ('E', 1),  # 415; CYRILLIC
    'З': ('3', 1),  # 417; CYRILLIC
    'К': ('K', 1),  # 41A; CYRILLIC
    'М': ('M', 1),  # 41C; CYRILLIC
    'Н': ('H', 1),  # 41D; CYRILLIC
    'О': ('O', 1),  # 41E; CYRILLIC
    'Р': ('P', 1),  # 420; CYRILLIC
    'С': ('C', 1),  # 421; CYRILLIC
    'Т': ('T', 1),  # 422; CYRILLIC
    'У': ('Y', 1),  # 423; CYRILLIC
    'Х': ('X', 1),  # 425; CYRILLIC
    'Ь': ('b', 1),  # 42C; CYRILLIC
    'а': ('a', 1),  # 430; CYRILLIC
    'б': ('6', 1),  # 431; CYRILLIC
    'г': ('r', 1),  # 433; CYRILLIC
    'е': ('e', 1),  # 435; CYRILLIC
    'о': ('o', 1),  # 43E; CYRILLIC
    'р': ('p', 1),  # 440; CYRILLIC
    'с': ('c', 1),  # 441; CYRILLIC
    'у': ('y', 1),  # 443; CYRILLIC
    'х': ('x', 1),  # 445; CYRILLIC
    'ѕ': ('s', 1),  # 455; CYRILLIC
    'і': ('i', 1),  # 456; CYRILLIC
    'ј': ('j', 1),  # 458; CYRILLIC
    'ѡ': ('w', 1),  # 461; CYRILLIC
    'Ѵ': ('V', 1),  # 474; CYRILLIC
    'ѵ': ('v', 1),  # 475; CYRILLIC
    'Ү': ('Y', 1),  # 4AE; CYRILLIC
    'ү': ('y', 1),  # 4AF; CYRILLIC
    'һ': ('h', 1),  # 4BB; CYRILLIC
    'ҽ': ('e', 1),  # 4BD; CYRILLIC
    'Ӏ': ('l', 1),  # 4C0; CYRILLIC
    'ӏ': ('i', 1),  # 4CF; CYRILLIC
    'Ӡ': ('3', 1),  # 4E0; CYRILLIC
    'ԁ': ('d', 1),  # 501; CYRILLIC
    'Ԍ': ('G', 1),  # 50C; CYRILLIC
    'ԛ': ('q', 1),  # 51B; CYRILLIC
    'Ԝ': ('W', 1),  # 51C; CYRILLIC
    'ԝ': ('w', 1),  # 51D; CYRILLIC
    'Ս': ('U', 2),  # 54D; ARMENIAN
    'Տ': ('S', 2),  # 54F; ARMENIAN
    'Օ': ('O', 2),  # 555; ARMENIAN
    '՚': ("'", 2),  # 55A; ARMENIAN
    '՝': ("'", 2),  # 55D; ARMENIAN
    'ա': ('w', 2),  # 561; ARMENIAN
    'գ': ('q', 2),  # 563; ARMENIAN
    'զ': ('q', 2),  # 566; ARMENIAN
    'հ': ('h', 2),  # 570; ARMENIAN
    'ո': ('n', 2),  # 578; ARMENIAN
    'ռ': ('n', 2),  # 57C; ARMENIAN
    'ս': ('u', 2),  # 57D; ARMENIAN
    'ց': ('g', 2),  # 581; ARMENIAN
    'ք': ('f', 2),  # 584; ARMENIAN
    'օ': ('o', 2),  # 585; ARMENIAN
    '։': (':', 2),  # 589; ARMENIAN
    '׀': ('l', None),  # 5C0; HEBREW
    '׃': (':', None),  # 5C3; HEBREW
    'ו': ('l', None),  # 5D5; HEBREW
    'ט': ('v', None),  # 5D8; HEBREW
    'י': ("'", None),  # 5D9; HEBREW
    'ן': ('l', None),  # 5DF; HEBREW
    'ס': ('o', None),  # 5E1; HEBREW
    '׳': ("'", None),  # 5F3; HEBREW
    '؍': (',', 3),  # 60D; ARABIC
    'ا': ('l', 3),  # 627; ARABIC
    'ه': ('o', 3),  # 647; ARABIC
    '٠': ('.', 3),  # 660; ARABIC
    '١': ('l', 3),  # 661; ARABIC
    '٥': ('o', 3),  # 665; ARABIC
    '٧': ('V', 3),  # 667; ARABIC
    '٫': (',', 3),  # 66B; ARABIC
    '٭': ('*', 3),  # 66D; ARABIC
    'ھ': ('o', 3),  # 6BE; ARABIC
    'ہ': ('o', 3),  # 6C1; ARABIC
    '۔': ('-', 3),  # 6D4; ARABIC
    'ە': ('o', 3),  # 6D5; ARABIC
    '۰': ('.', 3),  # 6F0; ARABIC
    '۱': ('l', 3),  # 6F1; ARABIC
    '۵': ('o', 3),  # 6F5; ARABIC
    '۷': ('V', 3),  # 6F7; ARABIC
    '܁': ('.', None),  # 701; SYRIAC
    '܂': ('.', None),  # 702; SYRIAC
    '܃': (':', None),  # 703; SYRIAC
    '܄': (':', None),  # 704; SYRIAC
    '߀': ('O', None),  # 7C0; NKO
    'ߊ': ('l', None),  # 7CA; NKO
    'ߴ': ("'", None),  # 7F4; NKO
    'ߵ': ("'", None),  # 7F5; NKO
    'ߺ': ('_', None),  # 7FA; NKO
    'ः': (':', 4),  # 903; DEVANAGARI
    '०': ('o', 4),  # 966; DEVANAGARI
    'ॽ': ('?', 4),  # 97D; DEVANAGARI
    '০': ('O', 5),  # 9E6; BENGALI
    '৪': ('8', 5),  # 9EA; BENGALI
    '৭': ('9', 5),  # 9ED; BENGALI
    '੦': ('o', 6),  # A66; GURMUKHI
    '੧': ('9', 6),  # A67; GURMUKHI
    '੪': ('8', 6),  # A6A; GURMUKHI
    'ઃ': (':', 7),  # A83; GUJARATI
    '૦': ('o', 7),  # AE6; GUJARATI
    'ଃ': ('8', 8),  # B03; ORIYA
    'ଠ': ('O', 8),  # B20; ORIYA
    '୦': ('O', 8),  # B66; ORIYA
    '୨': ('9', 8),  # B68; ORIYA
    '௦': ('o', None),  # BE6; TAMIL
    'ం': ('o', 9),  # C02; TELUGU
    '౦': ('o', 9),  # C66; TELUGU
    'ಂ': ('o', 10),  # C82; KANNADA
    '೦': ('o', 10),  # CE6; KANNADA
    'ം': ('o', None),  # D02; MALAYALAM
    'ഠ': ('o', None),  # D20; MALAYALAM
    '൦': ('o', None),  # D66; MALAYALAM
    '൭': ('9', None),  # D6D; MALAYALAM
    'ං': ('o', None),  # D82; SINHALA
    '๐': ('o', None),  # E50; THAI
    '໐': ('o', None),  # ED0; LAO
    'ဝ': ('o', None),  # 101D; MYANMAR
    '၀': ('o', None),  # 1040; MYANMAR
    'ყ': ('y', None),  # 10E7; GEORGIAN
    'ჿ': ('o', None),  # 10FF; GEORGIAN
    'ሀ': ('U', None),  # 1200; ETHIOPIC
    'ዐ': ('O', None),  # 12D0; ETHIOPIC
    'Ꭰ': ('D', None),  # 13A0; CHEROKEE
    'Ꭱ': ('R', None),  # 13A1; CHEROKEE
    'Ꭲ': ('T', None),  # 13A2; CHEROKEE
    'Ꭵ': ('i', None),  # 13A5; CHEROKEE
    'Ꭹ': ('Y', None),  # 13A9; CHEROKEE
    'Ꭺ': ('A', None),  # 13AA; CHEROKEE
    'Ꭻ': ('J', None),  # 13AB; CHEROKEE
    'Ꭼ': ('E', None),  # 13AC; CHEROKEE
    'Ꭾ': ('?', None),  # 13AE; CHEROKEE
    'Ꮃ': ('W', None),  # 13B3; CHEROKEE
    'Ꮇ': ('M', None),  # 13B7; CHEROKEE
    'Ꮋ': ('H', None),  # 13BB; CHEROKEE
    'Ꮍ': ('Y', None),  # 13BD; CHEROKEE
    'Ꮐ': ('G', None),  # 13C0; CHEROKEE
    'Ꮒ': ('h', None),  # 13C2; CHEROKEE
    'Ꮓ': ('Z', None),  # 13C3; CHEROKEE
    'Ꮞ': ('4', None),  # 13CE; CHEROKEE
    'Ꮟ': ('b', None),  # 13CF; CHEROKEE
    'Ꮢ': ('R', None),  # 13D2; CHEROKEE
    'Ꮤ': ('W', None),  # 13D4; CHEROKEE
    'Ꮥ': ('S', None),  # 13D5; CHEROKEE
    'Ꮩ': ('V', None),  # 13D9; CHEROKEE
    'Ꮪ': ('S', None),  # 13DA; CHEROKEE
    'Ꮮ': ('L', None),  # 13DE; CHEROKEE
    'Ꮯ': ('C', None),  # 13DF; CHEROKEE
    'Ꮲ': ('P', None),  # 13E2; CHEROKEE
    'Ꮶ': ('K', None),  # 13E6; CHEROKEE
    'Ꮷ': ('d', None),  # 13E7; CHEROKEE
    'Ꮾ': ('6', None),  # 13EE; CHEROKEE
    'Ᏻ': ('G', None),  # 13F3; CHEROKEE
    'Ᏼ': ('B', None),  # 13F4; CHEROKEE
    '᐀': ('=', None),  # 1400; CANADIAN_ABORIGINAL
    'ᐯ': ('V', None),  # 142F; CANADIAN_ABORIGINAL
    'ᐳ': ('>', None),  # 1433; CANADIAN_ABORIGINAL
    'ᐸ': ('<', None),  # 1438; CANADIAN_ABORIGINAL
    'ᑊ': ("'", None),  # 144A; CANADIAN_ABORIGINAL
    'ᑌ': ('U', None),  # 144C; CANADIAN_ABORIGINAL
    'ᑭ': ('P', None),  # 146D; CANADIAN_ABORIGINAL
    'ᑯ': ('d', None),  # 146F; CANADIAN_ABORIGINAL
    'ᑲ': ('b', None),  # 1472; CANADIAN_ABORIGINAL
    'ᒍ': ('J', None),  # 148D; CANADIAN_ABORIGINAL
    'ᒪ': ('L', None),  # 14AA; CANADIAN_ABORIGINAL
    'ᒿ': ('2', None),  # 14BF; CANADIAN_ABORIGINAL
    'ᕁ': ('x', None),  # 1541; CANADIAN_ABORIGINAL
    'ᕼ': ('H', None),  # 157C; CANADIAN_ABORIGINAL
    'ᕽ': ('x', None),  # 157D; CANADIAN_ABORIGINAL
    'ᖇ': ('R', None),  # 1587; CANADIAN_ABORIGINAL
    'ᖯ': ('b', None),  # 15AF; CANADIAN_ABORIGINAL
    'ᖴ': ('F', None),  # 15B4; CANADIAN_ABORIGINAL
    'ᗅ': ('A', None),  # 15C5; CANADIAN_ABORIGINAL
    'ᗞ': ('D', None),  # 15DE; CANADIAN_ABORIGINAL
    'ᗪ': ('D', None),  # 15EA; CANADIAN_ABORIGINAL
    'ᗰ': ('M', None),  # 15F0; CANADIAN_ABORIGINAL
    'ᗷ': ('B', None),  # 15F7; CANADIAN_ABORIGINAL
    '᙭': ('X', None),  # 166D; CANADIAN_ABORIGINAL
    '᙮': ('x', None),  # 166E; CANADIAN_ABORIGINAL
    '\u1680': (' ', None),  # 1680; OGHAM
    'ᚲ': ('<', None),  # 16B2; RUNIC
    'ᚷ': ('X', None),  # 16B7; RUNIC
    'ᛁ': ('l', None),  # 16C1; RUNIC
    'ᛌ': ("'", None),  # 16CC; RUNIC
    'ᛕ': ('K', None),  # 16D5; RUNIC
    'ᛖ': ('M', None),  # 16D6; RUNIC
    '᛬': (':', None),  # 16EC; COMMON
    '᛭': ('+', None),  # 16ED; COMMON
    '᜵': ('/', None),  # 1735; COMMON
    '᠃': (':', None),  # 1803; COMMON
    '᠉': (':', None),  # 1809; MONGOLIAN
    'ᴄ': ('c', None),  # 1D04; LATIN
    'ᴏ': ('o', None),  # 1D0F; LATIN
    'ᴑ': ('o', None),  # 1D11; LATIN
    'ᴜ': ('u', None),  # 1D1C; LATIN
    'ᴠ': ('v', None),  # 1D20; LATIN
    'ᴡ': ('w', None),  # 1D21; LATIN
    'ᴢ': ('z', None),  # 1D22; LATIN
    'ᴦ': ('r', 0),  # 1D26; GREEK
    'ᶃ': ('g', None),  # 1D83; LATIN
    'ᶌ': ('y', None),  # 1D8C; LATIN
    'ẝ': ('f', None),  # 1E9D; LATIN
    'ỿ': ('y', None),  # 1EFF; LATIN
    '᾽': ("'", 0),  # 1FBD; GREEK
    'ι': ('i', 0),  # 1FBE; GREEK
    '᾿': ("'", 0),  # 1FBF; GREEK
    '῀': ('~', 0),  # 1FC0; GREEK
    '`': ("'", 0),  # 1FEF; GREEK
    '´': ("'", 0),  # 1FFD; GREEK
    '῾': ("'", 0),  # 1FFE; GREEK
    '\u2000': (' ', None),  # 2000; COMMON
    '\u2001': (' ', None),  # 2001; COMMON
    '\u2002': (' ', None),  # 2002; COMMON
    '\u2003': (' ', None),  # 2003; COMMON
    '\u2004': (' ', None),  # 2004; COMMON
    '\u2005': (' ', None),  # 2005; COMMON
    '\u2006': (' ', None),  # 2006; COMMON
    '\u2007': (' ', None),  # 2007; COMMON
    '\u2008': (' ', None),  # 2008; COMMON
    '\u2009': (' ', None),  # 2009; COMMON
    '\u200a': (' ', None),  # 200A; COMMON
    '‐': ('-', None),  # 2010; COMMON
    '‑': ('-', None),  # 2011; COMMON
    '‒': ('-', None),  # 2012; COMMON
    '–': ('-', None),  # 2013; COMMON
    '‘': ("'", None),  # 2018; COMMON
    '’': ("'", None),  # 2019; COMMON
    '‚': (',', None),  # 201A; COMMON
    '‛': ("'", None),  # 201B; COMMON
    '․': ('.', None),  # 2024; COMMON
    '\u2028': (' ', None),  # 2028; COMMON
    '\u2029': (' ', None),  # 2029; COMMON
    '\u202f': (' ', None),  # 202F; COMMON
    '′': ("'", None),  # 2032; COMMON
    '‵': ("'", None),  # 2035; COMMON
    '‹': ('<', None),  # 2039; COMMON
    '›': ('>', None),  # 203A; COMMON
    '⁁': ('/', None),  # 2041; COMMON
    '⁃': ('-', None),  # 2043; COMMON
    '⁄': ('/', None),  # 2044; COMMON
    '⁎': ('*', None),  # 204E; COMMON
    '⁓': ('~', None),  # 2053; COMMON
    '⁚': (':', None),  # 205A; COMMON
    '\u205f': (' ', None),  # 205F; COMMON
    'ℂ': ('C', None),  # 2102; COMMON
    'ℊ': ('g', None),  # 210A; COMMON
    'ℋ': ('H', None),  # 210B; COMMON
    'ℌ': ('H', None),  # 210C; COMMON
    'ℍ': ('H', None),  # 210D; COMMON
    'ℎ': ('h', None),  # 210E; COMMON
    'ℐ': ('l', None),  # 2110; COMMON
    'ℑ': ('l', None),  # 2111; COMMON
    'ℒ': ('L', None),  # 2112; COMMON
    'ℓ': ('l', None),  # 2113; COMMON
    'ℕ': ('N', None),  # 2115; COMMON
    'ℙ': ('P', None),  # 2119; COMMON
    'ℚ': ('Q', None),  # 211A; COMMON
    'ℛ': ('R', None),  # 211B; COMMON
    'ℜ': ('R', None),  # 211C; COMMON
    'ℝ': ('R', None),  # 211D; COMMON
    'ℤ': ('Z', None),  # 2124; COMMON
    'ℨ': ('Z', None),  # 2128; COMMON
    'K': ('K', None),  # 212A; LATIN
    'ℬ': ('B', None),  # 212C; COMMON
    'ℭ': ('C', None),  # 212D; COMMON
    '℮': ('e', None),  # 212E; COMMON
    'ℯ': ('e', None),  # 212F; COMMON
    'ℰ': ('E', None),  # 2130; COMMON
    'ℱ': ('F', None),  # 2131; COMMON
    'ℳ': ('M', None),  # 2133; COMMON
    'ℴ': ('o', None),  # 2134; COMMON
    'ℹ': ('i', None),  # 2139; COMMON
    'ℽ': ('y', None),  # 213D; COMMON
    'ⅅ': ('D', None),  # 2145; COMMON
    'ⅆ': ('d', None),  # 2146; COMMON
    'ⅇ': ('e', None),  # 2147; COMMON
    'ⅈ': ('i', None),  # 2148; COMMON
    'ⅉ': ('j', None),  # 2149; COMMON
    'Ⅰ': ('l', None),  # 2160; LATIN
    'Ⅴ': ('V', None),  # 2164; LATIN
    'Ⅹ': ('X', None),  # 2169; LATIN
    'Ⅼ': ('L', None),  # 216C; LATIN
    'Ⅽ': ('C', None),  # 216D; LATIN
    'Ⅾ': ('D', None),  # 216E; LATIN
    'Ⅿ': ('M', None),  # 216F; LATIN
    'ⅰ': ('i', None),  # 2170; LATIN
    'ⅴ': ('v', None),  # 2174; LATIN
    'ⅹ': ('x', None),  # 2179; LATIN
    'ⅼ': ('l', None),  # 217C; LATIN
    'ⅽ': ('c', None),  # 217D; LATIN
    'ⅾ': ('d', None),  # 217E; LATIN
    '−': ('-', None),  # 2212; COMMON
    '∕': ('/', None),  # 2215; COMMON
    '∖': ('\\', None),  # 2216; COMMON
    '∗': ('*', None),  # 2217; COMMON
    '∣': ('l', None),  # 2223; COMMON
    '∨': ('v', None),  # 2228; COMMON
    '∪': ('U', None),  # 222A; COMMON
    '∶': (':', None),  # 2236; COMMON
    '∼': ('~', None),  # 223C; COMMON
    '⊤': ('T', None),  # 22A4; COMMON
    '⋁': ('v', None),  # 22C1; COMMON
    '⋃': ('U', None),  # 22C3; COMMON
    '⋿': ('E', None),  # 22FF; COMMON
    '⍳': ('i', None),  # 2373; COMMON
    '⍴': ('p', None),  # 2374; COMMON
    '⍺': ('a', None),  # 237A; COMMON
    '⏽': ('l', None),  # 23FD; COMMON
    '╱': ('/', None),  # 2571; COMMON
    '╳': ('X', None),  # 2573; COMMON
    '❨': ('(', None),  # 2768; COMMON
    '❩': (')', None),  # 2769; COMMON
    '❮': ('<', None),  # 276E; COMMON
    '❯': ('>', None),  # 276F; COMMON
    '❲': ('(', None),  # 2772; COMMON
    '❳': (')', None),  # 2773; COMMON
    '❴': ('{', None),  # 2774; COMMON
    '❵': ('}', None),  # 2775; COMMON
    '➕': ('+', None),  # 2795; COMMON
    '➖': ('-', None),  # 2796; COMMON
    '⟋': ('/', None),  # 27CB; COMMON
    '⟍': ('\\', None),  # 27CD; COMMON
    '⟙': ('T', None),  # 27D9; COMMON
    '⤫': ('x', None),  # 292B; COMMON
    '⤬': ('x', None),  # 292C; COMMON
    '⧵': ('\\', None),  # 29F5; COMMON
    '⧸': ('/', None),  # 29F8; COMMON
    '⧹': ('\\', None),  # 29F9; COMMON
    '⨯': ('x', None),  # 2A2F; COMMON
    'ⲅ': ('r', None),  # 2C85; COPTIC
    'Ⲏ': ('H', None),  # 2C8E; COPTIC
    'Ⲓ': ('l', None),  # 2C92; COPTIC
    'Ⲕ': ('K', None),  # 2C94; COPTIC
    'Ⲙ': ('M', None),  # 2C98; COPTIC
    'Ⲛ': ('N', None),  # 2C9A; COPTIC
    'Ⲟ': ('O', None),  # 2C9E; COPTIC
    'ⲟ': ('o', None),  # 2C9F; COPTIC
    'Ⲣ': ('P', None),  # 2CA2; COPTIC
    'ⲣ': ('p', None),  # 2CA3; COPTIC
    'Ⲥ': ('C', None),  # 2CA4; COPTIC
    'ⲥ': ('c', None),  # 2CA5; COPTIC
    'Ⲧ': ('T', None),  # 2CA6; COPTIC
    'Ⲩ': ('Y', None),  # 2CA8; COPTIC
    'Ⲭ': ('X', None),  # 2CAC; COPTIC
    'Ⲻ': ('-', None),  # 2CBA; COPTIC
    'Ⳇ': ('/', None),  # 2CC6; COPTIC
    'Ⳋ': ('9', None),  # 2CCA; COPTIC
    'Ⳍ': ('3', None),  # 2CCC; COPTIC
    'Ⳑ': ('L', None),  # 2CD0; COPTIC
    'Ⳓ': ('6', None),  # 2CD2; COPTIC
    'ⴸ': ('V', None),  # 2D38; TIFINAGH
    'ⴹ': ('E', None),  # 2D39; TIFINAGH
    'ⵏ': ('l', None),  # 2D4F; TIFINAGH
    'ⵑ': ('!', None),  # 2D51; TIFINAGH
    'ⵔ': ('O', None),  # 2D54; TIFINAGH
    'ⵕ': ('Q', None),  # 2D55; TIFINAGH
    'ⵝ': ('X', None),  # 2D5D; TIFINAGH
    '⹀': ('=', None),  # 2E40; COMMON
    '⼂': ('\\', None),  # 2F02; HAN
    '⼃': ('/', None),  # 2F03; HAN
    '〇': ('O', None),  # 3007; HAN
    '〔': ('(', None),  # 3014; COMMON
    '〕': (')', None),  # 3015; COMMON
    '〳': ('/', None),  # 3033; COMMON
    '゠': ('=', None),  # 30A0; COMMON
    'ノ': ('/', 11),  # 30CE; KATAKANA
    '㇓': ('/', None),  # 31D3; COMMON
    '㇔': ('\\', None),  # 31D4; COMMON
    '丶': ('\\', None),  # 4E36; HAN
    '丿': ('/', None),  # 4E3F; HAN
    'ꓐ': ('B', None),  # A4D0; LISU
    'ꓑ': ('P', None),  # A4D1; LISU
    'ꓒ': ('d', None),  # A4D2; LISU
    'ꓓ': ('D', None),  # A4D3; LISU
    'ꓔ': ('T', None),  # A4D4; LISU
    'ꓖ': ('G', None),  # A4D6; LISU
    'ꓗ': ('K', None),  # A4D7; LISU
    'ꓙ': ('J', None),  # A4D9; LISU
    'ꓚ': ('C', None),  # A4DA; LISU
    'ꓜ': ('Z', None),  # A4DC; LISU
    'ꓝ': ('F', None),  # A4DD; LISU
    'ꓟ': ('M', None),  # A4DF; LISU
    'ꓠ': ('N', None),  # A4E0; LISU
    'ꓡ': ('L', None),  # A4E1; LISU
    'ꓢ': ('S', None),  # A4E2; LISU
    'ꓣ': ('R', None),  # A4E3; LISU
    'ꓦ': ('V', None),  # A4E6; LISU
    'ꓧ': ('H', None),  # A4E7; LISU
    'ꓪ': ('W', None),  # A4EA; LISU
    'ꓫ': ('X', None),  # A4EB; LISU
    'ꓬ': ('Y', None),  # A4EC; LISU
    'ꓮ': ('A', None),  # A4EE; LISU
    'ꓰ': ('E', None),  # A4F0; LISU
    'ꓲ': ('l', None),  # A4F2; LISU
    'ꓳ': ('O', None),  # A4F3; LISU
    'ꓴ': ('U', None),  # A4F4; LISU
    'ꓸ': ('.', None),  # A4F8; LISU
    'ꓹ': (',', None),  # A4F9; LISU
    'ꓽ': (':', None),  # A4FD; LISU
    '꓿': ('=', None),  # A4FF; LISU
    '꘎': ('.', None),  # A60E; VAI
    'Ꙅ': ('2', 1),  # A644; CYRILLIC
    'ꙇ': ('i', 1),  # A647; CYRILLIC
    'ꛟ': ('V', None),  # A6DF; BAMUM
    'ꛫ': ('?', None),  # A6EB; BAMUM
    'ꛯ': ('2', None),  # A6EF; BAMUM
    'ꜱ': ('s', None),  # A731; LATIN
    'Ꝛ': ('2', None),  # A75A; LATIN
    'Ꝫ': ('3', None),  # A76A; LATIN
    'Ꝯ': ('9', None),  # A76E; LATIN
    'ꝸ': ('&', None),  # A778; LATIN
    '꞉': (':', None),  # A789; COMMON
    'ꞌ': ("'", None),  # A78C; LATIN
    'Ꞙ': ('F', None),  # A798; LATIN
    'ꞙ': ('f', None),  # A799; LATIN
    'ꞟ': ('u', None),  # A79F; LATIN
    'Ɜ': ('3', None),  # A7AB; LATIN
    'Ʝ': ('J', None),  # A7B2; LATIN
    'Ꭓ': ('X', None),  # A7B3; LATIN
    'Ꞵ': ('B', None),  # A7B4; LATIN
    'ꬲ': ('e', None),  # AB32; LATIN
    'ꬵ': ('f', None),  # AB35; LATIN
    'ꬽ': ('o', None),  # AB3D; LATIN
    'ꭇ': ('r', None),  # AB47; LATIN
    'ꭈ': ('r', None),  # AB48; LATIN
    'ꭎ': ('u', None),  # AB4E; LATIN
    'ꭒ': ('u', None),  # AB52; LATIN
    'ꭚ': ('y', None),  # AB5A; LATIN
    'ꭵ': ('i', None),  # AB75; CHEROKEE
    'ꮁ': ('r', None),  # AB81; CHEROKEE
    'ꮃ': ('w', None),  # AB83; CHEROKEE
    'ꮓ': ('z', None),  # AB93; CHEROKEE
    'ꮩ': ('v', None),  # ABA9; CHEROKEE
    'ꮪ': ('s', None),  # ABAA; CHEROKEE
    'ꮯ': ('c', None),  # ABAF; CHEROKEE
    'ﮦ': ('o', 3),  # FBA6; ARABIC
    'ﮧ': ('o', 3),  # FBA7; ARABIC
    'ﮨ': ('o', 3),  # FBA8; ARABIC
    'ﮩ': ('o', 3),  # FBA9; ARABIC
    'ﮪ': ('o', 3),  # FBAA; ARABIC
    'ﮫ': ('o', 3),  # FBAB; ARABIC
    'ﮬ': ('o', 3),  # FBAC; ARABIC
    'ﮭ': ('o', 3),  # FBAD; ARABIC
    '﴾': ('(', None),  # FD3E; COMMON
    '﴿': (')', None),  # FD3F; COMMON
    '︰': (':', None),  # FE30; COMMON
    '﹍': ('_', None),  # FE4D; COMMON
    '﹎': ('_', None),  # FE4E; COMMON
    '﹏': ('_', None),  # FE4F; COMMON
    '﹘': ('-', None),  # FE58; COMMON
    '﹨': ('\\', None),  # FE68; COMMON
    'ﺍ': ('l', 3),  # FE8D; ARABIC
    'ﺎ': ('l', 3),  # FE8E; ARABIC
    'ﻩ': ('o', 3),  # FEE9; ARABIC
    'ﻪ': ('o', 3),  # FEEA; ARABIC
    'ﻫ': ('o', 3),  # FEEB; ARABIC
    'ﻬ': ('o', 3),  # FEEC; ARABIC
    '！': ('!', None),  # FF01; COMMON
    '＇': ("'", None),  # FF07; COMMON
    '：': (':', None),  # FF1A; COMMON
    'Ａ': ('A', None),  # FF21; LATIN
    'Ｂ': ('B', None),  # FF22; LATIN
    'Ｃ': ('C', None),  # FF23; LATIN
    'Ｅ': ('E', None),  # FF25; LATIN
    'Ｈ': ('H', None),  # FF28; LATIN
    'Ｉ': ('l', None),  # FF29; LATIN
    'Ｊ': ('J', None),  # FF2A; LATIN
    'Ｋ': ('K', None),  # FF2B; LATIN
    'Ｍ': ('M', None),  # FF2D; LATIN
    'Ｎ': ('N', None),  # FF2E; LATIN
    'Ｏ': ('O', None),  # FF2F; LATIN
    'Ｐ': ('P', None),  # FF30; LATIN
    'Ｓ': ('S', None),  # FF33; LATIN
    'Ｔ': ('T', None),  # FF34; LATIN
    'Ｘ': ('X', None),  # FF38; LATIN
    'Ｙ': ('Y', None),  # FF39; LATIN
    'Ｚ': ('Z', None),  # FF3A; LATIN
    '［': ('(', None),  # FF3B; COMMON
    '＼': ('\\', None),  # FF3C; COMMON
    '］': (')', None),  # FF3D; COMMON
    '｀': ("'", None),  # FF40; COMMON
    'ａ': ('a', None),  # FF41; LATIN
    'ｃ': ('c', None),  # FF43; LATIN
    'ｅ': ('e', None),  # FF45; LATIN
    'ｇ': ('g', None),  # FF47; LATIN
    'ｈ': ('h', None),  # FF48; LATIN
    'ｉ': ('i', None),  # FF49; LATIN
    'ｊ': ('j', None),  # FF4A; LATIN
    'ｌ': ('l', None),  # FF4C; LATIN
    'ｏ': ('o', None),  # FF4F; LATIN
    'ｐ': ('p', None),  # FF50; LATIN
    'ｓ': ('s', None),  # FF53; LATIN
    'ｖ': ('v', None),  # FF56; LATIN
    'ｘ': ('x', None),  # FF58; LATIN
    'ｙ': ('y', None),  # FF59; LATIN
    '￨': ('l', None),  # FFE8; COMMON
    '𐊂': ('B', None),  # 10282; LYCIAN
    '𐊆': ('E', None),  # 10286; LYCIAN
    '𐊇': ('F', None),  # 10287; LYCIAN
    '𐊊': ('l', None),  # 1028A; LYCIAN
    '𐊐': ('X', None),  # 10290; LYCIAN
    '𐊒': ('O', None),  # 10292; LYCIAN
    '𐊕': ('P', None),  # 10295; LYCIAN
    '𐊖': ('S', None),  # 10296; LYCIAN
    '𐊗': ('T', None),  # 10297; LYCIAN
    '𐊛': ('+', None),  # 1029B; LYCIAN
    '𐊠': ('A', None),  # 102A0; CARIAN
    '𐊡': ('B', None),  # 102A1; CARIAN
    '𐊢': ('C', None),  # 102A2; CARIAN
    '𐊥': ('F', None),  # 102A5; CARIAN
    '𐊫': ('O', None),  # 102AB; CARIAN
    '𐊰': ('M', None),  # 102B0; CARIAN
    '𐊱': ('T', None),  # 102B1; CARIAN
    '𐊲': ('Y', None),  # 102B2; CARIAN
    '𐊴': ('X', None),  # 102B4; CARIAN
    '𐋏': ('H', None),  # 102CF; CARIAN
    '𐋵': ('Z', None),  # 102F5; COMMON
    '𐌁': ('B', None),  # 10301; OLD_ITALIC
    '𐌂': ('C', None),  # 10302; OLD_ITALIC
    '𐌉': ('l', None),  # 10309; OLD_ITALIC
    '𐌑': ('M', None),  # 10311; OLD_ITALIC
    '𐌕': ('T', None),  # 10315; OLD_ITALIC
    '𐌗': ('X', None),  # 10317; OLD_ITALIC
    '𐌚': ('8', None),  # 1031A; OLD_ITALIC
    '𐌟': ('*', None),  # 1031F; OLD_ITALIC
    '𐌠': ('l', None),  # 10320; OLD_ITALIC
    '𐌢': ('X', None),  # 10322; OLD_ITALIC
    '𐐄': ('O', None),  # 10404; DESERET
    '𐐕': ('C', None),  # 10415; DESERET
    '𐐛': ('L', None),  # 1041B; DESERET
    '𐐠': ('S', None),  # 10420; DESERET
    '𐐬': ('o', None),  # 1042C; DESERET
    '𐐽': ('c', None),  # 1043D; DESERET
    '𐑈': ('s', None),  # 10448; DESERET
    '𐒴': ('R', None),  # 104B4; OSAGE
    '𐓂': ('O', None),  # 104C2; OSAGE
    '𐓎': ('U', None),  # 104CE; OSAGE
    '𐓒': ('7', None),  # 104D2; OSAGE
    '𐓪': ('o', None),  # 104EA; OSAGE
    '𐓶': ('u', None),  # 104F6; OSAGE
    '𐔓': ('N', None),  # 10513; ELBASAN
    '𐔖': ('O', None),  # 10516; ELBASAN
    '𐔘': ('K', None),  # 10518; ELBASAN
    '𐔜': ('C', None),  # 1051C; ELBASAN
    '𐔝': ('V', None),  # 1051D; ELBASAN
    '𐔥': ('F', None),  # 10525; ELBASAN
    '𐔦': ('L', None),  # 10526; ELBASAN
    '𐔧': ('X', None),  # 10527; ELBASAN
    '𐩐': ('.', None),  # 10A50; KHAROSHTHI
    '𑓐': ('O', None),  # 114D0; TIRHUTA
    '𑜆': ('v', None),  # 11706; AHOM
    '𑜊': ('w', None),  # 1170A; AHOM
    '𑜎': ('w', None),  # 1170E; AHOM
    '𑜏': ('w', None),  # 1170F; AHOM
    '𑢠': ('V', None),  # 118A0; WARANG_CITI
    '𑢢': ('F', None),  # 118A2; WARANG_CITI
    '𑢣': ('L', None),  # 118A3; WARANG_CITI
    '𑢤': ('Y', None),  # 118A4; WARANG_CITI
    '𑢦': ('E', None),  # 118A6; WARANG_CITI
    '𑢩': ('Z', None),  # 118A9; WARANG_CITI
    '𑢬': ('9', None),  # 118AC; WARANG_CITI
    '𑢮': ('E', None),  # 118AE; WARANG_CITI
    '𑢯': ('4', None),  # 118AF; WARANG_CITI
    '𑢲': ('L', None),  # 118B2; WARANG_CITI
    '𑢵': ('O', None),  # 118B5; WARANG_CITI
    '𑢸': ('U', None),  # 118B8; WARANG_CITI
    '𑢻': ('5', None),  # 118BB; WARANG_CITI
    '𑢼': ('T', None),  # 118BC; WARANG_CITI
    '𑣀': ('v', None),  # 118C0; WARANG_CITI
    '𑣁': ('s', None),  # 118C1; WARANG_CITI
    '𑣂': ('F', None),  # 118C2; WARANG_CITI
    '𑣃': ('i', None),  # 118C3; WARANG_CITI
    '𑣄': ('z', None),  # 118C4; WARANG_CITI
    '𑣆': ('7', None),  # 118C6; WARANG_CITI
    '𑣈': ('o', None),  # 118C8; WARANG_CITI
    '𑣊': ('3', None),  # 118CA; WARANG_CITI
    '𑣌': ('9', None),  # 118CC; WARANG_CITI
    '𑣕': ('6', None),  # 118D5; WARANG_CITI
    '𑣖': ('9', None),  # 118D6; WARANG_CITI
    '𑣗': ('o', None),  # 118D7; WARANG_CITI
    '𑣘': ('u', None),  # 118D8; WARANG_CITI
    '𑣜': ('y', None),  # 118DC; WARANG_CITI
    '𑣠': ('O', None),  # 118E0; WARANG_CITI
    '𑣥': ('Z', None),  # 118E5; WARANG_CITI
    '𑣦': ('W', None),  # 118E6; WARANG_CITI
    '𑣩': ('C', None),  # 118E9; WARANG_CITI
    '𑣬': ('X', None),  # 118EC; WARANG_CITI
    '𑣯': ('W', None),  # 118EF; WARANG_CITI
    '𑣲': ('C', None),  # 118F2; WARANG_CITI
    '𖼈': ('V', None),  # 16F08; MIAO
    '𖼊': ('T', None),  # 16F0A; MIAO
    '𖼖': ('L', None),  # 16F16; MIAO
    '𖼨': ('l', None),  # 16F28; MIAO
    '𖼵': ('R', None),  # 16F35; MIAO
    '𖼺': ('S', None),  # 16F3A; MIAO
    '𖼻': ('3', None),  # 16F3B; MIAO
    '𖼿': ('>', None),  # 16F3F; MIAO
    '𖽀': ('A', None),  # 16F40; MIAO
    '𖽂': ('U', None),  # 16F42; MIAO
    '𖽃': ('Y', None),  # 16F43; MIAO
    '𖽑': ("'", None),  # 16F51; MIAO
    '𖽒': ("'", None),  # 16F52; MIAO
    '𝄔': ('{', None),  # 1D114; COMMON
    '𝅭': ('.', None),  # 1D16D; COMMON
    '𝈆': ('3', 0),  # 1D206; GREEK
    '𝈍': ('V', 0),  # 1D20D; GREEK
    '𝈏': ('\\', 0),  # 1D20F; GREEK
    '𝈒': ('7', 0),  # 1D212; GREEK
    '𝈓': ('F', 0),  # 1D213; GREEK
    '𝈖': ('R', 0),  # 1D216; GREEK
    '𝈪': ('L', 0),  # 1D22A; GREEK
    '𝈶': ('<', 0),  # 1D236; GREEK
    '𝈷': ('>', 0),  # 1D237; GREEK
    '𝈺': ('/', 0),  # 1D23A; GREEK
    '𝈻': ('\\', 0),  # 1D23B; GREEK
    '𝐀': ('A', None),  # 1D400; COMMON
    '𝐁': ('B', None),  # 1D401; COMMON
    '𝐂': ('C', None),  # 1D402; COMMON
    '𝐃': ('D', None),  # 1D403; COMMON
    '𝐄': ('E', None),  # 1D404; COMMON
    '𝐅': ('F', None),  # 1D405; COMMON
    '𝐆': ('G', None),  # 1D406; COMMON
    '𝐇': ('H', None),  # 1D407; COMMON
    '𝐈': ('l', None),  # 1D408; COMMON
    '𝐉': ('J', None),  # 1D409; COMMON
    '𝐊': ('K', None),  # 1D40A; COMMON
    '𝐋': ('L', None),  # 1D40B; COMMON
    '𝐌': ('M', None),  # 1D40C; COMMON
    '𝐍': ('N', None),  # 1D40D; COMMON
    '𝐎': ('O', None),  # 1D40E; COMMON
    '𝐏': ('P', None),  # 1D40F; COMMON
    '𝐐': ('Q', None),  # 1D410; COMMON
    '𝐑': ('R', None),  # 1D411; COMMON
    '𝐒': ('S', None),  # 1D412; COMMON
    '𝐓': ('T', None),  # 1D413; COMMON
    '𝐔': ('U', None),  # 1D414; COMMON
    '𝐕': ('V', None),  # 1D415; COMMON
    '𝐖': ('W', None),  # 1D416; COMMON
    '𝐗': ('X', None),  # 1D417; COMMON
    '𝐘': ('Y', None),  # 1D418; COMMON
    '𝐙': ('Z', None),  # 1D419; COMMON
    '𝐚': ('a', None),  # 1D41A; COMMON
    '𝐛': ('b', None),  # 1D41B; COMMON
    '𝐜': ('c', None),  # 1D41C; COMMON
    '𝐝': ('d', None),  # 1D41D; COMMON
    '𝐞': ('e', None),  # 1D41E; COMMON
    '𝐟': ('f', None),  # 1D41F; COMMON
    '𝐠': ('g', None),  # 1D420; COMMON
    '𝐡': ('h', None),  # 1D421; COMMON
    '𝐢': ('i', None),  # 1D422; COMMON
    '𝐣': ('j', None),  # 1D423; COMMON
    '𝐤': ('k', None),  # 1D424; COMMON
    '𝐥': ('l', None),  # 1D425; COMMON
    '𝐧': ('n', None),  # 1D427; COMMON
    '𝐨': ('o', None),  # 1D428; COMMON
    '𝐩': ('p', None),  # 1D429; COMMON
    '𝐪': ('q', None),  # 1D42A; COMMON
    '𝐫': ('r', None),  # 1D42B; COMMON
    '𝐬': ('s', None),  # 1D42C; COMMON
    '𝐭': ('t', None),  # 1D42D; COMMON
    '𝐮': ('u', None),  # 1D42E; COMMON
    '𝐯': ('v', None),  # 1D42F; COMMON
    '𝐰': ('w', None),  # 1D430; COMMON
    '𝐱': ('x', None),  # 1D431; COMMON
    '𝐲': ('y', None),  # 1D432; COMMON
    '𝐳': ('z', None),  # 1D433; COMMON
    '𝐴': ('A', None),  # 1D434; COMMON
    '𝐵': ('B', None),  # 1D435; COMMON
    '𝐶': ('C', None),  # 1D436; COMMON
    '𝐷': ('D', None),  # 1D437; COMMON
    '𝐸': ('E', None),  # 1D438; COMMON
    '𝐹': ('F', None),  # 1D439; COMMON
    '𝐺': ('G', None),  # 1D43A; COMMON
    '𝐻': ('H', None),  # 1D43B; COMMON
    '𝐼': ('l', None),  # 1D43C; COMMON
    '𝐽': ('J', None),  # 1D43D; COMMON
    '𝐾': ('K', None),  # 1D43E; COMMON
    '𝐿': ('L', None),  # 1D43F; COMMON
    '𝑀': ('M', None),  # 1D440; COMMON
    '𝑁': ('N', None),  # 1D441; COMMON
    '𝑂': ('O', None),  # 1D442; COMMON
    '𝑃': ('P', None),  # 1D443; COMMON
    '𝑄': ('Q', None),  # 1D444; COMMON
    '𝑅': ('R', None),  # 1D445; COMMON
    '𝑆': ('S', None),  # 1D446; COMMON
    '𝑇': ('T', None),  # 1D447; COMMON
    '𝑈': ('U', None),  # 1D448; COMMON
    '𝑉': ('V', None),  # 1D449; COMMON
    '𝑊': ('W', None),  # 1D44A; COMMON
    '𝑋': ('X', None),  # 1D44B; COMMON
    '𝑌': ('Y', None),  # 1D44C; COMMON
    '𝑍': ('Z', None),  # 1D44D; COMMON
    '𝑎': ('a', None),  # 1D44E; COMMON
    '𝑏': ('b', None),  # 1D44F; COMMON
    '𝑐': ('c', None),  # 1D450; COMMON
    '𝑑': ('d', None),  # 1D451; COMMON
    '𝑒': ('e', None),  # 1D452; COMMON
    '𝑓': ('f', None),  # 1D453; COMMON
    '𝑔': ('g', None),  # 1D454; COMMON
    '𝑖': ('i', None),  # 1D456; COMMON
    '𝑗': ('j', None),  # 1D457; COMMON
    '𝑘': ('k', None),  # 1D458; COMMON
    '𝑙': ('l', None),  # 1D459; COMMON
    '𝑛': ('n', None),  # 1D45B; COMMON
    '𝑜': ('o', None),  # 1D45C; COMMON
    '𝑝': ('p', None),  # 1D45D; COMMON
    '𝑞': ('q', None),  # 1D45E; COMMON
    '𝑟': ('r', None),  # 1D45F; COMMON
    '𝑠': ('s', None),  # 1D460; COMMON
    '𝑡': ('t', None),  # 1D461; COMMON
    '𝑢': ('u', None),  # 1D462; COMMON
    '𝑣': ('v', None),  # 1D463; COMMON
    '𝑤': ('w', None),  # 1D464; COMMON
    '𝑥': ('x', None),  # 1D465; COMMON
    '𝑦': ('y', None),  # 1D466; COMMON
    '𝑧': ('z', None),  # 1D467; COMMON
    '𝑨': ('A', None),  # 1D468; COMMON
    '𝑩': ('B', None),  # 1D469; COMMON
    '𝑪': ('C', None),  # 1D46A; COMMON
    '𝑫': ('D', None),  # 1D46B; COMMON
    '𝑬': ('E', None),  # 1D46C; COMMON
    '𝑭': ('F', None),  # 1D46D; COMMON
    '𝑮': ('G', None),  # 1D46E; COMMON
    '𝑯': ('H', None),  # 1D46F; COMMON
    '𝑰': ('l', None),  # 1D470; COMMON
    '𝑱': ('J', None),  # 1D471; COMMON
    '𝑲': ('K', None),  # 1D472; COMMON
    '𝑳': ('L', None),  # 1D473; COMMON
    '𝑴': ('M', None),  # 1D474; COMMON
    '𝑵': ('N', None),  # 1D475; COMMON
    '𝑶': ('O', None),  # 1D476; COMMON
    '𝑷': ('P', None),  # 1D477; COMMON
    '𝑸': ('Q', None),  # 1D478; COMMON
    '𝑹': ('R', None),  # 1D479; COMMON
    '𝑺': ('S', None),  # 1D47A; COMMON
    '𝑻': ('T', None),  # 1D47B; COMMON
    '𝑼': ('U', None),  # 1D47C; COMMON
    '𝑽': ('V', None),  # 1D47D; COMMON
    '𝑾': ('W', None),  # 1D47E; COMMON
    '𝑿': ('X', None),  # 1D47F; COMMON
    '𝒀': ('Y', None),  # 1D480; COMMON
    '𝒁': ('Z', None),  # 1D481; COMMON
    '𝒂': ('a', None),  # 1D482; COMMON
    '𝒃': ('b', None),  # 1D483; COMMON
    '𝒄': ('c', None),  # 1D484; COMMON
    '𝒅': ('d', None),  # 1D485; COMMON
    '𝒆': ('e', None),  # 1D486; COMMON
    '𝒇': ('f', None),  # 1D487; COMMON
    '𝒈': ('g', None),  # 1D488; COMMON
    '𝒉': ('h', None),  # 1D489; COMMON
    '𝒊': ('i', None),  # 1D48A; COMMON
    '𝒋': ('j', None),  # 1D48B; COMMON
    '𝒌': ('k', None),  # 1D48C; COMMON
    '𝒍': ('l', None),  # 1D48D; COMMON
    '𝒏': ('n', None),  # 1D48F; COMMON
    '𝒐': ('o', None),  # 1D490; COMMON
    '𝒑': ('p', None),  # 1D491; COMMON
    '𝒒': ('q', None),  # 1D492; COMMON
    '𝒓': ('r', None),  # 1D493; COMMON
    '𝒔': ('s', None),  # 1D494; COMMON
    '𝒕': ('t', None),  # 1D495; COMMON
    '𝒖': ('u', None),  # 1D496; COMMON
    '𝒗': ('v', None),  # 1D497; COMMON
    '𝒘': ('w', None),  # 1D498; COMMON
    '𝒙': ('x', None),  # 1D499; COMMON
    '𝒚': ('y', None),  # 1D49A; COMMON
    '𝒛': ('z', None),  # 1D49B; COMMON
    '𝒜': ('A', None),  # 1D49C; COMMON
    '𝒞': ('C', None),  # 1D49E; COMMON
    '𝒟': ('D', None),  # 1D49F; COMMON
    '𝒢': ('G', None),  # 1D4A2; COMMON
    '𝒥': ('J', None),  # 1D4A5; COMMON
    '𝒦': ('K', None),  # 1D4A6; COMMON
    '𝒩': ('N', None),  # 1D4A9; COMMON
    '𝒪': ('O', None),  # 1D4AA; COMMON
    '𝒫': ('P', None),  # 1D4AB; COMMON
    '𝒬': ('Q', None),  # 1D4AC; COMMON
    '𝒮': ('S', None),  # 1D4AE; COMMON
    '𝒯': ('T', None),  # 1D4AF; COMMON
    '𝒰': ('U', None),  # 1D4B0; COMMON
    '𝒱': ('V', None),  # 1D4B1; COMMON
    '𝒲': ('W', None),  # 1D4B2; COMMON
    '𝒳': ('X', None),  # 1D4B3; COMMON
    '𝒴': ('Y', None),  # 1D4B4; COMMON
    '𝒵': ('Z', None),  # 1D4B5; COMMON
    '𝒶': ('a', None),  # 1D4B6; COMMON
    '𝒷': ('b', None),  # 1D4B7; COMMON
    '𝒸': ('c', None),  # 1D4B8; COMMON
    '𝒹': ('d', None),  # 1D4B9; COMMON
    '𝒻': ('f', None),  # 1D4BB; COMMON
    '𝒽': ('h', None),  # 1D4BD; COMMON
    '𝒾': ('i', None),  # 1D4BE; COMMON
    '𝒿': ('j', None),  # 1D4BF; COMMON
    '𝓀': ('k', None),  # 1D4C0; COMMON
    '𝓁': ('l', None),  # 1D4C1; COMMON
    '𝓃': ('n', None),  # 1D4C3; COMMON
    '𝓅': ('p', None),  # 1D4C5; COMMON
    '𝓆': ('q', None),  # 1D4C6; COMMON
    '𝓇': ('r', None),  # 1D4C7; COMMON
    '𝓈': ('s', None),  # 1D4C8; COMMON
    '𝓉': ('t', None),  # 1D4C9; COMMON
    '𝓊': ('u', None),  # 1D4CA; COMMON
    '𝓋': ('v', None),  # 1D4CB; COMMON
    '𝓌': ('w', None),  # 1D4CC; COMMON
    '𝓍': ('x', None),  # 1D4CD; COMMON
    '𝓎': ('y', None),  # 1D4CE; COMMON
    '𝓏': ('z', None),  # 1D4CF; COMMON
    '𝓐': ('A', None),  # 1D4D0; COMMON
    '𝓑': ('B', None),  # 1D4D1; COMMON
    '𝓒': ('C', None),  # 1D4D2; COMMON
    '𝓓': ('D', None),  # 1D4D3; COMMON
    '𝓔': ('E', None),  # 1D4D4; COMMON
    '𝓕': ('F', None),  # 1D4D5; COMMON
    '𝓖': ('G', None),  # 1D4D6; COMMON
    '𝓗': ('H', None),  # 1D4D7; COMMON
    '𝓘': ('l', None),  # 1D4D8; COMMON
    '𝓙': ('J', None),  # 1D4D9; COMMON
    '𝓚': ('K', None),  # 1D4DA; COMMON
    '𝓛': ('L', None),  # 1D4DB; COMMON
    '𝓜': ('M', None),  # 1D4DC; COMMON
    '𝓝': ('N', None),  # 1D4DD; COMMON
    '𝓞': ('O', None),  # 1D4DE; COMMON
    '𝓟': ('P', None),  # 1D4DF; COMMON
    '𝓠': ('Q', None),  # 1D4E0; COMMON
    '𝓡': ('R', None),  # 1D4E1; COMMON
    '𝓢': ('S', None),  # 1D4E2; COMMON
    '𝓣': ('T', None),  # 1D4E3; COMMON
    '𝓤': ('U', None),  # 1D4E4; COMMON
    '𝓥': ('V', None),  # 1D4E5; COMMON
    '𝓦': ('W', None),  # 1D4E6; COMMON
    '𝓧': ('X', None),  # 1D4E7; COMMON
    '𝓨': ('Y', None),  # 1D4E8; COMMON
    '𝓩': ('Z', None),  # 1D4E9; COMMON
    '𝓪': ('a', None),  # 1D4EA; COMMON
    '𝓫': ('b', None),  # 1D4EB; COMMON
    '𝓬': ('c', None),  # 1D4EC; COMMON
    '𝓭': ('d', None),  # 1D4ED; COMMON
    '𝓮': ('e', None),  # 1D4EE; COMMON
    '𝓯': ('f', None),  # 1D4EF; COMMON
    '𝓰': ('g', None),  # 1D4F0; COMMON
    '𝓱': ('h', None),  # 1D4F1; COMMON
    '𝓲': ('i', None),  # 1D4F2; COMMON
    '𝓳': ('j', None),  # 1D4F3; COMMON
    '𝓴': ('k', None),  # 1D4F4; COMMON
    '𝓵': ('l', None),  # 1D4F5; COMMON
    '𝓷': ('n', None),  # 1D4F7; COMMON
    '𝓸': ('o', None),  # 1D4F8; COMMON
    '𝓹': ('p', None),  # 1D4F9; COMMON
    '𝓺': ('q', None),  # 1D4FA; COMMON
    '𝓻': ('r', None),  # 1D4FB; COMMON
    '𝓼': ('s', None),  # 1D4FC; COMMON
    '𝓽': ('t', None),  # 1D4FD; COMMON
    '𝓾': ('u', None),  # 1D4FE; COMMON
    '𝓿': ('v', None),  # 1D4FF; COMMON
    '𝔀': ('w', None),  # 1D500; COMMON
    '𝔁': ('x', None),  # 1D501; COMMON
    '𝔂': ('y', None),  # 1D502; COMMON
    '𝔃': ('z', None),  # 1D503; COMMON
    '𝔄': ('A', None),  # 1D504; COMMON
    '𝔅': ('B', None),  # 1D505; COMMON
    '𝔇': ('D', None),  # 1D507; COMMON
    '𝔈': ('E', None),  # 1D508; COMMON
    '𝔉': ('F', None),  # 1D509; COMMON
    '𝔊': ('G', None),  # 1D50A; COMMON
    '𝔍': ('J', None),  # 1D50D; COMMON
    '𝔎': ('K', None),  # 1D50E; COMMON
    '𝔏': ('L', None),  # 1D50F; COMMON
    '𝔐': ('M', None),  # 1D510; COMMON
    '𝔑': ('N', None),  # 1D511; COMMON
    '𝔒': ('O', None),  # 1D512; COMMON
    '𝔓': ('P', None),  # 1D513; COMMON
    '𝔔': ('Q', None),  # 1D514; COMMON
    '𝔖': ('S', None),  # 1D516; COMMON
    '𝔗': ('T', None),  # 1D517; COMMON
    '𝔘': ('U', None),  # 1D518; COMMON
    '𝔙': ('V', None),  # 1D519; COMMON
    '𝔚': ('W', None),  # 1D51A; COMMON
    '𝔛': ('X', None),  # 1D51B; COMMON
    '𝔜': ('Y', None),  # 1D51C; COMMON
    '𝔞': ('a', None),  # 1D51E; COMMON
    '𝔟': ('b', None),  # 1D51F; COMMON
    '𝔠': ('c', None),  # 1D520; COMMON
    '𝔡': ('d', None),  # 1D521; COMMON
    '𝔢': ('e', None),  # 1D522; COMMON
    '𝔣': ('f', None),  # 1D523; COMMON
    '𝔤': ('g', None),  # 1D524; COMMON
    '𝔥': ('h', None),  # 1D525; COMMON
    '𝔦': ('i', None),  # 1D526; COMMON
    '𝔧': ('j', None),  # 1D527; COMMON
    '𝔨': ('k', None),  # 1D528; COMMON
    '𝔩': ('l', None),  # 1D529; COMMON
    '𝔫': ('n', None),  # 1D52B; COMMON
    '𝔬': ('o', None),  # 1D52C; COMMON
    '𝔭': ('p', None),  # 1D52D; COMMON
    '𝔮': ('q', None),  # 1D52E; COMMON
    '𝔯': ('r', None),  # 1D52F; COMMON
    '𝔰': ('s', None),  # 1D530; COMMON
    '𝔱': ('t', None),  # 1D531; COMMON
    '𝔲': ('u', None),  # 1D532; COMMON
    '𝔳': ('v', None),  # 1D533; COMMON
    '𝔴': ('w', None),  # 1D534; COMMON
    '𝔵': ('x', None),  # 1D535; COMMON
    '𝔶': ('y', None),  # 1D536; COMMON
    '𝔷': ('z', None),  # 1D537; COMMON
    '𝔸': ('A', None),  # 1D538; COMMON
    '𝔹': ('B', None),  # 1D539; COMMON
    '𝔻': ('D', None),  # 1D53B; COMMON
    '𝔼': ('E', None),  # 1D53C; COMMON
    '𝔽': ('F', None),  # 1D53D; COMMON
    '𝔾': ('G', None),  # 1D53E; COMMON
    '𝕀': ('l', None),  # 1D540; COMMON
    '𝕁': ('J', None),  # 1D541; COMMON
    '𝕂': ('K', None),  # 1D542; COMMON
    '𝕃': ('L', None),  # 1D543; COMMON
    '𝕄': ('M', None),  # 1D544; COMMON
    '𝕆': ('O', None),  # 1D546; COMMON
    '𝕊': ('S', None),  # 1D54A; COMMON
    '𝕋': ('T', None),  # 1D54B; COMMON
    '𝕌': ('U', None),  # 1D54C; COMMON
    '𝕍': ('V', None),  # 1D54D; COMMON
    '𝕎': ('W', None),  # 1D54E; COMMON
    '𝕏': ('X', None),  # 1D54F; COMMON
    '𝕐': ('Y', None),  # 1D550; COMMON
    '𝕒': ('a', None),  # 1D552; COMMON
    '𝕓': ('b', None),  # 1D553; COMMON
    '𝕔': ('c', None),  # 1D554; COMMON
    '𝕕': ('d', None),  # 1D555; COMMON
    '𝕖': ('e', None),  # 1D556; COMMON
    '𝕗': ('f', None),  # 1D557; COMMON
    '𝕘': ('g', None),  # 1D558; COMMON
    '𝕙': ('h', None),  # 1D559; COMMON
    '𝕚': ('i', None),  # 1D55A; COMMON
    '𝕛': ('j', None),  # 1D55B; COMMON
    '𝕜': ('k', None),  # 1D55C; COMMON
    '𝕝': ('l', None),  # 1D55D; COMMON
    '𝕟': ('n', None),  # 1D55F; COMMON
    '𝕠': ('o', None),  # 1D560; COMMON
    '𝕡': ('p', None),  # 1D561; COMMON
    '𝕢': ('q', None),  # 1D562; COMMON
    '𝕣': ('r', None),  # 1D563; COMMON
    '𝕤': ('s', None),  # 1D564; COMMON
    '𝕥': ('t', None),  # 1D565; COMMON
    '𝕦': ('u', None),  # 1D566; COMMON
    '𝕧': ('v', None),  # 1D567; COMMON
    '𝕨': ('w', None),  # 1D568; COMMON
    '𝕩': ('x', None),  # 1D569; COMMON
    '𝕪': ('y', None),  # 1D56A; COMMON
    '𝕫': ('z', None),  # 1D56B; COMMON
    '𝕬': ('A', None),  # 1D56C; COMMON
    '𝕭': ('B', None),  # 1D56D; COMMON
    '𝕮': ('C', None),  # 1D56E; COMMON
    '𝕯': ('D', None),  # 1D56F; COMMON
    '𝕰': ('E', None),  # 1D570; COMMON
    '𝕱': ('F', None),  # 1D571; COMMON
    '𝕲': ('G', None),  # 1D572; COMMON
    '𝕳': ('H', None),  # 1D573; COMMON
    '𝕴': ('l', None),  # 1D574; COMMON
    '𝕵': ('J', None),  # 1D575; COMMON
    '𝕶': ('K', None),  # 1D576; COMMON
    '𝕷': ('L', None),  # 1D577; COMMON
    '𝕸': ('M', None),  # 1D578; COMMON
    '𝕹': ('N', None),  # 1D579; COMMON
    '𝕺': ('O', None),  # 1D57A; COMMON
    '𝕻': ('P', None),  # 1D57B; COMMON
    '𝕼': ('Q', None),  # 1D57C; COMMON
    '𝕽': ('R', None),  # 1D57D; COMMON
    '𝕾': ('S', None),  # 1D57E; COMMON
    '𝕿': ('T', None),  # 1D57F; COMMON
    '𝖀': ('U', None),  # 1D580; COMMON
    '𝖁': ('V', None),  # 1D581; COMMON
    '𝖂': ('W', None),  # 1D582; COMMON
    '𝖃': ('X', None),  # 1D583; COMMON
    '𝖄': ('Y', None),  # 1D584; COMMON
    '𝖅': ('Z', None),  # 1D585; COMMON
    '𝖆': ('a', None),  # 1D586; COMMON
    '𝖇': ('b', None),  # 1D587; COMMON
    '𝖈': ('c', None),  # 1D588; COMMON
    '𝖉': ('d', None),  # 1D589; COMMON
    '𝖊': ('e', None),  # 1D58A; COMMON
    '𝖋': ('f', None),  # 1D58B; COMMON
    '𝖌': ('g', None),  # 1D58C; COMMON
    '𝖍': ('h', None),  # 1D58D; COMMON
    '𝖎': ('i', None),  # 1D58E; COMMON
    '𝖏': ('j', None),  # 1D58F; COMMON
    '𝖐': ('k', None),  # 1D590; COMMON
    '𝖑': ('l', None),  # 1D591; COMMON
    '𝖓': ('n', None),  # 1D593; COMMON
    '𝖔': ('o', None),  # 1D594; COMMON
    '𝖕': ('p', None),  # 1D595; COMMON
    '𝖖': ('q', None),  # 1D596; COMMON
    '𝖗': ('r', None),  # 1D597; COMMON
    '𝖘': ('s', None),  # 1D598; COMMON
    '𝖙': ('t', None),  # 1D599; COMMON
    '𝖚': ('u', None),  # 1D59A; COMMON
    '𝖛': ('v', None),  # 1D59B; COMMON
    '𝖜': ('w', None),  # 1D59C; COMMON
    '𝖝': ('x', None),  # 1D59D; COMMON
    '𝖞': ('y', None),  # 1D59E; COMMON
    '𝖟': ('z', None),  # 1D59F; COMMON
    '𝖠': ('A', None),  # 1D5A0; COMMON
    '𝖡': ('B', None),  # 1D5A1; COMMON
    '𝖢': ('C', None),  # 1D5A2; COMMON
    '𝖣': ('D', None),  # 1D5A3; COMMON
    '𝖤': ('E', None),  # 1D5A4; COMMON
    '𝖥': ('F', None),  # 1D5A5; COMMON
    '𝖦': ('G', None),  # 1D5A6; COMMON
    '𝖧': ('H', None),  # 1D5A7; COMMON
    '𝖨': ('l', None),  # 1D5A8; COMMON
    '𝖩': ('J', None),  # 1D5A9; COMMON
    '𝖪': ('K', None),  # 1D5AA; COMMON
    '𝖫': ('L', None),  # 1D5AB; COMMON
    '𝖬': ('M', None),  # 1D5AC; COMMON
    '𝖭': ('N', None),  # 1D5AD; COMMON
    '𝖮': ('O', None),  # 1D5AE; COMMON
    '𝖯': ('P', None),  # 1D5AF; COMMON
    '𝖰': ('Q', None),  # 1D5B0; COMMON
    '𝖱': ('R', None),  # 1D5B1; COMMON
    '𝖲': ('S', None),  # 1D5B2; COMMON
    '𝖳': ('T', None),  # 1D5B3; COMMON
    '𝖴': ('U', None),  # 1D5B4; COMMON
    '𝖵': ('V', None),  # 1D5B5; COMMON
    '𝖶': ('W', None),  # 1D5B6; COMMON
    '𝖷': ('X', None),  # 1D5B7; COMMON
    '𝖸': ('Y', None),  # 1D5B8; COMMON
    '𝖹': ('Z', None),  # 1D5B9; COMMON
    '𝖺': ('a', None),  # 1D5BA; COMMON
    '𝖻': ('b', None),  # 1D5BB; COMMON
    '𝖼': ('c', None),  # 1D5BC; COMMON
    '𝖽': ('d', None),  # 1D5BD; COMMON
    '𝖾': ('e', None),  # 1D5BE; COMMON
    '𝖿': ('f', None),  # 1D5BF; COMMON
    '𝗀': ('g', None),  # 1D5C0; COMMON
    '𝗁': ('h', None),  # 1D5C1; COMMON
    '𝗂': ('i', None),  # 1D5C2; COMMON
    '𝗃': ('j', None),  # 1D5C3; COMMON
    '𝗄': ('k', None),  # 1D5C4; COMMON
    '𝗅': ('l', None),  # 1D5C5; COMMON
    '𝗇': ('n', None),  # 1D5C7; COMMON
    '𝗈': ('o', None),  # 1D5C8; COMMON
    '𝗉': ('p', None),  # 1D5C9; COMMON
    '𝗊': ('q', None),  # 1D5CA; COMMON
    '𝗋': ('r', None),  # 1D5CB; COMMON
    '𝗌': ('s', None),  # 1D5CC; COMMON
    '𝗍': ('t', None),  # 1D5CD; COMMON
    '𝗎': ('u', None),  # 1D5CE; COMMON
    '𝗏': ('v', None),  # 1D5CF; COMMON
    '𝗐': ('w', None),  # 1D5D0; COMMON
    '𝗑': ('x', None),  # 1D5D1; COMMON
    '𝗒': ('y', None),  # 1D5D2; COMMON
    '𝗓': ('z', None),  # 1D5D3; COMMON
    '𝗔': ('A', None),  # 1D5D4; COMMON
    '𝗕': ('B', None),  # 1D5D5; COMMON
    '𝗖': ('C', None),  # 1D5D6; COMMON
    '𝗗': ('D', None),  # 1D5D7; COMMON
    '𝗘': ('E', None),  # 1D5D8; COMMON
    '𝗙': ('F', None),  # 1D5D9; COMMON
    '𝗚': ('G', None),  # 1D5DA; COMMON
    '𝗛': ('H', None),  # 1D5DB; COMMON
    '𝗜': ('l', None),  # 1D5DC; COMMON
    '𝗝': ('J', None),  # 1D5DD; COMMON
    '𝗞': ('K', None),  # 1D5DE; COMMON
    '𝗟': ('L', None),  # 1D5DF; COMMON
    '𝗠': ('M', None),  # 1D5E0; COMMON
    '𝗡': ('N', None),  # 1D5E1; COMMON
    '𝗢': ('O', None),  # 1D5E2; COMMON
    '𝗣': ('P', None),  # 1D5E3; COMMON
    '𝗤': ('Q', None),  # 1D5E4; COMMON
    '𝗥': ('R', None),  # 1D5E5; COMMON
    '𝗦': ('S', None),  # 1D5E6; COMMON
    '𝗧': ('T', None),  # 1D5E7; COMMON
    '𝗨': ('U', None),  # 1D5E8; COMMON
    '𝗩': ('V', None),  # 1D5E9; COMMON
    '𝗪': ('W', None),  # 1D5EA; COMMON
    '𝗫': ('X', None),  # 1D5EB; COMMON
    '𝗬': ('Y', None),  # 1D5EC; COMMON
    '𝗭': ('Z', None),  # 1D5ED; COMMON
    '𝗮': ('a', None),  # 1D5EE; COMMON
    '𝗯': ('b', None),  # 1D5EF; COMMON
    '𝗰': ('c', None),  # 1D5F0; COMMON
    '𝗱': ('d', None),  # 1D5F1; COMMON
    '𝗲': ('e', None),  # 1D5F2; COMMON
    '𝗳': ('f', None),  # 1D5F3; COMMON
    '𝗴': ('g', None),  # 1D5F4; COMMON
    '𝗵': ('h', None),  # 1D5F5; COMMON
    '𝗶': ('i', None),  # 1D5F6; COMMON
    '𝗷': ('j', None),  # 1D5F7; COMMON
    '𝗸': ('k', None),  # 1D5F8; COMMON
    '𝗹': ('l', None),  # 1D5F9; COMMON
    '𝗻': ('n', None),  # 1D5FB; COMMON
    '𝗼': ('o', None),  # 1D5FC; COMMON
    '𝗽': ('p', None),  # 1D5FD; COMMON
    '𝗾': ('q', None),  # 1D5FE; COMMON
    '𝗿': ('r', None),  # 1D5FF; COMMON
    '𝘀': ('s', None),  # 1D600; COMMON
    '𝘁': ('t', None),  # 1D601; COMMON
    '𝘂': ('u', None),  # 1D602; COMMON
    '𝘃': ('v', None),  # 1D603; COMMON
    '𝘄': ('w', None),  # 1D604; COMMON
    '𝘅': ('x', None),  # 1D605; COMMON
    '𝘆': ('y', None),  # 1D606; COMMON
    '𝘇': ('z', None),  # 1D607; COMMON
    '𝘈': ('A', None),  # 1D608; COMMON
    '𝘉': ('B', None),  # 1D609; COMMON
    '𝘊': ('C', None),  # 1D60A; COMMON
    '𝘋': ('D', None),  # 1D60B; COMMON
    '𝘌': ('E', None),  # 1D60C; COMMON
    '𝘍': ('F', None),  # 1D60D; COMMON
    '𝘎': ('G', None),  # 1D60E; COMMON
    '𝘏': ('H', None),  # 1D60F; COMMON
    '𝘐': ('l', None),  # 1D610; COMMON
    '𝘑': ('J', None),  # 1D611; COMMON
    '𝘒': ('K', None),  # 1D612; COMMON
    '𝘓': ('L', None),  # 1D613; COMMON
    '𝘔': ('M', None),  # 1D614; COMMON
    '𝘕': ('N', None),  # 1D615; COMMON
    '𝘖': ('O', None),  # 1D616; COMMON
    '𝘗': ('P', None),  # 1D617; COMMON
    '𝘘': ('Q', None),  # 1D618; COMMON
    '𝘙': ('R', None),  # 1D619; COMMON
    '𝘚': ('S', None),  # 1D61A; COMMON
    '𝘛': ('T', None),  # 1D61B; COMMON
    '𝘜': ('U', None),  # 1D61C; COMMON
    '𝘝': ('V', None),  # 1D61D; COMMON
    '𝘞': ('W', None),  # 1D61E; COMMON
    '𝘟': ('X', None),  # 1D61F; COMMON
    '𝘠': ('Y', None),  # 1D620; COMMON
    '𝘡': ('Z', None),  # 1D621; COMMON
    '𝘢': ('a', None),  # 1D622; COMMON
    '𝘣': ('b', None),  # 1D623; COMMON
    '𝘤': ('c', None),  # 1D624; COMMON
    '𝘥': ('d', None),  # 1D625; COMMON
    '𝘦': ('e', None),  # 1D626; COMMON
    '𝘧': ('f', None),  # 1D627; COMMON
    '𝘨': ('g', None),  # 1D628; COMMON
    '𝘩': ('h', None),  # 1D629; COMMON
    '𝘪': ('i', None),  # 1D62A; COMMON
    '𝘫': ('j', None),  # 1D62B; COMMON
    '𝘬': ('k', None),  # 1D62C; COMMON
    '𝘭': ('l', None),  # 1D62D; COMMON
    '𝘯': ('n', None),  # 1D62F; COMMON
    '𝘰': ('o', None),  # 1D630; COMMON
    '𝘱': ('p', None),  # 1D631; COMMON
    '𝘲': ('q', None),  # 1D632; COMMON
    '𝘳': ('r', None),  # 1D633; COMMON
    '𝘴': ('s', None),  # 1D634; COMMON
    '𝘵': ('t', None),  # 1D635; COMMON
    '𝘶': ('u', None),  # 1D636; COMMON
    '𝘷': ('v', None),  # 1D637; COMMON
    '𝘸': ('w', None),  # 1D638; COMMON
    '𝘹': ('x', None),  # 1D639; COMMON
    '𝘺': ('y', None),  # 1D63A; COMMON
    '𝘻': ('z', None),  # 1D63B; COMMON
    '𝘼': ('A', None),  # 1D63C; COMMON
    '𝘽': ('B', None),  # 1D63D; COMMON
    '𝘾': ('C', None),  # 1D63E; COMMON
    '𝘿': ('D', None),  # 1D63F; COMMON
    '𝙀': ('E', None),  # 1D640; COMMON
    '𝙁': ('F', None),  # 1D641; COMMON
    '𝙂': ('G', None),  # 1D642; COMMON
    '𝙃': ('H', None),  # 1D643; COMMON
    '𝙄': ('l', None),  # 1D644; COMMON
    '𝙅': ('J', None),  # 1D645; COMMON
    '𝙆': ('K', None),  # 1D646; COMMON
    '𝙇': ('L', None),  # 1D647; COMMON
    '𝙈': ('M', None),  # 1D648; COMMON
    '𝙉': ('N', None),  # 1D649; COMMON
    '𝙊': ('O', None),  # 1D64A; COMMON
    '𝙋': ('P', None),  # 1D64B; COMMON
    '𝙌': ('Q', None),  # 1D64C; COMMON
    '𝙍': ('R', None),  # 1D64D; COMMON
    '𝙎': ('S', None),  # 1D64E; COMMON
    '𝙏': ('T', None),  # 1D64F; COMMON
    '𝙐': ('U', None),  # 1D650; COMMON
    '𝙑': ('V', None),  # 1D651; COMMON
    '𝙒': ('W', None),  # 1D652; COMMON
    '𝙓': ('X', None),  # 1D653; COMMON
    '𝙔': ('Y', None),  # 1D654; COMMON
    '𝙕': ('Z', None),  # 1D655; COMMON
    '𝙖': ('a', None),  # 1D656; COMMON
    '𝙗': ('b', None),  # 1D657; COMMON
    '𝙘': ('c', None),  # 1D658; COMMON
    '𝙙': ('d', None),  # 1D659; COMMON
    '𝙚': ('e', None),  # 1D65A; COMMON
    '𝙛': ('f', None),  # 1D65B; COMMON
    '𝙜': ('g', None),  # 1D65C; COMMON
    '𝙝': ('h', None),  # 1D65D; COMMON
    '𝙞': ('i', None),  # 1D65E; COMMON
    '𝙟': ('j', None),  # 1D65F; COMMON
    '𝙠': ('k', None),  # 1D660; COMMON
    '𝙡': ('l', None),  # 1D661; COMMON
    '𝙣': ('n', None),  # 1D663; COMMON
    '𝙤': ('o', None),  # 1D664; COMMON
    '𝙥': ('p', None),  # 1D665; COMMON
    '𝙦': ('q', None),  # 1D666; COMMON
    '𝙧': ('r', None),  # 1D667; COMMON
    '𝙨': ('s', None),  # 1D668; COMMON
    '𝙩': ('t', None),  # 1D669; COMMON
    '𝙪': ('u', None),  # 1D66A; COMMON
    '𝙫': ('v', None),  # 1D66B; COMMON
    '𝙬': ('w', None),  # 1D66C; COMMON
    '𝙭': ('x', None),  # 1D66D; COMMON
    '𝙮': ('y', None),  # 1D66E; COMMON
    '𝙯': ('z', None),  # 1D66F; COMMON
    '𝙰': ('A', None),  # 1D670; COMMON
    '𝙱': ('B', None),  # 1D671; COMMON
    '𝙲': ('C', None),  # 1D672; COMMON
    '𝙳': ('D', None),  # 1D673; COMMON
    '𝙴': ('E', None),  # 1D674; COMMON
    '𝙵': ('F', None),  # 1D675; COMMON
    '𝙶': ('G', None),  # 1D676; COMMON
    '𝙷': ('H', None),  # 1D677; COMMON
    '𝙸': ('l', None),  # 1D678; COMMON
    '𝙹': ('J', None),  # 1D679; COMMON
    '𝙺': ('K', None),  # 1D67A; COMMON
    '𝙻': ('L', None),  # 1D67B; COMMON
    '𝙼': ('M', None),  # 1D67C; COMMON
    '𝙽': ('N', None),  # 1D67D; COMMON
    '𝙾': ('O', None),  # 1D67E; COMMON
    '𝙿': ('P', None),  # 1D67F; COMMON
    '𝚀': ('Q', None),  # 1D680; COMMON
    '𝚁': ('R', None),  # 1D681; COMMON
    '𝚂': ('S', None),  # 1D682; COMMON
    '𝚃': ('T', None),  # 1D683; COMMON
    '𝚄': ('U', None),  # 1D684; COMMON
    '𝚅': ('V', None),  # 1D685; COMMON
    '𝚆': ('W', None),  # 1D686; COMMON
    '𝚇': ('X', None),  # 1D687; COMMON
    '𝚈': ('Y', None),  # 1D688; COMMON
    '𝚉': ('Z', None),  # 1D689; COMMON
    '𝚊': ('a', None),  # 1D68A; COMMON
    '𝚋': ('b', None),  # 1D68B; COMMON
    '𝚌': ('c', None),  # 1D68C; COMMON
    '𝚍': ('d', None),  # 1D68D; COMMON
    '𝚎': ('e', None),  # 1D68E; COMMON
    '𝚏': ('f', None),  # 1D68F; COMMON
    '𝚐': ('g', None),  # 1D690; COMMON
    '𝚑': ('h', None),  # 1D691; COMMON
    '𝚒': ('i', None),  # 1D692; COMMON
    '𝚓': ('j', None),  # 1D693; COMMON
    '𝚔': ('k', None),  # 1D694; COMMON
    '𝚕': ('l', None),  # 1D695; COMMON
    '𝚗': ('n', None),  # 1D697; COMMON
    '𝚘': ('o', None),  # 1D698; COMMON
    '𝚙': ('p', None),  # 1D699; COMMON
    '𝚚': ('q', None),  # 1D69A; COMMON
    '𝚛': ('r', None),  # 1D69B; COMMON
    '𝚜': ('s', None),  # 1D69C; COMMON
    '𝚝': ('t', None),  # 1D69D; COMMON
    '𝚞': ('u', None),  # 1D69E; COMMON
    '𝚟': ('v', None),  # 1D69F; COMMON
    '𝚠': ('w', None),  # 1D6A0; COMMON
    '𝚡': ('x', None),  # 1D6A1; COMMON
    '𝚢': ('y', None),  # 1D6A2; COMMON
    '𝚣': ('z', None),  # 1D6A3; COMMON
    '𝚤': ('i', None),  # 1D6A4; COMMON
    '𝚨': ('A', None),  # 1D6A8; COMMON
    '𝚩': ('B', None),  # 1D6A9; COMMON
    '𝚬': ('E', None),  # 1D6AC; COMMON
    '𝚭': ('Z', None),  # 1D6AD; COMMON
    '𝚮': ('H', None),  # 1D6AE; COMMON
    '𝚰': ('l', None),  # 1D6B0; COMMON
    '𝚱': ('K', None),  # 1D6B1; COMMON
    '𝚳': ('M', None),  # 1D6B3; COMMON
    '𝚴': ('N', None),  # 1D6B4; COMMON
    '𝚶': ('O', None),  # 1D6B6; COMMON
    '𝚸': ('P', None),  # 1D6B8; COMMON
    '𝚻': ('T', None),  # 1D6BB; COMMON
    '𝚼': ('Y', None),  # 1D6BC; COMMON
    '𝚾': ('X', None),  # 1D6BE; COMMON
    '𝛂': ('a', None),  # 1D6C2; COMMON
    '𝛄': ('y', None),  # 1D6C4; COMMON
    '𝛊': ('i', None),  # 1D6CA; COMMON
    '𝛎': ('v', None),  # 1D6CE; COMMON
    '𝛐': ('o', None),  # 1D6D0; COMMON
    '𝛒': ('p', None),  # 1D6D2; COMMON
    '𝛔': ('o', None),  # 1D6D4; COMMON
    '𝛖': ('u', None),  # 1D6D6; COMMON
    '𝛠': ('p', None),  # 1D6E0; COMMON
    '𝛢': ('A', None),  # 1D6E2; COMMON
    '𝛣': ('B', None),  # 1D6E3; COMMON
    '𝛦': ('E', None),  # 1D6E6; COMMON
    '𝛧': ('Z', None),  # 1D6E7; COMMON
    '𝛨': ('H', None),  # 1D6E8; COMMON
    '𝛪': ('l', None),  # 1D6EA; COMMON
    '𝛫': ('K', None),  # 1D6EB; COMMON
    '𝛭': ('M', None),  # 1D6ED; COMMON
    '𝛮': ('N', None),  # 1D6EE; COMMON
    '𝛰': ('O', None),  # 1D6F0; COMMON
    '𝛲': ('P', None),  # 1D6F2; COMMON
    '𝛵': ('T', None),  # 1D6F5; COMMON
    '𝛶': ('Y', None),  # 1D6F6; COMMON
    '𝛸': ('X', None),  # 1D6F8; COMMON
    '𝛼': ('a', None),  # 1D6FC; COMMON
    '𝛾': ('y', None),  # 1D6FE; COMMON
    '𝜄': ('i', None),  # 1D704; COMMON
    '𝜈': ('v', None),  # 1D708; COMMON
    '𝜊': ('o', None),  # 1D70A; COMMON
    '𝜌': ('p', None),  # 1D70C; COMMON
    '𝜎': ('o', None),  # 1D70E; COMMON
    '𝜐': ('u', None),  # 1D710; COMMON
    '𝜚': ('p', None),  # 1D71A; COMMON
    '𝜜': ('A', None),  # 1D71C; COMMON
    '𝜝': ('B', None),  # 1D71D; COMMON
    '𝜠': ('E', None),  # 1D720; COMMON
    '𝜡': ('Z', None),  # 1D721; COMMON
    '𝜢': ('H', None),  # 1D722; COMMON
    '𝜤': ('l', None),  # 1D724; COMMON
    '𝜥': ('K', None),  # 1D725; COMMON
    '𝜧': ('M', None),  # 1D727; COMMON
    '𝜨': ('N', None),  # 1D728; COMMON
    '𝜪': ('O', None),  # 1D72A; COMMON
    '𝜬': ('P', None),  # 1D72C; COMMON
    '𝜯': ('T', None),  # 1D72F; COMMON
    '𝜰': ('Y', None),  # 1D730; COMMON
    '𝜲': ('X', None),  # 1D732; COMMON
    '𝜶': ('a', None),  # 1D736; COMMON
    '𝜸': ('y', None),  # 1D738; COMMON
    '𝜾': ('i', None),  # 1D73E; COMMON
    '𝝂': ('v', None),  # 1D742; COMMON
    '𝝄': ('o', None),  # 1D744; COMMON
    '𝝆': ('p', None),  # 1D746; COMMON
    '𝝈': ('o', None),  # 1D748; COMMON
    '𝝊': ('u', None),  # 1D74A; COMMON
    '𝝔': ('p', None),  # 1D754; COMMON
    '𝝖': ('A', None),  # 1D756; COMMON
    '𝝗': ('B', None),  # 1D757; COMMON
    '𝝚': ('E', None),  # 1D75A; COMMON
    '𝝛': ('Z', None),  # 1D75B; COMMON
    '𝝜': ('H', None),  # 1D75C; COMMON
    '𝝞': ('l', None),  # 1D75E; COMMON
    '𝝟': ('K', None),  # 1D75F; COMMON
    '𝝡': ('M', None),  # 1D761; COMMON
    '𝝢': ('N', None),  # 1D762; COMMON
    '𝝤': ('O', None),  # 1D764; COMMON
    '𝝦': ('P', None),  # 1D766; COMMON
    '𝝩': ('T', None),  # 1D769; COMMON
    '𝝪': ('Y', None),  # 1D76A; COMMON
    '𝝬': ('X', None),  # 1D76C; COMMON
    '𝝰': ('a', None),  # 1D770; COMMON
    '𝝲': ('y', None),  # 1D772; COMMON
    '𝝸': ('i', None),  # 1D778; COMMON
    '𝝼': ('v', None),  # 1D77C; COMMON
    '𝝾': ('o', None),  # 1D77E; COMMON
    '𝞀': ('p', None),  # 1D780; COMMON
    '𝞂': ('o', None),  # 1D782; COMMON
    '𝞄': ('u', None),  # 1D784; COMMON
    '𝞎': ('p', None),  # 1D78E; COMMON
    '𝞐': ('A', None),  # 1D790; COMMON
    '𝞑': ('B', None),  # 1D791; COMMON
    '𝞔': ('E', None),  # 1D794; COMMON
    '𝞕': ('Z', None),  # 1D795; COMMON
    '𝞖': ('H', None),  # 1D796; COMMON
    '𝞘': ('l', None),  # 1D798; COMMON
    '𝞙': ('K', None),  # 1D799; COMMON
    '𝞛': ('M', None),  # 1D79B; COMMON
    '𝞜': ('N', None),  # 1D79C; COMMON
    '𝞞': ('O', None),  # 1D79E; COMMON
    '𝞠': ('P', None),  # 1D7A0; COMMON
    '𝞣': ('T', None),  # 1D7A3; COMMON
    '𝞤': ('Y', None),  # 1D7A4; COMMON
    '𝞦': ('X', None),  # 1D7A6; COMMON
    '𝞪': ('a', None),  # 1D7AA; COMMON
    '𝞬': ('y', None),  # 1D7AC; COMMON
    '𝞲': ('i', None),  # 1D7B2; COMMON
    '𝞶': ('v', None),  # 1D7B6; COMMON
    '𝞸': ('o', None),  # 1D7B8; COMMON
    '𝞺': ('p', None),  # 1D7BA; COMMON
    '𝞼': ('o', None),  # 1D7BC; COMMON
    '𝞾': ('u', None),  # 1D7BE; COMMON
    '𝟈': ('p', None),  # 1D7C8; COMMON
    '𝟊': ('F', None),  # 1D7CA; COMMON
    '𝟎': ('O', None),  # 1D7CE; COMMON
    '𝟏': ('l', None),  # 1D7CF; COMMON
    '𝟐': ('2', None),  # 1D7D0; COMMON
    '𝟑': ('3', None),  # 1D7D1; COMMON
    '𝟒': ('4', None),  # 1D7D2; COMMON
    '𝟓': ('5', None),  # 1D7D3; COMMON
    '𝟔': ('6', None),  # 1D7D4; COMMON
    '𝟕': ('7', None),  # 1D7D5; COMMON
    '𝟖': ('8', None),  # 1D7D6; COMMON
    '𝟗': ('9', None),  # 1D7D7; COMMON
    '𝟘': ('O', None),  # 1D7D8; COMMON
    '𝟙': ('l', None),  # 1D7D9; COMMON
    '𝟚': ('2', None),  # 1D7DA; COMMON
    '𝟛': ('3', None),  # 1D7DB; COMMON
    '𝟜': ('4', None),  # 1D7DC; COMMON
    '𝟝': ('5', None),  # 1D7DD; COMMON
    '𝟞': ('6', None),  # 1D7DE; COMMON
    '𝟟': ('7', None),  # 1D7DF; COMMON
    '𝟠': ('8', None),  # 1D7E0; COMMON
    '𝟡': ('9', None),  # 1D7E1; COMMON
    '𝟢': ('O', None),  # 1D7E2; COMMON
    '𝟣': ('l', None),  # 1D7E3; COMMON
    '𝟤': ('2', None),  # 1D7E4; COMMON
    '𝟥': ('3', None),  # 1D7E5; COMMON
    '𝟦': ('4', None),  # 1D7E6; COMMON
    '𝟧': ('5', None),  # 1D7E7; COMMON
    '𝟨': ('6', None),  # 1D7E8; COMMON
    '𝟩': ('7', None),  # 1D7E9; COMMON
    '𝟪': ('8', None),  # 1D7EA; COMMON
    '𝟫': ('9', None),  # 1D7EB; COMMON
    '𝟬': ('O', None),  # 1D7EC; COMMON
    '𝟭': ('l', None),  # 1D7ED; COMMON
    '𝟮': ('2', None),  # 1D7EE; COMMON
    '𝟯': ('3', None),  # 1D7EF; COMMON
    '𝟰': ('4', None),  # 1D7F0; COMMON
    '𝟱': ('5', None),  # 1D7F1; COMMON
    '𝟲': ('6', None),  # 1D7F2; COMMON
    '𝟳': ('7', None),  # 1D7F3; COMMON
    '𝟴': ('8', None),  # 1D7F4; COMMON
    '𝟵': ('9', None),  # 1D7F5; COMMON
    '𝟶': ('O', None),  # 1D7F6; COMMON
    '𝟷': ('l', None),  # 1D7F7; COMMON
    '𝟸': ('2', None),  # 1D7F8; COMMON
    '𝟹': ('3', None),  # 1D7F9; COMMON
    '𝟺': ('4', None),  # 1D7FA; COMMON
    '𝟻': ('5', None),  # 1D7FB; COMMON
    '𝟼': ('6', None),  # 1D7FC; COMMON
    '𝟽': ('7', None),  # 1D7FD; COMMON
    '𝟾': ('8', None),  # 1D7FE; COMMON
    '𝟿': ('9', None),  # 1D7FF; COMMON
    '𞣇': ('l', None),  # 1E8C7; MENDE_KIKAKUI
    '𞣋': ('8', None),  # 1E8CB; MENDE_KIKAKUI
    '𞸀': ('l', 3),  # 1EE00; ARABIC
    '𞸤': ('o', 3),  # 1EE24; ARABIC
    '𞹤': ('o', 3),  # 1EE64; ARABIC
    '𞺀': ('l', 3),  # 1EE80; ARABIC
    '𞺄': ('o', 3),  # 1EE84; ARABIC
    '🝌': ('C', None),  # 1F74C; COMMON
    '🝨': ('T', None),  # 1F768; COMMON
    '🯰': ('O', None),  # 1FBF0; COMMON
    '🯱': ('l', None),  # 1FBF1; COMMON
    '🯲': ('2', None),  # 1FBF2; COMMON
    '🯳': ('3', None),  # 1FBF3; COMMON
    '🯴': ('4', None),  # 1FBF4; COMMON
    '🯵': ('5', None),  # 1FBF5; COMMON
    '🯶': ('6', None),  # 1FBF6; COMMON
    '🯷': ('7', None),  # 1FBF7; COMMON
    '🯸': ('8', None),  # 1FBF8; COMMON
    '🯹': ('9', None),  # 1FBF9; COMMON
}

CONFUSABLES_ID_TO_ALIAS_MAP: Tuple[str, ...] = (
    'Greek',
    'Cyrillic',
    'Armenian',
    'Arabic',
    'Devanagari',
    'Bengali',
    'Gurmukhi',
    'Gujarati',
    'Oriya',
    'Telugu',
    'Kannada',
    'Katakana',
)

CONFUSABLES_ALIAS_TO_ID_MAP: Dict[str, int] = {
    'Greek': 0,
    'Cyrillic': 1,
    'Armenian': 2,
    'Arabic': 3,
    'Devanagari': 4,
    'Bengali': 5,
    'Gurmukhi': 6,
    'Gujarati': 7,
    'Oriya': 8,
    'Telugu': 9,
    'Kannada': 10,
    'Katakana': 11,
}
